/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.xdb.util.Pair;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynRecordExtService;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.event.AdjSalSynRecordEvent;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapprbill.enums.SynStatusEnum;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjEvent;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjFieldFactory;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncConstants;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncGenResult;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncGenService;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncSet;
import kd.swc.hcdm.common.constants.AdjSalSynConstants;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.enums.DataStatusEnum;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.model.Message;
import kd.swc.hsbp.common.model.ValidateResult;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class BaseSalaryAdjSyncGenServiceImpl
implements SalaryAdjSyncGenService {
    private static final Log LOGGER = LogFactory.getLog(BaseSalaryAdjSyncGenServiceImpl.class);
    protected SalaryAdjEvent event;
    private long adjSalSynId;
    protected List<DynamicObject> salaryAdjRecordHisList;
    protected Map<Long, DynamicObject> salaryAdjRelPersonMap;
    protected final HashBasedTable<Long, Long, Long> syncSetDirectMap = HashBasedTable.create();
    protected HashBasedTable<Long, Long, Long> syncSetAssignMap = HashBasedTable.create();
    protected final HashBasedTable<Long, Long, Long> syncSetParentMap = HashBasedTable.create();
    protected Map<Long, SalaryAdjSyncSet> syncSetMapOfId;
    private BaseResult<?> initResult;
    protected HashBasedTable<Long, Long, DynamicObject> existSyncs;
    protected Map<Long, Map<Long, DynamicObject>> existSyncDetails;
    protected SWCDataServiceHelper adjSalarySynHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
    protected SWCDataServiceHelper adjSalarySynDetailHelper = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
    protected SWCDataServiceHelper adjSalarySynSetHelper = new SWCDataServiceHelper("hcdm_adjsalarysynset");

    @Override
    public SalaryAdjSyncGenResult generateSyncData() {
        Object obj = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"enablerange");
        Object entity = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"entity");
        LOGGER.info("BaseSalaryAdjSyncGenServiceImpl generateSyncData entity is {}", entity);
        if (obj == null || SWCStringUtils.equals((String)"3", (String)obj.toString())) {
            LOGGER.info("BaseSalaryAdjSyncGenServiceImpl generateSyncData \u672a\u5f00\u542f");
            return new SalaryAdjSyncGenResult(Lists.newArrayList(), null);
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.generateSyncData start");
        SalaryAdjSyncGenResult result = this.initResult();
        if (!result.isSuccess()) {
            throw new KDBizException(result.getMessage().getMsg());
        }
        if (CollectionUtils.isEmpty(this.salaryAdjRecordHisList) || CollectionUtils.isEmpty(this.salaryAdjRelPersonMap)) {
            return result;
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.generateSyncData result initialized, recSize is {}", (Object)this.salaryAdjRecordHisList.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (SWCStringUtils.equals((String)"2", (String)obj.toString())) {
            List entityList = (List)entity;
            Iterator iterator = entityList.iterator();
            while (iterator.hasNext()) {
                Map entityMap = (Map)iterator.next();
                Long orgId = Long.valueOf(String.valueOf(entityMap.get("orgId")));
                List countryIds = (List)entityMap.get("countryId");
                map.put(orgId, new HashSet(countryIds.stream().map(id -> Long.valueOf(String.valueOf(id))).collect(Collectors.toList())));
            }
            LOGGER.info("BaseSalaryAdjSyncGenServiceImpl generateSyncData map is {}", (Object)map);
        }
        for (DynamicObject salaryAdjRecord : this.salaryAdjRecordHisList) {
            BaseResult<DynamicObject> res;
            long relPersonId;
            DynamicObject salaryAdjRelPerson;
            String needPush = salaryAdjRecord.getString("needpush");
            if (SWCStringUtils.equals((String)needPush, (String)"0") || (salaryAdjRelPerson = this.salaryAdjRelPersonMap.get(relPersonId = salaryAdjRecord.getLong("relpersonid"))) == null) continue;
            long countryId = SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "country");
            long orgId = SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "org");
            if (SWCStringUtils.equals((String)"2", (String)obj.toString())) {
                LOGGER.info("BaseSalaryAdjSyncGenServiceImpl salaryAdjRecord orgId is {},countryId is {}", (Object)orgId, (Object)countryId);
                Set countryIds = (Set)map.get(orgId);
                LOGGER.info("BaseSalaryAdjSyncGenServiceImpl salaryAdjRecord countryIds is {}", (Object)countryIds);
                if (countryIds == null) {
                    LOGGER.info("BaseSalaryAdjSyncGenServiceImpl not in scope");
                    continue;
                }
                if (!countryIds.contains(countryId)) {
                    LOGGER.info("BaseSalaryAdjSyncGenServiceImpl not contains scope");
                    continue;
                }
            }
            DynamicObject adjSalarySyn = result.getAdjSalarySyn(orgId, countryId);
            ValidateResult<DynamicObject> synType = this.generateSynType(salaryAdjRecord, adjSalarySyn);
            LOGGER.info("BaseSalaryAdjSyncGenServiceImpl synType\uff1a{}", (Object)synType.getMessage());
            if (StringUtils.isEmpty((CharSequence)synType.getMessage())) continue;
            if (adjSalarySyn == null) {
                BaseResult<DynamicObject> res2 = this.createAdjSalarySyn(countryId, orgId);
                adjSalarySyn = (DynamicObject)res2.getData();
                result.putAdjSalarySyn(orgId, countryId, adjSalarySyn);
                if (!res2.isSuccess()) {
                    result.putAdjSalarySynMessage(orgId, countryId, res2.getMessage());
                }
            } else if (result.getAdjSalarySynMessage(orgId, countryId) == null) {
                boolean hasNoSet;
                String errormsg = adjSalarySyn.getString("errormsg");
                boolean bl = hasNoSet = !StringUtils.isEmpty((CharSequence)errormsg) || adjSalarySyn.getLong("adjsalarysynset.id") == 0L;
                if (hasNoSet) {
                    adjSalarySyn.set("errormsg", null);
                    res = this.assignSynSet(adjSalarySyn, orgId, countryId);
                    if (!res.isSuccess()) {
                        result.putAdjSalarySynMessage(orgId, countryId, res.getMessage());
                    }
                }
            }
            AdjSalSynRecordEvent recordEvent = new AdjSalSynRecordEvent(adjSalarySyn);
            recordEvent.setNewCreated(!adjSalarySyn.getDataEntityState().getFromDatabase());
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new IAdjSalSynRecordExtService(){}, IAdjSalSynRecordExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynRecordExtService#extDealAfterCreate", null);
            pluginProxy.callReplaceIfPresent(plugin -> {
                plugin.extDealAfterCreate(recordEvent);
                return null;
            });
            res = this.createAdjSalarySynDetail(salaryAdjRecord, salaryAdjRelPerson, adjSalarySyn, synType);
            result.addAdjSalarySynDetail(adjSalarySyn, (DynamicObject)res.getData());
            if (res.isSuccess()) continue;
            result.bizMsg(salaryAdjRecord, res.getMessage());
        }
        String lockKey = "SalaryAdjSyncGen_" + this.event.getLong("id");
        try (DLock dLock = DLock.create((String)lockKey);){
            dLock.lock();
            this.saveAdjSalarySyn(result);
        }
        return result;
    }

    protected void saveAdjSalarySyn(SalaryAdjSyncGenResult result) {
        List<DynamicObject> adjSalarySynList = result.allAdjSalarySyn();
        ArrayList newList = Lists.newArrayListWithExpectedSize((int)adjSalarySynList.size());
        ArrayList oldList = Lists.newArrayListWithExpectedSize((int)adjSalarySynList.size());
        for (DynamicObject object : adjSalarySynList) {
            if (object.getDataEntityState().getFromDatabase()) {
                oldList.add(object);
                continue;
            }
            newList.add(object);
        }
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.dealNewSynRec(result, newList, oldList);
        }
        this.dealBatchNumber(result, newList, true);
        this.dealOldSynRecBatchNumber(result, oldList);
        adjSalarySynList = result.allAdjSalarySyn();
        ArrayList detailList = Lists.newArrayListWithExpectedSize((int)500);
        ArrayList newDetailList = Lists.newArrayListWithExpectedSize((int)detailList.size());
        ArrayList oldDetailList = Lists.newArrayListWithExpectedSize((int)detailList.size());
        ArrayList noPersonDetailList = Lists.newArrayListWithExpectedSize((int)100);
        for (DynamicObject syncRec : adjSalarySynList) {
            this.dealSynDetails(result, detailList, newDetailList, oldDetailList, noPersonDetailList, syncRec);
        }
        if (!CollectionUtils.isEmpty((Collection)noPersonDetailList)) {
            this.setPersonForDetails(noPersonDetailList);
        }
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.adjSalarySynHelper.save(newList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)oldList)) {
            this.adjSalarySynHelper.save(oldList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)newDetailList)) {
            this.adjSalarySynDetailHelper.save(newDetailList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)oldDetailList)) {
            this.adjSalarySynDetailHelper.save(oldDetailList.toArray(new DynamicObject[0]));
        }
    }

    private void dealOldSynRecBatchNumber(SalaryAdjSyncGenResult result, List<DynamicObject> oldList) {
        ArrayList noNumbersSynRecList = Lists.newArrayListWithExpectedSize((int)oldList.size());
        Iterator<DynamicObject> iterator = oldList.iterator();
        while (iterator.hasNext()) {
            DynamicObject synRecDys = iterator.next();
            String errormsg = synRecDys.getString("errormsg");
            String batchnumber = synRecDys.getString("batchnumber");
            if (!batchnumber.equals(AdjSalSynConstants.BATCHNUMBER_FAILED()) && !AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode().equals(errormsg) && !AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode().equals(errormsg)) continue;
            noNumbersSynRecList.add(synRecDys);
            iterator.remove();
        }
        this.dealBatchNumber(result, noNumbersSynRecList, false);
        oldList.addAll(noNumbersSynRecList);
    }

    private void dealBatchNumber(SalaryAdjSyncGenResult result, List<DynamicObject> newList, boolean isNew) {
        block3: {
            try {
                if (!CollectionUtils.isEmpty(newList)) {
                    this.genBatchNumber(result, newList, isNew);
                }
            }
            catch (KDException ex) {
                if (null == ex.getErrorCode()) break block3;
                this.genBatchNumberOverSeq(result, newList, isNew);
            }
        }
    }

    private void genBatchNumber(SalaryAdjSyncGenResult result, List<DynamicObject> newList, boolean isNew) {
        List numbers = CodeRuleServiceHelper.getNumbers((String)"hcdm_adjsalsyn", newList);
        long[] ids = new long[]{newList.size()};
        if (isNew) {
            ORM orm = ORM.create();
            ids = orm.genLongIds("hcdm_adjsalsyn", newList.size());
        }
        for (int i = 0; i < newList.size(); ++i) {
            DynamicObject syncRec = newList.get(i);
            if (isNew) {
                syncRec.set("id", (Object)ids[i]);
            }
            String batchNumber = SWCStringUtils.isEmpty((String)((String)numbers.get(i))) ? AdjSalSynConstants.BATCHNUMBER_FAILED() : (String)numbers.get(i);
            newList.get(i).set("batchnumber", (Object)batchNumber);
            if (!SWCStringUtils.isEmpty((String)((String)numbers.get(i)))) continue;
            syncRec.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode());
            List<DynamicObject> syncDetails = result.adjSalarySynDetailsOf(syncRec);
            for (DynamicObject syncDetail : syncDetails) {
                syncDetail.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode());
            }
        }
    }

    private void genBatchNumberOverSeq(SalaryAdjSyncGenResult result, List<DynamicObject> newList, boolean isNew) {
        long[] ids = new long[]{newList.size()};
        if (isNew) {
            ORM orm = ORM.create();
            ids = orm.genLongIds("hcdm_adjsalsyn", newList.size());
        }
        for (int i = 0; i < newList.size(); ++i) {
            DynamicObject syncRec = newList.get(i);
            if (isNew) {
                syncRec.set("id", (Object)ids[i]);
            }
            syncRec.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode());
            newList.get(i).set("batchnumber", (Object)AdjSalSynConstants.BATCHNUMBER_FAILED());
            List<DynamicObject> syncDetails = result.adjSalarySynDetailsOf(syncRec);
            for (DynamicObject syncDetail : syncDetails) {
                syncDetail.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode());
            }
        }
    }

    private void dealSynDetails(SalaryAdjSyncGenResult result, List<DynamicObject> detailList, List<DynamicObject> newDetailList, List<DynamicObject> oldDetailList, List<DynamicObject> noPersonDetailList, DynamicObject syncRec) {
        List<DynamicObject> syncDetails = result.adjSalarySynDetailsOf(syncRec);
        if (CollectionUtils.isEmpty(syncDetails)) {
            return;
        }
        HashSet synTypeSet = Sets.newHashSetWithExpectedSize((int)4);
        String synTypes = syncRec.getString("syntypes");
        if (!StringUtils.isEmpty((CharSequence)synTypes)) {
            synTypeSet.addAll(Arrays.asList(synTypes.split(",")));
        }
        Iterator<DynamicObject> iterator = syncDetails.iterator();
        int failSize = 0;
        int totalSize = 0;
        while (iterator.hasNext()) {
            String message;
            DynamicObject detail = iterator.next();
            if (StringUtil.isEmpty((String)detail.getString("syntype"))) {
                iterator.remove();
                continue;
            }
            Long personId = SalaryAdjFieldFactory.getIdOfBaseProp(detail, "person");
            if (personId == 0L) {
                noPersonDetailList.add(detail);
            }
            if (!StringUtils.isEmpty((CharSequence)(message = detail.getString("errormsg")))) {
                detail.set("status", (Object)"1");
                detail.set("errormessage", (Object)AdjSalarySynHelper.getErrorDescByCode(message));
            }
            detail.set("batchnumber", (Object)syncRec.getString("batchnumber"));
            if (detail.getDataEntityState().getFromDatabase()) {
                oldDetailList.add(detail);
                continue;
            }
            ++totalSize;
            if ("1".equals(detail.get("status"))) {
                ++failSize;
            }
            synTypeSet.add(detail.getString("syntype"));
            detail.set("adjsalsyn", (Object)syncRec.getLong("id"));
            newDetailList.add(detail);
        }
        detailList.addAll(syncDetails);
        syncRec.set("totalnum", (Object)(syncRec.getInt("totalnum") + totalSize));
        syncRec.set("failnum", (Object)(syncRec.getInt("failnum") + failSize));
        syncRec.set("syntypes", (Object)Joiner.on((char)',').join((Iterable)synTypeSet));
    }

    private void dealNewSynRec(SalaryAdjSyncGenResult result, List<DynamicObject> newList, List<DynamicObject> oldList) {
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)newList.size());
        HashSet countryIds = Sets.newHashSetWithExpectedSize((int)newList.size());
        for (DynamicObject object : newList) {
            orgIds.add(SalaryAdjFieldFactory.getIdOfBaseProp(object, "org"));
            countryIds.add(SalaryAdjFieldFactory.getIdOfBaseProp(object, "country"));
        }
        Object[] query = this.adjSalarySynHelper.query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{new QFilter("salaryadjevent.id", "=", (Object)this.event.getLong("id")), new QFilter("org.id", "in", (Object)orgIds), new QFilter("country.id", "in", (Object)countryIds)});
        if (!ArrayUtils.isEmpty((Object[])query)) {
            HashBasedTable tempMap = HashBasedTable.create();
            for (Object object : query) {
                tempMap.put((Object)object.getLong("org.id"), (Object)object.getLong("country.id"), object);
            }
            Iterator<DynamicObject> iterator = newList.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                DynamicObject old = (DynamicObject)tempMap.get((Object)SalaryAdjFieldFactory.getIdOfBaseProp(next, "org"), (Object)SalaryAdjFieldFactory.getIdOfBaseProp(next, "country"));
                if (old == null) continue;
                oldList.add(next);
                result.replaceSync(next, old);
                iterator.remove();
            }
        }
    }

    private void setPersonForDetails(List<DynamicObject> noPersonDetailList) {
        HashSet comPersonNumbers = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashSet unComPersonNumbers = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashSet stdPositionIds = Sets.newHashSetWithExpectedSize((int)noPersonDetailList.size());
        HashMap noPersonDetailCache = Maps.newHashMapWithExpectedSize((int)noPersonDetailList.size());
        Date maxEffectDate = null;
        Date minEffectDate = null;
        for (DynamicObject dynamicObject : noPersonDetailList) {
            boolean hasPos;
            String number = dynamicObject.getString("decadjrelperson.empnumber");
            if (StringUtils.isEmpty((CharSequence)number)) {
                dynamicObject.set("status", (Object)"1");
                dynamicObject.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1006.getCode());
                dynamicObject.set("errormessage", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1006.getName());
                continue;
            }
            List detailsOfEmpNumber = noPersonDetailCache.computeIfAbsent(number, ky -> Lists.newArrayListWithExpectedSize((int)2));
            detailsOfEmpNumber.add(dynamicObject);
            Long depEmp = SalaryAdjFieldFactory.getIdOfBaseProp(dynamicObject, "depemp");
            if (depEmp != 0L) {
                depEmpIds.add(depEmp);
                continue;
            }
            long orgId = dynamicObject.getLong("decadjrelperson.adminorg.id");
            long positionId = dynamicObject.getLong("position.id");
            long stdPositionId = dynamicObject.getLong("decadjrelperson.stdposition.id");
            boolean bl = hasPos = positionId != 0L || stdPositionId != 0L;
            if (orgId != 0L && hasPos) {
                comPersonNumbers.add(number);
                orgIds.add(orgId);
                positionIds.add(positionId);
                stdPositionIds.add(stdPositionId);
                continue;
            }
            unComPersonNumbers.add(number);
            Date bsed = dynamicObject.getDate("bsed");
            if (bsed == null) continue;
            if (maxEffectDate == null) {
                maxEffectDate = bsed;
                minEffectDate = bsed;
                continue;
            }
            if (bsed.before(minEffectDate)) {
                minEffectDate = bsed;
                continue;
            }
            if (!bsed.after(maxEffectDate)) continue;
            maxEffectDate = bsed;
        }
        if (!CollectionUtils.isEmpty((Collection)depEmpIds)) {
            this.dealNoPersonWithDepEmp(depEmpIds, noPersonDetailCache);
        }
        if (!CollectionUtils.isEmpty((Collection)comPersonNumbers)) {
            this.dealNoPersonWithCompInfo(comPersonNumbers, orgIds, positionIds, stdPositionIds, noPersonDetailCache);
        }
        if (!CollectionUtils.isEmpty((Collection)unComPersonNumbers)) {
            this.dealNoPersonWithUnCompInfo(unComPersonNumbers, noPersonDetailCache, maxEffectDate, minEffectDate);
        }
        for (Map.Entry entry : noPersonDetailCache.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            for (DynamicObject person : value) {
                person.set("status", (Object)"1");
                person.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1006.getCode());
                person.set("errormessage", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1006.getName());
            }
        }
    }

    protected void dealNoPersonWithDepEmp(Set<Long> depEmpIds, Map<String, List<DynamicObject>> noPersonDetailCache) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_depemp");
        QFilter idFilter = new QFilter("id", "in", depEmpIds);
        Object[] depEmpArr = serviceHelper.query("id,employee.id,person.id,person.number", new QFilter[]{idFilter});
        if (!ArrayUtils.isEmpty((Object[])depEmpArr)) {
            for (Object depEmp : depEmpArr) {
                String number = depEmp.getString("person.number");
                List<DynamicObject> list = noPersonDetailCache.get(number);
                if (CollectionUtils.isEmpty(list)) continue;
                Iterator<DynamicObject> iterator = list.iterator();
                while (iterator.hasNext()) {
                    DynamicObject detail = iterator.next();
                    long depEmpId = SalaryAdjFieldFactory.getIdOfBaseProp(detail, "depemp");
                    if (depEmpId != depEmp.getLong("id")) continue;
                    detail.set("employee", depEmp.get("employee"));
                    detail.set("person", depEmp.get("person"));
                    iterator.remove();
                }
            }
        }
    }

    private void dealNoPersonWithCompInfo(Set<String> comPersonNumbers, Set<Long> orgIds, Set<Long> positionIds, Set<Long> stdPositionIds, Map<String, List<DynamicObject>> noPersonDetailCache) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_depemp");
        QFilter personFilter = new QFilter("person.number", "in", comPersonNumbers);
        QFilter orgFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter otherFilter = new QFilter("position.id", "in", stdPositionIds).or(new QFilter("stdposition.id", "in", positionIds));
        Object[] depEmps = serviceHelper.query("id,employee.id,person.id,person.number,adminorg.id,position.id,stdposition.id,startdate,enddate", new QFilter[]{personFilter, orgFilter, otherFilter});
        if (!ArrayUtils.isEmpty((Object[])depEmps)) {
            for (Object depEmp : depEmps) {
                String number = depEmp.getString("person.number");
                List<DynamicObject> list = noPersonDetailCache.get(number);
                if (CollectionUtils.isEmpty(list)) continue;
                long orgId = depEmp.getLong("adminorg.id");
                long positionId = depEmp.getLong("position.id");
                long stdPositionId = depEmp.getLong("stdposition.id");
                Date startDate = depEmp.getDate("startdate");
                Date endDate = depEmp.getDate("enddate");
                Iterator<DynamicObject> iterator = list.iterator();
                while (iterator.hasNext()) {
                    boolean posMatch;
                    DynamicObject detail = iterator.next();
                    Date bsedOfDetail = detail.getDate("bsed");
                    if (!SWCDateTimeUtils.isCover((Date)bsedOfDetail, (Date)startDate, (Date)endDate)) continue;
                    long orgIdOfDetail = detail.getLong("decadjrelperson.adminorg.id");
                    long positionIdOfDetail = detail.getLong("position.id");
                    long stdPositionIdOfDetail = detail.getLong("decadjrelperson.stdposition.id");
                    boolean bl = posMatch = positionId == positionIdOfDetail || stdPositionId == stdPositionIdOfDetail;
                    if (orgId != orgIdOfDetail || !posMatch) continue;
                    detail.set("depemp", depEmp);
                    detail.set("employee", depEmp.get("employee"));
                    detail.set("person", depEmp.get("person"));
                    iterator.remove();
                }
            }
        }
    }

    private void dealNoPersonWithUnCompInfo(Set<String> comPersonNumbers, Map<String, List<DynamicObject>> personCache, Date maxEffectDate, Date minEffectDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter personFilter = new QFilter("person.number", "in", comPersonNumbers);
        QFilter minEffectFilter = new QFilter("enddate", ">=", (Object)minEffectDate);
        QFilter maxEffectFilter = new QFilter("startdate", "<=", (Object)maxEffectDate);
        QFilter currVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatus = new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.SCHEDULEEFFECT.getCode(), DataStatusEnum.INVALID.getCode()});
        Object[] query = serviceHelper.query("id,depemp.id,employee.id,person.id,person.number,position,job,isprimary,startdate,enddate", new QFilter[]{personFilter, minEffectFilter, maxEffectFilter, currVersionFilter, dataStatus});
        if (!ArrayUtils.isEmpty((Object[])query)) {
            for (Object object : query) {
                String number = object.getString("person.number");
                List<DynamicObject> list = personCache.get(number);
                if (CollectionUtils.isEmpty(list)) continue;
                boolean isPrimary = "1".equals(object.getString("isprimary"));
                Date startDate = object.getDate("startdate");
                Date endDate = object.getDate("enddate");
                Iterator<DynamicObject> iterator = list.iterator();
                while (iterator.hasNext()) {
                    DynamicObject detail = iterator.next();
                    long depEmpOfDetail = detail.getLong("depemp.id");
                    boolean hasEmpAndNotPri = depEmpOfDetail != 0L && !isPrimary;
                    Date bsedOfDetail = detail.getDate("bsed");
                    if (hasEmpAndNotPri || !SWCDateTimeUtils.isCover((Date)bsedOfDetail, (Date)startDate, (Date)endDate)) continue;
                    detail.set("depemp", object.get("depemp"));
                    detail.set("employee", object.get("employee"));
                    detail.set("person", object.get("person"));
                    iterator.remove();
                }
            }
        }
    }

    private BaseResult<DynamicObject> createAdjSalarySyn(long countryId, long orgId) {
        DynamicObject adjSalarySyn = this.adjSalarySynHelper.generateEmptyDynamicObject();
        adjSalarySyn.set("salaryadjevent", (Object)this.event.getLong("id"));
        adjSalarySyn.set("country", (Object)countryId);
        adjSalarySyn.set("org", (Object)orgId);
        adjSalarySyn.set("datasource", (Object)this.event.getDataSource());
        adjSalarySyn.set("srcbill", (Object)this.event.getSrcBillDesc());
        adjSalarySyn.set("srcbillid", (Object)this.event.getSrcBillId());
        adjSalarySyn.set("needrepush", (Object)this.event.getNeedRePush());
        adjSalarySyn.set("synstatus", (Object)"9");
        adjSalarySyn.set("createtime", (Object)new Date());
        return this.assignSynSet(adjSalarySyn, orgId, countryId);
    }

    private BaseResult<DynamicObject> assignSynSet(DynamicObject adjSalarySyn, long orgId, long countryId) {
        BaseResult<SalaryAdjSyncSet> syncTplRes = this.matchAdjSalarySynSet(orgId, countryId);
        BaseResult result = BaseResult.success((Object)adjSalarySyn);
        if (!syncTplRes.isSuccess()) {
            adjSalarySyn.set("errormsg", (Object)syncTplRes.getMsg());
            adjSalarySyn.set("synstatus", (Object)"1");
            result.setMessage(syncTplRes.getMessage());
            return result;
        }
        SalaryAdjSyncSet data = (SalaryAdjSyncSet)syncTplRes.getData();
        adjSalarySyn.set("adjsalarysynset", (Object)data.getSrcEntity());
        adjSalarySyn.set("syncschedule", data.get("syncschedule"));
        String syncStrategy = data.getString("syncstrategy");
        if (StringUtils.isEmpty((CharSequence)syncStrategy)) {
            syncStrategy = "1";
        }
        adjSalarySyn.set("syncstrategy", (Object)syncStrategy);
        return result;
    }

    private BaseResult<DynamicObject> createAdjSalarySynDetail(DynamicObject salaryAdjRecord, DynamicObject salaryAdjRelPerson, DynamicObject adjSalarySyn, ValidateResult<DynamicObject> synType) {
        DynamicObject result;
        long salaryAdjRecId = salaryAdjRecord.getLong("id");
        boolean refOld = false;
        if (synType.isSuccess()) {
            result = (DynamicObject)synType.getData();
            result.set("syntype", (Object)synType.getMessage());
            result.set("errormsg", null);
            result.set("errormessage", null);
            result.set("status", (Object)"9");
        } else {
            Map<Long, DynamicObject> existIds;
            result = this.adjSalarySynDetailHelper.generateEmptyDynamicObject();
            result.set("salaryadjrecord", (Object)salaryAdjRecId);
            long salaryAdjRecBoId = salaryAdjRecord.getLong("boid");
            result.set("salaryadjrecordboid", (Object)salaryAdjRecBoId);
            result.set("decadjrelperson", (Object)salaryAdjRelPerson);
            result.set("syntype", (Object)synType.getMessage());
            result.set("status", (Object)SynStatusEnum.TO_SYNC.getCode());
            result.set("approvalbillid", (Object)salaryAdjRecord.getLong("bussinessid"));
            if (!"1".equals(synType.getMessage()) && !CollectionUtils.isEmpty(existIds = this.existSyncDetails.get(salaryAdjRecId))) {
                DynamicObject oldSynDetail = existIds.values().iterator().next();
                for (String prop : SalaryAdjSyncConstants.PROPS_COPY_FROM_OLD) {
                    result.set(prop, oldSynDetail.get(prop));
                }
                refOld = true;
            }
            if (!refOld) {
                result.set("bizdatacode", (Object)(salaryAdjRecId + ""));
                this.copyPropToSynDetail(salaryAdjRecord, salaryAdjRelPerson, result);
            }
        }
        BaseResult success = BaseResult.success((Object)result);
        result.set("bsed", (Object)salaryAdjRecord.getDate("bsed"));
        result.set("bsled", (Object)salaryAdjRecord.getDate("bsled"));
        Long standardItemId = SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "standarditem");
        result.set("salarystditem", (Object)standardItemId);
        String errorMsgCode = adjSalarySyn.getString("errormsg");
        if (!StringUtils.isEmpty((CharSequence)errorMsgCode)) {
            result.set("errormsg", (Object)errorMsgCode);
            result.set("status", (Object)"1");
            success.setMessage(new Message(errorMsgCode, 400));
            return success;
        }
        long adjSalarySynSetId = SalaryAdjFieldFactory.getIdOfBaseProp(adjSalarySyn, "adjsalarysynset");
        SalaryAdjSyncSet adjSalarySynSet = this.syncSetMapOfId.get(adjSalarySynSetId);
        result.set("adjsalarysynset", (Object)adjSalarySynSetId);
        Long bizItemId = adjSalarySynSet.bizItemIdOfStdId(standardItemId);
        if (bizItemId == null || bizItemId == 0L) {
            result.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1005.getCode());
            result.set("status", (Object)"1");
            success.setMessage(new Message(AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1005.getCode(), 400));
            return success;
        }
        result.set("bizitem", (Object)bizItemId);
        if (refOld) {
            return success;
        }
        Map<String, Object> extraInfo = this.resolveFieldMapping(salaryAdjRecord, salaryAdjRelPerson, adjSalarySynSet, bizItemId);
        HashMap personChangeInfo = Maps.newHashMapWithExpectedSize((int)2);
        personChangeInfo.put("salaryadjustrsn", SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "salaryadjrsn"));
        personChangeInfo.put("action", this.event.getString("eventtype"));
        extraInfo.put("personchangeinfo", personChangeInfo);
        result.set("fieldmappingvalue", (Object)SerializationUtils.toJsonString(extraInfo));
        return success;
    }

    private Map<String, Object> resolveFieldMapping(DynamicObject salaryAdjRecord, DynamicObject salaryAdjRelPerson, SalaryAdjSyncSet adjSalarySynSet, Long bizItemId) {
        HashMap extraInfo = Maps.newHashMapWithExpectedSize((int)2);
        List<Long> props = adjSalarySynSet.propsOfBizItem(bizItemId);
        if (!CollectionUtils.isEmpty(props)) {
            ArrayList propValues = Lists.newArrayListWithCapacity((int)props.size());
            for (Long prop : props) {
                Object value;
                Pair<String, String> fetch = adjSalarySynSet.valueFetchOfProp(prop);
                if (fetch == null) continue;
                try {
                    value = SalaryAdjFieldFactory.valueOf((String)fetch.getValue(), (String)fetch.getKey(), salaryAdjRecord, salaryAdjRelPerson);
                }
                catch (Exception ex) {
                    LOGGER.error("Trace By Quinn: error occurs when SalaryAdjFieldFactory.valueOf", (Throwable)ex);
                    continue;
                }
                if (value == null || SWCStringUtils.isEmpty((String)value.toString())) continue;
                HashMap propItem = Maps.newHashMapWithExpectedSize((int)2);
                propItem.put("bizitempropid", prop);
                propItem.put("propvalue", value instanceof ILocaleString ? value.toString() : value);
                propValues.add(propItem);
            }
            extraInfo.put("propdatalist", propValues);
        }
        return extraInfo;
    }

    private void copyPropToSynDetail(DynamicObject salaryAdjRecord, DynamicObject salaryAdjRelPerson, DynamicObject result) {
        Long salaryAdjFile = SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "salaryadjfile");
        Long depEmpId = SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "depemp");
        result.set("adjfile", (Object)salaryAdjFile);
        if (salaryAdjFile != 0L) {
            result.set("person", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "salaryadjfile.person"));
            result.set("employee", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "salaryadjfile.employee"));
            result.set("depemp", (Object)depEmpId);
        } else if (depEmpId != 0L) {
            result.set("depemp", (Object)depEmpId);
            result.set("employee", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "depemp.employee"));
            result.set("person", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "depemp.person"));
        }
        result.set("frequency", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "frequency"));
        result.set("currency", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRecord, "currency"));
        result.set("amount", (Object)salaryAdjRecord.getBigDecimal("amount"));
        result.set("remark", (Object)salaryAdjRecord.getString("remark"));
        result.set("issend", (Object)salaryAdjRecord.getString("issend"));
        result.set("salaystructure", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "salaystructure"));
        result.set("job", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "job"));
        result.set("position", (Object)SalaryAdjFieldFactory.getIdOfBaseProp(salaryAdjRelPerson, "position"));
    }

    protected ValidateResult<DynamicObject> generateSynType(DynamicObject salaryAdjRecord, DynamicObject adjSalarySyn) {
        DynamicObject next;
        DynamicObject old;
        long salaryAdjRecId = salaryAdjRecord.getLong("id");
        Map<Long, DynamicObject> existIds = this.existSyncDetails.get(salaryAdjRecId);
        String enable = salaryAdjRecord.getString("enable");
        if ("0".equals(enable)) {
            return new ValidateResult(false, null, "");
        }
        if (existIds != null && adjSalarySyn != null && adjSalarySyn.getLong("id") != 0L && (old = existIds.get(adjSalarySyn.getLong("id"))) != null) {
            if (StringUtils.isEmpty((CharSequence)old.getString("errormsg"))) {
                return new ValidateResult(false, (Object)old, "");
            }
            return new ValidateResult(true, (Object)old, old.getString("syntype"));
        }
        String status = salaryAdjRecord.getString("status");
        String dataStatus = salaryAdjRecord.getString("datastatus");
        String syncType = "E".equals(status) || "-2".equals(dataStatus) || "-1".equals(dataStatus) || "-4".equals(dataStatus) ? (CollectionUtils.isEmpty(existIds) ? "" : "0") : (existIds == null || existIds.isEmpty() ? (this.event.isAbandon() || this.event.isExpire() ? "" : "1") : ("2".equals((next = existIds.values().iterator().next()).get("status")) ? "" : "2"));
        return new ValidateResult(false, null, syncType);
    }

    protected abstract void doInitEvent();

    protected void initEventExtend() {
        if (StringUtil.isEmpty((String)this.event.getDataSource()) && !CollectionUtils.isEmpty(this.salaryAdjRecordHisList)) {
            String eventType = this.event.getString("eventtype");
            LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.initEventExtend eventType is {}", (Object)eventType);
            if ("3".equals(eventType) || "2".equals(eventType)) {
                this.salaryAdjRecordHisList.sort((o1, o2) -> o2.getDate("createtime").compareTo(o1.getDate("createtime")));
                long billId = this.salaryAdjRecordHisList.get(0).getLong("bussinessid");
                this.event.setSrcBillId(billId);
                if ("3".equals(eventType)) {
                    SWCDataServiceHelper billServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
                    DynamicObject billObj = billServiceHelper.queryOriginalOne("billname,salaryadjrsn.attributiontype", (Object)billId);
                    if (billObj != null) {
                        this.event.setSrcBillDesc(billObj.getString("billname"));
                        String type = billObj.getString("salaryadjrsn.attributiontype");
                        if (!StringUtils.isEmpty((CharSequence)type)) {
                            this.event.setDataSource(eventType + type);
                        }
                    }
                } else {
                    this.event.setDataSource(eventType);
                    SWCDataServiceHelper billServiceHelper = new SWCDataServiceHelper("hcdm_candsetsalappl");
                    DynamicObject billObj = billServiceHelper.queryOriginalOne("billno", (Object)billId);
                    if (billObj != null) {
                        this.event.setSrcBillDesc(billObj.getString("billno"));
                    }
                }
            } else {
                this.event.setDataSource(eventType);
            }
        }
    }

    protected void addSalaryAdjRecord(List<DynamicObject> salaryAdjRecordList) {
        if (CollectionUtils.isEmpty(salaryAdjRecordList)) {
            return;
        }
        if (this.salaryAdjRecordHisList == null) {
            this.salaryAdjRecordHisList = Lists.newArrayList(salaryAdjRecordList);
        } else {
            this.salaryAdjRecordHisList.addAll(salaryAdjRecordList);
        }
        this.initEventExtend();
    }

    protected void addSalaryAdjPerson(List<DynamicObject> salaryAdjPersonList) {
        if (CollectionUtils.isEmpty(salaryAdjPersonList)) {
            return;
        }
        if (this.salaryAdjRelPersonMap == null) {
            this.salaryAdjRelPersonMap = Maps.newHashMapWithExpectedSize((int)salaryAdjPersonList.size());
        }
        salaryAdjPersonList.forEach(ele -> this.salaryAdjRelPersonMap.put(ele.getLong("id"), (DynamicObject)ele));
    }

    private BaseResult<SalaryAdjSyncSet> matchAdjSalarySynSet(long orgId, long countryId) {
        BaseResult<SalaryAdjSyncSet> result = this.matchDirectSet(orgId, countryId);
        if (!result.isSuccess() || result.getData() != null) {
            return result;
        }
        SalaryAdjSyncSet res = this.matchAssignSet(orgId, countryId);
        if (res != null) {
            return BaseResult.success((Object)res);
        }
        res = this.matchParentSet(orgId, countryId);
        return res == null ? BaseResult.message((String)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1001.getCode(), (int)400) : BaseResult.success((Object)res);
    }

    private BaseResult<SalaryAdjSyncSet> matchDirectSet(long orgId, long countryId) {
        Long result = (Long)this.syncSetDirectMap.get((Object)orgId, (Object)countryId);
        if (result == null && (result = (Long)this.syncSetDirectMap.get((Object)orgId, (Object)0L)) == null) {
            return BaseResult.success(null);
        }
        if (result > 0L) {
            return BaseResult.success((Object)this.syncSetMapOfId.get(result));
        }
        if (result == 0L) {
            return BaseResult.message((String)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1001.getCode(), (int)400);
        }
        return BaseResult.message((String)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1000.getCode(), (int)400);
    }

    private SalaryAdjSyncSet matchAssignSet(long orgId, long countryId) {
        Long result = (Long)this.syncSetAssignMap.get((Object)orgId, (Object)countryId);
        if (result == null) {
            result = (Long)this.syncSetAssignMap.get((Object)orgId, (Object)0L);
        }
        return this.syncSetMapOfId.get(result);
    }

    private SalaryAdjSyncSet matchParentSet(long orgId, long countryId) {
        Long tempId = (Long)this.syncSetParentMap.get((Object)orgId, (Object)countryId);
        if (tempId == null || tempId == 0L) {
            tempId = (Long)this.syncSetParentMap.get((Object)orgId, (Object)0L);
        }
        return this.syncSetMapOfId.get(tempId);
    }

    private SalaryAdjSyncGenResult initResult() {
        this.prevInitCommonResource();
        this.initResult = this.initResult == null ? BaseResult.success(null) : this.initResult;
        SalaryAdjSyncGenResult result = new SalaryAdjSyncGenResult((List<DynamicObject>)(this.salaryAdjRecordHisList == null ? Lists.newArrayList() : this.salaryAdjRecordHisList), this.initResult.getMessage());
        if (this.existSyncs != null) {
            LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.initResult existSyncs size is {}", (Object)this.existSyncs.size());
            for (Long orgId : this.existSyncs.rowKeySet()) {
                for (Map.Entry entry : this.existSyncs.row((Object)orgId).entrySet()) {
                    result.putAdjSalarySyn(orgId, (Long)entry.getKey(), (DynamicObject)entry.getValue());
                }
            }
        }
        result.setEvent(this.event);
        return result;
    }

    private void prevInitCommonResource() {
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource start");
        this.doInitEvent();
        if (this.event == null || this.event.getSrcEntity() == null) {
            String message = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b9a\u8c03\u85aa\u4e8b\u4ef6\u3002", (String)"BaseSalaryAdjSyncGenServiceImpl_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
            this.initResult = BaseResult.message((String)message, (int)400);
            return;
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource doInitEvent complete");
        this.doInitSalaryAdjRecordAndRelPerson();
        if (CollectionUtils.isEmpty(this.salaryAdjRelPersonMap)) {
            String message = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4efb\u4f55\u5b9a\u8c03\u85aa\u8bb0\u5f55\u3002", (String)"BaseSalaryAdjSyncGenServiceImpl_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
            this.initResult = BaseResult.message((String)message, (int)300);
            return;
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource doInitSalaryAdjRecordAndRelPerson complete");
        this.doInitExistSalarySyncRec();
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource doInitExistSalarySyncRec complete");
        if (CollectionUtils.isEmpty(this.syncSetMapOfId)) {
            HashBasedTable syncTplMapTemp = HashBasedTable.create();
            for (Map.Entry<Long, DynamicObject> entry : this.salaryAdjRelPersonMap.entrySet()) {
                DynamicObject person = entry.getValue();
                syncTplMapTemp.put((Object)SalaryAdjFieldFactory.getIdOfBaseProp(person, "org"), (Object)SalaryAdjFieldFactory.getIdOfBaseProp(person, "country"), (Object)0L);
            }
            this.doInitSyncTpl((HashBasedTable<Long, Long, Long>)syncTplMapTemp);
            LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource doInitSyncTpl complete");
        }
        if (CollectionUtils.isEmpty(this.syncSetMapOfId)) {
            String message = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u4f55\u5339\u914d\u7684\u5b9a\u85aa\u8bb0\u5f55\u540c\u6b65\u6a21\u677f\u3002", (String)"BaseSalaryAdjSyncGenServiceImpl_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
            this.initResult = BaseResult.message((String)message, (int)300);
            LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.prevInitCommonResource {}", (Object)message);
        } else {
            this.initResult = BaseResult.success(null);
        }
    }

    private void preInitSyncTpl(Set<Long> vidList) {
        HashBasedTable syncTplMapTemp = HashBasedTable.create();
        if (!CollectionUtils.isEmpty(this.salaryAdjRelPersonMap)) {
            for (Map.Entry<Long, DynamicObject> entry : this.salaryAdjRelPersonMap.entrySet()) {
                DynamicObject person = entry.getValue();
                syncTplMapTemp.put((Object)SalaryAdjFieldFactory.getIdOfBaseProp(person, "org"), (Object)SalaryAdjFieldFactory.getIdOfBaseProp(person, "country"), (Object)0L);
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct b.fcountryid, b.forgid from t_hcdm_salaryadjrecord a join t_hcdm_decadjrelperson b on a.frelpersonid = b.fid where a.fid in (0");
        vidList.forEach(ele -> sql.append(",?"));
        sql.append(')');
        try (DataSet dataSet = HCDMDbHelper.queryDataSet(sql.toString(), vidList.toArray());){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                syncTplMapTemp.put((Object)next.getLong("forgid"), (Object)next.getLong("fcountryid"), (Object)0L);
            }
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.preInitSyncTpl syncTplMapTemp size is {}", (Object)syncTplMapTemp.size());
        this.doInitSyncTpl((HashBasedTable<Long, Long, Long>)syncTplMapTemp);
    }

    protected void doInitSalaryAdjRecordAndRelPerson() {
        Object serviceHelper;
        Set<Long> vidList = this.salaryAdjRecordVidSet();
        if (CollectionUtils.isEmpty(vidList)) {
            return;
        }
        this.preInitSyncTpl(vidList);
        HashSet recordPropName = Sets.newHashSetWithExpectedSize((int)20);
        HashSet personPropName = Sets.newHashSetWithExpectedSize((int)20);
        StringBuilder field = new StringBuilder("id,boid,salaryadjrsn.id,standarditem.id,frequency.id,currency.id,amount,relpersonid,salaryadjfile.id,datasource,bussinessid,actualamount,issend,needpush,bsed,bsled,remark,enable,status,datastatus,createtime");
        if (!CollectionUtils.isEmpty(this.syncSetMapOfId)) {
            this.collectPropsFromSet(recordPropName, personPropName);
        }
        if (!CollectionUtils.isEmpty(this.salaryAdjRecordHisList)) {
            if (!CollectionUtils.isEmpty((Collection)recordPropName)) {
                this.abandonAdjRecIfPropAbsent(vidList, recordPropName);
            } else {
                for (DynamicObject obj : this.salaryAdjRecordHisList) {
                    vidList.remove(obj.getLong("id"));
                }
            }
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.doInitSalaryAdjRecordAndRelPerson vid size after adjust is {}", (Object)vidList.size());
        if (!CollectionUtils.isEmpty(vidList)) {
            for (String prop : recordPropName) {
                field.append(',').append(prop);
            }
            QFilter idFilter = new QFilter("id", "in", vidList);
            serviceHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
            Object[] salaryAdjRecords = serviceHelper.query(field.toString(), new QFilter[]{idFilter}, "id desc");
            if (!ArrayUtils.isEmpty((Object[])salaryAdjRecords)) {
                this.addSalaryAdjRecord(Arrays.asList(salaryAdjRecords));
            }
        }
        if (CollectionUtils.isEmpty(this.salaryAdjRecordHisList)) {
            return;
        }
        Set<Long> relPersonIds = this.salaryAdjRecordHisList.stream().map(ele -> ele.getLong("relpersonid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(this.salaryAdjRelPersonMap)) {
            if (!CollectionUtils.isEmpty((Collection)personPropName)) {
                this.abandonAdjPersonIfPropAbsent(personPropName, relPersonIds);
            } else {
                relPersonIds.removeAll(this.salaryAdjRelPersonMap.keySet());
            }
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.doInitSalaryAdjRecordAndRelPerson relPersonIds size after adjust is {}", (Object)vidList.size());
        if (!CollectionUtils.isEmpty(relPersonIds)) {
            field = new StringBuilder("id,country.id,org.id,empgroup.id,depcytype.id,salaystructure,depemp,adminorg,position,job,stdposition,empnumber,personname,joblevel,jobgrade");
            for (String prop : personPropName) {
                field.append(',').append(prop);
            }
            serviceHelper = new SWCDataServiceHelper("hcdm_decadjrelperson");
            Object[] salaryAdjRelPersons = serviceHelper.query(field.toString(), new QFilter[]{new QFilter("id", "in", relPersonIds)}, "id desc");
            if (!ArrayUtils.isEmpty((Object[])salaryAdjRelPersons)) {
                this.addSalaryAdjPerson(Arrays.asList(salaryAdjRelPersons));
            }
        }
    }

    private void abandonAdjPersonIfPropAbsent(Set<String> personPropName, Set<Long> relPersonIds) {
        DynamicObject next = this.salaryAdjRelPersonMap.values().iterator().next();
        for (String prop : personPropName) {
            try {
                next.get(prop);
            }
            catch (Exception ex) {
                this.salaryAdjRelPersonMap.clear();
                return;
            }
        }
        relPersonIds.removeAll(this.salaryAdjRelPersonMap.keySet());
    }

    private void abandonAdjRecIfPropAbsent(Set<Long> vidList, Set<String> recordPropName) {
        DynamicObject object = this.salaryAdjRecordHisList.get(0);
        for (String prop : recordPropName) {
            try {
                object.get(prop);
            }
            catch (Exception ex) {
                this.salaryAdjRecordHisList.clear();
                return;
            }
            for (DynamicObject obj : this.salaryAdjRecordHisList) {
                vidList.remove(obj.getLong("id"));
            }
        }
    }

    private void collectPropsFromSet(Set<String> recordPropName, Set<String> personPropName) {
        for (Map.Entry<Long, SalaryAdjSyncSet> entry : this.syncSetMapOfId.entrySet()) {
            SalaryAdjSyncSet syncSet = entry.getValue();
            Map<Long, Pair<String, String>> fetchOfProp = syncSet.getValueFetchOfProp();
            for (Map.Entry<Long, Pair<String, String>> pairEntry : fetchOfProp.entrySet()) {
                Pair<String, String> value = pairEntry.getValue();
                if ("hcdm_decadjrelperson".equals(value.getValue())) {
                    personPropName.add((String)value.getKey());
                    continue;
                }
                if (!"hcdm_salaryadjrecord".equals(value.getValue())) continue;
                recordPropName.add((String)value.getKey());
            }
        }
    }

    protected abstract Set<Long> salaryAdjRecordVidSet();

    protected void doInitExistSalarySyncRec() {
        List salaryAdjRecordIds = this.salaryAdjRecordHisList.stream().map(ele -> ele.getLong("id")).collect(Collectors.toList());
        QFilter recdFilter = new QFilter("salaryadjrecord.id", "in", salaryAdjRecordIds);
        Set syncIds = this.existSyncs.values().stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
        QFilter syncFilter = new QFilter("adjsalsyn", "in", syncIds).or("syntype", "=", (Object)"1");
        DynamicObject[] existSyncDetail = this.adjSalarySynDetailHelper.query(SalaryAdjSyncConstants.SYNC_DETAIL_QUERY_PROPS, new QFilter[]{syncFilter, recdFilter});
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.doInitExistSalarySyncRec existSyncDetails size is {}", (Object)existSyncDetail.length);
        this.existSyncDetails = this.existSyncDetails == null ? Maps.newHashMapWithExpectedSize((int)existSyncDetail.length) : this.existSyncDetails;
        for (DynamicObject detail : existSyncDetail) {
            long recordId = detail.getLong("salaryadjrecord.id");
            long syncId = detail.getLong("adjsalsyn");
            Map syncDetailMap = this.existSyncDetails.computeIfAbsent(recordId, recKey -> Maps.newHashMapWithExpectedSize((int)2));
            syncDetailMap.put(syncId, detail);
        }
    }

    protected void doInitSyncTpl(HashBasedTable<Long, Long, Long> syncTplMapTemp) {
        if (syncTplMapTemp == null || syncTplMapTemp.isEmpty()) {
            return;
        }
        if (this.syncSetMapOfId == null) {
            this.syncSetMapOfId = Maps.newHashMapWithExpectedSize((int)syncTplMapTemp.size());
        }
        LOGGER.info("Trace By Quinn: BaseSalaryAdjSyncGenServiceImpl.doInitSyncTpl doInitSyncTplFromExistSync syncTplMapTemp size is {}", (Object)syncTplMapTemp.size());
        this.doInitSyncTplFromExistSync(syncTplMapTemp);
        if (syncTplMapTemp.isEmpty()) {
            return;
        }
        HashBasedTable parentShareTpl = HashBasedTable.create();
        ArrayList coveredTpl = Lists.newArrayListWithCapacity((int)syncTplMapTemp.size());
        LOGGER.info(" syncTplMapTemp orgids:{}", (Object)JSON.toJSONString(syncTplMapTemp));
        for (Long orgId : syncTplMapTemp.rowKeySet()) {
            QFilter filter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_adjsalarysynset", (Long)orgId);
            Map placeHolder = syncTplMapTemp.row((Object)orgId);
            HashSet countryIds = Sets.newHashSet(placeHolder.keySet());
            Object[] synSetArr = this.loadSynSet(countryIds, filter);
            if (ArrayUtils.isEmpty((Object[])synSetArr)) continue;
            for (Object synSet : synSetArr) {
                String areaType = synSet.getString("areatype");
                long countryId = synSet.getLong("country.id");
                long createOrgId = synSet.getLong("createorg.id");
                long id = synSet.getLong("id");
                if (createOrgId == orgId) {
                    coveredTpl.add(new Pair((Object)orgId, (Object)countryId));
                    if (countryId == 0L && "1".equals(areaType)) {
                        this.syncSetDirectMap.put((Object)orgId, (Object)countryId, (Object)id);
                        this.syncSetMapOfId.put(id, new SalaryAdjSyncSet((DynamicObject)synSet));
                        continue;
                    }
                    if (!syncTplMapTemp.contains((Object)orgId, (Object)countryId)) continue;
                    this.syncSetDirectMap.put((Object)orgId, (Object)countryId, (Object)id);
                    this.syncSetMapOfId.put(id, new SalaryAdjSyncSet((DynamicObject)synSet));
                    continue;
                }
                if (this.syncSetDirectMap.get((Object)orgId, (Object)countryId) != null) continue;
                String ctrlStrategy = synSet.getString("ctrlstrategy");
                if ("5".equals(ctrlStrategy)) {
                    parentShareTpl.put((Object)createOrgId, (Object)countryId, synSet);
                    continue;
                }
                if ((!"1".equals(areaType) || countryId != 0L) && !syncTplMapTemp.contains((Object)orgId, (Object)countryId)) continue;
                coveredTpl.add(new Pair((Object)orgId, (Object)countryId));
                Long oldId = (Long)this.syncSetAssignMap.put((Object)orgId, (Object)countryId, (Object)id);
                if (oldId != null) {
                    this.syncSetDirectMap.put((Object)orgId, (Object)countryId, (Object)-1L);
                    this.syncSetAssignMap.remove((Object)orgId, (Object)countryId);
                    continue;
                }
                this.syncSetMapOfId.put(id, new SalaryAdjSyncSet((DynamicObject)synSet));
            }
        }
        for (Pair pair : coveredTpl) {
            Long orgId = (Long)pair.getKey();
            Long countryId = (Long)pair.getValue();
            if (countryId == 0L) {
                syncTplMapTemp.rowKeySet().remove(orgId);
                continue;
            }
            syncTplMapTemp.remove((Object)orgId, (Object)countryId);
        }
        if (!syncTplMapTemp.isEmpty()) {
            Set orgIds = syncTplMapTemp.rowKeySet();
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            Map allSuperiorOrg = orgService.getAllSuperiorOrgs("28", (List)Lists.newArrayList((Iterable)orgIds));
            if (!CollectionUtils.isEmpty((Map)allSuperiorOrg)) {
                for (Map.Entry entry : allSuperiorOrg.entrySet()) {
                    Long orgId = (Long)entry.getKey();
                    Map row = syncTplMapTemp.row((Object)orgId);
                    row.put(0L, 0L);
                    List superOrgIds = (List)entry.getValue();
                    block4: for (Map.Entry placeholderOfCountry : row.entrySet()) {
                        for (Long superOrgId : superOrgIds) {
                            Long countryId;
                            DynamicObject object = (DynamicObject)parentShareTpl.get((Object)superOrgId, (Object)(countryId = (Long)placeholderOfCountry.getKey()));
                            if (object == null) continue;
                            long setId = object.getLong("id");
                            this.syncSetParentMap.put((Object)orgId, (Object)countryId, (Object)setId);
                            this.syncSetMapOfId.putIfAbsent(setId, new SalaryAdjSyncSet(object));
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    protected void doInitSyncTplFromExistSync(HashBasedTable<Long, Long, Long> syncTplMapTemp) {
        Long eventId = this.event.getLong("id");
        Object[] existSyncObjs = this.adjSalSynId == 0L ? this.adjSalarySynHelper.query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{new QFilter("salaryadjevent.id", "=", (Object)eventId)}) : this.adjSalarySynHelper.query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{new QFilter("id", "=", (Object)this.adjSalSynId)});
        if (ArrayUtils.isEmpty((Object[])existSyncObjs)) {
            this.existSyncs = this.existSyncs == null ? HashBasedTable.create((int)0, (int)0) : this.existSyncs;
            this.existSyncDetails = this.existSyncDetails == null ? Maps.newHashMapWithExpectedSize((int)0) : this.existSyncDetails;
            return;
        }
        ArrayList setIds = Lists.newArrayListWithCapacity((int)existSyncObjs.length);
        this.existSyncs = this.existSyncs == null ? HashBasedTable.create((int)existSyncObjs.length, (int)4) : this.existSyncs;
        for (Object sync : existSyncObjs) {
            long setId;
            Long orgId = sync.getLong("org.id");
            Long countryId = sync.getLong("country.id");
            this.existSyncs.put((Object)orgId, (Object)countryId, sync);
            Long placeholder = (Long)syncTplMapTemp.get((Object)orgId, (Object)countryId);
            if (placeholder == null || (setId = sync.getLong("adjsalarysynset.id")) == 0L) continue;
            this.syncSetDirectMap.put((Object)orgId, (Object)countryId, (Object)setId);
            syncTplMapTemp.remove((Object)orgId, (Object)countryId);
            setIds.add(setId);
        }
        this.loadSyncSet(setIds);
    }

    private DynamicObject[] loadSynSet(Set<Long> countryIds, QFilter ... filter) {
        QFilter[] filters;
        QFilter countryFilter = new QFilter("country.id", "in", countryIds);
        countryFilter.or(new QFilter("areatype", "=", (Object)"1"));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (ArrayUtils.isEmpty((Object[])filter)) {
            filters = new QFilter[]{countryFilter, statusFilter, enableFilter};
        } else {
            filters = Arrays.copyOf(filter, filter.length + 3);
            filters[filter.length] = countryFilter;
            filters[filter.length + 1] = statusFilter;
            filters[filter.length + 2] = enableFilter;
        }
        return this.adjSalarySynSetHelper.query("id,createorg,areatype,country,syncstrategy,syncschedule,ctrlstrategy,entryentity.bizitem,entryentity.salarystditem,fieldentry.salaryadjfield,fieldentry.bizitemprop", filters);
    }

    private void loadSyncSet(Collection<Long> setIds) {
        DynamicObject[] adjSalarySynSet;
        if (CollectionUtils.isEmpty(setIds)) {
            return;
        }
        for (DynamicObject synSet : adjSalarySynSet = this.adjSalarySynSetHelper.query("id,createorg,areatype,country,syncstrategy,syncschedule,ctrlstrategy,entryentity.bizitem,entryentity.salarystditem,fieldentry.salaryadjfield,fieldentry.bizitemprop", new QFilter[]{new QFilter("id", "in", setIds)})) {
            this.syncSetMapOfId.put(synSet.getLong("id"), new SalaryAdjSyncSet(synSet));
        }
    }

    public void setAdjSalSynId(long adjSalSynId) {
        this.adjSalSynId = adjSalSynId;
    }
}

