/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync.impl;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynExtService;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.event.BeforeSalaryAdjSyncDeleteEvent;
import kd.swc.hcdm.business.salaryadjsync.AdjSalSynExtService;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPushResult;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPusher;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hcdm.common.utils.HCDMServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryAdjSyncDeletePusher
implements SalaryAdjSyncPusher {
    private static final Log LOGGER = LogFactory.getLog(SalaryAdjSyncDeletePusher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SalaryAdjSyncPushResult push(DynamicObject syncRecord, List<Long> syncDetailIds) {
        SWCDataServiceHelper adjSalarySynDetailHelper = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
        QFilter msgCodeFilter = new QFilter("errormsg", "not in", (Object)new String[]{AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1000.getCode(), AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1001.getCode(), AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1005.getCode(), AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1006.getCode(), AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode(), AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode()});
        Object[] syncDetails = adjSalarySynDetailHelper.query("id,bizdatacode,bizitem.id,status,errormsg,errormessage", new QFilter[]{new QFilter("id", "in", syncDetailIds), msgCodeFilter});
        SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(syncDetailIds, null);
        if (ArrayUtils.isEmpty((Object[])syncDetails)) {
            return result;
        }
        result.addSyncDetails((DynamicObject[])syncDetails);
        try (TXHandle handle = TX.requiresNew();){
            Map params = AdjSalarySynHelper.assembleAdjSalaryForDel(syncRecord, (DynamicObject[])syncDetails);
            BeforeSalaryAdjSyncDeleteEvent event = new BeforeSalaryAdjSyncDeleteEvent();
            event.setParams(params);
            event.setSyncRecord(syncRecord);
            event.setSyncDetails((DynamicObject[])syncDetails);
            HRPlugInProxyFactory.create((Object)new AdjSalSynExtService(), IAdjSalSynExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynExtService#beforeSalaryAdjSyncDelete", null).callReplaceIfPresent(proxy -> {
                proxy.beforeSalaryAdjSyncDelete(event);
                return null;
            });
            params = event.getParams();
            LOGGER.info("Trace by Quinn SalaryAdjSyncDeletePusher request: {}", (Object)SerializationUtils.toJsonString((Object)params));
            Map rpcRes = HCDMServiceUtils.delBizData((Map)params);
            result.mergeRpcRes(rpcRes);
            LOGGER.info("Trace by Quinn SalaryAdjSyncDeletePusher response: {}", (Object)SerializationUtils.toJsonString((Object)rpcRes));
            handle.commit();
        }
        return result;
    }
}

