/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjEvent;
import kd.swc.hcdm.business.salaryadjsync.impl.BaseSalaryAdjSyncGenServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryAdjSyncGenEventAndBoIdServiceImpl
extends BaseSalaryAdjSyncGenServiceImpl {
    private static final Log LOGGER = LogFactory.getLog(SalaryAdjSyncGenEventAndBoIdServiceImpl.class);
    private final List<Long> adjSalaryRecBoIds;

    public SalaryAdjSyncGenEventAndBoIdServiceImpl(Object event, List<Long> adjSalaryRecBoIds) {
        this.event = event instanceof Long ? new SalaryAdjEvent((Long)event) : new SalaryAdjEvent(String.valueOf(event));
        this.adjSalaryRecBoIds = adjSalaryRecBoIds == null ? Lists.newArrayList() : adjSalaryRecBoIds;
    }

    public static SalaryAdjSyncGenEventAndBoIdServiceImpl newInstance(Object event, List<DynamicObject> adjSalaryRecs, List<DynamicObject> relPersonDys) {
        if (CollectionUtils.isEmpty(adjSalaryRecs)) {
            return new SalaryAdjSyncGenEventAndBoIdServiceImpl(event, null);
        }
        HashSet recBoIds = Sets.newHashSetWithExpectedSize((int)adjSalaryRecs.size());
        ArrayList copyList = Lists.newArrayList(adjSalaryRecs);
        Iterator iterator = copyList.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            long boId = next.getLong("boid");
            recBoIds.add(boId);
            if (next.getLong("id") != boId) continue;
            iterator.remove();
        }
        return new SalaryAdjSyncGenEventAndBoIdServiceImpl(event, Lists.newArrayList((Iterable)recBoIds));
    }

    @Override
    protected void doInitEvent() {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncGenEventAndBoIdServiceImpl.doInitEvent start");
        QFilter filter = this.event.getEventId() != 0L ? new QFilter("id", "=", (Object)this.event.getEventId()) : new QFilter("event", "=", (Object)this.event.getEventKey());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_salaryadjevent");
        DynamicObject eventEntity = serviceHelper.queryOne("id,event,eventtype,eventdate,comment,eventstatus,needrepush", new QFilter[]{filter});
        if (eventEntity == null) {
            LOGGER.info("Trace By Quinn: SalaryAdjSyncGenEventAndBoIdServiceImpl.doInitEvent eventEntity is null");
            return;
        }
        this.event.init(eventEntity);
        this.initEventExtend();
        LOGGER.info("Trace By Quinn: SalaryAdjSyncGenEventAndBoIdServiceImpl.doInitEvent initEventExtend complete");
    }

    @Override
    protected Set<Long> salaryAdjRecordVidSet() {
        StringBuilder sql = new StringBuilder().append("select a.fvid from t_hcdm_eventrelhis a join t_hcdm_busieventrel b ON a.fbusieventid = b.fid where b.feventid = ?").append(" and b.fsourceentity = 'hcdm_salaryadjrecord'");
        if (!CollectionUtils.isEmpty(this.adjSalaryRecBoIds)) {
            sql.append(" and b.fboid in (0");
            this.adjSalaryRecBoIds.forEach(ele -> sql.append(",?"));
            sql.append(')');
        }
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)(1 + this.adjSalaryRecBoIds.size()));
        paramList.add(this.event.getLong("id"));
        paramList.addAll(this.adjSalaryRecBoIds);
        HashSet vidList = Sets.newHashSetWithExpectedSize((int)(this.adjSalaryRecBoIds.isEmpty() ? 2000 : this.adjSalaryRecBoIds.size() * 2));
        try (DataSet dataSet = HCDMDbHelper.queryDataSet(sql.toString(), paramList.toArray());){
            while (dataSet.hasNext()) {
                vidList.add(dataSet.next().getLong("fvid"));
            }
        }
        LOGGER.info("Trace By Quinn: SalaryAdjSyncGenEventAndBoIdServiceImpl.salaryAdjRecordVidSet vid size is {}", (Object)vidList.size());
        return vidList;
    }
}

