/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynExtService;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.event.BeforeUpdateSyncDetailStatusEvent;
import kd.swc.hcdm.business.salaryadjsync.AdjSalSynExtService;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPushResult;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPusher;
import kd.swc.hcdm.business.salaryadjsync.impl.BaseSalaryAdjSyncPushServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncGenBackAtPushServiceImpl;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.model.Message;

public class SalaryAdjSyncPushSyncDetailServiceImpl
extends BaseSalaryAdjSyncPushServiceImpl {
    private static final SWCDataServiceHelper ADJ_SALARY_SYN_DETAIL_HELPER = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
    private static final SWCDataServiceHelper ADJ_SAL_SYN_HELPER = new SWCDataServiceHelper("hcdm_adjsalsyn");
    private static final int BATCH_SIZE = 1000;
    private static final int BATCH_WITH_BUFFER = 1020;
    private final DynamicObject syncRecord;
    private final String syncType;
    private final Map<Long, Long> syncDetailIdToRecEmployeeIds;
    private Map<Long, Long> failDetailIdRecIds;

    public SalaryAdjSyncPushSyncDetailServiceImpl(Long syncRecordId, Map<Long, Long> syncDetailIdToRecBoIds, String syncType) {
        this(ADJ_SAL_SYN_HELPER.queryOne("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", (Object)syncRecordId), syncDetailIdToRecBoIds, syncType);
    }

    public SalaryAdjSyncPushSyncDetailServiceImpl(DynamicObject syncRecord, Map<Long, Long> syncDetailIdToRecEmployeeIds, String syncType) {
        this.syncRecord = syncRecord;
        this.syncDetailIdToRecEmployeeIds = syncDetailIdToRecEmployeeIds;
        this.syncType = syncType;
    }

    @Override
    public SalaryAdjSyncPushResult pushSyncData() {
        if (CollectionUtils.isEmpty(this.syncDetailIdToRecEmployeeIds) || StringUtils.isEmpty((Object)this.syncType)) {
            Object[] ids;
            ArrayList filterList = Lists.newArrayListWithExpectedSize((int)4);
            filterList.add(new QFilter("adjsalsyn", "=", (Object)this.syncRecord.getLong("id")));
            filterList.add(new QFilter("status", "in", (Object)new String[]{"1", "9"}));
            if (!CollectionUtils.isEmpty(this.syncDetailIdToRecEmployeeIds)) {
                filterList.add(new QFilter("id", "in", this.syncDetailIdToRecEmployeeIds.keySet()));
            }
            if (!StringUtils.isEmpty((Object)this.syncType)) {
                filterList.add(new QFilter("syntype", "=", (Object)this.syncType));
            }
            if (ArrayUtils.isEmpty((Object[])(ids = ADJ_SALARY_SYN_DETAIL_HELPER.query("id,syntype,adjsalsyn,salaryadjrecordboid,salaryadjrecord.id,employee.id,status,errormsg,errormessage", filterList.toArray(new QFilter[0]), "salaryadjrecordboid asc")))) {
                return new SalaryAdjSyncPushResult(Lists.newArrayList(), null);
            }
            SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(Lists.newArrayListWithExpectedSize((int)ids.length), null);
            Map idOfType = Arrays.stream(ids).collect(Collectors.groupingBy(ele -> ele.getString("syntype"), HashMap::new, Collectors.toList()));
            ArrayList synTypeList = Lists.newArrayList((Object[])new String[]{"0", "2", "1"});
            for (String synType : synTypeList) {
                List value = (List)idOfType.get(synType);
                if (CollectionUtils.isEmpty((Collection)value)) continue;
                if (value.size() > 1000) {
                    ArrayList split = Lists.newArrayListWithCapacity((int)1020);
                    long latestRecBoId = 0L;
                    for (DynamicObject object : value) {
                        long boId;
                        split.add(object);
                        if (split.size() <= 1000 || latestRecBoId == (boId = object.getLong("salaryadjrecordboid"))) continue;
                        SalaryAdjSyncPushSyncDetailServiceImpl.subGroupPush(result, synType, this.syncRecord, split);
                        split = Lists.newArrayListWithCapacity((int)1020);
                        latestRecBoId = boId;
                    }
                    if (split.isEmpty()) continue;
                    SalaryAdjSyncPushSyncDetailServiceImpl.subGroupPush(result, synType, this.syncRecord, split);
                    continue;
                }
                SalaryAdjSyncPushSyncDetailServiceImpl.subGroupPush(result, synType, this.syncRecord, value);
            }
            return result;
        }
        return this.doPushSyncData();
    }

    @Override
    public BaseResult<List<String>> validateBefore() {
        if (this.syncRecord == null) {
            return BaseResult.success((Object)Lists.newArrayList());
        }
        return BaseResult.success((Object)Lists.newArrayList((Object[])new String[]{this.syncRecord.getString("batchnumber")}));
    }

    public static void subGroupPush(SalaryAdjSyncPushResult result, String syncType, DynamicObject syncRecord, List<DynamicObject> details) {
        HashMap detailIdToEmployeeId = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap failDetailIdRecIdsTemp = Maps.newHashMapWithExpectedSize((int)details.size());
        for (DynamicObject detail : details) {
            long employeeId = detail.getLong("employee.id");
            long id = detail.getLong("id");
            detailIdToEmployeeId.put(id, employeeId);
            if (StringUtils.isEmpty((Object)detail.getString("errormsg"))) continue;
            long salaryAdjRecordId = detail.getLong("salaryadjrecord.id");
            failDetailIdRecIdsTemp.put(id, salaryAdjRecordId);
        }
        SalaryAdjSyncPushSyncDetailServiceImpl syncDetailService = new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecord, (Map<Long, Long>)detailIdToEmployeeId, syncType);
        if (!CollectionUtils.isEmpty((Map)failDetailIdRecIdsTemp)) {
            syncDetailService.setFailDetailIdRecIds(failDetailIdRecIdsTemp);
        }
        result.merge(syncDetailService.pushSyncData());
    }

    public SalaryAdjSyncPushResult doPushSyncData() {
        SalaryAdjSyncPusher pusher = SalaryAdjSyncPusher.bySyncType(this.syncType);
        if (pusher == null) {
            return new SalaryAdjSyncPushResult(Lists.newArrayList(this.syncDetailIdToRecEmployeeIds.keySet()), new Message("syncType not supported", 400));
        }
        QFilter boIdFilter = new QFilter("employee.id", "in", this.syncDetailIdToRecEmployeeIds.values());
        QFilter syncIdFilter = new QFilter("adjsalsyn", "<", (Object)this.syncRecord.getLong("id"));
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"1", "9"});
        Object[] notReadyOld = ADJ_SALARY_SYN_DETAIL_HELPER.queryOriginalArray("id,employee.id,batchnumber", new QFilter[]{boIdFilter, syncIdFilter, statusFilter});
        SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(Lists.newArrayListWithExpectedSize((int)this.syncDetailIdToRecEmployeeIds.size()), null);
        if (!ArrayUtils.isEmpty((Object[])notReadyOld)) {
            HashMap employeeBatchNumberMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Object detailSynDy : notReadyOld) {
                long employeeId = detailSynDy.getLong("employee.id");
                String batchNumber = detailSynDy.getString("batchnumber");
                Set batchNums = employeeBatchNumberMap.computeIfAbsent(employeeId, key -> new HashSet());
                batchNums.add(batchNumber);
            }
            Set employeeIds = employeeBatchNumberMap.keySet();
            ArrayList failIds = Lists.newArrayListWithCapacity((int)Math.min(employeeIds.size(), this.syncDetailIdToRecEmployeeIds.size()));
            Iterator<Map.Entry<Long, Long>> iterator = this.syncDetailIdToRecEmployeeIds.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Long> next = iterator.next();
                if (!employeeIds.contains(next.getValue())) continue;
                failIds.add(next.getKey());
                iterator.remove();
            }
            DynamicObject[] query = ADJ_SALARY_SYN_DETAIL_HELPER.query("id,bizdatacode,status,errormsg,errormessage,employee.id", new QFilter[]{new QFilter("id", "in", (Object)failIds)});
            Map<Long, String> empErrorMap = this.convertErrorMsg(employeeBatchNumberMap);
            result.addSyncDetailsWith(query, new Message(AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1002.getCode(), 400), empErrorMap);
        }
        if (!CollectionUtils.isEmpty(this.syncDetailIdToRecEmployeeIds)) {
            if (!CollectionUtils.isEmpty(this.failDetailIdRecIds)) {
                this.failDetailIdRecIds.keySet().retainAll(this.syncDetailIdToRecEmployeeIds.keySet());
                if (!this.failDetailIdRecIds.isEmpty()) {
                    SalaryAdjSyncGenBackAtPushServiceImpl backAtPushService = new SalaryAdjSyncGenBackAtPushServiceImpl(this.syncRecord.getDynamicObject("salaryadjevent"), this.failDetailIdRecIds);
                    backAtPushService.setAdjSalSynId(this.syncRecord.getLong("id"));
                    backAtPushService.generateSyncData();
                }
            }
            SalaryAdjSyncPushResult pushResult = pusher.push(this.syncRecord, Lists.newArrayList(this.syncDetailIdToRecEmployeeIds.keySet()));
            result.merge(pushResult);
        }
        this.updateSyncDetailStatus(result);
        SalaryAdjSyncFacade.updateSyncRecStatus(ADJ_SAL_SYN_HELPER, this.syncRecord);
        return result;
    }

    private Map<Long, String> convertErrorMsg(Map<Long, Set<String>> employeeBatchNumberMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)employeeBatchNumberMap.size());
        String errorMsg = AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1007.getName();
        for (Map.Entry<Long, Set<String>> entry : employeeBatchNumberMap.entrySet()) {
            Set<String> batchNumberSet = entry.getValue();
            StringJoiner stringJoiner = new StringJoiner("\uff1b");
            for (String batchNumber : batchNumberSet) {
                if (stringJoiner.length() > 500) break;
                stringJoiner.add(batchNumber);
            }
            resultMap.put(entry.getKey(), MessageFormat.format(errorMsg, stringJoiner.toString()));
        }
        return resultMap;
    }

    protected void updateSyncDetailStatus(SalaryAdjSyncPushResult result) {
        List details = result.detailsWithStatus();
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        BeforeUpdateSyncDetailStatusEvent event = new BeforeUpdateSyncDetailStatusEvent();
        event.setSyncRecord(this.syncRecord);
        event.setDetails(details);
        HRPlugInProxyFactory.create((Object)new AdjSalSynExtService(), IAdjSalSynExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynExtService#beforeUpdateSyncDetailStatus", null).callReplaceIfPresent(proxy -> {
            proxy.beforeUpdateSyncDetailStatus(event);
            return null;
        });
        details = event.getDetails();
        ArrayList status1002List = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList statusOtherList = Lists.newArrayListWithExpectedSize((int)details.size());
        for (DynamicObject detail : details) {
            if (AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1002.getCode().equals(detail.getString("errormsg"))) {
                status1002List.add(detail);
                continue;
            }
            statusOtherList.add(detail);
        }
        if (!CollectionUtils.isEmpty((Collection)statusOtherList)) {
            ADJ_SALARY_SYN_DETAIL_HELPER.save(statusOtherList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)status1002List)) {
            ADJ_SALARY_SYN_DETAIL_HELPER.save(status1002List.toArray(new DynamicObject[0]));
        }
    }

    public void setFailDetailIdRecIds(Map<Long, Long> failDetailIdRecIds) {
        this.failDetailIdRecIds = failDetailIdRecIds;
    }
}

