/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPushResult;
import kd.swc.hcdm.business.salaryadjsync.impl.BaseSalaryAdjSyncPushServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushSyncDetailServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.model.Message;

public class SalaryAdjSyncPushSyncRecordServiceImpl
extends BaseSalaryAdjSyncPushServiceImpl {
    private static final Log logger = LogFactory.getLog(SalaryAdjSyncPushSyncRecordServiceImpl.class);
    private final DynamicObject[] syncRecords;
    private static final long[] RE_PUSH_DURATIONS = new long[]{5000L, 20000L, 120000L};

    public SalaryAdjSyncPushSyncRecordServiceImpl(DynamicObject[] syncRecords) {
        this.syncRecords = syncRecords;
    }

    @Override
    public SalaryAdjSyncPushResult pushSyncData() {
        if (ArrayUtils.isEmpty((Object[])this.syncRecords)) {
            return new SalaryAdjSyncPushResult(Lists.newArrayList(), null);
        }
        SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(Lists.newArrayListWithExpectedSize((int)1000), null);
        for (DynamicObject syncRecord : this.syncRecords) {
            if ("0".equals(syncRecord.getString("synstatus"))) continue;
            String synTypes = syncRecord.getString("syntypes");
            if (StringUtils.isEmpty((CharSequence)synTypes)) {
                SalaryAdjSyncPushResult res = new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecord, null, null).pushSyncData();
                result.merge(res);
                if (!"1".equals(syncRecord.getString("needrepush")) || syncRecord.getInt("syntimes") != 0 || !res.hasFailMsg()) continue;
                this.synRePushSyncRecord(syncRecord, null);
                continue;
            }
            ArrayList synTypeList = Lists.newArrayList((Object[])new String[]{"0", "2", "1"});
            String[] synTypeArr = synTypes.split(",");
            synTypeList.retainAll(Arrays.asList(synTypeArr));
            SalaryAdjSyncPushResult resultTemp = new SalaryAdjSyncPushResult(Lists.newArrayListWithExpectedSize((int)1000), null);
            for (String synType : synTypeList) {
                SalaryAdjSyncPushResult res = new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecord, null, synType).pushSyncData();
                resultTemp.merge(res);
                result.merge(res);
            }
            if (!"1".equals(syncRecord.getString("needrepush")) || syncRecord.getInt("syntimes") != 0 || !resultTemp.hasFailMsg()) continue;
            this.synRePushSyncRecord(syncRecord, synTypeList);
        }
        return result;
    }

    private void synRePushSyncRecord(DynamicObject syncRecord, List<String> synTypeList) {
        syncRecord.set("syntimes", (Object)1);
        syncRecord.set("syntime", (Object)new Date());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
        serviceHelper.saveOne(syncRecord);
        RequestContext ctx = RequestContext.getOrCreate();
        ThreadPools.executeOnce((String)"SalaryAdjSyncPushSyncRecordServiceImpl.synRePushSyncRecord", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            this.rePushSyncRecord(syncRecord, synTypeList, 1);
        });
    }

    private void rePushSyncRecord(DynamicObject syncRecord, List<String> synTypeList, int synTimes) {
        if (synTimes > RE_PUSH_DURATIONS.length) {
            return;
        }
        long duration = RE_PUSH_DURATIONS[synTimes - 1];
        this.sleep(duration);
        if (synTimes > 1) {
            syncRecord.set("syntimes", (Object)synTimes);
            syncRecord.set("syntime", (Object)new Date());
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
            serviceHelper.saveOne(syncRecord);
        }
        if (CollectionUtils.isEmpty(synTypeList)) {
            SalaryAdjSyncPushResult res = new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecord, null, null).pushSyncData();
            if ("1".equals(syncRecord.getString("needrepush")) && res.hasFailMsg() && synTimes < RE_PUSH_DURATIONS.length) {
                this.rePushSyncRecord(syncRecord, null, synTimes + 1);
            }
        } else {
            SalaryAdjSyncPushResult resultTemp = new SalaryAdjSyncPushResult(Lists.newArrayListWithExpectedSize((int)1000), null);
            for (String synType : synTypeList) {
                SalaryAdjSyncPushResult res = new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecord, null, synType).pushSyncData();
                resultTemp.merge(res);
            }
            if ("1".equals(syncRecord.getString("needrepush")) && resultTemp.hasFailMsg() && synTimes < RE_PUSH_DURATIONS.length) {
                this.rePushSyncRecord(syncRecord, synTypeList, synTimes + 1);
            }
        }
    }

    private void sleep(long seconds) {
        try {
            Thread.sleep(seconds);
        }
        catch (InterruptedException ex) {
            logger.error((Throwable)ex);
        }
    }

    @Override
    public BaseResult<List<String>> validateBefore() {
        BaseResult success = BaseResult.success(null);
        String message = this.subValidate();
        if (ArrayUtils.isEmpty((Object[])this.syncRecords)) {
            success.setData((Object)Lists.newArrayList());
            String notFound = ResManager.loadKDString((String)"\u6839\u636e\u63a5\u53e3\u53c2\u6570\u6ca1\u6709\u627e\u5230\u5b9a\u8c03\u85aa\u540c\u6b65\u8bb0\u5f55\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"SalaryAdjSyncPushSyncRecordServiceImpl_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((CharSequence)message)) {
                message = notFound + message;
            }
            success.setMessage(new Message(message, 200));
            return success;
        }
        if (!StringUtils.isEmpty((CharSequence)message)) {
            success.setMessage(new Message(message, 200));
        }
        success.setData(Arrays.stream(this.syncRecords).map(ele -> ele.getString("batchnumber")).collect(Collectors.toList()));
        return success;
    }

    protected String subValidate() {
        return null;
    }
}

