/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salarystandard.ContrastConfigHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class AppliedRangeHelper {
    private static final String DELIMITER = ",";

    public static List<Long> splitIdStrToList(String idStr) {
        String[] splits;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        if (SWCStringUtils.isEmpty((String)idStr)) {
            return list;
        }
        for (String split : splits = idStr.split(DELIMITER)) {
            if (!SWCStringUtils.isNotEmpty((String)split)) continue;
            list.add(Long.valueOf(split));
        }
        return list;
    }

    public static List<String> splitNameStrToList(String rangeNameStr) {
        if (SWCStringUtils.isEmpty((String)rangeNameStr)) {
            return Collections.emptyList();
        }
        String[] split = rangeNameStr.split(DELIMITER);
        return Arrays.asList(split);
    }

    private static DataSet queryAppliedrange(Collection<Long> stdIds) {
        String sql = "SELECT a.fid, a.frangeid, b.fid AS fcontrastpropconfid FROM t_hcdm_appliedrange a\nLEFT JOIN t_hcdm_contrastpropconf b on a.frangetype = b.fentityobjectid\nWHERE a.fid IN " + HCDMDbHelper.getFidHolder(stdIds.size());
        return HCDMDbHelper.queryDataSet(sql, stdIds.toArray());
    }

    @Deprecated
    public static Map<Long, List<ContrastDataEntity>> queryApplyRangeData(Collection<Long> stdIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        if (CollectionUtils.isEmpty(stdIds)) {
            return resultMap;
        }
        DataSet dataSet = AppliedRangeHelper.queryAppliedrange(stdIds);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long stdId = row.getLong(0);
            String cValueString = row.getString(1);
            Long propConfId = row.getLong(2);
            List<String> split = AppliedRangeHelper.splitNameStrToList(cValueString);
            for (String cValueStr : split) {
                if (!NumberUtils.isNumber((String)cValueStr)) continue;
                Long cValue = Long.valueOf(cValueStr);
                ContrastDataEntity entity = new ContrastDataEntity();
                entity.setContrastPropValue(cValue);
                entity.setContrastPropConfId(propConfId);
                List contrastDataEntities = resultMap.computeIfAbsent(stdId, value -> Lists.newArrayListWithCapacity((int)10));
                contrastDataEntities.add(entity);
            }
        }
        dataSet.close();
        return resultMap;
    }

    public static Map<Long, Map<Long, List<ContrastDataEntity>>> groupAppliEdrangeData(Map<Long, List<ContrastDataEntity>> contrastDataMap) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)contrastDataMap.size());
        for (Map.Entry<Long, List<ContrastDataEntity>> entry : contrastDataMap.entrySet()) {
            List<ContrastDataEntity> list = entry.getValue();
            Map<Long, List<ContrastDataEntity>> standardContrastDataPropIdMap = list.stream().collect(Collectors.groupingBy(ContrastDataEntity::getContrastPropConfId));
            result.put(entry.getKey(), standardContrastDataPropIdMap);
        }
        return result;
    }

    public static Map<Long, List<Long>> queryApplyRangeCfgId(Collection<Long> stdIds) {
        if (CollectionUtils.isEmpty(stdIds)) {
            return Collections.emptyMap();
        }
        String sql = "select a.fid as stdId,b.fid as configId FROM t_hcdm_appliedrange a\nleft join t_hcdm_contrastpropconf b on a.frangetype = b.fentityobjectid\nwhere  a.fid in  " + HCDMDbHelper.getFidHolder(stdIds.size());
        DataSet dataSet = HCDMDbHelper.queryDataSet(sql, stdIds.toArray());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        for (Row row : dataSet) {
            Long stdId = (Long)row.get(0);
            Long configId = (Long)row.get(1);
            List configIds = resultMap.computeIfAbsent(stdId, o1 -> Lists.newArrayList());
            configIds.add(configId);
        }
        return resultMap;
    }

    public static Map<Long, List<ContrastPropConfigEntity>> queryApplyRangeContrastProps(Collection<Long> stdIds) {
        if (CollectionUtils.isEmpty(stdIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        Map<Long, List<Long>> rangeMap = AppliedRangeHelper.queryApplyRangeCfgId(stdIds);
        Map<Long, ContrastPropConfigEntity> allContrastConfigMap = ContrastConfigHelper.getAllContrastConfigMap();
        for (Map.Entry<Long, List<Long>> rangeEntry : rangeMap.entrySet()) {
            Long stdId = rangeEntry.getKey();
            List<Long> cfgIds = rangeEntry.getValue();
            resultMap.put(stdId, cfgIds.stream().map(o1 -> (ContrastPropConfigEntity)allContrastConfigMap.get(o1)).collect(Collectors.toList()));
        }
        return resultMap;
    }

    @Deprecated
    public static Map<Long, List<ContrastPropConfigEntity>> queryApplyRangeContrastPropMap(Collection<Long> stdIds) {
        if (CollectionUtils.isEmpty(stdIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        Map<Long, List<Long>> rangeMap = AppliedRangeHelper.queryApplyRangeCfgId(stdIds);
        if (rangeMap == null || rangeMap.size() == 0) {
            return Collections.emptyMap();
        }
        HashSet<Long> rangConfIdSet = new HashSet<Long>(16);
        rangeMap.values().stream().forEach(rangConfIdSet::addAll);
        Map<Long, ContrastPropConfigEntity> rangContrastConfigMap = ContrastConfigHelper.getContrastConfigMap(rangConfIdSet);
        for (Map.Entry<Long, List<Long>> rangeEntry : rangeMap.entrySet()) {
            Long stdId = rangeEntry.getKey();
            List<Long> cfgIds = rangeEntry.getValue();
            resultMap.put(stdId, cfgIds.stream().map(o1 -> (ContrastPropConfigEntity)rangContrastConfigMap.get(o1)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return resultMap;
    }

    public static Set<Long> queryGradeOrLevelIds(String basedEntityName) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(basedEntityName);
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQfilter = new QFilter("status", "=", (Object)"C");
        QFilter curQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] objects = serviceHelper.query("id", new QFilter[]{enableQfilter, statusQfilter, curQfilter});
        return Arrays.stream(objects).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
    }
}

