/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salarystandard.CartesianIndexMatrix;
import kd.swc.hcdm.business.salarystandard.CartesianRowEntity;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.ContrastGridViewHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.salarystandard.grid.ContrastDataPrepareContext;
import kd.swc.hcdm.common.entity.salarystandard.ContrastCartesianItemEntity;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataQueryParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class CartesianFetchDataHelper {
    public static int getMaxTotalRow(IFormView anyView, String mainPageId, String gridViewPageId) {
        if (anyView == null || StringUtils.isEmpty((String)mainPageId) || StringUtils.isEmpty((String)gridViewPageId)) {
            return 0;
        }
        IFormView mainView = anyView.getView(mainPageId);
        IFormView gridView = anyView.getView(gridViewPageId);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData(mainPageId);
        String filterParam = (String)gridView.getFormShowParameter().getCustomParam("contrastFilterParam");
        ContrastDataQueryParam queryParam = SalaryStandardSerializationUtils.fromJsonString(filterParam, ContrastDataQueryParam.class);
        Map<Long, List<QFilter>> previewQFilterMap = ContrastGridViewHelper.getPreviewQFilterWithExt(stdData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList()), mainView);
        return CartesianFetchDataHelper.getMaxTotalRow(stdData, queryParam == null ? null : queryParam.getPropValues(), previewQFilterMap);
    }

    private static int getMaxTotalRow(SalaryStandardEntryData standardEntryData, Map<Long, List<Long>> propFilterParam, Map<Long, List<QFilter>> previewQFilterMap) {
        List contrastRowEntities = standardEntryData.getContrastRowEntities();
        ContrastGridViewHelper.filterContrastRow(contrastRowEntities, standardEntryData.getContrastPropEntities(), previewQFilterMap, propFilterParam);
        return CartesianFetchDataHelper.countAllCartesianResult(contrastRowEntities);
    }

    public static DynamicObject[] getFormDataForGrid(int startIndex, int endIndex, ContrastDataPrepareContext context) {
        List contrastPropEntities = context.getStdData().getContrastPropEntities();
        DynamicObject currencyFromDb = context.getCurrencyFromDb();
        Map<Long, SalaryGradeEntity> gradeEntityMap = context.getGradeEntityMap();
        Map<Long, SalaryRankEntity> rankEntityMap = context.getRankEntityMap();
        boolean useSalaryRank = context.getStdData().getStdBaseEntity().isUseSalaryRank();
        Map<GradeRankKey, Map<String, BigDecimal>> stdDataMap = context.getStdDataMap();
        Map<Long, Map<Long, DynamicObject>> dbData = context.getDbData();
        DataEntityPropertyCollection entityProperties = context.getRows().getDynamicObjectType().getProperties();
        List<ContrastCartesianItemEntity> cartesianResult = CartesianFetchDataHelper.transToCartesianResult(context.getStdData().getContrastRowEntities(), gradeEntityMap, rankEntityMap, startIndex, endIndex, contrastPropEntities, useSalaryRank);
        CartesianFetchDataHelper.assembleDataToGrid(context.getRows(), currencyFromDb, stdDataMap, dbData, entityProperties, cartesianResult);
        int amtPrecision = context.getStdData().getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
        for (DynamicObject row : context.getRows()) {
            SalaryStandardViewHelper.fixAmtPrecision(row, amtPrecision);
        }
        return (DynamicObject[])context.getRows().toArray((Object[])new DynamicObject[0]);
    }

    private static void assembleDataToGrid(DynamicObjectCollection rows, DynamicObject currencyFromDb, Map<GradeRankKey, Map<String, BigDecimal>> stdDataMap, Map<Long, Map<Long, DynamicObject>> dbData, DataEntityPropertyCollection entityProperties, List<ContrastCartesianItemEntity> cartesianResult) {
        for (ContrastCartesianItemEntity resultItem : cartesianResult) {
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            for (IDataEntityProperty tempProperty : entityProperties) {
                String tempPropertyName = tempProperty.getName();
                if (tempPropertyName.startsWith("dgdf")) {
                    DynamicFieldIdGenerationParamForTabular fieldIdGenerationParam = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName);
                    if (SWCStringUtils.equals((String)fieldIdGenerationParam.getFieldType(), (String)"mulbasedatafield")) {
                        Long propConfId = fieldIdGenerationParam.getIdentityId();
                        int index = resultItem.getContrastPropIds().indexOf(propConfId);
                        if (index < 0 || MapUtils.isEmpty(dbData.get(propConfId))) continue;
                        Long propValue = (Long)resultItem.getContrastPropValues().get(index);
                        if (dbData.get(propConfId).get(propValue) == null) continue;
                        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                        DynamicObject mulBaseDynamicObject = ContrastDataHelper.createMulBaseDynamicObject((MulBasedataProp)tempProperty, dbData.get(propConfId).get(propValue));
                        dynamicObjects.add((Object)mulBaseDynamicObject);
                        tempRow.set(tempPropertyName, (Object)dynamicObjects);
                    } else {
                        GradeRankKey gradeRankKey = resultItem.getGradeRankKey();
                        Map<String, BigDecimal> map = stdDataMap.get(gradeRankKey);
                        String matchedKey = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName).generateDataMatchedKey();
                        if (map != null && map.get(matchedKey) != null) {
                            tempRow.set(tempPropertyName, (Object)map.get(matchedKey));
                        }
                    }
                } else if (tempPropertyName.startsWith("dgff")) {
                    FixedFieldIdGenerationParam generationParam = FixedFieldIdGenerationParam.parseFrom((String)tempPropertyName);
                    if (SWCStringUtils.equals((String)generationParam.getName(), (String)"grade")) {
                        String gradeName = resultItem.getGradeRankKey() == null ? "" : resultItem.getGradeRankKey().getGradeEntity().getGradeName();
                        tempRow.set(tempPropertyName, (Object)gradeName);
                    } else if (SWCStringUtils.equals((String)generationParam.getName(), (String)"rank")) {
                        String rankName = resultItem.getGradeRankKey() == null ? "" : resultItem.getGradeRankKey().getRankEntity().getRankName();
                        tempRow.set(tempPropertyName, (Object)rankName);
                    }
                }
                if (!SWCStringUtils.equals((String)"currencyfield", (String)tempPropertyName)) continue;
                tempRow.set(tempPropertyName, (Object)currencyFromDb);
            }
            rows.add((Object)tempRow);
        }
        stdDataMap.clear();
        cartesianResult.clear();
    }

    private static List<ContrastCartesianItemEntity> transToCartesianResult(List<ContrastRowDataEntity> contrastRowEntities, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, int startIndex, int endIndex, List<ContrastPropEntity> contrastPropEntities, boolean useSalaryRank) {
        ArrayList<ContrastCartesianItemEntity> lastResult = new ArrayList<ContrastCartesianItemEntity>(10);
        if (endIndex <= startIndex) {
            return lastResult;
        }
        Map<Integer, ContrastRowDataEntity> rowMap = CartesianFetchDataHelper.resetIndex(contrastRowEntities);
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntityMap.values());
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(rankEntityMap.values()));
        ArrayList gradeEntities = Lists.newArrayList(gradeEntityMap.values());
        CartesianIndexMatrix startIndexMatrix = CartesianFetchDataHelper.calStartMatrix(rowMap, gradeEntityMap, rankEntityMap, startIndex, endIndex, contrastPropEntities, useSalaryRank);
        int dataSize = endIndex - startIndex;
        CartesianRowEntity cartesianRowEntity = new CartesianRowEntity(startIndexMatrix, dataSize);
        int startRow = startIndexMatrix.getStartRowIndex();
        while (rowMap.containsKey(startRow)) {
            ContrastRowDataEntity rowDataEntity = rowMap.get(startRow);
            Map stdPropValueMap = rowDataEntity.getStdPropValueMap();
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyList = new ArrayList<GradeRankKey>(10);
            if (rangeDBEntity != null) {
                gradeRankKeyList = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntities, useSalaryRank);
                GradeRankHelper.sortGradeRankKeyList(gradeRankKeyList, 1, 1);
            }
            cartesianRowEntity.setDataSize(dataSize - lastResult.size());
            List<ContrastCartesianItemEntity> tempResult = CartesianFetchDataHelper.transOneRowToCartesianResult(stdPropValueMap, gradeRankKeyList, cartesianRowEntity, contrastPropEntities, startRow);
            lastResult.addAll(tempResult);
            cartesianRowEntity.setFirstRowGetData(false);
            if (lastResult.size() >= dataSize) break;
            ++startRow;
        }
        return lastResult;
    }

    private static Map<Integer, ContrastRowDataEntity> resetIndex(List<ContrastRowDataEntity> contrastRowEntities) {
        int rowIndex = 0;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)contrastRowEntities.size());
        for (ContrastRowDataEntity contrastRowEntity : contrastRowEntities) {
            contrastRowEntity.setRowIndex(rowIndex++);
            rowMap.put(contrastRowEntity.getRowIndex(), contrastRowEntity);
        }
        return rowMap;
    }

    private static List<ContrastCartesianItemEntity> transOneRowToCartesianResult(Map<Long, List<Long>> contrastDataMap, List<GradeRankKey> gradeRankKeyList, CartesianRowEntity cartesianRowEntity, List<ContrastPropEntity> contrastPropEntities, int curRowIndex) {
        ArrayList lastResultNew = Lists.newArrayListWithExpectedSize((int)cartesianRowEntity.getDataSize());
        List<Long> propIdList = CartesianFetchDataHelper.getPropIdList(contrastDataMap, contrastPropEntities);
        CartesianIndexMatrix startIndexMatrix = cartesianRowEntity.getStartIndexMatrix();
        cartesianRowEntity.resetIndexMatrix(CartesianFetchDataHelper.initPropIndexMap(propIdList), curRowIndex, propIdList, gradeRankKeyList.isEmpty());
        LinkedHashMap<Long, Integer> propIndexMap = startIndexMatrix.getPropIndex();
        if (propIndexMap == null || propIndexMap.isEmpty()) {
            return lastResultNew;
        }
        for (int i1 = 0; i1 < cartesianRowEntity.getDataSize(); ++i1) {
            ContrastCartesianItemEntity cartesianItemEntity = new ContrastCartesianItemEntity();
            CartesianFetchDataHelper.movePointer(contrastDataMap, gradeRankKeyList.size(), propIndexMap, propIdList, startIndexMatrix);
            if (startIndexMatrix.getPointer() == -1) break;
            for (Map.Entry<Long, List<Long>> propEntry : contrastDataMap.entrySet()) {
                Long propEntryKey = propEntry.getKey();
                Integer index = propIndexMap.get(propEntryKey);
                if (index == null) continue;
                List<Long> propEntryValue = propEntry.getValue();
                if (index >= propEntryValue.size()) continue;
                Long val = propEntryValue.get(index);
                cartesianItemEntity.getContrastPropIds().add(propEntryKey);
                cartesianItemEntity.getContrastPropValues().add(val);
            }
            if (startIndexMatrix.getGradeRankIndex() < gradeRankKeyList.size()) {
                cartesianItemEntity.setGradeRankKey(gradeRankKeyList.get(startIndexMatrix.getGradeRankIndex()));
                startIndexMatrix.moveGradeRankIndex();
            }
            lastResultNew.add(cartesianItemEntity);
        }
        return lastResultNew;
    }

    private static List<Long> getPropIdList(Map<Long, List<Long>> contrastDataMap, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<Long> propIdList = new ArrayList<Long>(10);
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            if (!contrastDataMap.containsKey(contrastPropEntity.getPropConfigId())) continue;
            propIdList.add(contrastPropEntity.getPropConfigId());
        }
        return propIdList;
    }

    private static CartesianIndexMatrix calStartMatrix(Map<Integer, ContrastRowDataEntity> rowMap, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, int startIndex, int endIndex, List<ContrastPropEntity> contrastPropEntities, boolean useSalaryRank) {
        CartesianIndexMatrix startMatrix = new CartesianIndexMatrix(startIndex, endIndex);
        int total = 0;
        int targetRow = 0;
        int preRowTotal = 0;
        for (Map.Entry<Integer, ContrastRowDataEntity> entity : rowMap.entrySet()) {
            targetRow = entity.getKey();
            ContrastRowDataEntity contrastRowEntity = entity.getValue();
            Map stdPropValueMap = contrastRowEntity.getStdPropValueMap();
            int gradeRankKeyCount = CartesianFetchDataHelper.getGradeRankKeyCount(contrastRowEntity.getRangeCode());
            int leftFetchSize = startIndex - total;
            if (leftFetchSize > 0) {
                preRowTotal = total;
                total += CartesianFetchDataHelper.countCartesianResult(stdPropValueMap, gradeRankKeyCount);
                continue;
            }
            if (targetRow <= 0) break;
            --targetRow;
            break;
        }
        startMatrix.setStartRowIndex(targetRow);
        ContrastRowDataEntity rowDataEntity = rowMap.get(targetRow);
        if (rowDataEntity == null) {
            return startMatrix;
        }
        int gradeRankKeyCount = CartesianFetchDataHelper.getGradeRankKeyCount(rowDataEntity.getRangeCode());
        int dataSize = startIndex - preRowTotal;
        CartesianFetchDataHelper.setStartCartesianIndexMatrix(rowDataEntity.getStdPropValueMap(), gradeRankKeyCount, dataSize, startMatrix, contrastPropEntities);
        return startMatrix;
    }

    private static int getGradeRankKeyCount(List<GradeRankValue> rangeCode) {
        int gradeRankKeyCount = 0;
        for (GradeRankValue rankValue : rangeCode) {
            gradeRankKeyCount += rankValue.getEndValue() - rankValue.getBeginValue() + 1;
        }
        return gradeRankKeyCount;
    }

    private static void movePointer(Map<Long, List<Long>> contrastDataMap, int gradeRankKeyListSize, LinkedHashMap<Long, Integer> propIndexMap, List<Long> propIdList, CartesianIndexMatrix curEndMatrix) {
        boolean isPointerMoveRight = false;
        while (!isPointerMoveRight) {
            Long propId;
            int pointer = curEndMatrix.getPointer();
            if (pointer != -2) {
                List<Long> contrastDataEntities;
                if (pointer == -1) break;
                propId = propIdList.get(pointer);
                int index = propIndexMap.get(propId);
                if (index >= (contrastDataEntities = contrastDataMap.get(propId)).size()) {
                    pointer = curEndMatrix.movePointer();
                    if (pointer == -1) break;
                    Long prePropId = propIdList.get(pointer);
                    propIndexMap.put(prePropId, propIndexMap.get(prePropId) + 1);
                    continue;
                }
                for (int pos = pointer + 1; pos < propIdList.size(); ++pos) {
                    Long nextPropId = propIdList.get(pos);
                    propIndexMap.put(nextPropId, 0);
                }
                curEndMatrix.resetGradeRankIndex();
                curEndMatrix.resetPointer();
                isPointerMoveRight = true;
                continue;
            }
            if (curEndMatrix.getGradeRankIndex() >= gradeRankKeyListSize) {
                curEndMatrix.setPointer(propIdList.size() - 1);
                propId = propIdList.get(curEndMatrix.getPointer());
                propIndexMap.put(propId, propIndexMap.get(propId) + 1);
                continue;
            }
            isPointerMoveRight = true;
        }
    }

    private static CartesianIndexMatrix setStartCartesianIndexMatrix(Map<Long, List<Long>> contrastDataMap, int gradeRankKeyListSize, int dataSize, CartesianIndexMatrix startMatrix, List<ContrastPropEntity> contrastPropEntities) {
        List<Long> propIdList = CartesianFetchDataHelper.getPropIdList(contrastDataMap, contrastPropEntities);
        LinkedHashMap<Long, Integer> propIndexMap = CartesianFetchDataHelper.initPropIndexMap(propIdList);
        startMatrix.setPropIndex(propIndexMap);
        for (int index = 0; index < dataSize; ++index) {
            CartesianFetchDataHelper.movePointer(contrastDataMap, gradeRankKeyListSize, propIndexMap, propIdList, startMatrix);
            startMatrix.moveGradeRankIndex();
            if (startMatrix.getPointer() == -1) break;
        }
        return startMatrix;
    }

    private static LinkedHashMap<Long, Integer> initPropIndexMap(List<Long> propIdList) {
        LinkedHashMap propIndexMap = Maps.newLinkedHashMapWithExpectedSize((int)propIdList.size());
        for (Long propId : propIdList) {
            propIndexMap.put(propId, 0);
        }
        return propIndexMap;
    }

    private static int countAllCartesianResult(List<ContrastRowDataEntity> contrastRowEntities) {
        int maxTotalRow = 0;
        for (ContrastRowDataEntity rowEntity : contrastRowEntities) {
            List rangeCode = rowEntity.getRangeCode();
            int gradeRankKeyCount = 0;
            for (GradeRankValue rankValue : rangeCode) {
                gradeRankKeyCount += rankValue.getEndValue() - rankValue.getBeginValue() + 1;
            }
            int curRowCount = CartesianFetchDataHelper.countCartesianResult(rowEntity.getStdPropValueMap(), gradeRankKeyCount);
            maxTotalRow += curRowCount;
        }
        if (maxTotalRow < 0 || maxTotalRow >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return maxTotalRow;
    }

    private static int countCartesianResult(Map<Long, List<Long>> stdPropValueMap, int gradeRankKeyCount) {
        int total = 0;
        for (Map.Entry<Long, List<Long>> entry : stdPropValueMap.entrySet()) {
            int size = entry.getValue().size();
            if (total == 0) {
                total = size;
                continue;
            }
            if (size == 0) continue;
            total *= size;
        }
        if (gradeRankKeyCount == 0) {
            return total;
        }
        return total * gradeRankKeyCount;
    }
}

