/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class ContrastConfigHelper {
    public static DynamicObject[] queryContrastConfig() {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_contrastpropconf");
        QFilter queryFilter = new QFilter("status", "=", (Object)"C");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{queryFilter});
    }

    public static List<ContrastPropConfigEntity> getAllContrastConfig() {
        DynamicObject[] dynamicObjects = ContrastConfigHelper.queryContrastConfig();
        ArrayList cfgList = Lists.newArrayList();
        for (DynamicObject object : dynamicObjects) {
            ContrastPropConfigEntity cfg = EntityConverter.dynamicObjToContrastPropConfigEntity(object);
            cfgList.add(cfg);
        }
        return cfgList;
    }

    public static Map<Long, ContrastPropConfigEntity> getAllContrastConfigMap() {
        List<ContrastPropConfigEntity> configEntityList = ContrastConfigHelper.getAllContrastConfig();
        return configEntityList.stream().collect(Collectors.toMap(ContrastPropConfigEntity::getId, Function.identity(), (o1, o2) -> o2));
    }

    public static Map<String, Long> getCfgEntityIdMap() {
        DynamicObject[] contrastConfigDyObjs = ContrastConfigHelper.queryContrastConfig();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)contrastConfigDyObjs.length);
        for (DynamicObject dynamicObject : contrastConfigDyObjs) {
            resultMap.putIfAbsent(dynamicObject.getString("entityobject.id"), dynamicObject.getLong("id"));
        }
        return resultMap;
    }

    public static Map<Long, ContrastPropConfigEntity> getContrastConfigMap(Set<Long> confIdSet) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)confIdSet.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_contrastpropconf");
        QFilter queryFilter = new QFilter("status", "=", (Object)"C");
        queryFilter.and("enable", "=", (Object)"1");
        queryFilter.and("id", "in", confIdSet);
        String fields = "id,name,number,entityobject.number,category,queryfields,width";
        DynamicObjectCollection objs = helper.queryOriginalCollection(fields, new QFilter[]{queryFilter});
        for (DynamicObject obj : objs) {
            long id = obj.getLong("id");
            ContrastPropConfigEntity cfg = EntityConverter.dynamicObjToContrastPropConfigEntity(obj);
            dataMap.put(id, cfg);
        }
        return dataMap;
    }
}

