/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.AppliedRangeEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salarystandard.ContrastConfigHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardComparator;
import kd.swc.hcdm.business.salarystandard.constraint.DeleteResult;
import kd.swc.hcdm.business.salarystandard.constraint.EntityDataKey;
import kd.swc.hcdm.business.salarystandard.constraint.StandardTabConstrainManager;
import kd.swc.hcdm.common.entity.salarystandard.ContrastCartesianGradeItemEntity;
import kd.swc.hcdm.common.entity.salarystandard.ContrastCartesianItemEntity;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataOutbound;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public class ContrastDataHelper {
    private static final Log log = LogFactory.getLog(ContrastDataHelper.class);

    public static List<ContrastDataEntity> getContrastDataByLabel(List<ContrastDataEntity> contrastDataEntities, ContrastPropLabelEnum ... standard) {
        List<ContrastPropLabelEnum> labelEnumList = Arrays.asList(standard);
        return contrastDataEntities.stream().filter(o1 -> labelEnumList.contains(o1.getContrastPropLabelEnum())).collect(Collectors.toList());
    }

    public static List<ContrastDataEntity> sortByIndex(List<ContrastDataEntity> contrastDataEntities) {
        Collections.sort(contrastDataEntities, new SalaryStandardComparator.ContrastDataComparator());
        return contrastDataEntities;
    }

    public static void sortByPropAndSubIndex(List<ContrastDataEntity> contrastDataEntities, List<Long> props) {
        contrastDataEntities.sort(new SalaryStandardComparator.ContrastDataWithPropComparator(props));
    }

    public static void filterByPropValues(List<ContrastCartesianItemEntity> cartesianResult, Map<Long, List<Long>> propFilterParam) {
        if (propFilterParam == null || MapUtils.isEmpty(propFilterParam)) {
            return;
        }
        for (Map.Entry<Long, List<Long>> propParam : propFilterParam.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)propParam.getValue())) continue;
            Iterator<ContrastCartesianItemEntity> iterator = cartesianResult.iterator();
            while (iterator.hasNext()) {
                Long tempPropValueId;
                ContrastCartesianItemEntity o1 = iterator.next();
                Long propConfId = propParam.getKey();
                List<Long> propValueIds = propParam.getValue();
                int index = o1.getContrastPropIds().indexOf(propConfId);
                if (index < 0 || propValueIds.contains(tempPropValueId = (Long)o1.getContrastPropValues().get(index))) continue;
                iterator.remove();
            }
        }
    }

    public static void filterGradeCartesianResultByPropValues(List<ContrastCartesianGradeItemEntity> cartesianResult, Map<Long, List<Long>> propFilterParam) {
        if (propFilterParam == null || MapUtils.isEmpty(propFilterParam)) {
            return;
        }
        for (Map.Entry<Long, List<Long>> propParam : propFilterParam.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)propParam.getValue())) continue;
            Iterator<ContrastCartesianGradeItemEntity> iterator = cartesianResult.iterator();
            while (iterator.hasNext()) {
                Long tempPropValueId;
                ContrastCartesianGradeItemEntity o1 = iterator.next();
                Long propConfId = propParam.getKey();
                List<Long> propValueIds = propParam.getValue();
                int index = o1.getContrastPropIds().indexOf(propConfId);
                if (index < 0 || propValueIds.contains(tempPropValueId = (Long)o1.getContrastPropValues().get(index))) continue;
                iterator.remove();
            }
        }
    }

    public static Map<Integer, Map<Long, List<ContrastDataEntity>>> groupByRowPropIdWithLinkedMap(List<ContrastDataEntity> contrastData) {
        Map<Integer, List<ContrastDataEntity>> standardContrastDataRowMap = contrastData.stream().collect(Collectors.groupingBy(ContrastDataEntity::getRowIndex));
        LinkedHashMap stdContrastDataRowPropMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<Integer, List<ContrastDataEntity>> entry : standardContrastDataRowMap.entrySet()) {
            List<ContrastDataEntity> tempContrastDataList = entry.getValue();
            Map<Long, List<ContrastDataEntity>> tempContrastDataMap = tempContrastDataList.stream().collect(Collectors.groupingBy(ContrastDataEntity::getContrastPropConfId));
            stdContrastDataRowPropMap.put(entry.getKey(), tempContrastDataMap);
        }
        return stdContrastDataRowPropMap;
    }

    private static List<ContrastCartesianItemEntity> calCartesianWithCommonPropData(List<ContrastCartesianItemEntity> lastResult, List<Long> value, Long propId) {
        ArrayList<ContrastCartesianItemEntity> resultList = new ArrayList<ContrastCartesianItemEntity>();
        if (value != null) {
            for (Long propValId : value) {
                if (CollectionUtils.isEmpty(lastResult)) {
                    ContrastCartesianItemEntity tempItem = new ContrastCartesianItemEntity();
                    tempItem.getContrastPropIds().add(propId);
                    tempItem.getContrastPropValues().add(propValId);
                    resultList.add(tempItem);
                    continue;
                }
                for (ContrastCartesianItemEntity cartesianItemEntity : lastResult) {
                    ContrastCartesianItemEntity tempItem = new ContrastCartesianItemEntity();
                    tempItem.getContrastPropIds().addAll(cartesianItemEntity.getContrastPropIds());
                    tempItem.getContrastPropIds().add(propId);
                    tempItem.getContrastPropValues().addAll(cartesianItemEntity.getContrastPropValues());
                    tempItem.getContrastPropValues().add(propValId);
                    resultList.add(tempItem);
                }
            }
        }
        return resultList;
    }

    private static List<ContrastCartesianItemEntity> calCartesianWithSpecialPropData(List<ContrastCartesianItemEntity> lastResult, List<GradeRankKey> gradeRankKeyList) {
        ArrayList<ContrastCartesianItemEntity> resultList = new ArrayList<ContrastCartesianItemEntity>();
        for (ContrastCartesianItemEntity cartesianItemEntity : lastResult) {
            for (GradeRankKey gradeRankKey : gradeRankKeyList) {
                ContrastCartesianItemEntity tempItem = new ContrastCartesianItemEntity();
                tempItem.getContrastPropIds().addAll(cartesianItemEntity.getContrastPropIds());
                tempItem.getContrastPropValues().addAll(cartesianItemEntity.getContrastPropValues());
                tempItem.setGradeRankKey(gradeRankKey);
                resultList.add(tempItem);
            }
        }
        return resultList;
    }

    private static List<ContrastCartesianItemEntity> transOneRowToCartesianResult(Map<Long, List<Long>> stdPropValueMap, List<GradeRankKey> gradeRankKeyList) {
        List<ContrastCartesianItemEntity> lastResult = new ArrayList<ContrastCartesianItemEntity>();
        for (Map.Entry<Long, List<Long>> entry : stdPropValueMap.entrySet()) {
            lastResult = ContrastDataHelper.calCartesianWithCommonPropData(lastResult, entry.getValue(), entry.getKey());
        }
        return ContrastDataHelper.calCartesianWithSpecialPropData(lastResult, gradeRankKeyList);
    }

    public static List<ContrastCartesianItemEntity> transToCartesianResult(List<ContrastRowDataEntity> rowDataEntities, List<SalaryGradeEntity> gradeEntityList, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, boolean isUseSalaryRank) {
        ArrayList<ContrastCartesianItemEntity> lastResult = new ArrayList<ContrastCartesianItemEntity>();
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntityMap.values());
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(rankEntityMap.values()));
        for (ContrastRowDataEntity rowDataEntity : rowDataEntities) {
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
            List<ContrastCartesianItemEntity> tempResult = ContrastDataHelper.transOneRowToCartesianResult(rowDataEntity.getStdPropValueMap(), gradeRankKeyOfRow);
            lastResult.addAll(tempResult);
        }
        return lastResult.stream().distinct().collect(Collectors.toList());
    }

    public static List<ContrastCartesianGradeItemEntity> transToGradeItemCartesianResult(List<ContrastRowDataEntity> rowDataEntities, List<SalaryGradeEntity> gradeEntityList, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, boolean isUseSalaryRank) {
        ArrayList<ContrastCartesianGradeItemEntity> lastResult = new ArrayList<ContrastCartesianGradeItemEntity>();
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntityMap.values());
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(rankEntityMap.values()));
        for (ContrastRowDataEntity rowDataEntity : rowDataEntities) {
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
            Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap = ContrastDataHelper.getGradeRankEntityMap(gradeRankKeyOfRow);
            List<ContrastCartesianGradeItemEntity> tempResult = ContrastDataHelper.transOneRowToGradeItemCartesianResult(rowDataEntity.getStdPropValueMap(), gradeEntitySetMap);
            lastResult.addAll(tempResult);
        }
        return lastResult.stream().distinct().collect(Collectors.toList());
    }

    public static Map<SalaryGradeEntity, Set<SalaryRankEntity>> getGradeRankEntityMap(List<GradeRankKey> range) {
        HashMap<SalaryGradeEntity, Set<SalaryRankEntity>> resultMap = new HashMap<SalaryGradeEntity, Set<SalaryRankEntity>>(range.size());
        for (GradeRankKey gradeRankKey : range) {
            Set rankEntitySet = resultMap.computeIfAbsent(gradeRankKey.getGradeEntity(), o1 -> Sets.newHashSet());
            rankEntitySet.add(gradeRankKey.getRankEntity());
        }
        return resultMap;
    }

    private static List<ContrastCartesianGradeItemEntity> transOneRowToGradeItemCartesianResult(Map<Long, List<Long>> getStdPropValueMap, Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap) {
        List<ContrastCartesianGradeItemEntity> lastResult = new ArrayList<ContrastCartesianGradeItemEntity>();
        for (Map.Entry<Long, List<Long>> entry : getStdPropValueMap.entrySet()) {
            lastResult = ContrastDataHelper.calCartesianCommonPropData(lastResult, entry.getValue(), entry.getKey());
        }
        return ContrastDataHelper.calGradeItemCartesianWithRangeData(lastResult, gradeEntitySetMap);
    }

    private static List<ContrastCartesianGradeItemEntity> calGradeItemCartesianWithRangeData(List<ContrastCartesianGradeItemEntity> lastResult, Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap) {
        ArrayList<ContrastCartesianGradeItemEntity> resultList = new ArrayList<ContrastCartesianGradeItemEntity>();
        for (ContrastCartesianGradeItemEntity cartesianItemEntity : lastResult) {
            for (Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>> entry : gradeEntitySetMap.entrySet()) {
                SalaryGradeEntity gradeEntity = entry.getKey();
                ContrastCartesianGradeItemEntity tempItem = new ContrastCartesianGradeItemEntity();
                tempItem.getContrastPropIds().addAll(cartesianItemEntity.getContrastPropIds());
                tempItem.getContrastPropValues().addAll(cartesianItemEntity.getContrastPropValues());
                tempItem.setGradeEntity(gradeEntity);
                tempItem.setRankEntities(gradeEntitySetMap.get(gradeEntity));
                resultList.add(tempItem);
            }
        }
        return resultList;
    }

    private static List<ContrastCartesianGradeItemEntity> calCartesianCommonPropData(List<ContrastCartesianGradeItemEntity> lastResult, List<Long> propValueSet, Long propId) {
        ArrayList<ContrastCartesianGradeItemEntity> resultList = new ArrayList<ContrastCartesianGradeItemEntity>();
        for (Long propValue : propValueSet) {
            if (CollectionUtils.isEmpty(lastResult)) {
                ContrastCartesianGradeItemEntity tempItem = new ContrastCartesianGradeItemEntity();
                tempItem.getContrastPropIds().add(propId);
                tempItem.getContrastPropValues().add(propValue);
                resultList.add(tempItem);
                continue;
            }
            for (ContrastCartesianGradeItemEntity cartesianItemEntity : lastResult) {
                ContrastCartesianGradeItemEntity tempItem = new ContrastCartesianGradeItemEntity();
                tempItem.getContrastPropIds().addAll(cartesianItemEntity.getContrastPropIds());
                tempItem.getContrastPropIds().add(propId);
                tempItem.getContrastPropValues().addAll(cartesianItemEntity.getContrastPropValues());
                tempItem.getContrastPropValues().add(propValue);
                resultList.add(tempItem);
            }
        }
        return resultList;
    }

    public static Map<Long, Map<Long, DynamicObject>> queryFromDb(List<ContrastPropEntity> contrastPropEntities, List<ContrastRowDataEntity> rowDataEntities) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < contrastPropEntities.size(); ++i) {
            HashSet valueIds = Sets.newHashSetWithExpectedSize((int)16);
            for (ContrastRowDataEntity rowDataEntity : rowDataEntities) {
                List pkIds;
                List stdContrastArrValue = rowDataEntity.getStdContrastArrValue();
                if (stdContrastArrValue.size() - 1 < i || !CollectionUtils.isNotEmpty((Collection)(pkIds = (List)stdContrastArrValue.get(i)))) continue;
                valueIds.addAll(pkIds);
            }
            if (!CollectionUtils.isNotEmpty((Collection)valueIds)) continue;
            QFilter filter = new QFilter("id", "in", (Object)valueIds);
            ContrastPropEntity contrastPropEntity = contrastPropEntities.get(i);
            DynamicObjectCollection resultList = QueryServiceHelper.query((String)contrastPropEntity.getPropConfigEntity().getObjectTypeIId(), (String)contrastPropEntity.getPropConfigEntity().getQueryFields(), (QFilter[])new QFilter[]{filter});
            HashMap objMap = Maps.newHashMapWithExpectedSize((int)resultList.size());
            for (DynamicObject o : resultList) {
                objMap.putIfAbsent(o.getLong("id"), o);
            }
            resultMap.put(contrastPropEntity.getPropConfigId(), objMap);
        }
        return resultMap;
    }

    public static DynamicObject createMulBaseDynamicObject(MulBasedataProp prop, DynamicObject dbObject) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
        DynamicObjectType propertyType = prop.getDynamicCollectionItemPropertyType();
        DynamicObject baseObj = new DynamicObject((DynamicObjectType)dataEntityType);
        DynamicObject dynamicObject = new DynamicObject(propertyType);
        dynamicObject.set("fbasedataid", (Object)baseObj);
        dynamicObject.set("fbasedataid_id", dbObject.get("id"));
        baseObj.set("id", dbObject.get("id"));
        baseObj.set("number", dbObject.get("number"));
        baseObj.set("name", dbObject.get("name"));
        return dynamicObject;
    }

    public static List<ContrastDataEntity> getByRowIndex(List<ContrastDataEntity> contrastDataEntities, List<Integer> rowIndexs) {
        return contrastDataEntities.stream().filter(o1 -> rowIndexs.contains(o1.getRowIndex())).collect(Collectors.toList());
    }

    public static Map<Integer, List<ContrastDataEntity>> groupByRowIndexWithLinkedMap(List<ContrastDataEntity> specialContrastData) {
        LinkedHashMap<Integer, List<ContrastDataEntity>> map = new LinkedHashMap<Integer, List<ContrastDataEntity>>();
        for (ContrastDataEntity entity : specialContrastData) {
            map.computeIfAbsent(entity.getRowIndex(), k2 -> new ArrayList());
            ((List)map.get(entity.getRowIndex())).add(entity);
        }
        return map;
    }

    public static boolean checkCollectionEqual(List<List<Long>> sourceCollection, List<List<Long>> targetCollection) {
        for (int i = 0; i < sourceCollection.size(); ++i) {
            if (CollectionUtils.isEqualCollection((Collection)sourceCollection.get(i), (Collection)targetCollection.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkCollectionContainsNotEqual(List<List<Long>> sourceCollection, List<List<Long>> targetCollection) {
        if (ContrastDataHelper.checkCollectionEqual(sourceCollection, targetCollection)) {
            return false;
        }
        for (int i = 0; i < sourceCollection.size(); ++i) {
            if (targetCollection.get(i).containsAll((Collection)sourceCollection.get(i))) continue;
            return false;
        }
        return true;
    }

    private static ContrastDataEntity findParentAndOneChildFromConstructData(List<ContrastDataEntity> targetDataList, GradeRankKey targetGradeRank) {
        for (ContrastDataEntity contrastDataEntity : targetDataList) {
            if (!contrastDataEntity.getContrastPropValue().equals(targetGradeRank.getGradeEntity().getGradeIdentity())) continue;
            if (CollectionUtils.isEmpty((Collection)contrastDataEntity.getChildren())) {
                return null;
            }
            for (ContrastDataEntity child : contrastDataEntity.getChildren()) {
                if (!child.getContrastPropValue().equals(targetGradeRank.getRankEntity().getRankIdentity())) continue;
                try {
                    ContrastDataEntity parent = (ContrastDataEntity)SerializationUtils.clone((Serializable)contrastDataEntity);
                    parent.getChildren().clear();
                    parent.getChildren().add(child);
                    return parent;
                }
                catch (Exception exception) {
                }
            }
            return contrastDataEntity;
        }
        return null;
    }

    private static ContrastDataEntity findParentFromConstructData(List<ContrastDataEntity> sourceDataList, GradeRankKey targetGradeRank) {
        for (ContrastDataEntity contrastDataEntity : sourceDataList) {
            if (!contrastDataEntity.getContrastPropValue().equals(targetGradeRank.getGradeEntity().getGradeIdentity())) continue;
            return contrastDataEntity;
        }
        return null;
    }

    private static void contrastRowDataCompare(List<ContrastRowDataEntity> dataList, List<ContrastPropEntity> props) {
        for (ContrastRowDataEntity rowDataEntity : dataList) {
            rowDataEntity.setDataStatus(1);
        }
        int rowCount = dataList.size();
        block1: for (int i = 0; i < rowCount - 1; ++i) {
            ContrastRowDataEntity currentRow = dataList.get(i);
            if (currentRow.getDataStatus() == 0 || ContrastDataHelper.checkHasPropEmpty(currentRow, props)) continue;
            for (int j = i + 1; j < rowCount; ++j) {
                ContrastRowDataEntity nextRow = dataList.get(j);
                if (nextRow.getDataStatus() == 0 || ContrastDataHelper.checkHasPropEmpty(nextRow, props)) continue;
                ContrastDataHelper.tryMerge(currentRow, nextRow);
                if (currentRow.getDataStatus() == 0) continue block1;
            }
        }
    }

    private static void tryMerge(ContrastRowDataEntity currentRow, ContrastRowDataEntity nextRow) {
        InclusionType inclusionType = ContrastDataHelper.calcRangeInclusion(currentRow, nextRow);
        if (inclusionType == InclusionType.FORWARD) {
            boolean valueInclude = ContrastDataHelper.isValueInclude(currentRow.getStdContrastArrValue(), nextRow.getStdContrastArrValue());
            if (valueInclude) {
                nextRow.setDataStatus(0);
            }
        } else if (inclusionType == InclusionType.REVERSE) {
            boolean valueInclude = ContrastDataHelper.isValueInclude(nextRow.getStdContrastArrValue(), currentRow.getStdContrastArrValue());
            if (valueInclude) {
                currentRow.setDataStatus(0);
            }
        } else if (inclusionType == InclusionType.EQUAL) {
            boolean valueInclude = ContrastDataHelper.isValueInclude(currentRow.getStdContrastArrValue(), nextRow.getStdContrastArrValue());
            if (valueInclude) {
                nextRow.setDataStatus(0);
            } else {
                boolean valueBeInclude = ContrastDataHelper.isValueInclude(nextRow.getStdContrastArrValue(), currentRow.getStdContrastArrValue());
                if (valueBeInclude) {
                    currentRow.setDataStatus(0);
                }
            }
        } else {
            List currentArr = currentRow.getStdContrastArrValue();
            List nextRowArr = nextRow.getStdContrastArrValue();
            boolean valueEquals = true;
            for (int i = 0; i < currentArr.size(); ++i) {
                List currValue = (List)currentArr.get(i);
                List nextValue = (List)nextRowArr.get(i);
                if (nextValue.size() != currValue.size()) {
                    valueEquals = false;
                    break;
                }
                if (CollectionUtils.isEqualCollection((Collection)currValue, (Collection)nextValue)) continue;
                valueEquals = false;
                break;
            }
            if (valueEquals) {
                List<GradeRankValue> gradeRankValues = GradeRankHelper.unionRangeByCode(currentRow.getRangeCode(), nextRow.getRangeCode());
                currentRow.getGradeRankRangeDBEntity().setRangeCodeArr(gradeRankValues);
                nextRow.setDataStatus(0);
            }
        }
    }

    private static boolean isValueInclude(List<List<Long>> currentArr, List<List<Long>> nextRowArr) {
        boolean valueInclude = true;
        for (int i = 0; i < currentArr.size(); ++i) {
            List<Long> currValue = currentArr.get(i);
            List<Long> nextValue = nextRowArr.get(i);
            if (currValue.size() < nextValue.size()) {
                valueInclude = false;
                break;
            }
            if (currValue.containsAll(nextValue)) continue;
            valueInclude = false;
            break;
        }
        return valueInclude;
    }

    private static InclusionType calcRangeInclusion(ContrastRowDataEntity currentRow, ContrastRowDataEntity nextRow) {
        boolean contains = GradeRankHelper.checkRangeContainsByCode(currentRow.getRangeCode(), nextRow.getRangeCode());
        if (contains) {
            boolean reverseContains = GradeRankHelper.checkRangeContainsByCode(nextRow.getRangeCode(), currentRow.getRangeCode());
            if (reverseContains) {
                return InclusionType.EQUAL;
            }
            return InclusionType.FORWARD;
        }
        boolean reverseContains = GradeRankHelper.checkRangeContainsByCode(nextRow.getRangeCode(), currentRow.getRangeCode());
        if (reverseContains) {
            return InclusionType.REVERSE;
        }
        return InclusionType.NOT;
    }

    private static boolean checkHasPropEmpty(ContrastRowDataEntity source, List<ContrastPropEntity> props) {
        boolean hasRange;
        List stdContrastDataIds = source.getStdContrastArrValue();
        if (source.getStdContrastArrValue().size() != props.size()) {
            throw new KDBizException("please check contrastRow size");
        }
        for (int i = 0; i < props.size(); ++i) {
            List longs = (List)stdContrastDataIds.get(i);
            if (!CollectionUtils.isEmpty((Collection)longs)) continue;
            return true;
        }
        boolean bl = hasRange = source.getGradeRankRangeDBEntity() != null && CollectionUtils.isNotEmpty((Collection)source.getRangeCode());
        return !hasRange;
    }

    public static List<ContrastRowDataEntity> mergeContrastData(List<ContrastRowDataEntity> contrastRowDataList, List<ContrastPropEntity> props) {
        long begin = System.currentTimeMillis();
        if (contrastRowDataList.size() <= 1) {
            return contrastRowDataList;
        }
        ContrastDataHelper.contrastRowDataCompare(contrastRowDataList, props);
        contrastRowDataList.removeIf(entity -> entity.getDataStatus() == 0);
        long end = System.currentTimeMillis();
        log.info("mergeContrastData cost {} ms", (Object)(end - begin));
        return contrastRowDataList;
    }

    @Deprecated
    public static List<ContrastRowDataEntity> convertToRowDataEntity(List<ContrastDataEntity> sourceDataList, List<ContrastPropEntity> props, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        return null;
    }

    @Deprecated
    public static ContrastRowDataEntity mergeContrastRow(List<ContrastRowDataEntity> contrastDataOriginal) {
        return null;
    }

    @Deprecated
    public static Map<Integer, List<ContrastRowDataEntity>> calcCartesianWithRepeatSet(List<ContrastRowDataEntity> contrastDataOriginal, Map<Integer, List<Set<Long>>> repeatSetOfProps) {
        return null;
    }

    @Deprecated
    private static <T> void descartes(List<List<T>> dimvalue, List<List<T>> result, int layer, List<T> curList) {
    }

    @Deprecated
    public static void syncContrEntWithMergedResult(AbstractFormDataModel model, DynamicObjectCollection contrastDataEnt, List<ContrastRowDataEntity> mergedResult) {
    }

    @Deprecated
    private static List<List<Long>> groupByPropIdWithLinkedMap(List<ContrastDataEntity> standardContrastData, List<ContrastPropEntity> props) {
        return null;
    }

    @Deprecated
    public static List<Integer> getAllContrastRowIndexs(List<ContrastDataEntity> dataEntityList) {
        return null;
    }

    @Deprecated
    public static List<ContrastDataOutbound> createOutboundsByAppliedRange(List<AppliedRangeEntity> appliedRangeEntities, Map<String, Long> cfgEntityIdMap) {
        return null;
    }

    public static List<ContrastDataEntity> createDataEntity(List<Long> ids) {
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)ids.size());
        for (Long id : ids) {
            ContrastDataEntity contrastDataEntity = new ContrastDataEntity();
            contrastDataEntity.setContrastPropValue(id);
            contrastDataEntity.setContrastPropLabelEnum(ContrastPropLabelEnum.STANDARD);
            objects.add(contrastDataEntity);
        }
        return objects;
    }

    public static String createRelationDetailMsg(StandardTabConstrainManager constrainManager, DeleteResult deleteResult, IFormView formView, boolean startRowIndex) {
        StringBuilder detail = new StringBuilder();
        List<ContrastPropEntity> props = deleteResult.getProps();
        List<ContrastRowDataEntity> contrastDataList = deleteResult.getContrastData();
        HashMap propMap = Maps.newHashMapWithExpectedSize((int)props.size());
        for (int i = 0; i < props.size(); ++i) {
            propMap.put(i, props.get(i));
        }
        String msg = ResManager.loadKDString((String)"\u7b2c\u4e09\u6b65\u5bf9\u7167\u5c5e\u6027-", (String)"ContrastDataHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String fmt = ResManager.loadKDString((String)"\u7b2c%s\u884c:", (String)"ContrastDataHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashMap propDataMsg = Maps.newHashMapWithExpectedSize((int)16);
        for (ContrastRowDataEntity contrastRowDataEntity : contrastDataList) {
            if (contrastRowDataEntity == null) continue;
            StringBuilder rowSb = new StringBuilder();
            if (startRowIndex) {
                int rowIndex = contrastRowDataEntity.getRowIndex();
                rowSb.append(msg).append(String.format(Locale.ROOT, fmt, rowIndex + 1));
            }
            boolean flag = false;
            List stdContrastDataIds = contrastRowDataEntity.getStdContrastArrValue();
            for (int i = 0; i < stdContrastDataIds.size(); ++i) {
                ContrastPropEntity contrastPropEntity = (ContrastPropEntity)propMap.get(i);
                ContrastPropConfigEntity propConfigEntity = contrastPropEntity.getPropConfigEntity();
                EntityDataKey propEntityDataKey = new EntityDataKey("hcdm_contrastpropconf", propConfigEntity.getId());
                Map<String, String> propData = constrainManager.getEntityData(propEntityDataKey, formView);
                List stdContrastDataIdList = (List)stdContrastDataIds.get(i);
                if (CollectionUtils.isEmpty((Collection)stdContrastDataIdList)) continue;
                ArrayList tdContrastDataNames = Lists.newArrayListWithExpectedSize((int)stdContrastDataIdList.size());
                String propName = propData.get("name");
                for (Long stdContrastDataId : stdContrastDataIdList) {
                    EntityDataKey stdContrastEntityDataKey = new EntityDataKey(propConfigEntity.getObjectTypeIId(), stdContrastDataId);
                    Map<String, String> stdContrastData = constrainManager.getEntityData(stdContrastEntityDataKey, formView);
                    String propDataName = stdContrastData.get("name");
                    tdContrastDataNames.add(propDataName);
                    StringJoiner propSJ = (StringJoiner)propDataMsg.get(propName);
                    if (propSJ == null) {
                        StringJoiner tempPropSJ = new StringJoiner(",");
                        tempPropSJ.add(propDataName);
                        propDataMsg.put(propName, tempPropSJ);
                        continue;
                    }
                    propSJ.add(propDataName);
                    propDataMsg.put(propName, propSJ);
                }
                if (startRowIndex) {
                    rowSb.append(propName).append(" : ").append(String.join((CharSequence)",", tdContrastDataNames)).append('\uff1b');
                }
                flag = true;
            }
            if (!flag) continue;
            detail.append((CharSequence)rowSb);
            if (!startRowIndex) continue;
            detail.append("\r\n");
        }
        if (!startRowIndex && MapUtils.isNotEmpty((Map)propDataMsg)) {
            for (Map.Entry entry : propDataMsg.entrySet()) {
                String itemStr = ((StringJoiner)entry.getValue()).toString();
                String[] split = itemStr.split(",");
                List items = Arrays.stream(split).distinct().collect(Collectors.toList());
                detail.append((String)entry.getKey()).append(" : ").append(String.join((CharSequence)",", items)).append("\r\n");
            }
        }
        return detail.toString();
    }

    public static void removeCurProp(DeleteResult deleteResult, Long propCfgId) {
        List props = deleteResult.getProps().stream().filter(o1 -> o1.getPropConfigId().equals(propCfgId)).collect(Collectors.toList());
        int propIndex = -1;
        for (int i = 0; i < props.size(); ++i) {
            if (!((ContrastPropEntity)props.get(i)).getPropConfigId().equals(propCfgId)) continue;
            propIndex = i;
            break;
        }
        if (propIndex == -1) {
            return;
        }
        List<ContrastRowDataEntity> contrastDatas = deleteResult.getContrastData();
        for (ContrastRowDataEntity contrastData : contrastDatas) {
            List stdContrastDataIds = contrastData.getStdContrastArrValue();
            stdContrastDataIds.set(propIndex, Lists.newArrayListWithExpectedSize((int)0));
        }
        deleteResult.getContrastPropDelPkIds().remove(propCfgId);
    }

    public static void afterDelContrastRowData(List<ContrastRowDataEntity> contrastDataEntities, List<ContrastRowDataEntity> delContrastRows) {
        if (CollectionUtils.isEmpty(contrastDataEntities)) {
            return;
        }
        List props = contrastDataEntities.get(0).getProps();
        Map delContrastRowMap = delContrastRows.stream().collect(Collectors.toMap(o -> o.getRowIndex(), Function.identity()));
        for (ContrastRowDataEntity contrastDataEntity : contrastDataEntities) {
            ContrastRowDataEntity delContrastRow = (ContrastRowDataEntity)delContrastRowMap.get(contrastDataEntity.getRowIndex());
            if (delContrastRow == null) continue;
            List originalValArr = contrastDataEntity.getStdContrastArrValue();
            Map originalValMap = contrastDataEntity.getStdPropValueMap();
            List del = delContrastRow.getStdContrastArrValue();
            for (int i = 0; i < del.size(); ++i) {
                List tempDel = (List)del.get(i);
                if (!CollectionUtils.isNotEmpty((Collection)tempDel)) continue;
                ((List)originalValArr.get(i)).removeAll(tempDel);
                ((List)originalValMap.get(((ContrastPropEntity)props.get(i)).getPropConfigId())).removeAll(tempDel);
            }
        }
    }

    public static void sortContrastDataEntities(List<ContrastRowDataEntity> contrastDataEntities) {
        int newIndex = 0;
        for (ContrastRowDataEntity contrastDataEntity : contrastDataEntities) {
            contrastDataEntity.setRowIndex(newIndex++);
        }
    }

    @Deprecated
    public static Map<Long, Map<Integer, Map<Long, List<ContrastDataEntity>>>> groupStandardData(Map<Long, List<ContrastDataEntity>> contrastDataMap) {
        return null;
    }

    @Deprecated
    public static Map<Long, Map<Integer, List<ContrastDataEntity>>> groupSpecialData(Map<Long, List<ContrastDataEntity>> contrastDataMap) {
        return null;
    }

    @Deprecated
    public static void mergeAppliEdrangeToStandardDataGroup(Map<Long, Map<Integer, Map<Long, List<ContrastDataEntity>>>> standardDataMap, Map<Long, Map<Long, List<ContrastDataEntity>>> appliEdrangeDataMap) {
    }

    public static Map<Long, List<ContrastPropConfigEntity>> queryContrastProps(Collection<Long> stdIds) {
        if (CollectionUtils.isEmpty(stdIds)) {
            return Collections.emptyMap();
        }
        String sql = "select fid,fpscontrastpropconfid from t_hcdm_contrastps where fid in  " + HCDMDbHelper.getFidHolder(stdIds.size());
        DataSet dataSet = HCDMDbHelper.queryDataSet(sql, stdIds.toArray());
        LinkedHashMap stdPropMap = Maps.newLinkedHashMapWithExpectedSize((int)stdIds.size());
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long stdId = row.getLong(0);
            Long configId = row.getLong(1);
            List cfgIds = stdPropMap.computeIfAbsent(stdId, value -> Lists.newArrayListWithCapacity((int)10));
            cfgIds.add(configId);
        }
        dataSet.close();
        List<ContrastPropConfigEntity> allCfg = ContrastConfigHelper.getAllContrastConfig();
        Map scmMap = allCfg.stream().collect(Collectors.toMap(ContrastPropConfigEntity::getId, Function.identity(), (o1, o2) -> o2));
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)stdIds.size());
        for (Map.Entry entry : stdPropMap.entrySet()) {
            List scmIds = (List)entry.getValue();
            List cfgList = scmIds.stream().map(o1 -> (ContrastPropConfigEntity)scmMap.get(o1)).filter(Objects::nonNull).collect(Collectors.toList());
            resultMap.computeIfAbsent(entry.getKey(), o1 -> cfgList);
        }
        return resultMap;
    }

    @Deprecated
    public static Map<Long, List<ContrastPropConfigEntity>> queryContrastPropMap(Collection<Long> stdIds) {
        return null;
    }

    @Deprecated
    public static Map<Long, List<ContrastDataEntity>> queryContrastData(Collection<Long> stdIds) {
        return null;
    }

    public static Map<Long, Map<Long, Object>> convertToVersion(List<ContrastPropConfigEntity> propCfg, Map<Long, Map<Long, Object>> personPropMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personPropMap.size());
        for (Map.Entry<Long, Map<Long, Object>> entry : personPropMap.entrySet()) {
            resultMap.put(entry.getKey(), Maps.newHashMap(entry.getValue()));
        }
        for (ContrastPropConfigEntity cfg : propCfg) {
            MainEntityType entityType;
            if (!StringUtils.isNotBlank((CharSequence)cfg.getObjectTypeIId()) || (entityType = EntityMetadataCache.getDataEntityType((String)cfg.getObjectTypeIId())).getProperty("iscurrentversion") == null || entityType.getProperty("sourcevid") == null) continue;
            ArrayList propBoValue = Lists.newArrayList();
            for (Map.Entry<Long, Map<Long, Object>> entry : personPropMap.entrySet()) {
                Map<Long, Object> propToValue = entry.getValue();
                Object value = propToValue.get(cfg.getId());
                if (value instanceof List) {
                    propBoValue.addAll((List)value);
                    continue;
                }
                if (!(value instanceof Long)) continue;
                propBoValue.add((Long)value);
            }
            Map boMap = BaseDataHisHelper.getVersionOfCurrent((String)cfg.getObjectTypeIId(), (Collection)propBoValue);
            for (Map.Entry<Long, Map<Long, Object>> entry : personPropMap.entrySet()) {
                Long vId;
                Map<Long, Object> propValue = entry.getValue();
                Map propVersionValue = resultMap.computeIfAbsent(entry.getKey(), v1 -> Maps.newHashMap());
                Object value = propValue.get(cfg.getId());
                if (value == null) continue;
                if (value instanceof List) {
                    List sourceVidList = ((List)value).stream().map(aLong -> boMap.getOrDefault(aLong, 0L)).filter(aLong -> aLong > 0L).collect(Collectors.toList());
                    propVersionValue.put(cfg.getId(), sourceVidList);
                    continue;
                }
                if (!(value instanceof Long) || (vId = (Long)boMap.get(value)) == null) continue;
                propVersionValue.put(cfg.getId(), vId);
            }
        }
        return resultMap;
    }

    public static Map<Long, Map<Long, List<Long>>> convertToBo(List<ContrastPropConfigEntity> propCfg, Map<Long, Map<Long, List<Long>>> personPropMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personPropMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : personPropMap.entrySet()) {
            resultMap.put(entry.getKey(), Maps.newHashMap(entry.getValue()));
        }
        for (ContrastPropConfigEntity cfg : propCfg) {
            MainEntityType entityType;
            if (!StringUtils.isNotBlank((CharSequence)cfg.getObjectTypeIId()) || (entityType = EntityMetadataCache.getDataEntityType((String)cfg.getObjectTypeIId())).getProperty("iscurrentversion") == null || entityType.getProperty("boid") == null) continue;
            ArrayList propVersionValue = Lists.newArrayList();
            for (Map.Entry<Long, Map<Long, List<Long>>> entry : personPropMap.entrySet()) {
                Map<Long, List<Long>> propToValue = entry.getValue();
                List<Long> value = propToValue.get(cfg.getId());
                if (!CollectionUtils.isNotEmpty(value)) continue;
                propVersionValue.addAll(value);
            }
            Map versionToBoMap = BaseDataHisHelper.getCurrentOfVersion((String)cfg.getObjectTypeIId(), (Collection)propVersionValue);
            for (Map.Entry<Long, Map<Long, List<Long>>> entry : personPropMap.entrySet()) {
                Map<Long, List<Long>> propValue = entry.getValue();
                Map propBoValue = resultMap.computeIfAbsent(entry.getKey(), v1 -> Maps.newHashMap());
                List<Long> value = propValue.get(cfg.getId());
                if (value == null) continue;
                List sourceVidList = value.stream().map(vid -> versionToBoMap.getOrDefault(vid, vid)).filter(aLong -> aLong > 0L).collect(Collectors.toList());
                propBoValue.put(cfg.getId(), sourceVidList);
            }
        }
        return resultMap;
    }

    public static Pair<BigDecimal, BigDecimal> getMinMaxValueByInterval(GradeRankKey begin, GradeRankKey end, List<SalaryStdDataEntity> stdDataList, Map<Long, Integer> gradeIdentityToIndexMap, Map<Long, Integer> rankIdentityToIndexMap, boolean withAmount) {
        int rankSize = rankIdentityToIndexMap.size();
        Integer beginGradeIndex = gradeIdentityToIndexMap.get(begin.getGradeEntity().getGradeIdentity());
        Integer beginRankIndex = rankIdentityToIndexMap.get(begin.getRankEntity().getRankIdentity());
        Integer endGradeIndex = gradeIdentityToIndexMap.get(end.getGradeEntity().getGradeIdentity());
        Integer endRankIndex = rankIdentityToIndexMap.get(end.getRankEntity().getRankIdentity());
        int beginPositionNumber = beginGradeIndex * rankSize + beginRankIndex;
        int endPositionNumber = endGradeIndex * rankSize + endRankIndex;
        HashMap positionNumberMap = Maps.newHashMapWithExpectedSize((int)stdDataList.size());
        for (SalaryStdDataEntity entity : stdDataList) {
            Integer rankIndex = rankIdentityToIndexMap.get(entity.getRankIdentity());
            Integer gradeIndex = gradeIdentityToIndexMap.get(entity.getGradeIdentity());
            Integer positionNumber = gradeIndex * rankSize + rankIndex;
            positionNumberMap.put(positionNumber, entity);
        }
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        for (int i = beginPositionNumber; i <= endPositionNumber; ++i) {
            BigDecimal value;
            SalaryStdDataEntity entity = (SalaryStdDataEntity)positionNumberMap.get(i);
            if (null == entity) continue;
            BigDecimal bigDecimal = value = withAmount ? entity.getMin() : entity.getSalaryCount();
            if (value == null) continue;
            if (minValue == null) {
                minValue = value;
                maxValue = value;
                continue;
            }
            if (value.compareTo(minValue) < 0) {
                minValue = value;
            }
            if (maxValue == null || maxValue.compareTo(value) >= 0) continue;
            maxValue = value;
        }
        return new Pair(minValue, maxValue);
    }

    private static enum InclusionType {
        FORWARD,
        REVERSE,
        NOT,
        EQUAL;

    }
}

