/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetCustomerQFilterEvent;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.matchprop.HcdmContrastPropPlugin;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.MulBasedataFieldParamContainer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ContrastGridViewHelper {
    public static final Log logger = LogFactory.getLog(ContrastGridViewHelper.class);
    private static final Map<String, String> entityQueryViewMap = new HashMap<String, String>(2);
    public static final int MAX_TOTAL_ROW = 100000;
    public static final int DEFAULT_PAGE_ROWS = 5000;

    public static EntryAp createEntryApForGrid(EntityMetadata entityMetadata, SalaryStandardEntryData standardEntryData) {
        List<EntryParamContainer> createEntryBuildParamForTabular = EntryParamContainerHelper.createEntryBuildParamForTabular(entityMetadata, standardEntryData);
        List<EntryParamContainer> entryApBuildParam = EntryParamContainerHelper.createMulBaseParamForContrast(entityMetadata, standardEntryData.getContrastPropEntities());
        entryApBuildParam.addAll(createEntryBuildParamForTabular);
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    public static void registerPropertyForGrid(SalaryStandardEntryData standardEntryData, EntryType entryType) {
        List<EntryParamContainer> entryBuildParamForTabular = EntryParamContainerHelper.createEntryBuildParamForTabular(null, standardEntryData);
        List<EntryParamContainer> mulBaseParamForContrast = EntryParamContainerHelper.createMulBaseParamForContrast(null, standardEntryData.getContrastPropEntities());
        entryBuildParamForTabular.addAll(mulBaseParamForContrast);
        EntryParamContainerBaseHelper.registProp(entryBuildParamForTabular, (EntityType)entryType);
    }

    public static Map<Long, List<QFilter>> getPreviewQFilterWithExt(List<ContrastPropConfigEntity> propConfigEntities, IFormView mainPage) {
        if (mainPage != null && mainPage.getModel().isDataLoaded()) {
            DynamicObject dataEntity = mainPage.getModel().getDataEntity();
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new HcdmContrastPropPlugin(), IHcdmContrastPropExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin#onGetCustomerQFilterForStdPreview", null);
            OnGetCustomerQFilterEvent event = new OnGetCustomerQFilterEvent((Object)mainPage);
            event.setPropCfgList(propConfigEntities);
            event.setScene("stdtable_preview");
            pluginProxy.callAfter(plugin -> {
                plugin.onGetCustomerQFilterForStdPreview(event);
                return null;
            });
            logger.info("onGetCustomerQFilterForStdPreview : result = {}", (Object)event.getCustomerQFilter());
            return event.getCustomerQFilter();
        }
        return Collections.emptyMap();
    }

    public static Set<Integer> filterContrastRow(List<ContrastRowDataEntity> contrastRowEntities, List<ContrastPropEntity> contrastPropEntities, Map<Long, List<QFilter>> previewQFilterMap, Map<Long, List<Long>> commonFilterParam) {
        if (MapUtils.isEmpty(previewQFilterMap) && MapUtils.isEmpty(commonFilterParam)) {
            return Collections.emptySet();
        }
        HashMap originalPropIdSetMap = Maps.newHashMapWithExpectedSize((int)contrastPropEntities.size());
        HashMap finalPropIdSetMap = Maps.newHashMapWithExpectedSize((int)contrastPropEntities.size());
        for (ContrastRowDataEntity contrastRowEntity : contrastRowEntities) {
            Map stdPropValueMap = contrastRowEntity.getStdPropValueMap();
            for (Map.Entry entry : stdPropValueMap.entrySet()) {
                Set valueSet = originalPropIdSetMap.computeIfAbsent(entry.getKey(), value -> Sets.newHashSet());
                valueSet.addAll((Collection)entry.getValue());
            }
        }
        HashMap propIndex = Maps.newHashMapWithExpectedSize((int)contrastPropEntities.size());
        for (int i = 0; i < contrastPropEntities.size(); ++i) {
            List<Long> values;
            List<QFilter> previewQFilters;
            ContrastPropEntity prop = contrastPropEntities.get(i);
            Long propConfigId = prop.getPropConfigId();
            propIndex.put(propConfigId, i);
            ArrayList allFilters = Lists.newArrayList();
            if (previewQFilterMap != null && CollectionUtils.isNotEmpty(previewQFilters = previewQFilterMap.get(propConfigId))) {
                allFilters.addAll(previewQFilters);
            }
            if (commonFilterParam != null && CollectionUtils.isNotEmpty(values = commonFilterParam.get(propConfigId))) {
                allFilters.add(new QFilter("id", "in", values));
            }
            if (allFilters.isEmpty()) continue;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(prop.getPropConfigEntity().getObjectTypeIId());
            DynamicObject[] dynamicObjectArray = serviceHelper.query("id", allFilters.toArray(new QFilter[0]));
            Set finalIdSet = Arrays.stream(dynamicObjectArray).map(rowObj -> rowObj.getLong("id")).collect(Collectors.toSet());
            finalPropIdSetMap.put(propConfigId, finalIdSet);
        }
        HashSet unPermissionRows = Sets.newHashSetWithExpectedSize((int)contrastRowEntities.size());
        Iterator<ContrastRowDataEntity> iterator1 = contrastRowEntities.iterator();
        block3: while (iterator1.hasNext()) {
            ContrastRowDataEntity rowDataEntity = iterator1.next();
            Map stdPropValueMap = rowDataEntity.getStdPropValueMap();
            for (Map.Entry entry : stdPropValueMap.entrySet()) {
                Set permissionPropIdSet = (Set)finalPropIdSetMap.get(entry.getKey());
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue())) || permissionPropIdSet == null) continue;
                List permissionValId = ((List)entry.getValue()).stream().filter(permissionPropIdSet::contains).collect(Collectors.toList());
                if (permissionValId.isEmpty()) {
                    iterator1.remove();
                    unPermissionRows.add(rowDataEntity.getRowIndex());
                    continue block3;
                }
                entry.setValue(permissionValId);
                rowDataEntity.getStdContrastArrValue().set((Integer)propIndex.get(entry.getKey()), permissionValId);
            }
        }
        return unPermissionRows;
    }

    public static FlexPanelAp createQueryPanel(EntityMetadata entityMetadata, SalaryStandardEntryData standardEntryData) {
        List<EntryParamContainer> containers = EntryParamContainerHelper.createMulBaseParamForQueryPanel(entityMetadata, standardEntryData.getContrastPropEntities());
        FlexPanelAp flexPanelAp = EntryParamContainerHelper.createPanelAp(containers);
        return flexPanelAp;
    }

    public static void registerPropertyQueryPanel(SalaryStandardEntryData standardEntryData, EntityType panelEntityType) {
        List<EntryParamContainer> containers = EntryParamContainerHelper.createMulBaseParamForQueryPanel(null, standardEntryData.getContrastPropEntities());
        for (EntryParamContainer entryParamContainer : containers) {
            if (!(entryParamContainer instanceof MulBasedataFieldParamContainer)) continue;
            ((MulBasedataFieldParamContainer)entryParamContainer).registerProp(panelEntityType);
        }
    }

    public static BaseShowParameter getStandardCompareForm(String parentPageId, Object pkId, String entityId) {
        BaseShowParameter form = new BaseShowParameter();
        form.setPkId(pkId);
        form.setFormId(ContrastGridViewHelper.getQueryViewByEntityId(entityId));
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setStatus(OperationStatus.VIEW);
        form.setPageId(ContrastGridViewHelper.getStdComparePageId(parentPageId, pkId));
        form.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u5206\u6790\u67e5\u8be2", (String)"ContrastGridViewHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        return form;
    }

    private static String getQueryViewByEntityId(String entityId) {
        return entityQueryViewMap.get(entityId);
    }

    private static String getStdComparePageId(String parentPageId, Object pkid) {
        return String.format("%s%s%s", parentPageId, "suffixPageIdStandardCompare", pkid);
    }

    static {
        entityQueryViewMap.put("hcdm_salarystandard", "hcdm_salarystdqueryview");
    }
}

