/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.SalaryStandardCreatePkService;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.StdTabValSetHelper;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.DynamicCommonFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.GradeRankKeyOutbound;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.IntegerFieldParamContainer;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class ContrastRelationSettingGridHelper {
    public static EntryAp createEntryApForSettingForm(EntityMetadata entityMetadata, SalaryStandardBaseEntity stdBaseEntity, List<ContrastPropEntity> contrastPropEntities) {
        List<EntryParamContainer> containers = EntryParamContainerHelper.createEntryBuildParamForContrast(entityMetadata, stdBaseEntity, contrastPropEntities);
        return EntryParamContainerBaseHelper.createControlAp((EntryAp)EntryParamContainerHelper.createEntryApForContrastRelationSettingGrid("entryentity"), containers);
    }

    public static void registerPropertyForSettingForm(SalaryStandardBaseEntity stdBaseEntity, List<ContrastPropEntity> contrastPropEntities, EntryType entryType) {
        IntegerFieldParamContainer createRowIndexFieldParam = EntryParamContainerHelper.createRowIndexFieldParam();
        List<EntryParamContainer> mulBaseParamForContrast = EntryParamContainerHelper.createMulBaseParamForContrast(null, contrastPropEntities);
        mulBaseParamForContrast.add(0, (EntryParamContainer)createRowIndexFieldParam);
        EntryParamContainerBaseHelper.registProp(mulBaseParamForContrast, (EntityType)entryType);
    }

    public static void setFormDataForSettingForm(DynamicObjectCollection rows, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<ContrastPropEntity> contrastPropEntities, List<ContrastRowDataEntity> contrastRowEntities, SalaryStandardBaseEntity salaryStandardBaseEntity) {
        if (contrastRowEntities.isEmpty()) {
            return;
        }
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        Map<Integer, String> gradeIndexNameMap = GradeRankHelper.getGradeIndexNameMap(gradeEntities);
        Map<Integer, String> rankIndexNameMap = GradeRankHelper.getRankIndexNameMap(standardRanks);
        boolean isUseSalaryRank = salaryStandardBaseEntity.getIsUseSalaryRank() > 0;
        Map<Long, Map<Long, DynamicObject>> dbData = ContrastDataHelper.queryFromDb(contrastPropEntities, contrastRowEntities);
        int rowMax = contrastRowEntities.size();
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        for (int i = 0; i < rowMax; ++i) {
            Integer row = i;
            ContrastRowDataEntity rowDataEntity = contrastRowEntities.get(i);
            Map stdPropValueMap = rowDataEntity.getStdPropValueMap();
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            int rowIndex = rowDataEntity.getRowIndex();
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            for (IDataEntityProperty tempProperty : entityProperties) {
                String tempPropertyName = tempProperty.getName();
                if (tempPropertyName.startsWith("dgdf")) {
                    Long identityId = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName).getIdentityId();
                    List pkIds = (List)stdPropValueMap.get(identityId);
                    Map<Long, DynamicObject> propValue = dbData.get(identityId);
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pkIds) || MapUtils.isEmpty(propValue)) continue;
                    DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                    for (Long pkId : pkIds) {
                        DynamicObject dbContrastDataObject = propValue.get(pkId);
                        if (dbContrastDataObject == null) continue;
                        DynamicObject mulBaseDynamicObject = ContrastDataHelper.createMulBaseDynamicObject((MulBasedataProp)tempProperty, dbContrastDataObject);
                        dynamicObjects.add((Object)mulBaseDynamicObject);
                    }
                    tempRow.set(tempProperty.getName(), (Object)dynamicObjects);
                    continue;
                }
                if (!tempPropertyName.startsWith("dgff")) continue;
                DynamicCommonFieldIdGenerationParam generationParam = DynamicCommonFieldIdGenerationParam.parseFrom((String)tempPropertyName);
                boolean rangeIsNotEmpty = rangeDBEntity != null && StringUtils.isNotBlank((CharSequence)rangeDBEntity.getRangeCodeString());
                boolean existStdProp = MapUtils.isNotEmpty((Map)stdPropValueMap);
                String rangeName = "";
                if (rangeDBEntity != null) {
                    rangeName = GradeRankHelper.getRangeNamesByRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeIndexNameMap, rankIndexNameMap, isUseSalaryRank);
                }
                if (SWCStringUtils.equals((String)generationParam.getName(), (String)"grade_rank")) {
                    if (!existStdProp && SWCStringUtils.isNotEmpty((String)rangeName)) {
                        tempRow.set(tempPropertyName, (Object)rangeName);
                    }
                    if (!existStdProp) continue;
                    tempRow.set(tempPropertyName, (Object)(SWCStringUtils.isNotEmpty((String)rangeName) ? rangeName : SalaryStandardConstants.EMPTY_GR_DISPLAY()));
                    continue;
                }
                if (SWCStringUtils.equals((String)generationParam.getName(), (String)"lookup") && rangeIsNotEmpty) {
                    tempRow.set(tempPropertyName, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ContrastSetGridView_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!SWCStringUtils.equals((String)generationParam.getName(), (String)"rowindex") || !rangeIsNotEmpty && !existStdProp) continue;
                tempRow.set(tempPropertyName, (Object)rowIndex);
            }
            if (!tempRow.getDataEntityState().isChanged()) continue;
            rows.add((Object)tempRow);
        }
    }

    public static List<ContrastDataEntity> fetchContrastDataEntityFromMulBaseData(String fieldKey, DynamicObjectCollection datas, int rowindex, Long contrastPropConfId) {
        List<Long> pkIds = EntityConverter.getPkIdFromMulBaseData(datas);
        ArrayList<ContrastDataEntity> resultList = new ArrayList<ContrastDataEntity>(datas.size());
        SalaryStandardCreatePkService createPkService = new SalaryStandardCreatePkService();
        long[] longs = createPkService.genEntPkByTime(pkIds.size());
        int subIndex = 0;
        for (Long contrastPropValue : pkIds) {
            ContrastDataEntity contrastDataEntity = new ContrastDataEntity(Long.valueOf(0L), Long.valueOf(0L), contrastPropConfId, contrastPropValue, rowindex, subIndex, ContrastPropLabelEnum.STANDARD);
            contrastDataEntity.setContrastIdentity(Long.valueOf(longs[subIndex]));
            resultList.add(contrastDataEntity);
            ++subIndex;
        }
        return resultList;
    }

    public static GradeRankKeyOutbound getGradeRankOutboundForOneRow(SalaryStandardEntryData entryData, int rowIndex) {
        List<ContrastDataEntity> contrastDataEntities = entryData.getContrastDataEntities().stream().filter(o1 -> o1.getRowIndex() == rowIndex).collect(Collectors.toList());
        List<ContrastDataEntity> gradeRankContrastData = ContrastDataHelper.getContrastDataByLabel(contrastDataEntities, ContrastPropLabelEnum.GRADE, ContrastPropLabelEnum.RANK);
        List<ContrastDataEntity> structureForGradeRank = GradeRankHelper.buildStructureForGradeRank(gradeRankContrastData);
        List<GradeRankKey> gradeRankKeyList = GradeRankHelper.getGradeRankKey(structureForGradeRank, GradeRankHelper.groupByGradeIdentity(entryData.getGradeEntities()), GradeRankHelper.groupByRankIdentity(entryData.getRankEntities()));
        GradeRankKeyOutbound gradeRankKeyOutbound = new GradeRankKeyOutbound();
        gradeRankKeyOutbound.getDataList().addAll(gradeRankKeyList);
        return gradeRankKeyOutbound;
    }

    @Deprecated
    public static int getSpecialContrastDataTailRow(Map<Integer, List<ContrastDataEntity>> specialContrastDataRowMap) {
        return 0;
    }

    @Deprecated
    public static int getstandardContrastDataTailRow(Map<Integer, Map<Long, List<ContrastDataEntity>>> map) {
        return 0;
    }

    public static void updateToParentEntry(List<ContrastRowDataEntity> entryRows, IFormView parentView, boolean updateAll) {
        AbstractFormDataModel model = (AbstractFormDataModel)parentView.getModel();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entryRows)) {
            model.deleteEntryData("contrastsumdata");
        }
        if (updateAll) {
            for (int i = 0; i < entryRows.size(); ++i) {
                ContrastRowDataEntity contrastRowDataEntity = entryRows.get(i);
                contrastRowDataEntity.setRowIndex(i);
            }
            TableValueSetter tableSetter = StdTabValSetHelper.getContrastpsDataTableSetter(entryRows);
            model.deleteEntryData("contrastsumdata");
            model.batchCreateNewEntryRow("contrastsumdata", tableSetter);
        } else {
            for (ContrastRowDataEntity entryRow : entryRows) {
                int rowIndex = entryRow.getRowIndex();
                DynamicObject parentRow = ContrastRelationSettingGridHelper.getOrCreateParentRowWithIdx(rowIndex, parentView);
                entryRow.saveChange();
                parentRow.set("standardpropvalue", (Object)entryRow.getStdPropValueDBVal());
                parentRow.set("graderankrange", (Object)entryRow.getGradeRankRangeDBVal());
            }
        }
        ContrastRelationSettingGridHelper.saveParentEntryChange(parentView);
    }

    public static void deleteEntryRowByRowIndex(Set<Integer> existRowIndexs, IFormView parentView, boolean autoSave) {
        IDataModel mainModel = parentView.getModel();
        DynamicObjectCollection contrastData = mainModel.getEntryEntity("contrastsumdata");
        ArrayList delRowSeq = Lists.newArrayListWithExpectedSize((int)contrastData.size());
        for (int i = 0; i < contrastData.size(); ++i) {
            DynamicObject parentRowObj = (DynamicObject)contrastData.get(i);
            int rowIndex = parentRowObj.getInt("sumrowindex");
            if (existRowIndexs.contains(rowIndex)) continue;
            delRowSeq.add(i);
        }
        if (!delRowSeq.isEmpty()) {
            mainModel.deleteEntryRows("contrastsumdata", delRowSeq.stream().mapToInt(Number::intValue).toArray());
        }
        if (autoSave) {
            ContrastRelationSettingGridHelper.saveParentEntryChange(parentView);
        }
    }

    public static void updateFieldValToParent(DynamicObject row, IFormView parentView, IFormView childView, boolean autoSave) {
        DynamicObject parentRow = ContrastRelationSettingGridHelper.getOrCreateParentRowWithIdx(ContrastRelationSettingGridHelper.getRowIndex(row), parentView);
        List<Map<Long, List<Long>>> stdPropEntryToEntity = ContrastRelationSettingGridHelper.convertStdPropEntryToEntity(Collections.singleton(row), (EntryProp)childView.getModel().getProperty("entryentity"));
        parentRow.set("standardpropvalue", (Object)ContrastRowDataEntity.serializeStdProp(stdPropEntryToEntity.get(0)));
        if (autoSave) {
            ContrastRelationSettingGridHelper.saveParentEntryChange(parentView);
        }
    }

    public static void saveParentEntryChange(IFormView parentView) {
        IDataModel parentModel = parentView.getModel();
        parentModel.updateEntryCache(parentModel.getEntryEntity("contrastsumdata"));
    }

    public static int getRowIndex(DynamicObject row) {
        String rowindexKey = new DynamicCommonFieldIdGenerationParam("dgff", "rowindex").generateKey();
        return row.getInt(rowindexKey);
    }

    public static DynamicObject getOrCreateParentRowWithIdx(int rowIndex, IFormView parentView) {
        IDataModel mainModel = parentView.getModel();
        DynamicObjectCollection contrastData = mainModel.getEntryEntity("contrastsumdata");
        DynamicObject parentRow = null;
        for (DynamicObject parentTempRow : contrastData) {
            int parentRowIndex = parentTempRow.getInt("sumrowindex");
            if (parentRowIndex != rowIndex) continue;
            parentRow = parentTempRow;
        }
        if (parentRow == null) {
            parentRow = mainModel.getEntryRowEntity("contrastsumdata", mainModel.createNewEntryRow("contrastsumdata"));
            parentRow.set("sumrowindex", (Object)rowIndex);
        }
        return parentRow;
    }

    public static int getLastRowIndex(IFormView view, boolean parentEntry) {
        int lastRowIndex = -1;
        if (parentEntry) {
            IDataModel mainModel = view.getParentView().getModel();
            DynamicObjectCollection contrastData = mainModel.getEntryEntity("contrastsumdata");
            if (contrastData.size() > 0) {
                lastRowIndex = ((DynamicObject)contrastData.get(contrastData.size() - 1)).getInt("sumrowindex");
            }
        } else {
            DynamicObjectCollection contrastData = view.getModel().getEntryEntity("entryentity");
            if (contrastData.size() > 0) {
                String rowindexKey = new DynamicCommonFieldIdGenerationParam("dgff", "rowindex").generateKey();
                lastRowIndex = ((DynamicObject)contrastData.get(contrastData.size() - 1)).getInt(rowindexKey);
            }
        }
        return lastRowIndex;
    }

    public static List<Map<Long, List<Long>>> convertStdPropEntryToEntity(Collection<DynamicObject> entryRows, EntryProp entryProp) {
        if (CollectionUtils.isEmpty(entryRows)) {
            return Collections.emptyList();
        }
        Map<String, Long> propNameMap = ContrastRelationSettingGridHelper.getPropMap(entryProp);
        ArrayList resultMap = Lists.newArrayListWithExpectedSize((int)entryRows.size());
        for (DynamicObject entryRow : entryRows) {
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)propNameMap.size());
            for (Map.Entry<String, Long> entry : propNameMap.entrySet()) {
                String propName = entry.getKey();
                Long propId = entry.getValue();
                DynamicObjectCollection valueObjs = entryRow.getDynamicObjectCollection(propName);
                List idList = valueObjs.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                valueMap.put(propId, idList);
            }
            resultMap.add(valueMap);
        }
        return resultMap;
    }

    private static Map<String, Long> getPropMap(EntryProp entryProp) {
        DataEntityPropertyCollection properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        HashMap propNameMap = Maps.newHashMapWithExpectedSize((int)10);
        for (IDataEntityProperty property : properties) {
            DynamicFieldIdGenerationParamForTabular param;
            String fieldType;
            if (!property.getName().startsWith("dgdf") || !StringUtils.equals((CharSequence)(fieldType = (param = DynamicFieldIdGenerationParamForTabular.parseFrom((String)property.getName())).getFieldType()), (CharSequence)"mulbasedatafield")) continue;
            propNameMap.put(property.getName(), param.getIdentityId());
        }
        return propNameMap;
    }
}

