/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.sdk.swc.hcdm.common.stdtab.DisplayModeCheckBoxEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class DisplayModePaintHelper {
    public static final String PREFIX_RANK = "rank_";
    public static final String PREFIX_ITEM = "item_";
    public static final String KEY_DISPLAY_ONLYSALARYCOUNT = "show_salary_count";

    public static void toLoadCustomControlMetas(LoadCustomControlMetasArgs args, String flexPanelKey, boolean isQueryView, SalaryStandardTypeEnum typeEnum, DisplayModeCheckBoxEntity displayOnlySalaryCount) {
        List<DisplayModeCheckBoxEntity> modeCheckBoxEntities = isQueryView ? DisplayModePaintHelper.getCheckBoxEntitiesForQueryView(typeEnum) : DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum, displayOnlySalaryCount);
        List<FieldAp> fieldAps = DisplayModePaintHelper.batchCreateCheckboxFieldAp(modeCheckBoxEntities);
        List metaItems = fieldAps.stream().map(FieldAp::createControl).collect(Collectors.toCollection(() -> Lists.newArrayListWithExpectedSize((int)fieldAps.size())));
        HashMap<String, Object> checkboxFieldApMap = new HashMap<String, Object>(16);
        checkboxFieldApMap.put("id", flexPanelKey);
        checkboxFieldApMap.put("items", metaItems);
        args.getItems().add(checkboxFieldApMap);
    }

    public static void toLoadCustomControlMetas(LoadCustomControlMetasArgs args, String flexPanelKey, boolean isQueryView, SalaryStandardTypeEnum typeEnum) {
        DisplayModeCheckBoxEntity displayOnlySalaryCount = DisplayModePaintHelper.getSalaryCountBoxEntity(SalaryStandardConstants.ONLY_SALARYCOUNT());
        DisplayModePaintHelper.toLoadCustomControlMetas(args, flexPanelKey, isQueryView, typeEnum, displayOnlySalaryCount);
    }

    public static void toCreateNewData(BizDataEventArgs args, IDataModel model, boolean isQueryView, SalaryStandardTypeEnum typeEnum) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)model.getDataEntityType());
        List<DisplayModeCheckBoxEntity> modeCheckBoxEntities = isQueryView ? DisplayModePaintHelper.getCheckBoxEntitiesForQueryView(typeEnum) : DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum);
        for (DisplayModeCheckBoxEntity mode : modeCheckBoxEntities) {
            String fieldKey = DisplayModePaintHelper.getFieldKeyByType(mode.getType(), mode.getId());
            dataEntity.set(fieldKey, (Object)mode.isValue());
        }
        args.setDataEntity((Object)dataEntity);
    }

    public static List<String> getFieldKeys(List<DisplayModeCheckBoxEntity> modeCheckBoxEntities) {
        return modeCheckBoxEntities.stream().map(mode -> DisplayModePaintHelper.getFieldKeyByType(mode.getType(), mode.getId())).collect(Collectors.toCollection(() -> new ArrayList(10)));
    }

    public static List<String> getSecondPageFieldKeys(SalaryStandardTypeEnum typeEnum) {
        List<DisplayModeCheckBoxEntity> modeCheckBoxEntities = DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum);
        return modeCheckBoxEntities.stream().map(mode -> DisplayModePaintHelper.getFieldKeyByType(mode.getType(), mode.getId())).collect(Collectors.toCollection(() -> new ArrayList(10)));
    }

    public static DisplayParamNew dynamicObjToDisplayParam(DisplayParamNew displayParam, DynamicObject secondPageDyn, List<String> fieldKeys) {
        for (String fieldKey : fieldKeys) {
            int value = -1;
            try {
                value = DisplayParamHelper.displayParamBooleanValueToInt(secondPageDyn.getBoolean(fieldKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (SWCStringUtils.isEmpty((String)fieldKey) || value == -1) continue;
            if (fieldKey.startsWith(PREFIX_RANK)) {
                if (displayParam.getRankLevelValueById(Long.valueOf(fieldKey.substring(5))) == -1) continue;
                displayParam.setRankLevelValueById(Long.valueOf(fieldKey.substring(5)), value);
                continue;
            }
            if (fieldKey.startsWith(PREFIX_ITEM)) {
                if (displayParam.getItemLevelValueById(Long.valueOf(fieldKey.substring(5))) == -1) continue;
                displayParam.setItemLevelValueById(Long.valueOf(fieldKey.substring(5)), value);
                continue;
            }
            if (!KEY_DISPLAY_ONLYSALARYCOUNT.equals(fieldKey) || displayParam.getDisplayOnlySalaryCount() == -1) continue;
            displayParam.setDisplayOnlySalaryCount(value);
        }
        return displayParam;
    }

    public static void trySetFromSecondOrFourthModel(IFormView curView, DisplayParamNew displayParam, String parentPageId, SalaryStandardEntryData entryData, boolean isSecondFromPage) {
        String secondPageId;
        if (displayParam == null) {
            return;
        }
        String string = secondPageId = isSecondFromPage ? SalaryStandardCacheHelper.getSecondPageId(parentPageId) : SalaryStandardCacheHelper.getFourthPageId(parentPageId);
        if (StringUtils.isEmpty((CharSequence)secondPageId)) {
            return;
        }
        IFormView secondView = curView.getView(secondPageId);
        if (secondView == null) {
            return;
        }
        DynamicObject secondPageDyn = secondView.getModel().getDataEntity();
        List<String> fieldKeys = DisplayModePaintHelper.getSecondPageFieldKeys(entryData.getStdBaseEntity().getType());
        DisplayModePaintHelper.dynamicObjToDisplayParam(displayParam, secondPageDyn, fieldKeys);
    }

    public static void toCreateNewData(BizDataEventArgs args, IDataModel model, SalaryStandardTypeEnum typeEnum) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)model.getDataEntityType());
        List<DisplayModeCheckBoxEntity> modeCheckBoxEntities = DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum);
        for (DisplayModeCheckBoxEntity mode : modeCheckBoxEntities) {
            String fieldKey = DisplayModePaintHelper.getFieldKeyByType(mode.getType(), mode.getId());
            if (DisplayParamHelper.sysPresetGradeRankIds.contains(mode.getId()) || DisplayParamHelper.sysPresetStdItemIdsForSalaryCount.contains(mode.getId())) {
                mode.setValue(true);
            }
            dataEntity.set(fieldKey, (Object)mode.isValue());
        }
        args.setDataEntity((Object)dataEntity);
    }

    public static void createCheckBoxControl(OnGetControlArgs args, String key, IFormView formView) {
        FieldEdit checkBoxEdit = new FieldEdit();
        checkBoxEdit.setKey(key);
        checkBoxEdit.setView(formView);
        checkBoxEdit.setFieldKey(key.toLowerCase());
        checkBoxEdit.setModel(formView.getModel());
        args.setControl((Control)checkBoxEdit);
    }

    public static void toBindData(IFormView formView, String flexPaneKey, boolean isQueryView, SalaryStandardTypeEnum typeEnum) {
        List<FieldAp> fieldAps = DisplayModePaintHelper.batchCreateCheckboxFieldAp(isQueryView ? DisplayModePaintHelper.getCheckBoxEntitiesForQueryView(typeEnum) : DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum));
        Container flex = (Container)formView.getControl(flexPaneKey);
        List<Control> allControls = DisplayModePaintHelper.getControls(fieldAps);
        if (allControls.isEmpty()) {
            return;
        }
        for (Control control : allControls) {
            control.setView(formView);
            flex.getItems().add(control);
        }
    }

    private static List<Control> getControls(List<FieldAp> fieldAps) {
        ArrayList<Control> allControls = new ArrayList<Control>(fieldAps.size());
        for (FieldAp fieldAp : fieldAps) {
            allControls.add((Control)fieldAp.buildRuntimeControl());
        }
        return allControls;
    }

    public static List<FieldAp> batchCreateCheckboxFieldAp(List<DisplayModeCheckBoxEntity> modeCheckBoxEntities) {
        ArrayList<FieldAp> fieldAps = new ArrayList<FieldAp>(10);
        modeCheckBoxEntities.sort(Comparator.comparing(DisplayModeCheckBoxEntity::getIndex));
        for (DisplayModeCheckBoxEntity entity : modeCheckBoxEntities) {
            String fieldKey = DisplayModePaintHelper.getFieldKeyByType(entity.getType(), entity.getId());
            FieldAp checkboxFieldAp = DisplayModePaintHelper.createCheckboxFieldAp(fieldKey, entity.getName(), entity.isValue());
            fieldAps.add(checkboxFieldAp);
        }
        return fieldAps;
    }

    public static FieldAp createCheckboxFieldAp(String checkBoxKey, String checkBoxName, boolean defValue) {
        FieldAp checkBoxFieldAp = new FieldAp();
        checkBoxFieldAp.setId(checkBoxKey);
        checkBoxFieldAp.setKey(checkBoxKey);
        checkBoxFieldAp.setFireUpdEvt(true);
        checkBoxFieldAp.setName(new LocaleString(checkBoxName));
        CheckBoxField ck = new CheckBoxField();
        ck.setName(new LocaleString(checkBoxName));
        ck.setKey(checkBoxKey);
        ck.setShowStyle(2);
        ck.setDefValue(defValue);
        checkBoxFieldAp.setField((Field)ck);
        Style inStyle = new Style();
        Margin inMargin = new Margin();
        inMargin.setBottom("15px");
        inMargin.setTop("7px");
        inStyle.setMargin(inMargin);
        checkBoxFieldAp.setStyle(inStyle);
        checkBoxFieldAp.setHeight(new LocaleString("8px"));
        checkBoxFieldAp.setWidth(new LocaleString("auto"));
        checkBoxFieldAp.setTextAlign("center");
        checkBoxFieldAp.setBusyTip(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d", (String)"DisplayModePaintHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0])));
        return checkBoxFieldAp;
    }

    public static void registerDynamicProps(MainEntityType newMainType, boolean isQueryView, SalaryStandardTypeEnum typeEnum) {
        List<DisplayModeCheckBoxEntity> displayModeCheckBoxEntities = isQueryView ? DisplayModePaintHelper.getCheckBoxEntitiesForQueryView(typeEnum) : DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum);
        ArrayList fieldParam = Lists.newArrayListWithCapacity((int)10);
        for (DisplayModeCheckBoxEntity mode : displayModeCheckBoxEntities) {
            BooleanProp booleanProp = new BooleanProp();
            booleanProp.setDefValue((Object)mode.isValue());
            String fieldKey = DisplayModePaintHelper.getFieldKeyByType(mode.getType(), mode.getId());
            booleanProp.setName(fieldKey);
            booleanProp.setDbIgnore(true);
            booleanProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)booleanProp);
        }
        EntryParamContainerBaseHelper.registProp((List)fieldParam, (EntityType)newMainType);
    }

    public static String getFieldKeyByType(String modeType, String id) {
        String fieldKey = "";
        switch (modeType) {
            case "item": {
                fieldKey = PREFIX_ITEM + id;
                break;
            }
            case "rank": {
                fieldKey = PREFIX_RANK + id;
                break;
            }
            case "only": {
                fieldKey = id;
                break;
            }
            default: {
                fieldKey = id;
            }
        }
        return fieldKey;
    }

    public static List<DisplayModeCheckBoxEntity> getCheckBoxEntitiesForSettingForm(SalaryStandardTypeEnum typeEnum, DisplayModeCheckBoxEntity displayOnlySalaryCount) {
        DisplayModeCheckBoxEntity displayModeCheckBoxEntity;
        DynamicObject[] specialRankWithExt = GradeRankHelper.getInstance().getSpecialRankWithExt(typeEnum, 1);
        DynamicObject[] varPredictItemWithExt = SalaryStdItemHelper.getVarPredictItemWithExt(typeEnum, 1);
        ArrayList<DisplayModeCheckBoxEntity> modeCheckBoxEntities = new ArrayList<DisplayModeCheckBoxEntity>(10);
        if (SalaryStandardTypeEnum.SALARYCOUNT.equals((Object)typeEnum)) {
            displayOnlySalaryCount.setVisible(true);
        } else {
            displayOnlySalaryCount.setVisible(false);
        }
        modeCheckBoxEntities.add(displayOnlySalaryCount);
        if (specialRankWithExt != null) {
            for (DynamicObject specialRank : specialRankWithExt) {
                displayModeCheckBoxEntity = new DisplayModeCheckBoxEntity(specialRank.getString("id"), specialRank.getString("name"), "rank");
                modeCheckBoxEntities.add(displayModeCheckBoxEntity);
            }
        }
        if (varPredictItemWithExt != null) {
            for (DynamicObject varPredictItem : varPredictItemWithExt) {
                displayModeCheckBoxEntity = new DisplayModeCheckBoxEntity(varPredictItem.getString("id"), varPredictItem.getString("name"), "item");
                modeCheckBoxEntities.add(displayModeCheckBoxEntity);
            }
        }
        return modeCheckBoxEntities;
    }

    public static List<DisplayModeCheckBoxEntity> getCheckBoxEntitiesForSettingForm(SalaryStandardTypeEnum typeEnum) {
        DisplayModeCheckBoxEntity displayOnlySalaryCount = DisplayModePaintHelper.getSalaryCountBoxEntity(SalaryStandardConstants.ONLY_SALARYCOUNT());
        return DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(typeEnum, displayOnlySalaryCount);
    }

    public static DisplayModeCheckBoxEntity getSalaryCountBoxEntity(String name) {
        DisplayModeCheckBoxEntity displayOnlySalaryCount = new DisplayModeCheckBoxEntity(KEY_DISPLAY_ONLYSALARYCOUNT, name, "only");
        displayOnlySalaryCount.setIndex(-2);
        return displayOnlySalaryCount;
    }

    public static List<DisplayModeCheckBoxEntity> getCheckBoxEntitiesForQueryView(SalaryStandardTypeEnum typeEnum) {
        DynamicObject[] varPredictItemWithExt = SalaryStdItemHelper.getVarPredictItemWithExt(typeEnum, 1);
        ArrayList<DisplayModeCheckBoxEntity> modeCheckBoxEntities = new ArrayList<DisplayModeCheckBoxEntity>(10);
        DisplayModeCheckBoxEntity displayOnlySalaryCount = DisplayModePaintHelper.getSalaryCountBoxEntity(SalaryStandardConstants.ONLY_SALARYCOUNT());
        if (SalaryStandardTypeEnum.SALARYCOUNT.equals((Object)typeEnum)) {
            displayOnlySalaryCount.setVisible(true);
        } else {
            displayOnlySalaryCount.setVisible(false);
        }
        modeCheckBoxEntities.add(displayOnlySalaryCount);
        if (varPredictItemWithExt != null) {
            for (DynamicObject varPredictItem : varPredictItemWithExt) {
                DisplayModeCheckBoxEntity displayModeCheckBoxEntity = new DisplayModeCheckBoxEntity(varPredictItem.getString("id"), varPredictItem.getString("name"), "item");
                if (DisplayParamHelper.sysPresetStdItemIdsForSalaryCount.contains(varPredictItem.getString("id"))) {
                    displayModeCheckBoxEntity.setValue(true);
                }
                modeCheckBoxEntities.add(displayModeCheckBoxEntity);
            }
        }
        return modeCheckBoxEntities;
    }
}

