/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetDefaultDisplayParamEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetOnlySalaryCountEvent;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.DisplayModeCheckBoxEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayModeDefaultParam;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.salarystandard.DisplayModePaintHelper;

public class DisplayParamHelper {
    public static final Set<String> sysPresetGradeRankIds = new HashSet<String>(16);
    public static final Set<String> sysPresetStdItemIdsForSalaryCount = new HashSet<String>(16);
    private static final Set<String> sysPresetStdItemIdsForBroadBand = new HashSet<String>(16);

    public static DisplayParamNew getDefaultParamForStandardWithExt(SalaryStandardBaseEntity standardBaseEntity) {
        OnGetDefaultDisplayParamEvent evt = new OnGetDefaultDisplayParamEvent((Object)standardBaseEntity);
        evt.setStandardBaseEntity(standardBaseEntity);
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetDisplayParam", null);
        proxy.callAfter(o1 -> {
            o1.onGetDisplayParam(evt);
            return null;
        });
        return evt.getDisplayParam();
    }

    public static DisplayParamNew getDefaultParamForSalaryCount(SalaryStandardBaseEntity standardBaseEntity) {
        DisplayParamNew param = new DisplayParamNew();
        param.setDisplaySalaryGradeSort(1);
        param.setDisplaySalaryRankSort(standardBaseEntity.getIsUseSalaryRank() > 0 ? 1 : -1);
        param.setDisplayGradeStyle(SalaryStdGridDisplayTypeEnum.GROUPITEMS.getCode());
        param.setDisplayOnlySalaryCount(DisplayParamHelper.getDefaultCodeOfOnlyScByUseSc(standardBaseEntity.getIsUseSalaryCount(), SalaryStandardTypeEnum.SALARYCOUNT));
        List<DisplayModeCheckBoxEntity> displayModeCheckBoxEntities = DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(SalaryStandardTypeEnum.SALARYCOUNT);
        ArrayList<DisplayModeDefaultParam> defaultParams = new ArrayList<DisplayModeDefaultParam>(10);
        for (DisplayModeCheckBoxEntity displayMode : displayModeCheckBoxEntities) {
            int value;
            String id = displayMode.getId();
            if ("rank".equals(displayMode.getType())) {
                value = sysPresetGradeRankIds.contains(id) ? 1 : 2;
                defaultParams.add(new DisplayModeDefaultParam("rank", Long.valueOf(id), value));
            }
            if (!"item".equals(displayMode.getType())) continue;
            value = sysPresetStdItemIdsForSalaryCount.contains(id) ? 1 : 2;
            defaultParams.add(new DisplayModeDefaultParam("item", Long.valueOf(id), value));
        }
        for (DisplayModeDefaultParam defaultParam : defaultParams) {
            if ("item".equals(defaultParam.getType())) {
                param.setItemLevelValueById(defaultParam.getId(), defaultParam.getValue());
                continue;
            }
            param.setRankLevelValueById(defaultParam.getId(), defaultParam.getValue());
        }
        return param;
    }

    public static DisplayParamNew getDefaultParamForBroadband(SalaryStandardBaseEntity standardBaseEntity) {
        DisplayParamNew param = new DisplayParamNew();
        param.setDisplaySalaryGradeSort(1);
        param.setDisplaySalaryRankSort(1);
        param.setDisplayGradeStyle(SalaryStdGridDisplayTypeEnum.GROUPITEMS.getCode());
        List<DisplayModeCheckBoxEntity> displayModeCheckBoxEntities = DisplayModePaintHelper.getCheckBoxEntitiesForSettingForm(SalaryStandardTypeEnum.BROADBAND);
        ArrayList<DisplayModeDefaultParam> defaultParams = new ArrayList<DisplayModeDefaultParam>(10);
        for (DisplayModeCheckBoxEntity displayMode : displayModeCheckBoxEntities) {
            int value;
            String id = displayMode.getId();
            if ("rank".equals(displayMode.getType())) {
                value = sysPresetGradeRankIds.contains(id) ? 1 : 2;
                defaultParams.add(new DisplayModeDefaultParam("rank", Long.valueOf(id), value));
            }
            if (!"item".equals(displayMode.getType())) continue;
            value = sysPresetStdItemIdsForBroadBand.contains(id) ? 1 : 2;
            defaultParams.add(new DisplayModeDefaultParam("item", Long.valueOf(id), value));
        }
        for (DisplayModeDefaultParam defaultParam : defaultParams) {
            if ("item".equals(defaultParam.getType())) {
                param.setItemLevelValueById(defaultParam.getId(), defaultParam.getValue());
                continue;
            }
            param.setRankLevelValueById(defaultParam.getId(), defaultParam.getValue());
        }
        return param;
    }

    public static boolean getRankVisibleFlagByDisplayParam(SalaryRankEntity rank, DisplayParamNew param) {
        if (rank.getRankLabel().equals((Object)SalaryRankLabelEnum.STANDARD)) {
            return true;
        }
        if (rank.getRankIdentity() == null || param == null) {
            return false;
        }
        Integer value = (Integer)param.getRankLevelParam().get(rank.getRankIdentity());
        if (value == null) {
            return true;
        }
        return param.getRankLevelValueById(rank.getRankIdentity()) == 1;
    }

    public static boolean getItemVisibleFlagByDisplayParam(SalaryStdItemEntity item, DisplayParamNew param) {
        if (item.getItemLabel().equals((Object)SalaryItemLabelEnum.STANDARD)) {
            return true;
        }
        if (item.getItemIdentity() == null || param == null) {
            return false;
        }
        Integer value = (Integer)param.getItemLevelParam().get(item.getItemIdentity());
        if (value == null) {
            return false;
        }
        return param.getItemLevelValueById(item.getItemIdentity()) == 1;
    }

    public static List<CalculationMethodEnum> getAvailableCalcMethod(SalaryStandardTypeEnum stdtype) {
        ArrayList<CalculationMethodEnum> availableCalcMethods = new ArrayList<CalculationMethodEnum>(4);
        if (SalaryStandardTypeEnum.SALARYCOUNT == stdtype) {
            return availableCalcMethods;
        }
        if (SalaryStandardTypeEnum.BROADBAND == stdtype) {
            availableCalcMethods = new ArrayList<CalculationMethodEnum>(Arrays.asList(CalculationMethodEnum.values()));
        }
        return availableCalcMethods;
    }

    public static int getDefaultCodeOfOnlyScByUseSc(int isUseSalaryCount, SalaryStandardTypeEnum type) {
        OnGetOnlySalaryCountEvent evt = new OnGetOnlySalaryCountEvent((Object)type);
        evt.setIsUseSalaryCount(isUseSalaryCount);
        evt.setType(type);
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetOnlySalaryCount", null);
        proxy.callReplaceIfPresent(o1 -> {
            o1.onGetOnlySalaryCount(evt);
            return null;
        });
        return evt.getDisplayOnlySalaryCount();
    }

    public static Boolean getValueForBooleanAp(int code) {
        return code == 1;
    }

    public static int displayParamBooleanValueToInt(Boolean value) {
        if (value == null) {
            return -1;
        }
        if (Boolean.TRUE.equals(value)) {
            return 1;
        }
        return 2;
    }

    public static boolean checkNeedSort(int code) {
        return code > 0;
    }

    public static boolean checkNeedReverseSort(int code) {
        return code == 2;
    }

    public static boolean checkVisibleByCode(int code) {
        return code != -1;
    }

    public static SalaryStdGridDisplayTypeEnum checkGridTypeByCode(int code) {
        SalaryStdGridDisplayTypeEnum result;
        switch (code) {
            case 2: {
                result = SalaryStdGridDisplayTypeEnum.GROUPRANK;
                break;
            }
            case 3: {
                result = SalaryStdGridDisplayTypeEnum.TABULAR;
                break;
            }
            default: {
                result = SalaryStdGridDisplayTypeEnum.GROUPITEMS;
            }
        }
        return result;
    }

    public static int getCodeByVisible(boolean visible) {
        if (visible) {
            return 1;
        }
        return -1;
    }

    public static String getGradeOrderErrorMsg(DisplayParamNew displayParam) {
        int code = displayParam.getDisplaySalaryGradeSort();
        switch (code) {
            case 1: {
                return ResManager.loadKDString((String)"\u85aa\u7b49-\u9012\u589e", (String)"DisplayParamHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
            }
            case 2: {
                return ResManager.loadKDString((String)"\u85aa\u7b49-\u9012\u51cf", (String)"DisplayParamHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]);
            }
        }
        return "sort code error\uff0ccode is " + String.valueOf(code);
    }

    public static String getRankOrderErrorMsg(DisplayParamNew displayParam) {
        int code = displayParam.getDisplaySalaryRankSort();
        switch (code) {
            case 1: {
                return ResManager.loadKDString((String)"\u85aa\u6863-\u9012\u589e", (String)"DisplayParamHelper_4", (String)"swc-hcdm-business", (Object[])new Object[0]);
            }
            case 2: {
                return ResManager.loadKDString((String)"\u85aa\u6863-\u9012\u51cf", (String)"DisplayParamHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0]);
            }
        }
        return "sort code error\uff0ccode is " + String.valueOf(code);
    }

    static {
        sysPresetGradeRankIds.add("1000000000003");
        sysPresetGradeRankIds.add("1000000000004");
        sysPresetStdItemIdsForSalaryCount.add("1000000000001");
        sysPresetStdItemIdsForSalaryCount.add("1000000000002");
        sysPresetStdItemIdsForSalaryCount.add("1000000000003");
        sysPresetStdItemIdsForBroadBand.add("1000000000001");
        sysPresetStdItemIdsForBroadBand.add("1000000000002");
        sysPresetStdItemIdsForBroadBand.add("1000000000003");
    }
}

