/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.common.entity.salarystandard.BaseDynamicGridFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;

public class DynamicGridFieldIdChecker {
    private static final Log logger = LogFactory.getLog(DynamicGridFieldIdChecker.class);
    private static Map<String, List<Class>> typeMap = Maps.newHashMapWithExpectedSize((int)16);

    public static BaseDynamicGridFieldIdGenerationParam checkGenerationParamByKey(String key) {
        BaseDynamicGridFieldIdGenerationParam param = BaseDynamicGridFieldIdGenerationParam.parseFrom((String)key);
        Class clazz = typeMap.get(param.getPrefix()).get(param.getGridDisplayType().getCode() - 1);
        BaseDynamicGridFieldIdGenerationParam generationParam = null;
        try {
            generationParam = (BaseDynamicGridFieldIdGenerationParam)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("{} \u5b9e\u4f8b\u5316\u5931\u8d25,message is {}", (Object)clazz.getName(), (Object)e.getMessage());
        }
        return generationParam;
    }

    static {
        typeMap.put("dgdf", Arrays.asList(DynamicFieldIdGenerationParamForGroup.class, null, DynamicFieldIdGenerationParamForTabular.class));
        typeMap.put("dgff", Arrays.asList(FixedFieldIdGenerationParam.class, null, FixedFieldIdGenerationParam.class));
    }
}

