/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.AppliedRangeEntity;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.CurrencyEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.IntervalPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.sdk.swc.hcdm.common.stdtab.ViewControlParam;
import kd.swc.hcdm.business.SalaryStandardCreatePkService;
import kd.swc.hcdm.business.enums.SalaryStandardPreDataPolicyType;
import kd.swc.hcdm.business.enums.StdDimensionsType;
import kd.swc.hcdm.business.salarystandard.AppliedRangeHelper;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntity;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntityVO;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardPreDataParam;
import kd.swc.hcdm.common.entity.salarystandard.GradeRankValueOutbound;
import kd.swc.hcdm.common.enums.SalaryStandardMonetaryUnitEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

public class EntityConverter {
    private static final Log Logger = LogFactory.getLog(EntityConverter.class);
    private static SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);
    public static final SalaryStandardCreatePkService stdPkService = new SalaryStandardCreatePkService();
    private GradeRankHelper rankHelper = GradeRankHelper.getInstance();

    public static EntityConverter getInstance() {
        return new EntityConverter();
    }

    public static SalaryStandardEntryData fetchEntityFromModel(DynamicObject salaryStdObj) {
        long beginTime = TimeServiceHelper.now().getTime();
        SalaryStandardEntryData standardEntryData = EntityConverter.fetchEntityFromModel(salaryStdObj, true);
        Logger.info("EntityConverter fetchEntityFromModel costtime {}", (Object)(TimeServiceHelper.now().getTime() - beginTime));
        return standardEntryData;
    }

    public static SalaryStandardEntryData fetchEntityFromModel(DynamicObject salaryStdObj, boolean includeDbIgnoredFields) {
        return EntityConverter.fetchEntityFromModelWithEntryName(salaryStdObj, "salarystditem", "salarygrade", "salaryrank", "salarystddata_a", "intervalps", "appliedrange", "contrastps", "contrastsumdata", includeDbIgnoredFields ? "displayset" : "");
    }

    public static SalaryStandardEntryData fetchEntityFromModelWithEntryName(DynamicObject salaryStdObj, String ... entryNames) {
        SalaryStandardEntryData instance = SalaryStandardEntryData.instance();
        SalaryStandardBaseEntity standardBaseEntity = EntityConverter.dynamicObjToSalaryStdEntity(salaryStdObj);
        instance.buildBase(standardBaseEntity);
        DataEntityPropertyCollection properties = salaryStdObj.getDataEntityType().getProperties();
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"salarystditem") >= 0 && properties.get((Object)"salarystditem") != null) {
            instance.buildItem(EntityConverter.dynamicObjToSalaryStdItemEntity(salaryStdObj.getDynamicObjectCollection("salarystditem"), standardBaseEntity.getId()));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"salarygrade") >= 0 && properties.get((Object)"salarygrade") != null) {
            instance.buildGrade(EntityConverter.dynamicObjToSalaryGradeEntity(salaryStdObj.getDynamicObjectCollection("salarygrade"), standardBaseEntity.getId()));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"salaryrank") >= 0 && properties.get((Object)"salaryrank") != null) {
            instance.buildRank(EntityConverter.dynamicObjToSalaryRankEntity(salaryStdObj.getDynamicObjectCollection("salaryrank"), standardBaseEntity.getId(), standardBaseEntity.getType()));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"salarystddata_a") >= 0 && properties.get((Object)"salarystddata_a") != null) {
            String gradeRankSeqMapStr = salaryStdObj.getString("graderankseqmap");
            Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
            Map<String, Map<Integer, Long>> stringMapMap = service.reverseGradeRankSeqMap(gradeRankSeqMap);
            instance.buildStdDataStrs(EntityConverter.dynamicObjToSalaryStdDataStr(salaryStdObj.getDynamicObjectCollection("salarystddata_a"), standardBaseEntity.getId(), stringMapMap));
            instance.buildStdData(EntityConverter.dynamicObjToSalaryStdDataEntity(salaryStdObj.getDynamicObjectCollection("salarystddata_a"), standardBaseEntity.getId(), stringMapMap));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"intervalps") >= 0 && properties.get((Object)"intervalps") != null) {
            instance.buildIntervalProp(EntityConverter.dynamicObjToIntervalPropEntity(salaryStdObj.getDynamicObjectCollection("intervalps"), standardBaseEntity.getId()));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"appliedrange") >= 0 && properties.get((Object)"appliedrange") != null) {
            instance.buildAppliedRange(EntityConverter.dynamicObjToAppliedRangeEntity(salaryStdObj.getDynamicObjectCollection("appliedrange"), standardBaseEntity.getId()));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"displayset") >= 0 && properties.get((Object)"displayset") != null) {
            List<DisplayParamPropEntity> displayParamPropEntities = EntityConverter.dynamicObjToDisplayParamPropEntity(salaryStdObj.getDynamicObjectCollection("displayset"));
            instance.buildDisplayParamProp(displayParamPropEntities);
            DisplayParamNew displayParam = EntityConverter.dynamicObjToDisplayParam(displayParamPropEntities);
            instance.buildDisplayParamNew(displayParam == null ? DisplayParamHelper.getDefaultParamForStandardWithExt(standardBaseEntity) : displayParam);
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"contrastps") >= 0 && properties.get((Object)"contrastps") != null) {
            instance.buildContrastProp(EntityConverter.dynamicObjToContrastPropEntity(salaryStdObj.getDynamicObjectCollection("contrastps")));
        }
        if (ArrayUtils.indexOf((Object[])entryNames, (Object)"contrastsumdata") >= 0 && properties.get((Object)"contrastsumdata") != null) {
            instance.buildContrastRowData(EntityConverter.entryToContrastRowDataEntity(salaryStdObj.getDynamicObjectCollection("contrastsumdata"), (List<ContrastPropEntity>)instance.getContrastPropEntities()));
        }
        instance.buildViewControlParam(new ViewControlParam());
        return instance;
    }

    public static List<AppliedRangeEntity> dynamicObjToAppliedRangeEntity(DynamicObjectCollection dynamicObjectCollection, Long standardId) {
        return EntityConverter.dynamicObjToAppliedRangeEntity(dynamicObjectCollection, standardId, false);
    }

    public static List<AppliedRangeEntity> dynamicObjToAppliedRangeEntity(DynamicObjectCollection dynamicObjectCollection, Long standardId, boolean isRemoveEmpty) {
        ArrayList<AppliedRangeEntity> appliedRangeEntityList = new ArrayList<AppliedRangeEntity>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String rangetype = dynamicObject.getString("rangetype");
            String rangeid = dynamicObject.getString("rangeid");
            if (isRemoveEmpty && !StringUtils.isNotBlank((CharSequence)rangetype) && !StringUtils.isNotBlank((CharSequence)rangeid)) continue;
            appliedRangeEntityList.add(EntityConverter.dynamicObjToAppliedRangeEntity(dynamicObject, standardId));
        }
        return appliedRangeEntityList;
    }

    public static AppliedRangeEntity dynamicObjToAppliedRangeEntity(DynamicObject dynamicObject, Long standardId) {
        String rangeNameStr = dynamicObject.getString("rangename");
        String rangeIdStr = dynamicObject.getString("rangeid");
        return new AppliedRangeEntity(standardId, dynamicObject.getString("rangetype"), AppliedRangeHelper.splitNameStrToList(rangeNameStr), AppliedRangeHelper.splitIdStrToList(rangeIdStr));
    }

    public static SalaryStandardBaseEntity dynamicObjToSalaryStdEntity(DynamicObject obj) {
        long id = obj.getLong("id");
        String type = obj.getString("type");
        DynamicObject currency = obj.getDynamicObject("currency");
        DynamicObject amtPrecision = obj.getDynamicObject("amtprecision");
        CurrencyEntity currencyEntity = EntityConverter.dynamicObjToCurrencyEntity(currency);
        int scale = amtPrecision == null ? currencyEntity.getAmtPrecision() : amtPrecision.getInt("scale");
        currencyEntity.setAmtPrecision(scale);
        int isUseSalaryCount = EntityConverter.getCodeFromBooleanField(obj.getBoolean("isusesalarycount"));
        BigDecimal salaryCountAmount = obj.getBigDecimal("salarycountamount");
        String monetaryUnit = obj.getString("monetaryunit");
        int isUseSalaryRank = EntityConverter.getCodeFromBooleanField(obj.getBoolean("isusesalaryrank"));
        long jobScmId = obj.getLong("jobscm.id");
        CalculationMethodEnum calcMethod = CalculationMethodEnum.getCalcMethodByCode((int)obj.getInt("calcmethod"));
        long countryId = obj.getLong("country.id");
        long frequencyId = obj.getLong("frequency.id");
        String gradeRankSeqMapStr = obj.getString("graderankseqmap");
        SalaryStandardBaseEntity entity = new SalaryStandardBaseEntity();
        entity.setId(Long.valueOf(id));
        entity.setType(SalaryStandardTypeEnum.getFromCode((String)type));
        entity.setCurrencyId(Long.valueOf(currency == null ? 0L : currency.getLong("id")));
        entity.setCurrencyEntity(currencyEntity);
        entity.setIsUseSalaryCount(isUseSalaryCount);
        entity.setSalaryCountAmount(salaryCountAmount);
        entity.setMonetaryUnit(monetaryUnit);
        entity.setIsUseSalaryRank(isUseSalaryRank);
        entity.setJobScmId(Long.valueOf(jobScmId));
        entity.setCalcMethod(calcMethod != null ? calcMethod : CalculationMethodEnum.GRADE_RANK);
        entity.setCountryId(Long.valueOf(countryId));
        entity.setFrequencyId(Long.valueOf(frequencyId));
        entity.setGradeRankSeqMapEntity(service.getGradeRankSeqMapEntity(gradeRankSeqMapStr));
        return entity;
    }

    public static int getCodeFromBooleanField(Boolean value) {
        return value != false ? 1 : 0;
    }

    public static CurrencyEntity dynamicObjToCurrencyEntity(DynamicObject currency) {
        if (currency == null) {
            return new CurrencyEntity();
        }
        CurrencyEntity entity = new CurrencyEntity(currency.getLong("id"), currency.getString("number"), currency.getString("name"), currency.getString("sign"));
        int amtPrecision = currency.getInt("amtprecision");
        entity.setAmtPrecision(amtPrecision);
        return entity;
    }

    public static SalaryStdItemEntity dynamicObjToSalaryStdItemEntity(DynamicObject obj, Long salaryStandardId) {
        Long salaryItemId = obj.getLong("salaryitem.id");
        Long itemIdentity = obj.getLong("itemidentity");
        int isFixedItem = obj.getDynamicObject("salaryitem") == null ? 0 : EntityConverter.getCodeFromBooleanField(obj.getBoolean("salaryitem.fixeditem"));
        int itemIndex = obj.getInt("itemindex");
        String itemType = obj.getString("salarystdtype");
        SalaryStandardTypeEnum itemTypeEnum = SalaryStandardTypeEnum.getFromCode((String)itemType);
        String itemLabel = obj.getString("itemlabel");
        SalaryItemLabelEnum itemLabelEnum = SalaryItemLabelEnum.valueOf((String)itemLabel);
        String itemName = "";
        VarPredictItemType type = null;
        if (itemLabelEnum == SalaryItemLabelEnum.STANDARD) {
            itemName = obj.getString("salaryitem.name");
        } else {
            DynamicObject varPredictItem = SalaryStdItemHelper.getVarPredictItemById(itemIdentity);
            if (varPredictItem != null) {
                itemName = varPredictItem.getString("name");
                type = VarPredictItemType.fromCode((String)varPredictItem.getString("type"));
            } else {
                itemName = itemIdentity + "-deleted";
            }
        }
        int itemIsUseSalaryRank = EntityConverter.getCodeFromBooleanField(obj.getBoolean("itemisusesalaryrank"));
        int itemIsUseSalaryCount = EntityConverter.getCodeFromBooleanField(obj.getBoolean("itemisusesalarycount"));
        SalaryStdItemEntity itemEntity = new SalaryStdItemEntity(salaryStandardId, itemIdentity, itemIndex, salaryItemId, itemTypeEnum, itemIsUseSalaryRank, itemIsUseSalaryCount);
        itemEntity.setIsFixedItem(isFixedItem);
        itemEntity.setItemName(itemName);
        itemEntity.setItemLabel(itemLabelEnum);
        itemEntity.setVarPredictItemType(type);
        return itemEntity;
    }

    public static List<SalaryStdItemEntity> dynamicObjToSalaryStdItemEntity(DynamicObjectCollection objs, Long salaryStandardId) {
        ArrayList<SalaryStdItemEntity> entityList = new ArrayList<SalaryStdItemEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            SalaryStdItemEntity dynamicObjToSalaryStdItemEntity = EntityConverter.dynamicObjToSalaryStdItemEntity(obj, salaryStandardId);
            if (dynamicObjToSalaryStdItemEntity == null) continue;
            entityList.add(dynamicObjToSalaryStdItemEntity);
        }
        return entityList;
    }

    public static SalaryGradeEntity dynamicObjToSalaryGradeEntity(DynamicObject obj, Long salaryStandardId) {
        Long gradeIdentity = obj.getLong("gradeidentity");
        Long id = obj.getLong("id");
        int gradeIndex = obj.getInt("gradeindex");
        String gradeName = obj.getString("gradename");
        String gradeNumber = obj.getString("gradenumber");
        SalaryGradeEntity gradeEntity = new SalaryGradeEntity(salaryStandardId, gradeIdentity, gradeIndex, gradeName);
        gradeEntity.setGradeNumber(gradeNumber);
        gradeEntity.setId(id);
        return gradeEntity;
    }

    public static List<SalaryGradeEntity> dynamicObjToSalaryGradeEntity(DynamicObjectCollection objs, Long salaryStandardId) {
        ArrayList<SalaryGradeEntity> entityList = new ArrayList<SalaryGradeEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            entityList.add(EntityConverter.dynamicObjToSalaryGradeEntity(obj, salaryStandardId));
        }
        return entityList;
    }

    public SalaryRankEntity dynamicObjToSalaryRankEntity(DynamicObject obj, Long tabId, SalaryStandardTypeEnum type) {
        return this.dynamicObjToSalaryRankEntity(obj, tabId, type, false);
    }

    public SalaryRankEntity dynamicObjToSalaryRankEntity(DynamicObject obj, Long tabId, SalaryStandardTypeEnum type, boolean onlyStandard) {
        Long id = obj.getLong("id");
        Long rankIdentity = obj.getLong("rankidentity");
        int rankIndex = obj.getInt("rankindex");
        String rankName = obj.getString("rankname");
        String rankNumber = obj.getString("ranknumber");
        String rankLabel = obj.getString("ranklabel");
        SalaryRankLabelEnum rankLabelEnum = SalaryRankLabelEnum.valueOf((String)rankLabel);
        if (onlyStandard && rankLabelEnum != SalaryRankLabelEnum.STANDARD) {
            return null;
        }
        int rankIsUserSet = EntityConverter.getCodeFromBooleanField(obj.getBoolean("rankisuserset"));
        int rankIsSysPreSet = EntityConverter.getCodeFromBooleanField(obj.getBoolean("rankissyspreset"));
        if (!onlyStandard && SalaryRankLabelEnum.STANDARD != rankLabelEnum) {
            String specialRankName = this.rankHelper.loadSpRankNameByType(type, rankIdentity);
            rankName = SWCStringUtils.isNotEmpty((String)specialRankName) ? specialRankName : rankIdentity + "-deleted";
            rankNumber = rankName;
        }
        SalaryRankEntity rankEntity = new SalaryRankEntity(tabId, rankIdentity, rankIndex, rankName, rankLabelEnum, rankIsUserSet, rankIsSysPreSet);
        rankEntity.setId(id);
        rankEntity.setRankNumber(rankNumber);
        return rankEntity;
    }

    public static List<SalaryRankEntity> dynamicObjToSalaryRankEntity(DynamicObjectCollection objs, Long tabId, SalaryStandardTypeEnum typeEnum) {
        EntityConverter instance = EntityConverter.getInstance();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DynamicObject obj : objs) {
            builder.add((Object)instance.dynamicObjToSalaryRankEntity(obj, tabId, typeEnum));
        }
        return EntityConverter.dynamicObjToSalaryRankEntity(objs, tabId, typeEnum, false);
    }

    public static List<SalaryRankEntity> dynamicObjToSalaryRankEntity(DynamicObjectCollection objs, Long tabId, SalaryStandardTypeEnum typeEnum, boolean onlyStandard) {
        ImmutableList.Builder builder = ImmutableList.builder();
        EntityConverter instance = EntityConverter.getInstance();
        for (DynamicObject obj : objs) {
            SalaryRankEntity salaryRankEntity = instance.dynamicObjToSalaryRankEntity(obj, tabId, typeEnum, onlyStandard);
            if (salaryRankEntity == null) continue;
            builder.add((Object)salaryRankEntity);
        }
        return builder.build();
    }

    public static BigDecimal getValueFromMap(Map<String, String> valueMap, String key) {
        String valueStr = valueMap.get(key);
        if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
            return new BigDecimal(valueStr);
        }
        return null;
    }

    public static List<SalaryStdDataEntity> dynamicObjToSalaryStdDataEntity(DynamicObjectCollection objs, Long salaryStandardId, Map<String, Map<Integer, Long>> gradeRankSeqMap) {
        ArrayList<SalaryStdDataEntity> entityList = new ArrayList<SalaryStdDataEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            Long itemIdentity = obj.getLong("salarystditemid_a");
            String stdData = obj.getString("stddata");
            entityList.addAll(service.parseStdDataToEntity(salaryStandardId, itemIdentity, stdData, gradeRankSeqMap));
        }
        return entityList;
    }

    public static LinkedHashMap<Long, String> dynamicObjToSalaryStdDataStr(DynamicObjectCollection objs, Long salaryStandardId, Map<String, Map<Integer, Long>> gradeRankSeqMap) {
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)objs.size());
        for (DynamicObject obj : objs) {
            Long itemIdentity = obj.getLong("salarystditemid_a");
            String stdData = obj.getString("stddata");
            resultMap.put(itemIdentity, stdData);
        }
        return resultMap;
    }

    public static List<SalaryStdDataEntity> stdStrToSalaryStdDataEntity(Map<Long, String> objs, Long salaryStandardId, Map<String, Map<Integer, Long>> gradeRankSeqMap) {
        ArrayList<SalaryStdDataEntity> entityList = new ArrayList<SalaryStdDataEntity>(objs.size());
        for (Map.Entry<Long, String> entry : objs.entrySet()) {
            Long itemIdentity = entry.getKey();
            String stdData = entry.getValue();
            entityList.addAll(service.parseStdDataToEntity(salaryStandardId, itemIdentity, stdData, gradeRankSeqMap));
        }
        return entityList;
    }

    public static LinkedHashMap<Long, String> dynamicObjToSalaryStdDataString(DynamicObjectCollection objs) {
        LinkedHashMap<Long, String> entityList = new LinkedHashMap<Long, String>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            Long itemIdentity = obj.getLong("salarystditemid_a");
            String stdData = obj.getString("stddata");
            entityList.put(itemIdentity, stdData);
        }
        return entityList;
    }

    public static IntervalPropEntity dynamicObjToIntervalPropEntity(DynamicObject obj, Long salaryStandardId) {
        String intervalPropName = obj.getString("intervalpsname");
        String intervalPropDisplayName = obj.getString("intervalpsdisplayname");
        int intervalPropIndex = obj.getInt("intervalpsindex");
        return new IntervalPropEntity(salaryStandardId, intervalPropName, intervalPropDisplayName, intervalPropIndex);
    }

    public static List<IntervalPropEntity> dynamicObjToIntervalPropEntity(DynamicObjectCollection objs, Long salaryStandardId) {
        if (objs == null) {
            return new ArrayList<IntervalPropEntity>();
        }
        ArrayList<IntervalPropEntity> entityList = new ArrayList<IntervalPropEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            entityList.add(EntityConverter.dynamicObjToIntervalPropEntity(obj, salaryStandardId));
        }
        return entityList;
    }

    public static DisplayParamNew dynamicObjToDisplayParam(List<DisplayParamPropEntity> displayParamPropEntities) {
        if (CollectionUtils.isEmpty(displayParamPropEntities)) {
            return null;
        }
        DisplayParamNew entity = new DisplayParamNew();
        LinkedHashMap<Long, Integer> rankLevelParam = new LinkedHashMap<Long, Integer>(16);
        LinkedHashMap<Long, Integer> itemLevelParam = new LinkedHashMap<Long, Integer>(16);
        for (DisplayParamPropEntity displayParamPropEntity : displayParamPropEntities) {
            String propertyName = displayParamPropEntity.getPropertyName();
            int value = displayParamPropEntity.getPropertyValue();
            if (SWCStringUtils.isEmpty((String)propertyName)) continue;
            if (propertyName.startsWith("rank_")) {
                rankLevelParam.put(Long.valueOf(propertyName.substring(5)), value);
                continue;
            }
            if (propertyName.startsWith("item_")) {
                itemLevelParam.put(Long.valueOf(propertyName.substring(5)), value);
                continue;
            }
            if ("displaySalaryRankSort".equals(propertyName)) {
                entity.setDisplaySalaryRankSort(value);
                continue;
            }
            if ("displaySalaryGradeSort".equals(propertyName)) {
                entity.setDisplaySalaryGradeSort(value);
                continue;
            }
            if ("displayGradeStyle".equals(propertyName)) {
                entity.setDisplayGradeStyle(value);
                continue;
            }
            if (!"displayOnlySalaryCount".equals(propertyName)) continue;
            entity.setDisplayOnlySalaryCount(value);
        }
        entity.setRankLevelParam(rankLevelParam);
        entity.setItemLevelParam(itemLevelParam);
        return entity;
    }

    public static ContrastPropEntity dynamicObjToContrastPropEntity(DynamicObject obj) {
        ContrastPropConfigEntity propConfigEntity = EntityConverter.dynamicObjToContrastPropConfigEntity(obj.getDynamicObject("pscontrastpropconf"));
        int propIndex = obj.getInt("pspropindex");
        return new ContrastPropEntity(propConfigEntity.getId(), propConfigEntity, propIndex);
    }

    public static List<ContrastPropEntity> dynamicObjToContrastPropEntity(DynamicObjectCollection objs) {
        if (objs == null) {
            return new ArrayList<ContrastPropEntity>();
        }
        ArrayList<ContrastPropEntity> entityList = new ArrayList<ContrastPropEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            if (obj == null || obj.getDynamicObject("pscontrastpropconf") == null) continue;
            entityList.add(EntityConverter.dynamicObjToContrastPropEntity(obj));
        }
        return entityList;
    }

    public static ContrastPropConfigEntity dynamicObjToContrastPropConfigEntity(DynamicObject obj) {
        long configId = obj.getLong("id");
        String objectTypeIId = obj.getString("entityobject.number");
        String name = obj.getString("name");
        String number = obj.getString("number");
        String category = obj.getString("category");
        String queryFields = obj.getString("queryfields");
        String width = obj.getString("width");
        ContrastPropConfigEntity configEntity = new ContrastPropConfigEntity(Long.valueOf(configId), name, objectTypeIId, category, queryFields, width);
        configEntity.setNumber(number);
        return configEntity;
    }

    private static ContrastRowDataEntity entryToContrastRowDataEntity(DynamicObject obj, List<ContrastPropEntity> props) {
        ContrastRowDataEntity rowDataEntity = new ContrastRowDataEntity();
        rowDataEntity.setGradeRankRangeDBVal(obj.getString("graderankrange"));
        rowDataEntity.setStdPropValueDBVal(obj.getString("standardpropvalue"));
        rowDataEntity.setProps(props);
        rowDataEntity.setRowIndex(obj.getInt("sumrowindex"));
        return rowDataEntity;
    }

    private static List<List<Long>> parseToStdPropValue(String standardPropValue, List<ContrastPropEntity> contrastPropEntities) {
        if (StringUtils.isNotBlank((CharSequence)standardPropValue)) {
            Map map = (Map)JSON.parseObject((String)standardPropValue, Map.class);
            HashMap propValue = Maps.newHashMapWithExpectedSize((int)map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o2;
                Map.Entry entry = o2 = iterator.next();
                String configIdStr = (String)entry.getKey();
                List propValueIdStrList = (List)entry.getValue();
                propValue.put(Long.valueOf(configIdStr), propValueIdStrList.stream().map(Long::parseLong).collect(Collectors.toList()));
            }
            return contrastPropEntities.stream().map(o -> propValue.getOrDefault(o.getPropConfigId(), Lists.newArrayList())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static DisplayParamPropEntity dynamicObjToDisplayParamPropEntity(DynamicObject obj) {
        String displayProperty = obj.getString("displayproperty");
        int displayPropertyValue = obj.getInt("displaypropertyvalue");
        String displayModule = obj.getString("displaymodule");
        return new DisplayParamPropEntity(displayProperty, displayPropertyValue, displayModule);
    }

    public static List<DisplayParamPropEntity> dynamicObjToDisplayParamPropEntity(DynamicObjectCollection objs) {
        if (objs == null) {
            return new ArrayList<DisplayParamPropEntity>();
        }
        ArrayList<DisplayParamPropEntity> entityList = new ArrayList<DisplayParamPropEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            entityList.add(EntityConverter.dynamicObjToDisplayParamPropEntity(obj));
        }
        return entityList;
    }

    public static List<Long> getPkIdFromMulBaseData(DynamicObjectCollection objs) {
        return objs.stream().map(o1 -> o1.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Deprecated
    public static List<ContrastDataEntity> dynamicObjToContrastDataEntity(DynamicObjectCollection objs) {
        return new ArrayList<ContrastDataEntity>();
    }

    public static List<ContrastRowDataEntity> entryToContrastRowDataEntity(DynamicObjectCollection objs, List<ContrastPropEntity> props) {
        if (objs == null) {
            return new ArrayList<ContrastRowDataEntity>();
        }
        ArrayList<ContrastRowDataEntity> entityList = new ArrayList<ContrastRowDataEntity>(objs.getRowCount());
        for (DynamicObject obj : objs) {
            entityList.add(EntityConverter.entryToContrastRowDataEntity(obj, props));
        }
        return entityList;
    }

    public static SalaryStandardEntryEntityVO getSalaryGradeFromEnt(DynamicObjectCollection gradeEnt) {
        String suffix = StdDimensionsType.GRADE.getNameParam().loadKDString();
        return new SalaryStandardEntryEntityVO(new SalaryStandardPreDataParam(SalaryStandardPreDataPolicyType.NUMBER, "", suffix), EntityConverter.getGradeSalaryStandardEntryEntityList(gradeEnt), 1, StdDimensionsType.GRADE);
    }

    public static SalaryStandardEntryEntityVO getSalaryRankFromEnt(DynamicObjectCollection rankEnt, SalaryStandardTypeEnum typeEnum) {
        String suffix = StdDimensionsType.RANK.getNameParam().loadKDString();
        return new SalaryStandardEntryEntityVO(new SalaryStandardPreDataParam(SalaryStandardPreDataPolicyType.getPolicyTypeByStdType(typeEnum), "", suffix), EntityConverter.getRankSalaryStandardEntryEntityList(rankEnt, typeEnum), 1, StdDimensionsType.RANK);
    }

    public static List<SalaryStandardEntryEntity> getGradeSalaryStandardEntryEntityList(DynamicObjectCollection gradeEnt) {
        ArrayList<SalaryStandardEntryEntity> salaryStandardEntryEntities = new ArrayList<SalaryStandardEntryEntity>(gradeEnt.size());
        gradeEnt.forEach(ent -> {
            SalaryStandardEntryEntity entryEntity = new SalaryStandardEntryEntity();
            entryEntity.setDisplayName(ent.getString("gradename"));
            entryEntity.setId(ent.getLong("gradeidentity"));
            entryEntity.setIndex(ent.getInt("gradeindex"));
            salaryStandardEntryEntities.add(entryEntity);
        });
        return salaryStandardEntryEntities;
    }

    public static List<SalaryStandardEntryEntity> getRankSalaryStandardEntryEntityList(DynamicObjectCollection rankEnt, SalaryStandardTypeEnum type) {
        ArrayList<SalaryStandardEntryEntity> salaryStandardEntryEntities = new ArrayList<SalaryStandardEntryEntity>(rankEnt.size());
        List<SalaryRankEntity> rankEntities = EntityConverter.dynamicObjToSalaryRankEntity(rankEnt, 0L, type);
        rankEntities.forEach(ent -> {
            if (ent.getRankIsSysPreSet() == 0 && ent.getRankLabel() == SalaryRankLabelEnum.STANDARD) {
                SalaryStandardEntryEntity entryEntity = new SalaryStandardEntryEntity();
                entryEntity.setDisplayName(ent.getRankName());
                entryEntity.setId(ent.getRankIdentity());
                entryEntity.setIndex(ent.getRankIndex());
                salaryStandardEntryEntities.add(entryEntity);
            }
        });
        return salaryStandardEntryEntities;
    }

    public static String generateMoneyaryUnitStr(SalaryStandardBaseEntity stdEntity) {
        CurrencyEntity currencyEntity = stdEntity.getCurrencyEntity();
        return EntityConverter.getMoneyaryUnitStr(currencyEntity.getName(), currencyEntity.getNumber(), SalaryStandardMonetaryUnitEnum.getFromCode((String)stdEntity.getMonetaryUnit()).getI18NParam().loadKDString());
    }

    private static String getMoneyaryUnitStr(String curName, String curNum, String monetaryUnit) {
        StringBuilder displayString = new StringBuilder();
        if (SWCStringUtils.isNotEmpty((String)curName)) {
            displayString.append(curName);
        }
        if (SWCStringUtils.isNotEmpty((String)curNum)) {
            displayString.append(curNum);
        }
        displayString.append('(');
        if (SWCStringUtils.isNotEmpty((String)monetaryUnit)) {
            displayString.append(monetaryUnit);
        }
        displayString.append(')');
        return displayString.toString();
    }

    public static GradeRankValueOutbound dynamicObjToGradeRankValueOutbound(DynamicObjectCollection entryEntity, int rowIndex, int carryBit) {
        GradeRankValueOutbound bound = new GradeRankValueOutbound();
        bound.setCarryBit(carryBit);
        bound.setRowIndex(rowIndex);
        bound.setValueList(EntityConverter.getGradeRankValueFromEnt(entryEntity, carryBit));
        return bound;
    }

    private static List<GradeRankValue> getGradeRankValueFromEnt(DynamicObjectCollection entryEntity, int carryBit) {
        ArrayList<GradeRankValue> dataList = new ArrayList<GradeRankValue>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            int gradeBegin = dynamicObject.getInt("gradebegin");
            int rankBegin = dynamicObject.getInt("rankbegin");
            int gradeEnd = dynamicObject.getInt("gradeend");
            int rankEnd = dynamicObject.getInt("rankend");
            int beginValue = gradeBegin * carryBit + rankBegin;
            int endValue = gradeEnd * carryBit + rankEnd;
            dataList.add(new GradeRankValue(beginValue, endValue));
        }
        return dataList;
    }
}

