/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.swc.hcdm.common.entity.salarystandard.FieldEditGenerationParam;

public class FieldGenerator {
    private static final Log logger;
    private static Map<String, String[]> fieldTypeFunctionMap;
    private static Map<String, Method> functionMap;
    private static final int EDIT_FUNCTION_INDEX = 2;
    public static final String TEXT_FIELD_TYPE = "textfield";
    public static final String DECIMAL_FIELD_TYPE = "decimalfield";
    public static final String INTEGER_FIELD_TYPE = "integerfield";
    public static final String AMOUNT_FIELD_TYPE = "amountfield";
    public static final String MULBASEDATA_FIELD_TYPE = "mulbasedatafield";
    public static final String LOCK_STRING = "new,edit,view,submit,audit";
    public static final String CURRENCY_FIELD_KEY = "currencyfield";

    private static Method getMethodFromCache(String fieldType, int propFunctionIndex) {
        String[] methodNames = fieldTypeFunctionMap.get(fieldType);
        if (methodNames == null || methodNames.length == 0) {
            return null;
        }
        String methodName = methodNames[propFunctionIndex];
        return functionMap.get(methodName);
    }

    public static FieldEdit invokeCreateFieldEdit(FieldEditGenerationParam generationParam, String fieldType) {
        Method function = FieldGenerator.getMethodFromCache(fieldType, 2);
        if (function == null) {
            return null;
        }
        try {
            return (FieldEdit)function.invoke(FieldGenerator.class, generationParam);
        }
        catch (Exception e) {
            logger.error("method invoke error,fieldType = {},methodName = {}", (Object)fieldType, (Object)function.getName());
            return null;
        }
    }

    public static FieldEdit createTextEdit(FieldEditGenerationParam param) {
        TextEdit edit = new TextEdit();
        edit.setKey(param.getKey());
        edit.setEntryKey(param.getEntryKey());
        edit.setView(param.getFormView());
        edit.setEntryControlKey(param.getEntryKey());
        return edit;
    }

    public static FieldEdit createIntegerEdit(FieldEditGenerationParam param) {
        IntegerEdit edit = new IntegerEdit();
        edit.setKey(param.getKey());
        edit.setEntryKey(param.getEntryKey());
        edit.setView(param.getFormView());
        edit.setEntryControlKey(param.getEntryKey());
        return edit;
    }

    public static FieldEdit createMulBaseDataEdit(FieldEditGenerationParam param) {
        MulBasedataEdit edit = new MulBasedataEdit();
        edit.setKey(param.getKey());
        edit.setEntryKey(param.getEntryKey());
        edit.setView(param.getFormView());
        edit.setF7BatchFill(false);
        edit.setF7MultipleSelect(false);
        MulBasedataProp prop = (MulBasedataProp)param.getFormView().getModel().getDataEntityType().getAllFields().get(param.getKey());
        String propBaseEntityId = prop.getBaseEntityId();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)propBaseEntityId);
        Map allFields = mainEntityType.getAllFields();
        if (allFields.containsKey("status")) {
            edit.setQFilter(new QFilter("status", "=", (Object)"C"));
        }
        edit.setEntryControlKey(param.getEntryKey());
        return edit;
    }

    public static FieldEdit createAmountEdit(FieldEditGenerationParam param) {
        AmountEdit edit = new AmountEdit();
        edit.setKey(param.getKey());
        edit.setEntryKey(param.getEntryKey());
        edit.setView(param.getFormView());
        edit.setEntryControlKey(param.getEntryKey());
        return edit;
    }

    public static FieldEdit createDecimalEdit(FieldEditGenerationParam param) {
        DecimalEdit edit = new DecimalEdit();
        edit.setKey(param.getKey());
        edit.setEntryKey(param.getEntryKey());
        edit.setView(param.getFormView());
        edit.setEntryControlKey(param.getEntryKey());
        return edit;
    }

    static {
        Method[] methods;
        logger = LogFactory.getLog(FieldGenerator.class);
        fieldTypeFunctionMap = new HashMap<String, String[]>(4);
        functionMap = new HashMap<String, Method>(16);
        for (Method method : methods = FieldGenerator.class.getDeclaredMethods()) {
            functionMap.putIfAbsent(method.getName(), method);
        }
        fieldTypeFunctionMap.put(INTEGER_FIELD_TYPE, new String[]{"createIntegerFieldAp", "createIntegerProp", "createIntegerEdit"});
        fieldTypeFunctionMap.put(TEXT_FIELD_TYPE, new String[]{"createTextFieldAp", "createTextProp", "createTextEdit"});
        fieldTypeFunctionMap.put(DECIMAL_FIELD_TYPE, new String[]{"createDecimalFieldAp", "createDecimalProp", "createDecimalEdit"});
        fieldTypeFunctionMap.put(AMOUNT_FIELD_TYPE, new String[]{"createAmountFieldAp", "createAmountProp", "createAmountEdit"});
        fieldTypeFunctionMap.put(MULBASEDATA_FIELD_TYPE, new String[]{"createMulBaseDataFieldAp", "createMulBaseDataProp", "createMulBaseDataEdit"});
    }
}

