/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetFieldLockStatusEvent;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;

public class FieldLockStatusMapping {
    private HRPluginProxy<IStdTableExtPlugin> proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetFieldLockStatus", null);
    private static Map<String, Boolean> stdItemRankLockOfGroup = new HashMap<String, Boolean>();
    private static Map<String, Boolean> stdItemSpRankLockOfGroup = new HashMap<String, Boolean>();
    private static Map<String, Boolean> spItemStdRankLockOfGroup = new HashMap<String, Boolean>();
    private static Map<String, Boolean> spItemSpRankLockOfGroup = new HashMap<String, Boolean>();
    private static final String var_two_tpl = "%d-%d";
    private static final String var_three_tpl = "%d-%d-%d";
    private static final String var_four_tpl = "%d-%d-%d-%d";

    public static FieldLockStatusMapping getInstance() {
        return new FieldLockStatusMapping();
    }

    public Boolean checkForGroupItem(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, int seq, CalculationMethodEnum calcMethod) {
        Boolean status = null;
        OnGetFieldLockStatusEvent evt = new OnGetFieldLockStatusEvent((Object)stdBaseEntity);
        evt.setStdBaseEntity(stdBaseEntity);
        evt.setItemEntity(item);
        evt.setRankEntity(rank);
        evt.setSeq(seq);
        evt.setCalculationMethod(calcMethod);
        evt.setGridType(SalaryStdGridDisplayTypeEnum.GROUPITEMS);
        this.proxy.callAfter(plugin -> {
            plugin.onGetFieldLockStatus(evt);
            return null;
        });
        if (evt.getLockStatus() != null) {
            status = evt.getLockStatus();
        }
        return status;
    }

    public static Boolean getDefaultLockStatusOfGroup(SalaryStdItemEntity item, SalaryRankEntity rank, int seq, CalculationMethodEnum calcMethod) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        SalaryRankLabelEnum rankLabel = rank.getRankLabel();
        Boolean status = null;
        status = itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD) ? (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? stdItemRankLockOfGroup.get(String.format(var_two_tpl, seq, calcMethod.getCode())) : stdItemSpRankLockOfGroup.get(String.format(var_three_tpl, rank.getRankIdentity(), seq, calcMethod.getCode()))) : (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? spItemStdRankLockOfGroup.get(String.format(var_three_tpl, item.getItemIdentity(), seq, calcMethod.getCode())) : spItemSpRankLockOfGroup.get(String.format(var_four_tpl, item.getItemIdentity(), rank.getRankIdentity(), seq, calcMethod.getCode())));
        if (status == null && SalaryItemLabelEnum.SPECIAL.equals((Object)itemLabel)) {
            VarPredictItemType varPredictItemType = SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity());
            if (VarPredictItemType.predict == varPredictItemType) {
                status = Boolean.TRUE;
            }
            if (VarPredictItemType.variable == varPredictItemType) {
                status = Boolean.FALSE;
            }
        }
        if (status == null) {
            status = Boolean.FALSE;
        }
        return status;
    }

    public Boolean checkForTabular(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, int seq, CalculationMethodEnum calcMethod) {
        Boolean status = Boolean.TRUE;
        OnGetFieldLockStatusEvent evt = new OnGetFieldLockStatusEvent((Object)stdBaseEntity);
        evt.setStdBaseEntity(stdBaseEntity);
        evt.setItemEntity(item);
        evt.setSeq(seq);
        evt.setCalculationMethod(calcMethod);
        evt.setGridType(SalaryStdGridDisplayTypeEnum.TABULAR);
        this.proxy.callAfter(plugin -> {
            plugin.onGetFieldLockStatus(evt);
            return null;
        });
        if (evt.getLockStatus() != null) {
            status = evt.getLockStatus();
        }
        return status;
    }

    static {
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_WIDTH, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_GEARDIFFERENCE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_OVERLAP, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_ISOMETRIC, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_GEARDIFFERENCE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_OVERLAP, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_ISOMETRIC, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_WIDTH, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_OVERLAP, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        stdItemSpRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_RANK_ISOMETRIC, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        stdItemRankLockOfGroup.put(String.format(var_two_tpl, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        stdItemRankLockOfGroup.put(String.format(var_two_tpl, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        spItemStdRankLockOfGroup.put(String.format(var_three_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.GRADE_RANK.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_WIDTH.getCode()), Boolean.TRUE);
        spItemSpRankLockOfGroup.put(String.format(var_four_tpl, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode(), CalculationMethodEnum.MEDIAN_GEAR.getCode()), Boolean.TRUE);
    }
}

