/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetFieldParamEvent;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;

public class FieldTypeHelper {
    private static Map<String, String> stdItemRankFieldTypeMapOfGroup = new HashMap<String, String>(32);
    private static Map<String, String> stdItemSpRankFieldTypeMapOfGroup = new HashMap<String, String>(32);
    private static Map<String, String> spItemStRankFieldTypeMapOfGroup = new HashMap<String, String>(32);
    private static Map<String, String> spItemRankFieldTypeMapOfGroup = new HashMap<String, String>(32);
    private static Map<String, String> stdItemFieldTypeMapOfTabular = new HashMap<String, String>(16);
    private static Map<String, String> spItemFieldTypeMapOfTabular = new HashMap<String, String>(16);
    private static final String var_two_tpl = "%s-%d";
    private static final String var_three_tpl = "%s-%d-%d";
    private static final String var_four_tpl = "%s-%d-%d-%d";
    private HRPluginProxy<IStdTableExtPlugin> fieldTypeForGroupItemProxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetFieldTypeForGroupItem", null);
    private HRPluginProxy<IStdTableExtPlugin> fieldTypeForTabularProxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetFieldTypeForTabular", null);

    public String getFieldTypeForGroupItemWithExt(SalaryStandardTypeEnum type, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        String fieldType = null;
        OnGetFieldParamEvent evt = new OnGetFieldParamEvent((Object)type);
        evt.setType(type);
        evt.setItemEntity(item);
        evt.setRankEntity(rank);
        evt.setSeq(seq);
        this.fieldTypeForGroupItemProxy.callAfter(plugin -> {
            plugin.onGetFieldTypeForGroupItem(evt);
            return null;
        });
        if (evt.getFieldType() != null) {
            fieldType = evt.getFieldType();
        }
        return fieldType;
    }

    public static String getDefaultFieldTypeForGroupItem(SalaryStandardTypeEnum type, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        SalaryRankLabelEnum rankLabel = rank.getRankLabel();
        String fieldType = null;
        fieldType = itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD) ? (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? stdItemRankFieldTypeMapOfGroup.get(String.format(var_two_tpl, type.getCode(), seq)) : stdItemSpRankFieldTypeMapOfGroup.get(String.format(var_three_tpl, type.getCode(), rank.getRankIdentity(), seq))) : (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? spItemStRankFieldTypeMapOfGroup.get(String.format(var_three_tpl, type.getCode(), item.getItemIdentity(), seq)) : spItemRankFieldTypeMapOfGroup.get(String.format(var_four_tpl, type.getCode(), item.getItemIdentity(), rank.getRankIdentity(), seq)));
        if (fieldType == null && itemLabel.equals((Object)SalaryItemLabelEnum.SPECIAL)) {
            fieldType = VarPredictItemType.predict == SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity()) ? "amountfield" : "decimalfield";
        }
        if (fieldType == null) {
            fieldType = "amountfield";
        }
        return fieldType;
    }

    public String getFieldTypeForTabularWithExt(SalaryStandardTypeEnum type, SalaryStdItemEntity item, int seq) {
        String fieldType = null;
        OnGetFieldParamEvent evt = new OnGetFieldParamEvent((Object)type);
        evt.setType(type);
        evt.setItemEntity(item);
        evt.setRankEntity(null);
        evt.setSeq(seq);
        this.fieldTypeForTabularProxy.callAfter(plugin -> {
            plugin.onGetFieldTypeForTabular(evt);
            return null;
        });
        if (evt.getFieldType() != null) {
            fieldType = evt.getFieldType();
        }
        return fieldType;
    }

    public static String getDefaultFieldTypeForTabular(SalaryStandardTypeEnum type, SalaryStdItemEntity item, int seq) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        String fieldType = null;
        fieldType = itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD) ? stdItemFieldTypeMapOfTabular.get(String.format(var_two_tpl, type.getCode(), seq)) : spItemFieldTypeMapOfTabular.get(String.format(var_three_tpl, type, item.getItemIdentity(), seq));
        if (fieldType == null && itemLabel.equals((Object)SalaryItemLabelEnum.SPECIAL)) {
            fieldType = VarPredictItemType.predict == SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity()) ? "amountfield" : "decimalfield";
        }
        if (fieldType == null) {
            fieldType = "amountfield";
        }
        return fieldType;
    }

    static {
        stdItemRankFieldTypeMapOfGroup.put("A-1", "amountfield");
        stdItemRankFieldTypeMapOfGroup.put("A-2", "amountfield");
        stdItemRankFieldTypeMapOfGroup.put("A-3", "amountfield");
        stdItemRankFieldTypeMapOfGroup.put("A-0", "decimalfield");
        stdItemRankFieldTypeMapOfGroup.put("C-1", "amountfield");
        stdItemRankFieldTypeMapOfGroup.put("C-0", "decimalfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000001-1", "amountfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000002-1", "decimalfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000003-1", "decimalfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000004-1", "amountfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000005-1", "decimalfield");
        stdItemSpRankFieldTypeMapOfGroup.put("C-1000000000006-1", "decimalfield");
        spItemStRankFieldTypeMapOfGroup.put("C-1000000000001-1", "decimalfield");
        spItemStRankFieldTypeMapOfGroup.put("C-1000000000002-1", "amountfield");
        spItemStRankFieldTypeMapOfGroup.put("C-1000000000003-1", "amountfield");
        spItemStRankFieldTypeMapOfGroup.put("A-1000000000001-1", "decimalfield");
        spItemStRankFieldTypeMapOfGroup.put("A-1000000000002-1", "amountfield");
        spItemStRankFieldTypeMapOfGroup.put("A-1000000000003-1", "amountfield");
        spItemRankFieldTypeMapOfGroup.put("C-1000000000002-1000000000001-1", "amountfield");
        spItemRankFieldTypeMapOfGroup.put("C-1000000000003-1000000000001-1", "amountfield");
        stdItemFieldTypeMapOfTabular.put("A-1", "amountfield");
        stdItemFieldTypeMapOfTabular.put("A-0", "decimalfield");
        stdItemFieldTypeMapOfTabular.put("C-1", "amountfield");
        stdItemFieldTypeMapOfTabular.put("C-0", "decimalfield");
        spItemFieldTypeMapOfTabular.put("A-1000000000001-1", "amountfield");
        spItemFieldTypeMapOfTabular.put("A-1000000000001-0", "decimalfield");
        spItemFieldTypeMapOfTabular.put("A-1000000000002-1", "amountfield");
        spItemFieldTypeMapOfTabular.put("A-1000000000003-0", "decimalfield");
        spItemFieldTypeMapOfTabular.put("A-1000000000003-1", "amountfield");
        spItemFieldTypeMapOfTabular.put("C-1000000000001-1", "decimalfield");
        spItemFieldTypeMapOfTabular.put("C-1000000000002-1", "amountfield");
        spItemFieldTypeMapOfTabular.put("C-1000000000003-1", "amountfield");
    }
}

