/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.rpc.holders.IntHolder;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetItemRankEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetSpecialRankEvent;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryRankOperationFunction;
import kd.swc.hcdm.business.salarystandard.SalaryRankOperationKeyMapping;
import kd.swc.hcdm.business.salarystandard.SalaryStandardComparator;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.GradeRankValueOutbound;
import kd.swc.hcdm.common.enums.SalaryRankOperationKey;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class GradeRankHelper {
    private HRPluginProxy<IStdTableExtPlugin> proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetRankListOfItem", null);
    private HRPluginProxy<IStdTableExtPlugin> proxyOfSpecialRank = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetSpecialRankList", null);
    private Map<String, DynamicObject[]> specialRankCache;
    public static final String displayMedianValue = "1000000000001";
    public static final String displayIncreasingCoefficient = "1000000000002";
    public static final String displayWidth = "1000000000003";
    public static final String displayGearDifference = "1000000000004";
    public static final String displayOverlap = "1000000000005";
    public static final String displayIsoDifference = "1000000000006";

    public static GradeRankHelper getInstance() {
        return new GradeRankHelper();
    }

    public static Map<Long, SalaryGradeEntity> groupByGradeIdentity(List<SalaryGradeEntity> gradeEntities) {
        return gradeEntities.stream().collect(Collectors.toMap(SalaryGradeEntity::getGradeIdentity, Function.identity(), (p1, p2) -> p2));
    }

    public static Map<String, SalaryGradeEntity> groupByGradeName(List<SalaryGradeEntity> gradeEntities) {
        return gradeEntities.stream().collect(Collectors.toMap(SalaryGradeEntity::getGradeName, Function.identity(), (p1, p2) -> p2));
    }

    public static Map<Long, SalaryRankEntity> groupByRankIdentity(List<SalaryRankEntity> rankEntities) {
        return rankEntities.stream().collect(Collectors.toMap(SalaryRankEntity::getRankIdentity, Function.identity(), (p1, p2) -> p2));
    }

    public static Map<String, SalaryRankEntity> groupByRankName(List<SalaryRankEntity> rankEntities) {
        return rankEntities.stream().collect(Collectors.toMap(SalaryRankEntity::getRankName, Function.identity(), (p1, p2) -> p2));
    }

    @Deprecated
    public static List<ContrastDataEntity> buildStructureForGradeRank(List<ContrastDataEntity> gradeRankContrastDatas) {
        return null;
    }

    public static List<ContrastDataEntity> getAllGradeRankFromStructure(List<ContrastDataEntity> gradeRankContrastDatas) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        for (ContrastDataEntity parent : gradeRankContrastDatas) {
            resultList.add(parent);
            resultList.addAll(parent.getChildren());
        }
        return resultList;
    }

    @Deprecated
    public static String concatGradeRankName(List<ContrastDataEntity> gradeRankContrastData, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        return null;
    }

    public static List<GradeRankKey> getGradeRankKey(List<ContrastDataEntity> gradeRankContrastData, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, boolean isUserRank) {
        ArrayList<GradeRankKey> result = new ArrayList<GradeRankKey>();
        if (CollectionUtils.isEmpty(gradeRankContrastData)) {
            return result;
        }
        for (ContrastDataEntity contrastData : gradeRankContrastData) {
            List list = contrastData.getChildren();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (ContrastDataEntity dataEntity : list) {
                GradeRankKey gradeRankKey = new GradeRankKey(gradeEntityMap.get(contrastData.getContrastPropValue()), isUserRank ? rankEntityMap.get(dataEntity.getContrastPropValue()) : null);
                result.add(gradeRankKey);
            }
        }
        return result;
    }

    @Deprecated
    public static List<GradeRankKey> getGradeRankKey(List<ContrastDataEntity> gradeRankContrastData, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        return null;
    }

    public static int countGradeRankKey(List<ContrastDataEntity> gradeRankContrastData, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        int total = 0;
        if (CollectionUtils.isEmpty(gradeRankContrastData) || gradeEntityMap == null || rankEntityMap == null) {
            return total;
        }
        for (ContrastDataEntity contrastData : gradeRankContrastData) {
            List list = contrastData.getChildren();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            total += list.size();
        }
        return total;
    }

    public static List<GradeRankKey> getAllGradeRankKeyList(List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        ArrayList<GradeRankKey> result = new ArrayList<GradeRankKey>(gradeEntities.size() * rankEntities.size());
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            for (SalaryRankEntity rankEntity : rankEntities) {
                result.add(new GradeRankKey(gradeEntity, rankEntity));
            }
        }
        return result;
    }

    public static void sortGradeRankKeyList(List<GradeRankKey> gradeRankKeyList, int displaySalaryGradeSort, int displaySalaryRankSort) {
        if (!DisplayParamHelper.checkNeedSort(displaySalaryGradeSort)) {
            return;
        }
        Collections.sort(gradeRankKeyList, (o1, o2) -> {
            int sum = 0;
            if (DisplayParamHelper.checkNeedSort(displaySalaryGradeSort)) {
                sum = !DisplayParamHelper.checkNeedReverseSort(displaySalaryGradeSort) ? sum + o1.getGradeEntity().getGradeIndex() - o2.getGradeEntity().getGradeIndex() : sum + o2.getGradeEntity().getGradeIndex() - o1.getGradeEntity().getGradeIndex();
            }
            if (sum == 0 && DisplayParamHelper.checkNeedSort(displaySalaryRankSort)) {
                sum = !DisplayParamHelper.checkNeedReverseSort(displaySalaryRankSort) ? sum + o1.getRankEntity().getRankIndex() - o2.getRankEntity().getRankIndex() : sum + o2.getRankEntity().getRankIndex() - o1.getRankEntity().getRankIndex();
            }
            return sum;
        });
    }

    public static List<SalaryRankEntity> sortRankList(List<SalaryRankEntity> rankEntities, int displaySalaryRankSort) {
        if (CollectionUtils.isEmpty(rankEntities)) {
            return Lists.newArrayList();
        }
        if (!DisplayParamHelper.checkNeedSort(displaySalaryRankSort)) {
            return rankEntities;
        }
        ArrayList dataOfCopy = Lists.newArrayList(rankEntities);
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        dataOfCopy.removeAll(standardRanks);
        if (!DisplayParamHelper.checkNeedReverseSort(displaySalaryRankSort)) {
            standardRanks.sort(new SalaryStandardComparator.RankComparator());
        } else {
            standardRanks.sort(new SalaryStandardComparator.RankComparator().reversed());
        }
        standardRanks.addAll(dataOfCopy);
        return standardRanks;
    }

    public static List<SalaryGradeEntity> sortGradeList(List<SalaryGradeEntity> gradeEntities, int displaySalaryGradeSort) {
        if (CollectionUtils.isEmpty(gradeEntities)) {
            return Lists.newArrayList();
        }
        if (!DisplayParamHelper.checkNeedSort(displaySalaryGradeSort)) {
            return gradeEntities;
        }
        if (!DisplayParamHelper.checkNeedReverseSort(displaySalaryGradeSort)) {
            gradeEntities.sort(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex));
            return gradeEntities;
        }
        gradeEntities.sort(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex).reversed());
        return gradeEntities;
    }

    public static Map<String, Long> gradeGroupByName(List<SalaryGradeEntity> gradeEntities) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>(gradeEntities.size());
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            dataMap.putIfAbsent(gradeEntity.getGradeName(), gradeEntity.getGradeIdentity());
        }
        return dataMap;
    }

    public static Map<String, Long> rankGroupByName(List<SalaryRankEntity> rankEntities) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>(rankEntities.size());
        for (SalaryRankEntity rankEntity : rankEntities) {
            dataMap.putIfAbsent(rankEntity.getRankName(), rankEntity.getRankIdentity());
        }
        return dataMap;
    }

    public static SalaryGradeEntity getGradeByName(List<SalaryGradeEntity> gradeEntities, String gradeName) {
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            if (!gradeEntity.getGradeName().equals(gradeName)) continue;
            return gradeEntity;
        }
        return null;
    }

    public List<SalaryRankEntity> getDisplayRankForGroupItemWithExt(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, List<SalaryRankEntity> rankEntities) {
        List resutlList = null;
        OnGetItemRankEvent evt = new OnGetItemRankEvent((Object)stdBaseEntity);
        evt.setStdBaseEntity(stdBaseEntity);
        evt.setItemEntity(item);
        evt.setRankEntities(rankEntities);
        evt.setUseType("1");
        this.proxy.callAfter(plugin -> {
            plugin.onGetRankListOfItem(evt);
            return null;
        });
        if (CollectionUtils.isNotEmpty((Collection)evt.getReturnDisplayRankList())) {
            resutlList = evt.getReturnDisplayRankList();
        }
        return resutlList;
    }

    public static List<SalaryRankEntity> getDefaultRanksOfItemForDisplay(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, List<SalaryRankEntity> rankEntities) {
        SalaryRankOperationKey operationKey = SalaryRankOperationKeyMapping.getDisplayRankOperationKeyForGroupItem(stdBaseEntity, item);
        if (operationKey != null) {
            return SalaryRankOperationFunction.invokeFunction(rankEntities, operationKey);
        }
        return null;
    }

    public List<SalaryRankEntity> getCalcRankOfItemWithExt(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, List<SalaryRankEntity> rankEntities) {
        List resutlList = null;
        OnGetItemRankEvent evt = new OnGetItemRankEvent((Object)stdBaseEntity);
        evt.setStdBaseEntity(stdBaseEntity);
        evt.setItemEntity(item);
        evt.setRankEntities(rankEntities);
        evt.setUseType("2");
        this.proxy.callAfter(plugin -> {
            plugin.onGetRankListOfItem(evt);
            return null;
        });
        if (CollectionUtils.isNotEmpty((Collection)evt.getReturnDisplayRankList())) {
            resutlList = evt.getReturnDisplayRankList();
        }
        return resutlList;
    }

    public static List<SalaryRankEntity> getDefaultRanksOfItemForCalc(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, List<SalaryRankEntity> rankEntities) {
        List<SalaryRankEntity> resutlList = null;
        SalaryRankOperationKey operationKey = SalaryRankOperationKeyMapping.getCalcRankOperationKeyForGroupItem(stdBaseEntity, item);
        if (operationKey != null) {
            resutlList = SalaryRankOperationFunction.invokeFunction(rankEntities, operationKey);
        }
        return resutlList;
    }

    @Deprecated
    public static List<ContrastDataEntity> getContrastDataEntitiesFromGradeRankOutbound(GradeRankValueOutbound bound, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, Boolean isUseRank) {
        return null;
    }

    public static Map<Long, List<Long>> getRangeMapFromRangeCode(List<GradeRankValue> valueList, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> stdRankEntities, Boolean isUseRank) {
        List<GradeRankKey> rangeKey = GradeRankHelper.getGradeRankKeyFromRangeCode(valueList, stdRankEntities.size(), gradeEntities, stdRankEntities, isUseRank);
        Map<Long, List<Long>> gradeRankIdMap = GradeRankHelper.groupByRangeKeyToIdMap(rangeKey);
        for (Map.Entry<Long, List<Long>> entry : gradeRankIdMap.entrySet()) {
            if (isUseRank.booleanValue()) continue;
            entry.getValue().clear();
        }
        return gradeRankIdMap;
    }

    public static List<GradeRankKey> getGradeRankKeyFromRangeCode(List<GradeRankValue> valueList, int carryBit, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> stdRankEntities, Boolean isUseRank) {
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntities);
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(stdRankEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(stdRankEntities);
        return GradeRankHelper.getGradeRankKeyFromRangeCode(valueList, carryBit, gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntities, isUseRank);
    }

    public static List<GradeRankKey> getGradeRankKeyFromRangeCode(List<GradeRankValue> valueList, int carryBit, Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc, Map<Integer, SalaryRankEntity> rankMapByIndexAsc, Map<Long, SalaryRankEntity> rankEntityMap, List<SalaryGradeEntity> gradeEntities, Boolean isUseRank) {
        Map<Long, List<Long>> gradeRankRelMap = GradeRankHelper.getIdentityMapFromCarryBitValue(valueList, isUseRank, carryBit, gradeMapByIndexAsc, rankMapByIndexAsc);
        return GradeRankHelper.createGradeRankKey(gradeRankRelMap, gradeEntities, rankEntityMap);
    }

    public static boolean checkContainsGrade(List<GradeRankValue> valueList, int carryBit, int gradeIndex) {
        boolean contains = false;
        int gIdx = gradeIndex - 1;
        for (GradeRankValue value : valueList) {
            int beginValue = value.getBeginValue();
            int endValue = value.getEndValue();
            int minGradeIndex = beginValue / carryBit;
            int maxGradeIndex = endValue / carryBit;
            if (gIdx < minGradeIndex || gIdx > maxGradeIndex) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private static Map<Long, List<Long>> getIdentityMapFromCarryBitValue(List<GradeRankValue> valueList, Boolean isUseRank, int carryBit, Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc, Map<Integer, SalaryRankEntity> rankMapByIndexAsc) {
        HashMap<Long, List<Long>> gradeRankRelMap = new HashMap<Long, List<Long>>(gradeMapByIndexAsc.size());
        for (GradeRankValue gradeRankValue : valueList) {
            int beginValue = gradeRankValue.getBeginValue();
            int endValue = gradeRankValue.getEndValue();
            for (int i = beginValue; i <= endValue; ++i) {
                SalaryRankEntity salaryRankEntity;
                int gradeIndex = i / carryBit;
                int rankIndex = i % carryBit;
                SalaryGradeEntity grade = gradeMapByIndexAsc.get(gradeIndex + 1);
                if (grade == null) continue;
                Long gradeIdentity = grade.getGradeIdentity();
                ArrayList<Long> relList = (ArrayList<Long>)gradeRankRelMap.get(gradeIdentity);
                if (relList == null) {
                    relList = new ArrayList<Long>(10);
                }
                if ((salaryRankEntity = rankMapByIndexAsc.get(rankIndex + 1)) != null && !relList.contains(salaryRankEntity.getRankIdentity())) {
                    relList.add(salaryRankEntity.getRankIdentity());
                }
                gradeRankRelMap.put(gradeIdentity, relList);
            }
        }
        return gradeRankRelMap;
    }

    @Deprecated
    private static List<ContrastDataEntity> createContrastData(Map<Long, List<Long>> gradeRankRelMap, int rowIndex, List<SalaryGradeEntity> gradeEntities, Map<Integer, SalaryRankEntity> rankMapByIndexAsc) {
        return null;
    }

    private static List<GradeRankKey> createGradeRankKey(Map<Long, List<Long>> rangeIdentityMap, List<SalaryGradeEntity> gradeEntities, Map<Long, SalaryRankEntity> rankIdentityMap) {
        ArrayList<GradeRankKey> result = new ArrayList<GradeRankKey>(10);
        for (SalaryGradeEntity entity : gradeEntities) {
            List<Long> rankIds = rangeIdentityMap.get(entity.getGradeIdentity());
            if (rankIds == null) continue;
            if (rankIds.isEmpty()) {
                rankIds.add(Objects.requireNonNull(GradeRankHelper.getMinStandardRank(new ArrayList<SalaryRankEntity>(rankIdentityMap.values()))).getRankIdentity());
            }
            for (Long rankId : rankIds) {
                result.add(new GradeRankKey(entity, rankIdentityMap.get(rankId)));
            }
        }
        return result;
    }

    @Deprecated
    private static ContrastDataEntity createRankContrastData(long pkId, long parentId, Long rankId, int rowIndex, int subIndex) {
        return null;
    }

    @Deprecated
    private static ContrastDataEntity createGradeContrastData(long pkId, Long gradeId, int rowIndex, int subIndex) {
        return null;
    }

    public static Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc(Collection<SalaryGradeEntity> gradeEntity) {
        return gradeEntity.stream().sorted(Comparator.comparing(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toMap(SalaryGradeEntity::getGradeIndex, Function.identity(), (oldKey, newKey) -> oldKey));
    }

    public static Map<Integer, SalaryRankEntity> rankMapByIndexAsc(Collection<SalaryRankEntity> rankEntity) {
        return rankEntity.stream().sorted(Comparator.comparing(SalaryRankEntity::getRankIndex)).collect(Collectors.toMap(SalaryRankEntity::getRankIndex, Function.identity(), (oldKey, newKey) -> oldKey));
    }

    @Deprecated
    public static void deleteSpecialContrastDataByRowIndex(DynamicObjectCollection coll, List<Integer> rowIndexes) {
    }

    @Deprecated
    public static void deleteContrastDataByRowIndex(DynamicObjectCollection coll, List<Integer> rowIndexes) {
    }

    public static Map<Integer, String> getRankIndexNameMap(List<SalaryRankEntity> rankEntities) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)rankEntities.size());
        for (SalaryRankEntity rankEntity : rankEntities) {
            resultMap.put(rankEntity.getRankIndex(), rankEntity.getRankName());
        }
        return resultMap;
    }

    public static Map<Integer, String> getGradeIndexNameMap(List<SalaryGradeEntity> gradeEntities) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            resultMap.put(gradeEntity.getGradeIndex(), gradeEntity.getGradeName());
        }
        return resultMap;
    }

    @Deprecated
    public static GradeRankValueOutbound getGradeRankValueOutboundOfOneRow(Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, List<ContrastDataEntity> contrastDataEntities) {
        return null;
    }

    @Deprecated
    private static Map<Long, List<Long>> getIdentityStruct(List<ContrastDataEntity> gradeRankStruct) {
        return null;
    }

    private static Map<Long, List<Long>> getIdentityMapFromRangeKeys(List<GradeRankKey> gradeRankKeys) {
        Map<SalaryGradeEntity, List<GradeRankKey>> collect = gradeRankKeys.stream().collect(Collectors.groupingBy(GradeRankKey::getGradeEntity));
        HashMap map = Maps.newHashMapWithExpectedSize((int)collect.size());
        for (Map.Entry<SalaryGradeEntity, List<GradeRankKey>> entry : collect.entrySet()) {
            List values = map.computeIfAbsent(entry.getKey().getGradeIdentity(), xva$0 -> Lists.newArrayList((Object[])new Long[]{xva$0}));
            HashSet valueSet = new HashSet(values);
            List rankIds = entry.getValue().stream().map(GradeRankKey::getRankEntity).map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
            valueSet.addAll(rankIds);
            values.clear();
            values.addAll(valueSet);
        }
        return map;
    }

    private static List<GradeRankValue> makeGradeRankValue(List<Integer> valueList) {
        ArrayList<GradeRankValue> rangeCodeArr = new ArrayList<GradeRankValue>(valueList.size());
        int size = (valueList = valueList.stream().distinct().sorted(Comparator.comparingInt(o1 -> o1)).collect(Collectors.toList())).size();
        if (size == 1) {
            rangeCodeArr.add(new GradeRankValue(valueList.get(0).intValue(), valueList.get(0).intValue()));
            return rangeCodeArr;
        }
        Integer begin = valueList.get(0);
        Integer end = valueList.get(0);
        for (int i = 1; i <= size - 1; ++i) {
            Integer next = valueList.get(i);
            if (end + 1 == next) {
                end = next;
            } else {
                rangeCodeArr.add(new GradeRankValue(begin.intValue(), end.intValue()));
                begin = next;
                end = next;
            }
            if (i != size - 1) continue;
            rangeCodeArr.add(new GradeRankValue(begin.intValue(), end.intValue()));
        }
        return rangeCodeArr;
    }

    private static List<Integer> calGradeRankValue(Map<Long, List<Long>> gradeRankIdentityMap, Map<Long, SalaryGradeEntity> gradeMap, Map<Long, SalaryRankEntity> rankMap, int carryBit) {
        ArrayList<Integer> valueList = new ArrayList<Integer>(10);
        int rankIdxOfNotUseRank = 0;
        for (Map.Entry<Long, List<Long>> entry : gradeRankIdentityMap.entrySet()) {
            Long gradeId = entry.getKey();
            if (gradeMap == null || gradeMap.get(gradeId) == null) continue;
            Integer gradeIndex = gradeMap.get(gradeId).getGradeIndex() - 1;
            List<Long> rankIdList = entry.getValue();
            if (rankIdList.isEmpty()) {
                valueList.add(gradeIndex * carryBit + rankIdxOfNotUseRank);
                continue;
            }
            for (Long rankId : rankIdList) {
                if (rankMap.get(rankId) == null || rankMap.get(rankId).getRankIndex() < 0) continue;
                Integer rankIndex = rankMap.get(rankId).getRankIndex() - 1;
                valueList.add(gradeIndex * carryBit + rankIndex);
            }
        }
        return valueList;
    }

    public static String getRangeNameByRangeCode(GradeRankValue value, int carryBit, Map<Integer, String> gradeIndexNameMap, Map<Integer, String> rankIndexNameMap, boolean isUseRank) {
        return GradeRankHelper.doFormatRangeNameFromCode(value, carryBit, gradeIndexNameMap, rankIndexNameMap, isUseRank);
    }

    private static List<GradeRankValue> doSplitRangeCodeByGrade(GradeRankValue value, int carryBit) {
        int beginGradeIdx = value.getBeginValue() / carryBit;
        int endGradeIdx = value.getEndValue() / carryBit;
        int beginRankIdx = value.getBeginValue() % carryBit;
        int endRankIdx = value.getEndValue() % carryBit;
        ArrayList splitResult = Lists.newArrayListWithExpectedSize((int)(endGradeIdx - beginGradeIdx + 1));
        for (int i = beginGradeIdx; i <= endGradeIdx; ++i) {
            int tempStartRankIdx = 0;
            int tempEndRankIdx = carryBit - 1;
            if (i == beginGradeIdx) {
                tempStartRankIdx = beginRankIdx;
            }
            if (i == endGradeIdx) {
                tempEndRankIdx = endRankIdx;
            }
            splitResult.add(new GradeRankValue(i * carryBit + tempStartRankIdx, i * carryBit + tempEndRankIdx));
        }
        return splitResult;
    }

    public static List<GradeRankValue> splitRangeCodeByGrade(List<GradeRankValue> values, int carryBit) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)values.size());
        for (GradeRankValue value : values) {
            resultList.addAll(GradeRankHelper.doSplitRangeCodeByGrade(value, carryBit));
        }
        return resultList;
    }

    private static String doFormatRangeNameFromCode(GradeRankValue value, int carryBit, Map<Integer, String> gradeIndexNameMap, Map<Integer, String> rankIndexNameMap, boolean isUseRank) {
        String endStr;
        String beginStr;
        String endRankName;
        String beginRankName;
        String endGradeName;
        int beginValue = value.getBeginValue();
        int endValue = value.getEndValue();
        int gradeBeginIndex = beginValue / carryBit;
        int rankBeginIndex = beginValue % carryBit;
        int gradeEndIndex = endValue / carryBit;
        int rankEndIndex = endValue % carryBit;
        StringBuilder begin = new StringBuilder();
        StringBuilder end = new StringBuilder();
        String beginGradeName = gradeIndexNameMap.get(gradeBeginIndex + 1);
        if (SWCStringUtils.isNotEmpty((String)beginGradeName)) {
            begin.append(beginGradeName);
        }
        if (SWCStringUtils.isNotEmpty((String)(endGradeName = gradeIndexNameMap.get(gradeEndIndex + 1)))) {
            end.append(endGradeName);
        }
        if (SWCStringUtils.isNotEmpty((String)(beginRankName = rankIndexNameMap.get(rankBeginIndex + 1))) && isUseRank) {
            begin.append(beginRankName);
        }
        if (SWCStringUtils.isNotEmpty((String)(endRankName = rankIndexNameMap.get(rankEndIndex + 1))) && isUseRank) {
            end.append(endRankName);
        }
        if (StringUtils.equals((String)(beginStr = begin.toString()), (String)(endStr = end.toString()))) {
            return beginStr;
        }
        return String.format("%s~%s", beginStr, endStr);
    }

    public static String getRangeNamesByRangeCode(List<GradeRankValue> rangeCode, int carryBit, Map<Integer, String> gradeIndexNameMap, Map<Integer, String> rankIndexNameMap, boolean isUseRank) {
        StringBuilder sb = new StringBuilder();
        rangeCode = rangeCode.stream().sorted(Comparator.comparingInt(GradeRankValue::getBeginValue)).collect(Collectors.toList());
        for (GradeRankValue gradeRankValue : rangeCode) {
            String gradeRankStr = GradeRankHelper.getRangeNameByRangeCode(gradeRankValue, carryBit, gradeIndexNameMap, rankIndexNameMap, isUseRank);
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(gradeRankStr);
        }
        return sb.toString();
    }

    public static SalaryRankEntity getMinStandardRank(List<SalaryRankEntity> originalRankList) {
        List collect = originalRankList.stream().filter(o1 -> o1.getRankLabel() == SalaryRankLabelEnum.STANDARD).sorted(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return (SalaryRankEntity)collect.get(0);
    }

    public static SalaryRankEntity getMaxStandardRank(List<SalaryRankEntity> originalRankList) {
        List collect = originalRankList.stream().filter(o1 -> o1.getRankLabel() == SalaryRankLabelEnum.STANDARD).sorted(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        return (SalaryRankEntity)collect.get(collect.size() - 1);
    }

    public static List<SalaryRankEntity> fetchStandardRank(Collection<SalaryRankEntity> originalRankList) {
        return originalRankList.stream().filter(o1 -> SalaryRankLabelEnum.STANDARD.equals((Object)o1.getRankLabel())).collect(Collectors.toList());
    }

    public static List<SalaryRankEntity> fetchSpecialRank(Collection<SalaryRankEntity> originalRankList) {
        return originalRankList.stream().filter(o1 -> SalaryRankLabelEnum.SPECIAL.equals((Object)o1.getRankLabel())).collect(Collectors.toList());
    }

    public static List<SalaryRankEntity> fetchStandardAndSpecialRank(List<SalaryRankEntity> originalRankList, List<Long> specialIdentityList) {
        return originalRankList.stream().filter(o1 -> SalaryRankLabelEnum.STANDARD.equals((Object)o1.getRankLabel()) || specialIdentityList.contains(o1.getRankIdentity())).collect(Collectors.toList());
    }

    public static List<Long> loadSpRankIdentityByType(SalaryStandardTypeEnum type) {
        DynamicObject[] specialRankEntities = GradeRankHelper.getInstance().getSpecialRankWithExt(type, 2);
        return Arrays.stream(specialRankEntities).map(o1 -> o1.getLong("id")).collect(Collectors.toList());
    }

    public String loadSpRankNameByType(SalaryStandardTypeEnum type, Long identity) {
        DynamicObject[] specialRankEntities = this.getSpecialRankWithExt(type, 2);
        List collect = Arrays.stream(specialRankEntities).filter(o1 -> o1.getLong("id") == identity.longValue()).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        DynamicObject specialRankDy = (DynamicObject)collect.get(0);
        return specialRankDy == null ? "" : specialRankDy.getString("name");
    }

    public static List<SalaryRankEntity> fetchSpecialRankByIdentity(List<SalaryRankEntity> originalRankList, List<Long> identityList) {
        return originalRankList.stream().filter(o1 -> SalaryRankLabelEnum.SPECIAL.equals((Object)o1.getRankLabel()) && identityList.contains(o1.getRankIdentity())).collect(Collectors.toList());
    }

    public static boolean checkUserSetRank(List<SalaryRankEntity> rankEntities) {
        return rankEntities != null && !rankEntities.isEmpty() && (rankEntities.size() != 1 || rankEntities.get(0).getRankIsUserSet() > 0);
    }

    public static String getGradeRankGridPageId(String pageId) {
        return pageId + "hcdm_stdgraderankform";
    }

    public static SalaryGradeEntity getGradeByIndex(int index, List<SalaryGradeEntity> gradeList) {
        for (SalaryGradeEntity gradeEntity : gradeList) {
            if (gradeEntity.getGradeIndex() != index) continue;
            return gradeEntity;
        }
        return null;
    }

    public static List<SalaryRankEntity> getPresetRanks(SalaryStandardTypeEnum type) {
        if (type == SalaryStandardTypeEnum.SALARYCOUNT) {
            return GradeRankHelper.getPresetRankOfSalaryCount();
        }
        if (type == SalaryStandardTypeEnum.BROADBAND) {
            return GradeRankHelper.getPresetRankOfBroadBand();
        }
        return Collections.emptyList();
    }

    private static List<SalaryRankEntity> getPresetRankOfSalaryCount() {
        DynamicObject[] dynamicObjects;
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        long[] ids = EntityConverter.stdPkService.genEntPkByTime(1);
        SalaryRankEntity entity = new SalaryRankEntity();
        entity.setRankIdentity(Long.valueOf(ids[0]));
        entity.setRankIndex(1);
        entity.setRankLabel(SalaryRankLabelEnum.STANDARD);
        entity.setRankName("A");
        entity.setRankNumber("A");
        entity.setRankIsUserSet(0);
        entity.setRankIsSysPreSet(1);
        resultList.add(entity);
        for (DynamicObject dynamicObject : dynamicObjects = GradeRankHelper.getInstance().getSpecialRankWithExt(SalaryStandardTypeEnum.SALARYCOUNT, 2)) {
            SalaryRankEntity specialEntity = new SalaryRankEntity();
            int index = dynamicObject.getInt("index");
            String name = dynamicObject.getString("name");
            long id = dynamicObject.getLong("id");
            specialEntity.setRankIndex(index);
            specialEntity.setRankName(name);
            specialEntity.setRankNumber(name);
            specialEntity.setRankIsUserSet(0);
            specialEntity.setRankIsSysPreSet(1);
            specialEntity.setRankIdentity(Long.valueOf(id));
            specialEntity.setRankLabel(SalaryRankLabelEnum.SPECIAL);
            resultList.add(specialEntity);
        }
        return resultList;
    }

    private static List<SalaryRankEntity> getPresetRankOfBroadBand() {
        DynamicObject[] dynamicObjects;
        ArrayList<SalaryRankEntity> result = new ArrayList<SalaryRankEntity>(10);
        for (DynamicObject dynamicObject : dynamicObjects = GradeRankHelper.getInstance().getSpecialRankWithExt(SalaryStandardTypeEnum.BROADBAND, 2)) {
            SalaryRankEntity entity = new SalaryRankEntity();
            int index = dynamicObject.getInt("index");
            String name = dynamicObject.getString("name");
            long id = dynamicObject.getLong("id");
            entity.setRankIndex(index);
            entity.setRankName(name);
            entity.setRankNumber(name);
            entity.setRankIsUserSet(0);
            entity.setRankIsSysPreSet(1);
            entity.setRankIdentity(Long.valueOf(id));
            entity.setRankLabel(SalaryRankLabelEnum.SPECIAL);
            result.add(entity);
        }
        return result;
    }

    public static boolean checkRankMustInputByType(SalaryStandardTypeEnum type) {
        return SalaryStandardTypeEnum.BROADBAND == type;
    }

    public static List<SalaryRankEntity> getDefaultRankByCalMethod(List<SalaryRankEntity> ranks, CalculationMethodEnum calcMethod) {
        ArrayList specialIdentityList = Lists.newArrayList();
        boolean onlyReturnStandardRank = false;
        switch (calcMethod) {
            case GRADE_RANK: {
                onlyReturnStandardRank = true;
                break;
            }
            case MEDIAN_GEAR: {
                specialIdentityList.add(SalaryStandardConstants.S_RANK_MEDIANVALUE);
                specialIdentityList.add(SalaryStandardConstants.S_RANK_GEARDIFFERENCE);
                break;
            }
            case MEDIAN_WIDTH: {
                specialIdentityList.add(SalaryStandardConstants.S_RANK_MEDIANVALUE);
                specialIdentityList.add(SalaryStandardConstants.S_RANK_WIDTH);
                break;
            }
            default: {
                onlyReturnStandardRank = true;
            }
        }
        if (onlyReturnStandardRank) {
            return GradeRankHelper.fetchStandardAndSpecialRank(ranks, Collections.emptyList());
        }
        return GradeRankHelper.fetchStandardAndSpecialRank(ranks, specialIdentityList);
    }

    public static Set<Long> getRankIdSet(List<SalaryRankEntity> stdRanks) {
        return stdRanks.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
    }

    @Deprecated
    public static void mergeStructureOfGradeRank(List<ContrastDataEntity> source, List<ContrastDataEntity> target) {
    }

    public static GradeRankRangeDBEntity getRangeByGradeRankName(String beginGradeStr, String beginRankStr, String endGradeStr, String endRankStr, Map<String, SalaryGradeEntity> gradeEntityMap, Map<String, SalaryRankEntity> rankEntityMap, boolean isUseRank) {
        GradeRankRangeDBEntity dbEntity = new GradeRankRangeDBEntity();
        boolean gradeRankNotEmpty = GradeRankHelper.checkGradeRankNotEmpty(beginGradeStr, beginRankStr, endGradeStr, endRankStr, isUseRank);
        if (!gradeRankNotEmpty) {
            return dbEntity;
        }
        IntHolder errorCondition = new IntHolder(0);
        ArrayList<GradeRankValue> valueList = new ArrayList<GradeRankValue>(10);
        List<SalaryRankEntity> stdRanks = GradeRankHelper.fetchStandardRank(new ArrayList<SalaryRankEntity>(rankEntityMap.values()));
        int carryBit = stdRanks.size();
        char sep = '#';
        String gradeRankBeginStr = isUseRank ? beginGradeStr + sep + beginRankStr : beginGradeStr;
        String gradeRankEndStr = isUseRank ? endGradeStr + sep + endRankStr : endGradeStr;
        IntHolder gradeIdx = new IntHolder(-1);
        IntHolder rankIdx = new IntHolder(-1);
        GradeRankHelper.parseOneGradeRankIdx(gradeEntityMap, rankEntityMap, isUseRank, errorCondition, gradeRankBeginStr, gradeIdx, rankIdx, sep);
        if (errorCondition.value > 0) {
            return dbEntity;
        }
        int beginValue = gradeIdx.value * carryBit + rankIdx.value;
        rankIdx.value = 0;
        gradeIdx.value = 0;
        GradeRankHelper.parseOneGradeRankIdx(gradeEntityMap, rankEntityMap, isUseRank, errorCondition, gradeRankEndStr, gradeIdx, rankIdx, sep);
        if (errorCondition.value > 0) {
            return dbEntity;
        }
        int endValue = gradeIdx.value * carryBit + rankIdx.value;
        valueList.add(new GradeRankValue(beginValue, endValue));
        dbEntity.setRangeCodeArr(valueList);
        dbEntity.setRankNum(Integer.valueOf(stdRanks.size()));
        dbEntity.setGradeNum(Integer.valueOf(gradeEntityMap.size()));
        return dbEntity;
    }

    public static boolean checkGradeRankNotEmpty(String beginGradeStr, String beginRankStr, String endGradeStr, String endRankStr, boolean useSalaryRank) {
        if (useSalaryRank) {
            return StringUtils.isNotEmpty((String)beginGradeStr) && StringUtils.isNotEmpty((String)beginRankStr) && StringUtils.isNotEmpty((String)endGradeStr) && StringUtils.isNotEmpty((String)endRankStr);
        }
        return StringUtils.isNotEmpty((String)beginGradeStr) && StringUtils.isNotEmpty((String)endGradeStr);
    }

    private static void parseOneGradeRankIdx(Map<String, SalaryGradeEntity> gradeEntityMap, Map<String, SalaryRankEntity> rankEntityMap, boolean isUseRank, IntHolder errorCondition, String gradeRankStr, IntHolder gradeIdx, IntHolder rankIdx, char sep) {
        SalaryGradeEntity beginGradeEntity = null;
        SalaryRankEntity beginRankEntity = null;
        if (!isUseRank) {
            beginGradeEntity = gradeEntityMap.get(gradeRankStr);
        } else {
            String[] split = gradeRankStr.split(String.valueOf(sep));
            String gradeStr = split[0];
            String rankStr = split[1];
            beginGradeEntity = gradeEntityMap.get(gradeStr);
            beginRankEntity = rankEntityMap.get(rankStr);
        }
        if (beginGradeEntity == null) {
            errorCondition.value |= 1;
        } else {
            gradeIdx.value = beginGradeEntity.getGradeIndex() - 1;
        }
        if (isUseRank) {
            if (beginRankEntity == null) {
                errorCondition.value |= 2;
            } else {
                rankIdx.value = beginRankEntity.getRankIndex() - 1;
            }
        } else {
            rankIdx.value = 0;
        }
    }

    public static List<GradeRankValue> getRangeCodeByRangeKeys(List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<GradeRankKey> gradeRankKeys) {
        Map<Long, List<Long>> gradeRankIdentityMap = GradeRankHelper.getIdentityMapFromRangeKeys(gradeRankKeys);
        return GradeRankHelper.getRangeCodeByIdentityMap(gradeEntities, rankEntities, gradeRankIdentityMap);
    }

    public static List<GradeRankValue> getRangeCodeByIdentityMap(List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, Map<Long, List<Long>> gradeRankIdentityMap) {
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeEntities);
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(standardRanks);
        int carryBit = standardRanks.size();
        List<Integer> valueList = GradeRankHelper.calGradeRankValue(gradeRankIdentityMap, gradeEntityMap, rankEntityMap, carryBit);
        return GradeRankHelper.makeGradeRankValue(valueList);
    }

    public static List<GradeRankValue> getRangeCodeByMap(List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, Map<Long, List<Long>> gradeRankIdentityMap) {
        Map gradeEntityMap = gradeEntities.stream().collect(Collectors.toMap(SalaryGradeEntity::getId, Function.identity(), (p1, p2) -> p2));
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        Map rankEntityMap = rankEntities.stream().collect(Collectors.toMap(SalaryRankEntity::getId, Function.identity(), (p1, p2) -> p2));
        int carryBit = standardRanks.size();
        ArrayList<Integer> valueList = new ArrayList<Integer>(10);
        int rankIdxOfNotUseRank = 0;
        for (Map.Entry<Long, List<Long>> entry : gradeRankIdentityMap.entrySet()) {
            Long gradeId = entry.getKey();
            if (gradeEntityMap == null || gradeEntityMap.get(gradeId) == null) continue;
            Integer gradeIndex = ((SalaryGradeEntity)gradeEntityMap.get(gradeId)).getGradeIndex() - 1;
            List<Long> rankIdList = entry.getValue();
            if (rankIdList.isEmpty()) {
                valueList.add(gradeIndex * carryBit + rankIdxOfNotUseRank);
                continue;
            }
            for (Long rankId : rankIdList) {
                if (rankEntityMap.get(rankId) == null || ((SalaryRankEntity)rankEntityMap.get(rankId)).getRankIndex() < 0) continue;
                Integer rankIndex = ((SalaryRankEntity)rankEntityMap.get(rankId)).getRankIndex() - 1;
                valueList.add(gradeIndex * carryBit + rankIndex);
            }
        }
        return GradeRankHelper.makeGradeRankValue(valueList);
    }

    public static Map<Long, List<SalaryGradeEntity>> queryGradeEntities(Set<Long> stdVids) {
        if (CollectionUtils.isEmpty(stdVids)) {
            return Collections.emptyMap();
        }
        String gradeEntSql = "select FEntryID,fid,fgradeidentity,fgradename,fgradeindex from t_hcdm_salarygrade where fid in " + HCDMDbHelper.getFidHolder(stdVids.size());
        DataSet gradeEntDataSet = HCDMDbHelper.queryDataSet(gradeEntSql, stdVids.toArray());
        HashMap map = Maps.newHashMap();
        while (gradeEntDataSet.hasNext()) {
            Row next = gradeEntDataSet.next();
            Long stdVid = next.getLong("fid");
            Long id = next.getLong("fentryid");
            SalaryGradeEntity gradeEntity = new SalaryGradeEntity(stdVid, next.getLong("fgradeidentity"), next.getInteger("fgradeindex").intValue(), next.getString("fgradename"));
            gradeEntity.setId(id);
            List list = map.computeIfAbsent(stdVid, value -> Lists.newArrayList());
            list.add(gradeEntity);
        }
        gradeEntDataSet.close();
        return map;
    }

    public static Map<Long, List<SalaryRankEntity>> querySalaryRankEntities(Set<Long> stdVids, boolean onlyStandard) {
        if (CollectionUtils.isEmpty(stdVids)) {
            return Collections.emptyMap();
        }
        String rankEntSql = "select FEntryID,fid,frankidentity,frankname,frankindex,franklabel,frankisuserset from t_hcdm_salaryrank where fid in " + HCDMDbHelper.getFidHolder(stdVids.size());
        DataSet rankEntDataSet = HCDMDbHelper.queryDataSet(rankEntSql, stdVids.toArray());
        HashMap map = Maps.newHashMap();
        while (rankEntDataSet.hasNext()) {
            Row next = rankEntDataSet.next();
            Long stdVid = next.getLong("fid");
            SalaryRankEntity rankEntity = new SalaryRankEntity(stdVid, next.getLong("frankidentity"), next.getInteger("frankindex").intValue(), next.getString("frankname"), SalaryRankLabelEnum.valueOf((String)next.getString("franklabel")), next.getInteger("frankisuserset").intValue(), 0);
            rankEntity.setId(next.getLong("FEntryID"));
            List list = map.computeIfAbsent(stdVid, value -> Lists.newArrayList());
            if (onlyStandard) {
                if (rankEntity.getRankLabel() != SalaryRankLabelEnum.STANDARD) continue;
                list.add(rankEntity);
                continue;
            }
            list.add(rankEntity);
        }
        rankEntDataSet.close();
        return map;
    }

    public static Map<Long, Map<Long, SalaryGradeEntity>> queryGradeEntityMap(Set<Long> stdVids) {
        Map<Long, List<SalaryGradeEntity>> gradeEntities = GradeRankHelper.queryGradeEntities(stdVids);
        HashMap gradeIdentityMap = Maps.newHashMapWithExpectedSize((int)stdVids.size());
        gradeEntities.forEach((key, value) -> gradeIdentityMap.put(key, GradeRankHelper.groupByGradeIdentity(value)));
        return gradeIdentityMap;
    }

    public static Map<Long, Map<Long, SalaryRankEntity>> queryRankEntityMap(Set<Long> stdVids, boolean onlyStandard) {
        Map<Long, List<SalaryRankEntity>> rankEntities = GradeRankHelper.querySalaryRankEntities(stdVids, onlyStandard);
        HashMap rankIdentityMap = Maps.newHashMapWithExpectedSize((int)stdVids.size());
        rankEntities.forEach((key, value) -> rankIdentityMap.put(key, GradeRankHelper.groupByRankIdentity(value)));
        return rankIdentityMap;
    }

    @Deprecated
    public static Map<Long, SalaryRankEntity> queryRankData(Long salaryStandardId, String ranklabel, String rankIsUserset, Long rankIdentity) {
        return null;
    }

    public static Map<Long, SalaryGradeEntity> groupByGradeId(List<SalaryGradeEntity> gradeEntities) {
        return gradeEntities.stream().collect(Collectors.toMap(SalaryGradeEntity::getId, Function.identity(), (o1, o2) -> o2));
    }

    public static Map<Long, SalaryRankEntity> groupByRankId(List<SalaryRankEntity> rankEntities) {
        return rankEntities.stream().collect(Collectors.toMap(SalaryRankEntity::getId, Function.identity(), (o1, o2) -> o2));
    }

    public static DynamicObject[] queryAllSpecialRank() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return new SWCDataServiceHelper("hcdm_specialrank").query("id,number,name,index", new QFilter[]{filter});
    }

    public static DynamicObject[] getDefaultSpecialRank(DynamicObject[] originalSpecialRank, SalaryStandardTypeEnum type, int useScene) {
        DynamicObject[] result = originalSpecialRank;
        if (type.equals((Object)SalaryStandardTypeEnum.SALARYCOUNT)) {
            return new DynamicObject[0];
        }
        if (type.equals((Object)SalaryStandardTypeEnum.BROADBAND)) {
            if (useScene == 2) {
                for (DynamicObject object2 : result) {
                    long id = object2.getLong("id");
                    if (id != SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT && id != SalaryStandardConstants.S_RANK_WIDTH && id != SalaryStandardConstants.S_RANK_OVERLAP && id != SalaryStandardConstants.S_RANK_ISOMETRIC) continue;
                    object2.set("name", (Object)new LocaleString(object2.getString("name") + "(%)"));
                }
                return result;
            }
            if (useScene == 1) {
                result = Arrays.stream(result).filter(object -> object.getLong("id") != SalaryStandardConstants.S_RANK_MEDIANVALUE.longValue()).collect(Collectors.toList()).toArray(new DynamicObject[0]);
                return result;
            }
        }
        return result;
    }

    public DynamicObject[] getSpecialRankWithExt(SalaryStandardTypeEnum type, int useScene) {
        type = type == null ? SalaryStandardTypeEnum.SALARYCOUNT : type;
        DynamicObject[] result = null;
        String cacheKey = String.format("%s_%d", type.name(), useScene);
        if (this.specialRankCache == null) {
            this.specialRankCache = Maps.newHashMapWithExpectedSize((int)16);
        }
        if (MapUtils.isNotEmpty(this.specialRankCache)) {
            result = this.specialRankCache.get(cacheKey);
        }
        if (result == null) {
            OnGetSpecialRankEvent evt = new OnGetSpecialRankEvent((Object)type);
            evt.setType(type);
            evt.setUseScene(useScene);
            evt.setOriginalSpecialRankList(GradeRankHelper.queryAllSpecialRank());
            this.proxyOfSpecialRank.callAfter(plugin -> {
                plugin.onGetSpecialRankList(evt);
                return null;
            });
            result = evt.getSpecialRankList();
            if (result == null) {
                result = new DynamicObject[]{};
            }
            this.specialRankCache.put(cacheKey, result);
        }
        return result;
    }

    public static Map<Long, List<Long>> groupByRangeKeyToIdentityMap(List<GradeRankKey> rangeData) {
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        if (rangeData == null) {
            return resultMap;
        }
        for (GradeRankKey datum : rangeData) {
            List rankIds = resultMap.computeIfAbsent(datum.getGradeEntity().getGradeIdentity(), o1 -> Lists.newArrayList());
            rankIds.add(datum.getRankEntity().getRankIdentity());
        }
        return resultMap;
    }

    public static Map<Long, List<Long>> groupByRangeKeyToIdMap(List<GradeRankKey> rangeData) {
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        if (rangeData == null) {
            return resultMap;
        }
        for (GradeRankKey datum : rangeData) {
            List rankIds = resultMap.computeIfAbsent(datum.getGradeEntity().getId(), o1 -> Lists.newArrayList());
            rankIds.add(datum.getRankEntity().getId());
        }
        return resultMap;
    }

    public static Map<Long, Map<Long, SalaryGradeEntity>> queryGradeData(Set<Long> stdIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        Map<Long, List<SalaryGradeEntity>> gradeEntities = GradeRankHelper.queryGradeEntities(stdIds);
        for (Map.Entry<Long, List<SalaryGradeEntity>> entry : gradeEntities.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.toMap(SalaryGradeEntity::getGradeIdentity, Function.identity(), (o1, o2) -> o2)));
        }
        return resultMap;
    }

    public static Map<Long, Map<Long, SalaryRankEntity>> queryRankData(Set<Long> stdIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdIds.size());
        Map<Long, List<SalaryRankEntity>> rankEntities = GradeRankHelper.querySalaryRankEntities(stdIds, true);
        for (Map.Entry<Long, List<SalaryRankEntity>> entry : rankEntities.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.toMap(SalaryRankEntity::getRankIdentity, Function.identity(), (o1, o2) -> o2)));
        }
        return resultMap;
    }

    public static Map<Long, Integer> groupGradeIdToIndex(List<SalaryGradeEntity> gradeEntities, boolean withIdentity) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        for (int index = 0; index < gradeEntities.size(); ++index) {
            SalaryGradeEntity entity = gradeEntities.get(index);
            long id = withIdentity ? entity.getGradeIdentity() : entity.getId();
            resultMap.put(id, index);
        }
        return resultMap;
    }

    public static Map<Long, Integer> groupRankIdToIndex(List<SalaryRankEntity> rankEntities, boolean withIdentity) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)rankEntities.size());
        for (int index = 0; index < rankEntities.size(); ++index) {
            SalaryRankEntity entity = rankEntities.get(index);
            long id = withIdentity ? entity.getRankIdentity() : entity.getId();
            resultMap.put(id, index);
        }
        return resultMap;
    }

    public static List<Pair<GradeRankKey, GradeRankKey>> splitToMultiInterval(Map<Long, List<Long>> personRange, Map<Long, SalaryGradeEntity> gradeIdToEntityMap, Map<Long, SalaryRankEntity> rankIdToEntityMap, Map<Long, Integer> gradeIdToIndexMap, Map<Long, Integer> rankIdToIndexMap, SalaryRankEntity systemSetRank) {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        int gradeSize = gradeIdToEntityMap.size();
        int rankSize = rankIdToEntityMap.size();
        int minNum = 0;
        int maxNum = gradeSize * rankSize - 1;
        HashMap rangeExistFlagWithPosNum = Maps.newHashMapWithExpectedSize((int)maxNum);
        for (Map.Entry<Long, List<Long>> entry : personRange.entrySet()) {
            Long gradeId = entry.getKey();
            Integer gradeIndex = gradeIdToIndexMap.get(gradeId);
            List<Long> rankIds = entry.getValue();
            if (CollectionUtils.isEmpty(rankIds)) {
                rankIds = Collections.singletonList(systemSetRank.getId());
            }
            for (Long l : rankIds) {
                Integer rankIndex = rankIdToIndexMap.get(l);
                int positionNum = gradeIndex * rankSize + rankIndex;
                rangeExistFlagWithPosNum.put(positionNum, Boolean.TRUE);
            }
        }
        int beginPosNum = -1;
        int endPosNum = -1;
        ArrayList usedPositions = Lists.newArrayList();
        for (int num = minNum; num <= maxNum; ++num) {
            Boolean isUse = rangeExistFlagWithPosNum.getOrDefault(num, Boolean.FALSE);
            if (!isUse.booleanValue()) continue;
            if (beginPosNum < 0) {
                beginPosNum = num;
                endPosNum = num;
            }
            if (num == maxNum) {
                endPosNum = num;
                usedPositions.add(new Pair((Object)beginPosNum, (Object)endPosNum));
                beginPosNum = -1;
                endPosNum = -1;
                continue;
            }
            Boolean nextIsUse = rangeExistFlagWithPosNum.getOrDefault(num + 1, Boolean.FALSE);
            if (nextIsUse.booleanValue()) continue;
            endPosNum = num;
            usedPositions.add(new Pair((Object)beginPosNum, (Object)endPosNum));
            beginPosNum = -1;
            endPosNum = -1;
        }
        HashMap indexToGradeIdMap = Maps.newHashMapWithExpectedSize((int)gradeIdToIndexMap.size());
        HashMap indexToRankIdMap = Maps.newHashMapWithExpectedSize((int)rankIdToIndexMap.size());
        for (Map.Entry entry : gradeIdToIndexMap.entrySet()) {
            indexToGradeIdMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : rankIdToIndexMap.entrySet()) {
            indexToRankIdMap.put(entry.getValue(), entry.getKey());
        }
        for (Pair pair : usedPositions) {
            Integer startPos = (Integer)pair.getKey();
            Integer endPos = (Integer)pair.getValue();
            int startGradeIndex = startPos / rankSize;
            int startRankIndex = startPos % rankSize;
            int endGradeIndex = endPos / rankSize;
            int endRankIndex = endPos % rankSize;
            GradeRankKey begin = new GradeRankKey(gradeIdToEntityMap.get(indexToGradeIdMap.get(startGradeIndex)), rankIdToEntityMap.get(indexToRankIdMap.get(startRankIndex)));
            GradeRankKey end = new GradeRankKey(gradeIdToEntityMap.get(indexToGradeIdMap.get(endGradeIndex)), rankIdToEntityMap.get(indexToRankIdMap.get(endRankIndex)));
            resultList.add(new Pair((Object)begin, (Object)end));
        }
        return resultList;
    }

    public static List<GradeRankValue> getRangeCodeByGradeIdx(List<GradeRankValue> rangeCodeArr, Integer rankNum, int gradeIndex) {
        GradeRankValue gradeFullRange = new GradeRankValue((gradeIndex - 1) * rankNum, gradeIndex * rankNum - 1);
        return GradeRankHelper.intersectRangeByCode(rangeCodeArr, Lists.newArrayList((Object[])new GradeRankValue[]{gradeFullRange}));
    }

    public static boolean checkRangeContainsByCode(List<GradeRankValue> sourceRangeCode, List<GradeRankValue> targetRangeCode) {
        int removeCount = 0;
        block0: for (GradeRankValue targetRange : targetRangeCode) {
            for (GradeRankValue sourceRange : sourceRangeCode) {
                if (sourceRange.getBeginValue() > targetRange.getBeginValue() || sourceRange.getEndValue() < targetRange.getEndValue()) continue;
                ++removeCount;
                continue block0;
            }
        }
        return removeCount == targetRangeCode.size();
    }

    public static List<GradeRankValue> unionRangeByCode(List<GradeRankValue> sourceRangeCode, List<GradeRankValue> targetRangeCode) {
        ArrayList<GradeRankValue> allRangeCode = GradeRankHelper.collectRangeCode(sourceRangeCode, targetRangeCode);
        return GradeRankHelper.unionRangeByCode(allRangeCode);
    }

    public static List<GradeRankValue> intersectRangeByCode(List<GradeRankValue> rangeCode, List<GradeRankValue> targetRangeCode) {
        rangeCode.sort(Comparator.comparingInt(GradeRankValue::getBeginValue).thenComparingInt(GradeRankValue::getEndValue));
        targetRangeCode.sort(Comparator.comparingInt(GradeRankValue::getBeginValue).thenComparingInt(GradeRankValue::getEndValue));
        ArrayList intersectRange = Lists.newArrayListWithExpectedSize((int)rangeCode.size());
        for (GradeRankValue sourceCode : rangeCode) {
            int sourceBegin = sourceCode.getBeginValue();
            int sourceEnd = sourceCode.getEndValue();
            for (GradeRankValue targetCode : targetRangeCode) {
                int targetBegin = targetCode.getBeginValue();
                int targetEnd = targetCode.getEndValue();
                if (targetBegin > sourceEnd || targetEnd < sourceBegin) continue;
                int begin = Math.max(targetBegin, sourceBegin);
                int end = Math.min(targetEnd, sourceEnd);
                intersectRange.add(new GradeRankValue(begin, end));
            }
        }
        return intersectRange;
    }

    public static List<GradeRankValue> unionRangeByCode(List<GradeRankValue> allRangeCode) {
        allRangeCode.sort(Comparator.comparingInt(GradeRankValue::getBeginValue).thenComparingInt(GradeRankValue::getEndValue));
        if (allRangeCode.size() <= 1) {
            return allRangeCode;
        }
        int curIndex = 0;
        int afterIndex = 1;
        ArrayList removeSet = Lists.newArrayListWithExpectedSize((int)allRangeCode.size());
        while (afterIndex < allRangeCode.size()) {
            GradeRankValue intervalBefore = allRangeCode.get(curIndex);
            GradeRankValue intervalAfter = allRangeCode.get(afterIndex);
            if (removeSet.contains(intervalBefore)) {
                ++curIndex;
                ++afterIndex;
                continue;
            }
            if (intervalAfter.getBeginValue() - 1 <= intervalBefore.getEndValue()) {
                if (intervalAfter.getEndValue() > intervalBefore.getEndValue()) {
                    intervalBefore.setEndValue(intervalAfter.getEndValue());
                }
                removeSet.add(intervalAfter);
                ++afterIndex;
                continue;
            }
            ++curIndex;
            ++afterIndex;
        }
        return allRangeCode.stream().filter(o1 -> !removeSet.contains(o1)).collect(Collectors.toList());
    }

    public static List<GradeRankValue> resetRangeCodeWithNewCarryBit(List<GradeRankValue> oldRangeCode, int oldCarryBit, int newCarryBit, int newGradeNum) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)oldRangeCode.size());
        int maxRangeVal = newGradeNum * newCarryBit - 1;
        for (GradeRankValue gradeRankValue : oldRangeCode) {
            int beginValue = gradeRankValue.getBeginValue();
            int endValue = gradeRankValue.getEndValue();
            if (beginValue > maxRangeVal) continue;
            int newBeginValue = GradeRankHelper.calcResetRangeVal(oldCarryBit, newCarryBit, beginValue, newGradeNum);
            int newEndValue = GradeRankHelper.calcResetRangeVal(oldCarryBit, newCarryBit, endValue, newGradeNum);
            result.add(new GradeRankValue(newBeginValue, newEndValue));
        }
        return result;
    }

    private static int calcResetRangeVal(int oldCarryBit, int newCarryBit, int val, int newGradeNum) {
        int gradeIndex = val / oldCarryBit;
        int rankIndex = val % oldCarryBit;
        if (rankIndex >= newCarryBit) {
            rankIndex = newCarryBit - 1;
        }
        if (gradeIndex >= newGradeNum) {
            gradeIndex = newGradeNum - 1;
        }
        return gradeIndex * newCarryBit + rankIndex;
    }

    private static ArrayList<GradeRankValue> collectRangeCode(List<GradeRankValue> sourceRangeCode, List<GradeRankValue> targetRangeCode) {
        ArrayList allRangeCode = Lists.newArrayListWithExpectedSize((int)(sourceRangeCode.size() + targetRangeCode.size()));
        allRangeCode.addAll(sourceRangeCode);
        allRangeCode.addAll(targetRangeCode);
        return allRangeCode;
    }
}

