/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetIntervalPropEvent;
import kd.sdk.swc.hcdm.common.stdtab.IntervalPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.salarystandard.IntervalPropOperationKeyMapping;
import kd.swc.hcdm.common.enums.IntervalPropOperationKey;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;

public class IntervalPropOperationFunction {
    private static final Log logger;
    private static Map<String, Method> functionMap;
    private HRPluginProxy<IStdTableExtPlugin> proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetIntervalProp", null);

    public static IntervalPropOperationFunction getInstance() {
        return new IntervalPropOperationFunction();
    }

    public static List<IntervalPropEntity> returnEmpty(List<IntervalPropEntity> originalPropList) {
        return Collections.emptyList();
    }

    public static List<IntervalPropEntity> referenceAll(List<IntervalPropEntity> originalPropList) {
        return originalPropList;
    }

    public static List<IntervalPropEntity> createSalaryCountToNewList(List<IntervalPropEntity> originalPropList) {
        IntervalPropEntity salaryCount = new IntervalPropEntity(Long.valueOf(0L), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getI18nName().loadKDString(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getI18nName().loadKDString(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode());
        ArrayList<IntervalPropEntity> result = new ArrayList<IntervalPropEntity>();
        result.add(salaryCount);
        return result;
    }

    public static List<IntervalPropEntity> createSmallestToNewList(List<IntervalPropEntity> originalPropList) {
        IntervalPropEntity min = new IntervalPropEntity(Long.valueOf(0L), SalaryStdGridFieldSeqEnum.MIN_SEQ.getI18nName().loadKDString(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getI18nName().loadKDString(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode());
        ArrayList<IntervalPropEntity> result = new ArrayList<IntervalPropEntity>();
        result.add(min);
        return result;
    }

    public static List<IntervalPropEntity> createSalaryCountAndSmallestToNewList(List<IntervalPropEntity> originalPropList) {
        List<IntervalPropEntity> result = IntervalPropOperationFunction.createSalaryCountToNewList(originalPropList);
        IntervalPropEntity min = IntervalPropOperationFunction.createSmallestToNewList(originalPropList).get(0);
        min.setNeedLock(1);
        min.setIntervalPropDisplayName(ResManager.loadKDString((String)"\u503c", (String)"IntervalPropOperationFunction_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        result.add(min);
        return result;
    }

    public static List<IntervalPropEntity> invokeFunction(List<IntervalPropEntity> originalPropList, IntervalPropOperationKey operationKey) {
        if (operationKey == null) {
            return Collections.emptyList();
        }
        String functionName = operationKey.getName();
        Method method = functionMap.get(functionName);
        try {
            return (List)method.invoke(IntervalPropOperationFunction.class, originalPropList);
        }
        catch (Exception e) {
            logger.error("{} get instance error,message is {}", (Object)IntervalPropOperationFunction.class.getName(), (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<IntervalPropEntity> getIntervalPropWithExtForStdRank(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity item, int displayOnlySalaryCount, List<IntervalPropEntity> intervalPropEntities) {
        List propEntities = null;
        OnGetIntervalPropEvent evt = new OnGetIntervalPropEvent((Object)baseEntity);
        evt.setStdBaseEntity(baseEntity);
        evt.setItemEntity(item);
        evt.setDisplayOnlySalaryCount(displayOnlySalaryCount);
        evt.setOriginalIntervalPropList(intervalPropEntities);
        this.proxy.callAfter(plugin -> {
            plugin.onGetIntervalProp(evt);
            return null;
        });
        if (evt.getIntervalPropList() != null) {
            propEntities = evt.getIntervalPropList();
        }
        return propEntities;
    }

    public List<IntervalPropEntity> getIntervalPropWithExtForSpecialRank(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity item, SalaryRankEntity rankEntity, int displayOnlySalaryCount, List<IntervalPropEntity> intervalPropEntities) {
        List propEntities = null;
        OnGetIntervalPropEvent evt = new OnGetIntervalPropEvent((Object)baseEntity);
        evt.setStdBaseEntity(baseEntity);
        evt.setItemEntity(item);
        if (rankEntity.getRankLabel() == SalaryRankLabelEnum.SPECIAL) {
            // empty if block
        }
        evt.setDisplayOnlySalaryCount(displayOnlySalaryCount);
        evt.setOriginalIntervalPropList(intervalPropEntities);
        this.proxy.callAfter(plugin -> {
            plugin.onGetIntervalProp(evt);
            return null;
        });
        if (evt.getIntervalPropList() != null) {
            propEntities = evt.getIntervalPropList();
        }
        return propEntities;
    }

    public static List<IntervalPropEntity> getDefaultIntervalPropEntities(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity item, int displayOnlySalaryCount, List<IntervalPropEntity> intervalPropEntities) {
        IntervalPropOperationKey operationKey = IntervalPropOperationKeyMapping.getOperationKey(baseEntity, item, displayOnlySalaryCount);
        return IntervalPropOperationFunction.invokeFunction(intervalPropEntities, operationKey);
    }

    static {
        Method[] functions;
        logger = LogFactory.getLog(IntervalPropOperationFunction.class);
        functionMap = new HashMap<String, Method>(8);
        for (Method function : functions = IntervalPropOperationFunction.class.getDeclaredMethods()) {
            functionMap.put(function.getName(), function);
        }
    }
}

