/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.IntervalPropOperationKey;

public class IntervalPropOperationKeyMapping {
    private static Map<String, IntervalPropOperationKey> stdItemMap = new HashMap<String, IntervalPropOperationKey>(16);
    private static Map<String, IntervalPropOperationKey> spItemMap = new HashMap<String, IntervalPropOperationKey>(16);
    private static Map<String, IntervalPropOperationKey> defaultSpItemMapByType = new HashMap<String, IntervalPropOperationKey>(16);
    private static final String var_three_tpl = "%s-%d-%d";
    private static final String var_three_tpl2 = "%s-%s-%d";
    private static final String var_four_tpl = "%s-%d-%d-%d";

    public static IntervalPropOperationKey getOperationKey(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity itemEntity, int displayOnlySalaryCount) {
        SalaryItemLabelEnum itemLabel = itemEntity.getItemLabel();
        IntervalPropOperationKey operationKey = null;
        if (itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD)) {
            operationKey = stdItemMap.get(String.format(var_three_tpl, baseEntity.getType().getCode(), itemEntity.getItemIsUseSalaryCount(), displayOnlySalaryCount));
        } else {
            VarPredictItemType varPredictItemType;
            operationKey = spItemMap.get(String.format(var_four_tpl, baseEntity.getType().getCode(), itemEntity.getItemIdentity(), itemEntity.getItemIsUseSalaryCount(), displayOnlySalaryCount));
            if (operationKey == null && (varPredictItemType = SalaryStdItemHelper.getVarPredictItemTypeById(itemEntity.getItemIdentity())) != null) {
                operationKey = defaultSpItemMapByType.get(String.format(var_three_tpl2, baseEntity.getType().getCode(), varPredictItemType.getCode(), displayOnlySalaryCount));
            }
        }
        if (operationKey == null) {
            operationKey = IntervalPropOperationKey.CREATESMALLESTTONEWLIST;
        }
        return operationKey;
    }

    static {
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 0, 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 0, 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 1, 1), IntervalPropOperationKey.CREATESALARYCOUNTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 1, 2), IntervalPropOperationKey.CREATESALARYCOUNTANDSMALLESTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 1, -1), IntervalPropOperationKey.CREATESALARYCOUNTANDSMALLESTTONEWLIST);
        stdItemMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0, 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0, 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1, 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1, 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0, 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0, 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1, 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1, 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        spItemMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0, -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 2), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.BROADBAND.getCode(), VarPredictItemType.predict.getCode(), -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
        defaultSpItemMapByType.put(String.format(var_three_tpl2, SalaryStandardTypeEnum.BROADBAND.getCode(), VarPredictItemType.predict.getCode(), -1), IntervalPropOperationKey.CREATESMALLESTTONEWLIST);
    }
}

