/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryRankExtLabelEnum;
import kd.swc.hcdm.common.enums.SalaryRankOperationKey;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

public class SalaryRankOperationFunction {
    private static final Log logger;
    private static Map<String, Method> functionMap;

    public static List<SalaryRankEntity> referenceAll(List<SalaryRankEntity> originalRankList) {
        return originalRankList;
    }

    public static List<SalaryRankEntity> putSmallestToNewList(List<SalaryRankEntity> originalRankList) {
        if (originalRankList.isEmpty()) {
            return originalRankList;
        }
        ArrayList<SalaryRankEntity> tempRankList = new ArrayList<SalaryRankEntity>(1);
        tempRankList.add(GradeRankHelper.getMinStandardRank(originalRankList));
        return tempRankList;
    }

    public static List<SalaryRankEntity> copySmallestToNewList(List<SalaryRankEntity> originalRankList) {
        if (originalRankList.isEmpty()) {
            return originalRankList;
        }
        ArrayList<SalaryRankEntity> tempRankList = new ArrayList<SalaryRankEntity>(1);
        SalaryRankEntity minStandardRank = GradeRankHelper.getMinStandardRank(originalRankList);
        try {
            if (minStandardRank != null) {
                SalaryRankEntity dest = (SalaryRankEntity)BeanUtils.cloneBean((Object)minStandardRank);
                tempRankList.add(dest);
            }
        }
        catch (Exception e) {
            logger.error("bean clone error");
        }
        return tempRankList;
    }

    public static List<SalaryRankEntity> copySmallestMiddleAndLargestToNewList(List<SalaryRankEntity> originalRankList) {
        if (originalRankList.isEmpty()) {
            return originalRankList;
        }
        List<SalaryRankEntity> specialRankEntities = GradeRankHelper.fetchSpecialRankByIdentity(originalRankList, Collections.singletonList(SalaryStandardConstants.S_RANK_MEDIANVALUE));
        if (CollectionUtils.isEmpty(specialRankEntities)) {
            return Collections.emptyList();
        }
        ArrayList<SalaryRankEntity> tempRankList = new ArrayList<SalaryRankEntity>(3);
        SalaryRankEntity originalMinRank = GradeRankHelper.getMinStandardRank(originalRankList);
        SalaryRankEntity originalMaxRank = GradeRankHelper.getMaxStandardRank(originalRankList);
        SalaryRankEntity originalMedianValueRank = specialRankEntities.get(0);
        try {
            SalaryRankEntity minRank = (SalaryRankEntity)BeanUtils.cloneBean((Object)originalMinRank);
            SalaryRankEntity maxRank = (SalaryRankEntity)BeanUtils.cloneBean((Object)originalMaxRank);
            SalaryRankEntity medianValueRank = (SalaryRankEntity)BeanUtils.cloneBean((Object)originalMedianValueRank);
            minRank.setRankName(SalaryRankExtLabelEnum.MIN.getI18nName().loadKDString());
            maxRank.setRankName(SalaryRankExtLabelEnum.MAX.getI18nName().loadKDString());
            tempRankList.add(minRank);
            tempRankList.add(medianValueRank);
            tempRankList.add(maxRank);
        }
        catch (Exception e) {
            logger.error("bean clone error");
        }
        return tempRankList;
    }

    public static List<SalaryRankEntity> copySmallestAndResetFlagToNewList(List<SalaryRankEntity> originalRankList) {
        List<SalaryRankEntity> entities = SalaryRankOperationFunction.copySmallestToNewList(originalRankList);
        if (!entities.isEmpty()) {
            entities.get(0).setRankIsUserSet(0);
        }
        return entities;
    }

    public static List<SalaryRankEntity> copyStandardAndMiddleToNewList(List<SalaryRankEntity> originalRankList) {
        if (originalRankList.isEmpty()) {
            return originalRankList;
        }
        List<SalaryRankEntity> targetRanks = GradeRankHelper.fetchStandardAndSpecialRank(originalRankList, Collections.singletonList(SalaryStandardConstants.S_RANK_MEDIANVALUE));
        ArrayList<SalaryRankEntity> tempRankList = new ArrayList<SalaryRankEntity>(targetRanks.size());
        try {
            for (SalaryRankEntity rank : targetRanks) {
                tempRankList.add((SalaryRankEntity)BeanUtils.cloneBean((Object)rank));
            }
        }
        catch (Exception e) {
            logger.error("bean clone error");
        }
        return tempRankList;
    }

    public static List<SalaryRankEntity> invokeFunction(List<SalaryRankEntity> data, SalaryRankOperationKey operationKey) {
        if (operationKey == null) {
            return Collections.emptyList();
        }
        String functionName = operationKey.getFunctionName();
        Method method = functionMap.get(functionName);
        try {
            if (method != null) {
                return (List)method.invoke(SalaryRankOperationFunction.class, data);
            }
        }
        catch (Exception e) {
            logger.error("method invoke error");
        }
        return Collections.emptyList();
    }

    static {
        Method[] functions;
        logger = LogFactory.getLog(SalaryRankOperationFunction.class);
        functionMap = new HashMap<String, Method>(16);
        for (Method function : functions = SalaryRankOperationFunction.class.getMethods()) {
            functionMap.put(function.getName(), function);
        }
    }
}

