/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryRankOperationKey;

public class SalaryRankOperationKeyMapping {
    private static Map<String, SalaryRankOperationKey> stdItemsRankDisplayOp = new HashMap<String, SalaryRankOperationKey>(16);
    private static Map<String, SalaryRankOperationKey> spItemsRankDisplayOp = new HashMap<String, SalaryRankOperationKey>(16);
    private static Map<String, SalaryRankOperationKey> defaultSpItemsDisplayOpByType = new HashMap<String, SalaryRankOperationKey>(16);
    private static Map<String, SalaryRankOperationKey> spItemsRankCalcOp = new HashMap<String, SalaryRankOperationKey>(16);
    private static Map<String, SalaryRankOperationKey> defaultSpItemsRankCalcOpByType = new HashMap<String, SalaryRankOperationKey>(16);
    private static final String var_two_tpl = "%s-%d";
    private static final String var_three_tpl = "%s-%d-%d";
    private static final String var_three_type_tpl = "%s-%s-%d";

    public static SalaryRankOperationKey getDisplayRankOperationKeyForGroupItem(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity item) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        SalaryRankOperationKey operationKey = null;
        if (itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD)) {
            operationKey = stdItemsRankDisplayOp.get(String.format(var_two_tpl, baseEntity.getType().getCode(), item.getItemIsUseSalaryRank()));
        } else {
            operationKey = spItemsRankDisplayOp.get(String.format(var_three_tpl, baseEntity.getType().getCode(), item.getItemIdentity(), item.getItemIsUseSalaryRank()));
            if (operationKey == null) {
                operationKey = VarPredictItemType.predict == SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity()) ? defaultSpItemsDisplayOpByType.get(String.format(var_three_type_tpl, baseEntity.getType().getCode(), VarPredictItemType.predict.getCode(), item.getItemIsUseSalaryRank())) : defaultSpItemsDisplayOpByType.get(String.format(var_three_type_tpl, baseEntity.getType().getCode(), VarPredictItemType.variable.getCode(), item.getItemIsUseSalaryRank()));
            }
        }
        if (operationKey == null) {
            operationKey = SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST;
        }
        return operationKey;
    }

    public static SalaryRankOperationKey getCalcRankOperationKeyForGroupItem(SalaryStandardBaseEntity baseEntity, SalaryStdItemEntity item) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        SalaryRankOperationKey operationKey = null;
        if (itemLabel.equals((Object)SalaryItemLabelEnum.SPECIAL) && (operationKey = spItemsRankCalcOp.get(String.format(var_three_tpl, baseEntity.getType().getCode(), item.getItemIdentity(), item.getItemIsUseSalaryRank()))) == null) {
            operationKey = VarPredictItemType.predict == SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity()) ? defaultSpItemsRankCalcOpByType.get(String.format(var_three_type_tpl, baseEntity.getType().getCode(), VarPredictItemType.predict.getCode(), item.getItemIsUseSalaryRank())) : defaultSpItemsRankCalcOpByType.get(String.format(var_three_type_tpl, baseEntity.getType().getCode(), VarPredictItemType.variable.getCode(), item.getItemIsUseSalaryRank()));
        }
        if (operationKey == null) {
            operationKey = SalaryRankOperationKey.REFERENCEALL;
        }
        return operationKey;
    }

    static {
        stdItemsRankDisplayOp.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 1), SalaryRankOperationKey.REFERENCEALL);
        stdItemsRankDisplayOp.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        stdItemsRankDisplayOp.put(String.format(var_two_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 1), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 1), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1), SalaryRankOperationKey.COPYSMALLESTMIDDLEANDLARGESTTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1), SalaryRankOperationKey.COPYSMALLESTMIDDLEANDLARGESTTONEWLIST);
        spItemsRankDisplayOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL, 1), SalaryRankOperationKey.COPYSMALLESTMIDDLEANDLARGESTTONEWLIST);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 1), SalaryRankOperationKey.REFERENCEALL);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 1), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 0), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), VarPredictItemType.predict.getCode(), 1), SalaryRankOperationKey.COPYSMALLESTMIDDLEANDLARGESTTONEWLIST);
        defaultSpItemsDisplayOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), VarPredictItemType.variable.getCode(), 1), SalaryRankOperationKey.COPYSMALLESTANDRESETFLAGTONEWLIST);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 0), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 0), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 0), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL, 1), SalaryRankOperationKey.REFERENCEALL);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        spItemsRankCalcOp.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL, 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 1), SalaryRankOperationKey.REFERENCEALL);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 0), SalaryRankOperationKey.REFERENCEALL);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 0), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.predict.getCode(), 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
        defaultSpItemsRankCalcOpByType.put(String.format(var_three_type_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), VarPredictItemType.variable.getCode(), 1), SalaryRankOperationKey.COPYSTANDARDANDMIDDLETONEWLIST);
    }
}

