/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salarystandard.CartesianIndexMatrix;
import kd.swc.hcdm.business.salarystandard.CartesianRowEntity;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.ContrastGridViewHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.salarystandard.grid.ContrastDataPrepareContext;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hcdm.common.entity.salarystandard.BaseDynamicGridFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.ContrastCartesianGradeItemEntity;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataQueryParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryStandContrastGridViewHelper {
    public static EntryAp createEntryApForGrid(EntityMetadata entityMetadata, SalaryStandardEntryData standardEntryData) {
        List<EntryParamContainer> createEntryBuildParamForGroupItem = EntryParamContainerHelper.createEntryBuildParamForGroupItem(entityMetadata, standardEntryData);
        List<EntryParamContainer> entryApBuildParam = EntryParamContainerHelper.createMulBaseParamForContrast(entityMetadata, standardEntryData.getContrastPropEntities());
        entryApBuildParam.addAll(createEntryBuildParamForGroupItem);
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    public static void registerPropertyForGrid(SalaryStandardEntryData standardEntryData, EntryType entryType) {
        List<EntryParamContainer> createEntryBuildParamForGroupItem = EntryParamContainerHelper.createEntryBuildParamForGroupItem(null, standardEntryData);
        List<EntryParamContainer> mulBaseParamForContrast = EntryParamContainerHelper.createMulBaseParamForContrast(null, standardEntryData.getContrastPropEntities());
        createEntryBuildParamForGroupItem.addAll(mulBaseParamForContrast);
        EntryParamContainerBaseHelper.registProp(createEntryBuildParamForGroupItem, (EntityType)entryType);
    }

    public static int getMaxTotalRow(IFormView anyView, String mainPageId, String gridViewPageId) {
        if (anyView == null || StringUtils.isEmpty((String)mainPageId) || StringUtils.isEmpty((String)gridViewPageId)) {
            return 0;
        }
        IFormView mainView = anyView.getView(mainPageId);
        IFormView gridView = anyView.getView(gridViewPageId);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData(mainPageId);
        String filterParam = (String)gridView.getFormShowParameter().getCustomParam("contrastFilterParam");
        ContrastDataQueryParam queryParam = SalaryStandardSerializationUtils.fromJsonString(filterParam, ContrastDataQueryParam.class);
        Map<Long, List<QFilter>> previewQFilterMap = ContrastGridViewHelper.getPreviewQFilterWithExt(stdData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList()), mainView);
        return SalaryStandContrastGridViewHelper.getMaxTotalRow(stdData, queryParam == null ? null : queryParam.getPropValues(), previewQFilterMap);
    }

    private static int getMaxTotalRow(SalaryStandardEntryData standardEntryData, Map<Long, List<Long>> propFilterParam, Map<Long, List<QFilter>> previewQFilterMap) {
        List contrastRowEntities = standardEntryData.getContrastRowEntities();
        ContrastGridViewHelper.filterContrastRow(contrastRowEntities, standardEntryData.getContrastPropEntities(), previewQFilterMap, propFilterParam);
        List gradeEntities = standardEntryData.getGradeEntities();
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(standardEntryData.getRankEntities());
        boolean isUseSalaryRank = standardEntryData.getStdBaseEntity().getIsUseSalaryRank() > 0;
        return SalaryStandContrastGridViewHelper.countAllCartesianResult(contrastRowEntities, gradeEntityMap, rankEntityMap, isUseSalaryRank, gradeEntities);
    }

    public static DynamicObject[] getFormDataForGrid(int startIndex, int endIndex, ContrastDataPrepareContext context) {
        SalaryStandardEntryData standardEntryData = context.getStdData();
        DynamicObject currencyFromDb = context.getCurrencyFromDb();
        Map<Long, SalaryGradeEntity> gradeEntityMap = context.getGradeEntityMap();
        Map<Long, SalaryRankEntity> rankEntityMap = context.getRankEntityMap();
        Map<Long, SalaryStdItemEntity> itemMap = context.getItemMap();
        Map<Long, Map<String, BigDecimal>> dataMap = context.getDataMap();
        Map<Long, Map<Long, DynamicObject>> dbData = context.getDbData();
        DataEntityPropertyCollection entityProperties = context.getRows().getDynamicObjectType().getProperties();
        boolean isUseSalaryRank = context.getStdData().getStdBaseEntity().getIsUseSalaryRank() > 0;
        List<ContrastCartesianGradeItemEntity> cartesianResult = SalaryStandContrastGridViewHelper.transToCartesianResult(context.getStdData().getContrastRowEntities(), standardEntryData.getGradeEntities(), gradeEntityMap, rankEntityMap, startIndex, endIndex, context.getStdData().getContrastPropEntities(), isUseSalaryRank);
        SalaryStandContrastGridViewHelper.assembleDataToGrid(context.getRows(), currencyFromDb, dataMap, dbData, entityProperties, cartesianResult, itemMap, rankEntityMap);
        int amtPrecision = standardEntryData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
        for (DynamicObject row : context.getRows()) {
            SalaryStandardViewHelper.fixAmtPrecision(row, amtPrecision);
        }
        return (DynamicObject[])context.getRows().toArray((Object[])new DynamicObject[0]);
    }

    private static void assembleDataToGrid(DynamicObjectCollection rows, DynamicObject currencyFromDb, Map<Long, Map<String, BigDecimal>> dataMap, Map<Long, Map<Long, DynamicObject>> dbData, DataEntityPropertyCollection entityProperties, List<ContrastCartesianGradeItemEntity> cartesianResult, Map<Long, SalaryStdItemEntity> itemMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        ArrayList objects = Lists.newArrayList();
        LinkedHashMap tempMap = Maps.newLinkedHashMap();
        for (ContrastCartesianGradeItemEntity entity : cartesianResult) {
            List values = tempMap.getOrDefault(entity.getContrastPropValues(), Lists.newArrayList());
            values.add(entity);
            tempMap.putIfAbsent(entity.getContrastPropValues(), values);
        }
        for (List value : tempMap.values()) {
            value.sort((o1, o2) -> {
                int result = 0;
                SalaryGradeEntity source = o1.getGradeEntity();
                SalaryGradeEntity target = o2.getGradeEntity();
                if (source == null || target == null) {
                    return result;
                }
                return result += source.getGradeIndex() - target.getGradeIndex();
            });
        }
        tempMap.values().forEach(objects::addAll);
        for (ContrastCartesianGradeItemEntity resultGradeItem : objects) {
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            for (IDataEntityProperty tempProperty : entityProperties) {
                FixedFieldIdGenerationParam generationParam;
                String tempPropertyName = tempProperty.getName();
                SalaryGradeEntity gradeEntity = resultGradeItem.getGradeEntity();
                if (tempPropertyName.startsWith("dgdf")) {
                    BaseDynamicGridFieldIdGenerationParam fieldIdGenerationParam = BaseDynamicGridFieldIdGenerationParam.parseFrom((String)tempPropertyName);
                    if (SWCStringUtils.equals((String)fieldIdGenerationParam.getFieldType(), (String)"mulbasedatafield")) {
                        DynamicFieldIdGenerationParamForTabular generationParam2 = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName);
                        Long propConfId = generationParam2.getIdentityId();
                        int index = resultGradeItem.getContrastPropIds().indexOf(propConfId);
                        if (index < 0 || MapUtils.isEmpty(dbData.get(propConfId))) continue;
                        Long propValue = (Long)resultGradeItem.getContrastPropValues().get(index);
                        if (dbData.get(propConfId).get(propValue) == null) continue;
                        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                        DynamicObject mulBaseDynamicObject = ContrastDataHelper.createMulBaseDynamicObject((MulBasedataProp)tempProperty, dbData.get(propConfId).get(propValue));
                        dynamicObjects.add((Object)mulBaseDynamicObject);
                        tempRow.set(tempPropertyName, (Object)dynamicObjects);
                    } else {
                        Map<String, BigDecimal> tempData;
                        Set rankEntities = resultGradeItem.getRankEntities();
                        Set<Object> rankIds = new HashSet(16);
                        if (rankEntities != null) {
                            rankIds = rankEntities.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
                        }
                        DynamicFieldIdGenerationParamForGroup paramForGroup = DynamicFieldIdGenerationParamForGroup.parseFrom((String)tempPropertyName);
                        Long itemId = paramForGroup.getItemId();
                        Long rankId = paramForGroup.getRankId();
                        String matchedKey = paramForGroup.generateDataMatchedKey();
                        SalaryStdItemEntity stdItemEntity = itemMap.get(itemId);
                        SalaryRankEntity rankEntity = rankEntityMap.get(rankId);
                        if (gradeEntity != null && (tempData = dataMap.get(gradeEntity.getGradeIdentity())) != null) {
                            if (stdItemEntity != null && stdItemEntity.getItemLabel() == SalaryItemLabelEnum.STANDARD && rankEntity != null && rankEntity.getRankLabel() == SalaryRankLabelEnum.STANDARD) {
                                if (rankIds.contains(rankId)) {
                                    tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
                                }
                            } else {
                                tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
                            }
                        }
                    }
                } else if (tempPropertyName.startsWith("dgff") && SWCStringUtils.equals((String)(generationParam = FixedFieldIdGenerationParam.parseFrom((String)tempPropertyName)).getName(), (String)"grade") && gradeEntity != null) {
                    String gradeName = gradeEntity.getGradeName();
                    tempRow.set(tempPropertyName, (Object)gradeName);
                }
                if (!SWCStringUtils.equals((String)"currencyfield", (String)tempPropertyName)) continue;
                tempRow.set(tempPropertyName, (Object)currencyFromDb);
            }
            rows.add((Object)tempRow);
        }
        cartesianResult.clear();
    }

    private static List<ContrastCartesianGradeItemEntity> transToCartesianResult(List<ContrastRowDataEntity> rowDataEntities, List<SalaryGradeEntity> gradeEntityList, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, int startIndex, int endIndex, List<ContrastPropEntity> contrastPropEntities, boolean isUseSalaryRank) {
        ArrayList<ContrastCartesianGradeItemEntity> lastResult = new ArrayList<ContrastCartesianGradeItemEntity>(10);
        if (endIndex <= startIndex) {
            return lastResult;
        }
        Map<Integer, ContrastRowDataEntity> newCommonPropData = SalaryStandContrastGridViewHelper.resetIndex(rowDataEntities);
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntityMap.values());
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(rankEntityMap.values()));
        CartesianIndexMatrix startIndexMatrix = SalaryStandContrastGridViewHelper.calStartMatrix(newCommonPropData, gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, startIndex, endIndex, contrastPropEntities, gradeEntityList, isUseSalaryRank);
        int dataSize = endIndex - startIndex;
        CartesianRowEntity cartesianRowEntity = new CartesianRowEntity(startIndexMatrix, dataSize);
        int startRow = startIndexMatrix.getStartRowIndex();
        while (newCommonPropData.containsKey(startRow)) {
            ContrastRowDataEntity rowDataEntity = newCommonPropData.get(startRow);
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyOfRow = new ArrayList<GradeRankKey>(10);
            if (rangeDBEntity != null) {
                gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
            }
            Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap = SalaryStandContrastGridViewHelper.getGradeRankEntityMap(gradeRankKeyOfRow);
            ArrayList gradeEntitySetMapList = Lists.newArrayListWithExpectedSize((int)gradeEntitySetMap.size());
            gradeEntitySetMapList.addAll(gradeEntitySetMap.entrySet());
            gradeEntitySetMapList.sort(new Comparator<Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>>>(){

                @Override
                public int compare(Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>> o1, Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>> o2) {
                    return o1.getKey().getGradeIndex() - o2.getKey().getGradeIndex();
                }
            });
            cartesianRowEntity.setDataSize(dataSize - lastResult.size());
            List<ContrastCartesianGradeItemEntity> tempResult = SalaryStandContrastGridViewHelper.transOneRowToCartesianResult(rowDataEntity.getStdPropValueMap(), gradeEntitySetMapList, cartesianRowEntity, contrastPropEntities, startRow);
            lastResult.addAll(tempResult);
            cartesianRowEntity.setFirstRowGetData(false);
            if (lastResult.size() >= dataSize) break;
            ++startRow;
        }
        return lastResult;
    }

    private static Map<SalaryGradeEntity, Set<SalaryRankEntity>> getGradeRankEntityMap(List<GradeRankKey> gradeRankKeys) {
        LinkedHashMap<SalaryGradeEntity, Set<SalaryRankEntity>> resultMap = new LinkedHashMap<SalaryGradeEntity, Set<SalaryRankEntity>>(gradeRankKeys.size());
        for (GradeRankKey gradeRankKey : gradeRankKeys) {
            Set rankEntitySet = resultMap.computeIfAbsent(gradeRankKey.getGradeEntity(), o1 -> Sets.newHashSet());
            rankEntitySet.add(gradeRankKey.getRankEntity());
        }
        return resultMap;
    }

    private static List<ContrastCartesianGradeItemEntity> transOneRowToCartesianResult(Map<Long, List<Long>> contrastDataMap, List<Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>>> gradeRankKeyList, CartesianRowEntity cartesianRowEntity, List<ContrastPropEntity> contrastPropEntities, int curRowIndex) {
        ArrayList lastResultNew = Lists.newArrayListWithExpectedSize((int)cartesianRowEntity.getDataSize());
        List<Long> propIdList = SalaryStandContrastGridViewHelper.getPropIdList(contrastDataMap, contrastPropEntities);
        CartesianIndexMatrix startIndexMatrix = cartesianRowEntity.getStartIndexMatrix();
        cartesianRowEntity.resetIndexMatrix(SalaryStandContrastGridViewHelper.initPropIndexMap(propIdList), curRowIndex, propIdList, gradeRankKeyList.isEmpty());
        LinkedHashMap<Long, Integer> propIndexMap = startIndexMatrix.getPropIndex();
        if (propIndexMap == null || propIndexMap.isEmpty()) {
            return lastResultNew;
        }
        for (int i1 = 0; i1 < cartesianRowEntity.getDataSize(); ++i1) {
            ContrastCartesianGradeItemEntity cartesianItemEntity = new ContrastCartesianGradeItemEntity();
            SalaryStandContrastGridViewHelper.movePointer(contrastDataMap, gradeRankKeyList.size(), propIndexMap, propIdList, startIndexMatrix);
            if (startIndexMatrix.getPointer() == -1) break;
            for (Map.Entry<Long, List<Long>> propEntry : contrastDataMap.entrySet()) {
                Long propEntryKey = propEntry.getKey();
                Integer index = propIndexMap.get(propEntryKey);
                if (index == null) continue;
                List<Long> propEntryValue = propEntry.getValue();
                if (index >= propEntryValue.size()) continue;
                cartesianItemEntity.getContrastPropIds().add(propEntryKey);
                cartesianItemEntity.getContrastPropValues().add(propEntryValue.get(index));
            }
            if (startIndexMatrix.getGradeRankIndex() < gradeRankKeyList.size()) {
                Map.Entry<SalaryGradeEntity, Set<SalaryRankEntity>> salaryGradeEntitySetEntry = gradeRankKeyList.get(startIndexMatrix.getGradeRankIndex());
                cartesianItemEntity.setGradeEntity(salaryGradeEntitySetEntry.getKey());
                cartesianItemEntity.setRankEntities(salaryGradeEntitySetEntry.getValue());
                startIndexMatrix.moveGradeRankIndex();
            }
            lastResultNew.add(cartesianItemEntity);
        }
        return lastResultNew;
    }

    private static List<Long> getPropIdList(Map<Long, List<Long>> contrastDataMap, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<Long> propIdList = new ArrayList<Long>(10);
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            if (!contrastDataMap.containsKey(contrastPropEntity.getPropConfigId())) continue;
            propIdList.add(contrastPropEntity.getPropConfigId());
        }
        return propIdList;
    }

    private static CartesianIndexMatrix calStartMatrix(Map<Integer, ContrastRowDataEntity> commonPropData, Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc, Map<Integer, SalaryRankEntity> rankMapByIndexAsc, Map<Long, SalaryRankEntity> rankEntityMap, int startIndex, int endIndex, List<ContrastPropEntity> contrastPropEntities, List<SalaryGradeEntity> gradeEntityList, boolean isUseSalaryRank) {
        CartesianIndexMatrix startMatrix = new CartesianIndexMatrix(startIndex, endIndex);
        int total = 0;
        int targetRow = 0;
        int preRowTotal = 0;
        for (Map.Entry<Integer, ContrastRowDataEntity> mapEntry : commonPropData.entrySet()) {
            targetRow = mapEntry.getKey();
            ContrastRowDataEntity rowDataEntity = mapEntry.getValue();
            GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyOfRow = new ArrayList<GradeRankKey>(10);
            if (rangeDBEntity != null) {
                gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
            }
            Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap = SalaryStandContrastGridViewHelper.getGradeRankEntityMap(gradeRankKeyOfRow);
            int leftFetchSize = startIndex - total;
            if (leftFetchSize > 0) {
                preRowTotal = total;
                total += SalaryStandContrastGridViewHelper.countCartesianResult(rowDataEntity.getStdPropValueMap(), gradeEntitySetMap.size());
                continue;
            }
            if (targetRow <= 0) break;
            --targetRow;
            break;
        }
        startMatrix.setStartRowIndex(targetRow);
        ContrastRowDataEntity rowDataEntity = commonPropData.get(targetRow);
        if (rowDataEntity == null) {
            return startMatrix;
        }
        GradeRankRangeDBEntity rangeDBEntity = rowDataEntity.getGradeRankRangeDBEntity();
        List<GradeRankKey> gradeRankKeyOfRow = new ArrayList<GradeRankKey>(10);
        if (rangeDBEntity != null) {
            gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
        }
        Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap = SalaryStandContrastGridViewHelper.getGradeRankEntityMap(gradeRankKeyOfRow);
        int dataSize = startIndex - preRowTotal;
        SalaryStandContrastGridViewHelper.setStartCartesianIndexMatrix(rowDataEntity.getStdPropValueMap(), gradeEntitySetMap.size(), dataSize, startMatrix, contrastPropEntities);
        return startMatrix;
    }

    private static void movePointer(Map<Long, List<Long>> contrastDataMap, int gradeRankKeyListSize, LinkedHashMap<Long, Integer> propIndexMap, List<Long> propIdList, CartesianIndexMatrix curEndMatrix) {
        boolean isPointerMoveRight = false;
        while (!isPointerMoveRight) {
            Long propId;
            int pointer = curEndMatrix.getPointer();
            if (pointer != -2) {
                List<Long> contrastDataIds;
                if (pointer == -1) break;
                propId = propIdList.get(pointer);
                int index = propIndexMap.get(propId);
                if (index >= (contrastDataIds = contrastDataMap.get(propId)).size()) {
                    pointer = curEndMatrix.movePointer();
                    if (pointer == -1) break;
                    Long prePropId = propIdList.get(pointer);
                    propIndexMap.put(prePropId, propIndexMap.get(prePropId) + 1);
                    continue;
                }
                for (int pos = pointer + 1; pos < propIdList.size(); ++pos) {
                    Long nextPropId = propIdList.get(pos);
                    propIndexMap.put(nextPropId, 0);
                }
                curEndMatrix.resetGradeRankIndex();
                curEndMatrix.resetPointer();
                isPointerMoveRight = true;
                continue;
            }
            if (curEndMatrix.getGradeRankIndex() >= gradeRankKeyListSize) {
                curEndMatrix.setPointer(propIdList.size() - 1);
                propId = propIdList.get(curEndMatrix.getPointer());
                propIndexMap.put(propId, propIndexMap.get(propId) + 1);
                continue;
            }
            isPointerMoveRight = true;
        }
    }

    private static CartesianIndexMatrix setStartCartesianIndexMatrix(Map<Long, List<Long>> contrastDataMap, int gradeRankKeyListSize, int dataSize, CartesianIndexMatrix startMatrix, List<ContrastPropEntity> contrastPropEntities) {
        List<Long> propIdList = SalaryStandContrastGridViewHelper.getPropIdList(contrastDataMap, contrastPropEntities);
        LinkedHashMap<Long, Integer> propIndexMap = SalaryStandContrastGridViewHelper.initPropIndexMap(propIdList);
        startMatrix.setPropIndex(propIndexMap);
        for (int index = 0; index < dataSize; ++index) {
            SalaryStandContrastGridViewHelper.movePointer(contrastDataMap, gradeRankKeyListSize, propIndexMap, propIdList, startMatrix);
            startMatrix.moveGradeRankIndex();
            if (startMatrix.getPointer() == -1) break;
        }
        return startMatrix;
    }

    private static LinkedHashMap<Long, Integer> initPropIndexMap(List<Long> propIdList) {
        LinkedHashMap propIndexMap = Maps.newLinkedHashMapWithExpectedSize((int)propIdList.size());
        for (Long propId : propIdList) {
            propIndexMap.put(propId, 0);
        }
        return propIndexMap;
    }

    private static int countAllCartesianResult(List<ContrastRowDataEntity> contrastRowEntities, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap, boolean isUseSalaryRank, List<SalaryGradeEntity> gradeEntityList) {
        int maxTotalRow = 0;
        Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc = GradeRankHelper.gradeMapByIndexAsc(gradeEntityMap.values());
        Map<Integer, SalaryRankEntity> rankMapByIndexAsc = GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(rankEntityMap.values()));
        for (ContrastRowDataEntity contrastRowEntity : contrastRowEntities) {
            GradeRankRangeDBEntity rangeDBEntity = contrastRowEntity.getGradeRankRangeDBEntity();
            List<GradeRankKey> gradeRankKeyOfRow = new ArrayList<GradeRankKey>(10);
            if (rangeDBEntity != null) {
                gradeRankKeyOfRow = GradeRankHelper.getGradeRankKeyFromRangeCode(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeMapByIndexAsc, rankMapByIndexAsc, rankEntityMap, gradeEntityList, isUseSalaryRank);
            }
            Map<SalaryGradeEntity, Set<SalaryRankEntity>> gradeEntitySetMap = SalaryStandContrastGridViewHelper.getGradeRankEntityMap(gradeRankKeyOfRow);
            int curRowCount = SalaryStandContrastGridViewHelper.countCartesianResult(contrastRowEntity.getStdPropValueMap(), gradeEntitySetMap.size());
            maxTotalRow += curRowCount;
        }
        if (maxTotalRow < 0 || maxTotalRow >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return maxTotalRow;
    }

    private static int countCartesianResult(Map<Long, List<Long>> contrastDataMap, int gradeRankKeyCount) {
        int total = 0;
        for (Map.Entry<Long, List<Long>> entry : contrastDataMap.entrySet()) {
            int size = entry.getValue().size();
            if (total == 0) {
                total = size;
                continue;
            }
            if (size == 0) continue;
            total *= size;
        }
        if (gradeRankKeyCount == 0) {
            return total;
        }
        return total * gradeRankKeyCount;
    }

    private static Map<Integer, ContrastRowDataEntity> resetIndex(List<ContrastRowDataEntity> contrastRowEntities) {
        int rowIndex = 0;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)contrastRowEntities.size());
        for (ContrastRowDataEntity contrastRowEntity : contrastRowEntities) {
            contrastRowEntity.setRowIndex(rowIndex++);
            rowMap.put(contrastRowEntity.getRowIndex(), contrastRowEntity);
        }
        return rowMap;
    }
}

