/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.DynamicCommonFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hsbp.common.dynamic.FieldIdGenerationParam;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.MulBasedataFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryStandGraphGridHelper {
    public static EntryAp createEntryApForConstrastForm(EntityMetadata entityMetadata, List<ContrastPropEntity> contrastPropEntities) {
        List<EntryParamContainer> containers = SalaryStandGraphGridHelper.createEntryBuildParamForContrast(entityMetadata, contrastPropEntities);
        return EntryParamContainerBaseHelper.createControlAp(containers);
    }

    public static List<EntryParamContainer> createEntryBuildParamForContrast(EntityMetadata entityMetadata, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(contrastPropEntities.size() + 2);
        Collections.sort(contrastPropEntities, Comparator.comparingInt(ContrastPropEntity::getPropIndex));
        TextFieldParamContainer gradeContainer = EntryParamContainerHelper.createGradeContainer(entityMetadata, SalaryStdGridDisplayTypeEnum.TABULAR);
        allContainer.add((EntryParamContainer)gradeContainer);
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            MulBasedataFieldParamContainer container = new MulBasedataFieldParamContainer();
            container.setWidth(contrastPropEntity.getPropConfigEntity().getWidth());
            DynamicFieldIdGenerationParamForTabular idGenParam = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", contrastPropEntity.getPropConfigId());
            container.setFieldIdGenerationParam((FieldIdGenerationParam)idGenParam);
            container.setName(contrastPropEntity.getPropConfigEntity().getName());
            container.setEntityMetadata(entityMetadata);
            container.setLock("new,edit,view,submit,audit");
            container.setBaseEntityId(contrastPropEntity.getPropConfigEntity().getObjectTypeIId());
            allContainer.add((EntryParamContainer)container);
        }
        TextFieldParamContainer gradeRankContainer = new TextFieldParamContainer();
        gradeRankContainer.setHyperlink(false);
        gradeRankContainer.setLock("new,edit,view,submit,audit");
        gradeRankContainer.setWidth("100");
        gradeRankContainer.setTextAlign("left");
        gradeRankContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new DynamicCommonFieldIdGenerationParam("dgff", "grade_rank"));
        gradeRankContainer.setName(SalaryStandardConstants.FORM_STATIC_GRADE_RANK_FIELD_NAME());
        gradeRankContainer.setEntityMetadata(entityMetadata);
        allContainer.add((EntryParamContainer)gradeRankContainer);
        return allContainer;
    }

    public static void registerPropertyForConstrastForm(SalaryStandardEntryData standardEntryData, EntryType entryType) {
        List<EntryParamContainer> entryBuildParamForContrast = SalaryStandGraphGridHelper.createEntryBuildParamForContrast(null, standardEntryData.getContrastPropEntities());
        EntryParamContainerBaseHelper.registProp(entryBuildParamForContrast, (EntityType)entryType);
    }

    public static void setFormDataForConstrastForm(DynamicObjectCollection rows, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<ContrastPropEntity> contrastPropEntities, List<ContrastRowDataEntity> contrastDataEntities, Map<Long, List<Long>> propFilterParam, SalaryStandardBaseEntity salaryStandardBaseEntity) {
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        boolean isUseSalaryRank = salaryStandardBaseEntity.getIsUseSalaryRank() > 0;
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(standardRanks);
        Map<Integer, String> gradeIndexNameMap = GradeRankHelper.getGradeIndexNameMap(gradeEntities);
        Map<Integer, String> rankIndexNameMap = GradeRankHelper.getRankIndexNameMap(standardRanks);
        HashMap specialContrastDataMap = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        HashMap rangeDataMap = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        List sortedGradeEntities = gradeEntities.stream().sorted(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toList());
        LinkedHashMap gradeDataMap = Maps.newLinkedHashMapWithExpectedSize((int)sortedGradeEntities.size());
        SalaryStandGraphGridHelper.filterContrastDataByPropValues(contrastDataEntities, propFilterParam);
        for (Object gradeEntity : sortedGradeEntities) {
            Long l = gradeEntity.getGradeIdentity();
            int gradeIndex = gradeEntity.getGradeIndex();
            HashMap propData = new HashMap();
            ArrayList<GradeRankValue> ranges = new ArrayList<GradeRankValue>();
            for (ContrastRowDataEntity entry : contrastDataEntities) {
                Map stdPropValueMap;
                Integer rowIndex = entry.getRowIndex();
                GradeRankRangeDBEntity rangeDBEntity = entry.getGradeRankRangeDBEntity();
                List rangeCode = entry.getRangeCode();
                boolean containsGrade = CollectionUtils.isNotEmpty((Collection)rangeCode) && GradeRankHelper.checkContainsGrade(rangeCode, rangeDBEntity.getRankNum(), gradeIndex);
                if (!containsGrade || MapUtils.isEmpty((Map)(stdPropValueMap = entry.getStdPropValueMap()))) continue;
                for (Map.Entry contrastEntry : stdPropValueMap.entrySet()) {
                    Long key = (Long)contrastEntry.getKey();
                    List set = (List)contrastEntry.getValue();
                    HashSet propSet = (HashSet)propData.get(key);
                    if (null != propSet && !propSet.isEmpty()) {
                        propSet.addAll(set);
                    } else {
                        propSet = new HashSet();
                        propSet.addAll(set);
                    }
                    propData.put(key, propSet);
                }
                List<GradeRankValue> oneGradeRange = GradeRankHelper.getRangeCodeByGradeIdx(rangeDBEntity.getRuntimeRangeCodeArr(), rangeDBEntity.getRankNum(), gradeIndex);
                ranges.addAll(oneGradeRange);
            }
            if (propData.isEmpty() || ranges.isEmpty()) continue;
            gradeDataMap.put(l, propData);
            rangeDataMap.put(l, GradeRankHelper.unionRangeByCode(ranges));
        }
        HashMap rangeNameMap = Maps.newHashMapWithExpectedSize((int)specialContrastDataMap.size());
        for (Map.Entry entry : rangeDataMap.entrySet()) {
            String rangeName = GradeRankHelper.getRangeNamesByRangeCode((List)entry.getValue(), standardRanks.size(), gradeIndexNameMap, rankIndexNameMap, isUseSalaryRank);
            rangeNameMap.put(entry.getKey(), rangeName);
        }
        Map<Long, Map<Long, DynamicObject>> dbData = ContrastDataHelper.queryFromDb(contrastPropEntities, contrastDataEntities);
        String string = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "grade").generateKey();
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        for (Map.Entry gradeEntry : gradeDataMap.entrySet()) {
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            for (IDataEntityProperty tempProperty : entityProperties) {
                String tempPropertyName = tempProperty.getName();
                if (tempPropertyName.startsWith("dgdf")) {
                    Long identityId = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName).getIdentityId();
                    Map tempPropDataMap = (Map)gradeEntry.getValue();
                    Set tempPropIDs = (Set)tempPropDataMap.get(identityId);
                    if (CollectionUtils.isEmpty((Collection)tempPropIDs) || MapUtils.isEmpty(dbData.get(identityId))) continue;
                    DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                    for (Long propId : tempPropIDs) {
                        DynamicObject dbContrastDataObject = dbData.get(identityId).get(propId);
                        if (dbContrastDataObject == null) continue;
                        DynamicObject mulBaseDynamicObject = ContrastDataHelper.createMulBaseDynamicObject((MulBasedataProp)tempProperty, dbContrastDataObject);
                        dynamicObjects.add((Object)mulBaseDynamicObject);
                        tempRow.set(tempPropertyName, (Object)dynamicObjects);
                    }
                    continue;
                }
                if (!tempPropertyName.startsWith("dgff")) continue;
                DynamicCommonFieldIdGenerationParam generationParam = DynamicCommonFieldIdGenerationParam.parseFrom((String)tempPropertyName);
                if (SWCStringUtils.equals((String)tempPropertyName, (String)string)) {
                    tempRow.set(tempPropertyName, (Object)gradeEntityMap.get(gradeEntry.getKey()).getGradeName());
                    continue;
                }
                if (!SWCStringUtils.equals((String)generationParam.getName(), (String)"grade_rank")) continue;
                String str = (String)rangeNameMap.get(gradeEntry.getKey());
                tempRow.set(tempPropertyName, (Object)str);
            }
            rows.add((Object)tempRow);
        }
    }

    private static void filterContrastDataByPropValues(List<ContrastRowDataEntity> contrastDataEntities, Map<Long, List<Long>> propFilterParam) {
        if (propFilterParam == null || MapUtils.isEmpty(propFilterParam)) {
            return;
        }
        for (Map.Entry<Long, List<Long>> propParam : propFilterParam.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)propParam.getValue())) continue;
            Iterator<ContrastRowDataEntity> iterator = contrastDataEntities.iterator();
            while (iterator.hasNext()) {
                ContrastRowDataEntity next = iterator.next();
                Map propMap = next.getStdPropValueMap();
                Long propConfId = propParam.getKey();
                List<Long> filterPropVals = propParam.getValue();
                List propVals = (List)propMap.get(propConfId);
                if (filterPropVals == null || propVals == null) continue;
                List retainAll = ListUtils.retainAll(filterPropVals, (Collection)propVals);
                if (CollectionUtils.isEmpty((Collection)retainAll)) {
                    iterator.remove();
                    continue;
                }
                List valueAfter = propVals.stream().filter(retainAll::contains).collect(Collectors.toList());
                propMap.put(propConfId, valueAfter);
            }
        }
    }
}

