/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataOutbound;
import kd.swc.hcdm.common.entity.salarystandard.GradeRankKeyOutbound;
import kd.swc.hcdm.common.entity.salarystandard.SalaryStdGridOutbound;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryStandardCacheHelper {
    public static final String SALARY_STANDARD_CACHE_KEY = "hcdm_salarystandard_appcache";
    private static final String SALARY_STANDARD_GRID_PREFIX = "salary_standard_grid_data";
    private static final String LITTLE_CONTRAST_SET_GRID_PREFIX = "little_contrast_set_grid_prefix";
    private static final String ALL_CONTRAST_SET_GRID_PREFIX = "all_contrast_set_grid_prefix";
    private static final String GRADE_RANK_KEY_DATA_PREFIX = "grade_rank_key_data_prefix";
    private static final String STD_GRID_PAGE_ID_KEY = "std_grid_page_id_key";
    private static final String SALARY_STANDARD_ENTRY_DATA_PREFIX = "salary_standard_entry_data";
    private static final String SALARY_STANDARD_LASTCALC_ENTRY_DATA_PREFIX = "salary_standard_lastcalc_entry_data";
    private static final String GRADE_RANK_CONTRAST_SET_GRID_PREFIX = "grade_rank_contrast_set_grid_prefix";
    private static final String SALARY_STANDARD_ENTRY_AP_PREFIX = "salary_standard_entry_ap";
    private static final String CACHE_KEY_SEPARATOR = "&";
    private static final String SALARY_STANDARD_SECOND_PAGE_ID = "salary_standard_second_page_id";
    private static final String SALARY_STANDARD_FOURTH_PAGE_ID = "salary_standard_fourth_page_id";
    private static Map<String, Object> localCache = Maps.newConcurrentMap();
    private static Log log = LogFactory.getLog((String)SalaryStandardCacheHelper.class.getName());

    private static ISWCAppCache getCache() {
        return SWCAppCache.get((String)SALARY_STANDARD_CACHE_KEY);
    }

    public static void putEntryData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_ENTRY_DATA_PREFIX, pageId);
        long start = System.currentTimeMillis();
        SalaryStandardCacheHelper.beforeDeserialize((SalaryStandardEntryData)obj);
        SalaryStandardCacheHelper.getCache().put(key, obj);
        long end = System.currentTimeMillis();
        log.info("SalaryStandardCacheHelper_monitor-->putEntryData cost {}", (Object)(end - start));
        String requestId = RequestContext.get().getRequestId();
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            String localKey = SalaryStandardCacheHelper.generateLocalKey(SALARY_STANDARD_ENTRY_DATA_PREFIX, pageId, requestId);
            localCache.remove(localKey);
        }
    }

    private static void beforeDeserialize(SalaryStandardEntryData entryData) {
        entryData.buildStdData(null);
        List contrastRowEntities = entryData.getContrastRowEntities();
        if (CollectionUtils.isNotEmpty((Collection)contrastRowEntities)) {
            for (ContrastRowDataEntity rowEntity : contrastRowEntities) {
                rowEntity.setProps(null);
            }
        }
    }

    public static String serializeWithUtils(SalaryStandardEntryData entryData) {
        SalaryStandardCacheHelper.beforeDeserialize(entryData);
        return SerializationUtils.toJsonString((Object)entryData);
    }

    public static SalaryStandardEntryData deserializeWithUtils(String jsonString) {
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            SalaryStandardEntryData entity = (SalaryStandardEntryData)SerializationUtils.fromJsonString((String)jsonString, SalaryStandardEntryData.class);
            SalaryStandardCacheHelper.afterDeserialize(entity);
            return entity;
        }
        return null;
    }

    public static SalaryStandardEntryData getEntryData(String pageId) {
        String requestId = RequestContext.get().getRequestId();
        SalaryStandardEntryData entryData = null;
        String localKey = null;
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            localKey = SalaryStandardCacheHelper.generateLocalKey(SALARY_STANDARD_ENTRY_DATA_PREFIX, pageId, requestId);
            entryData = (SalaryStandardEntryData)localCache.get(localKey);
        }
        if (entryData == null) {
            String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_ENTRY_DATA_PREFIX, pageId);
            long start = System.currentTimeMillis();
            entryData = (SalaryStandardEntryData)SalaryStandardCacheHelper.getCache().get(key, SalaryStandardEntryData.class);
            if (entryData != null) {
                long end = System.currentTimeMillis();
                SalaryStandardCacheHelper.afterDeserialize(entryData);
                if (localKey != null) {
                    localCache.put(localKey, entryData);
                }
                log.info("SalaryStandardCacheHelper_monitor-->getEntryDataFrom Cache cost {}", (Object)(end - start));
            }
        }
        return entryData;
    }

    private static void afterDeserialize(SalaryStandardEntryData entryData) {
        SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);
        String dbValue = entryData.getStdBaseEntity().getGradeRankSeqMapEntity().getDbValue();
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(dbValue);
        Map stdDataStrs = entryData.getStdDataStrs();
        if (MapUtils.isNotEmpty((Map)stdDataStrs)) {
            List<SalaryStdDataEntity> stdDataEntities = EntityConverter.stdStrToSalaryStdDataEntity(entryData.getStdDataStrs(), entryData.getStdBaseEntity().getId(), service.reverseGradeRankSeqMap(gradeRankSeqMap));
            entryData.buildStdData(stdDataEntities);
        } else {
            entryData.buildStdData(Collections.emptyList());
        }
        List contrastPropEntities = entryData.getContrastPropEntities();
        List contrastRowEntities = entryData.getContrastRowEntities();
        if (CollectionUtils.isNotEmpty((Collection)contrastRowEntities)) {
            for (ContrastRowDataEntity rowEntity : contrastRowEntities) {
                rowEntity.setProps(contrastPropEntities);
            }
        }
    }

    private static String generateLocalKey(String prefix, String pageId, String requestId) {
        return String.format("%s&%s&%s", prefix, pageId, requestId);
    }

    public static void putLastCalcEntryData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_LASTCALC_ENTRY_DATA_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, obj);
    }

    public static SalaryStandardEntryData getLastCalcEntryData(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_LASTCALC_ENTRY_DATA_PREFIX, pageId);
        return (SalaryStandardEntryData)SalaryStandardCacheHelper.getCache().get(key, SalaryStandardEntryData.class);
    }

    public static void putSalaryStandardGridData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_GRID_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, obj);
    }

    public static SalaryStdGridOutbound getSalaryStandardGridData(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_GRID_PREFIX, pageId);
        return (SalaryStdGridOutbound)SalaryStandardCacheHelper.getCache().get(key, SalaryStdGridOutbound.class);
    }

    public static void putLittleContrastSetGridData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(LITTLE_CONTRAST_SET_GRID_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, obj);
    }

    public static ContrastDataOutbound getLittleContrastSetGridData(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(LITTLE_CONTRAST_SET_GRID_PREFIX, pageId);
        return (ContrastDataOutbound)SalaryStandardCacheHelper.getCache().get(key, ContrastDataOutbound.class);
    }

    public static void putAllContrastSetGridData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(ALL_CONTRAST_SET_GRID_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, obj);
    }

    public static ContrastDataOutbound getAllContrastSetGridData(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(ALL_CONTRAST_SET_GRID_PREFIX, pageId);
        return (ContrastDataOutbound)SalaryStandardCacheHelper.getCache().get(key, ContrastDataOutbound.class);
    }

    public static void putGradeRankKeyData(String pageId, Object data) {
        String key = SalaryStandardCacheHelper.generateKey(GRADE_RANK_KEY_DATA_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, data);
    }

    public static GradeRankKeyOutbound getGradeRankKeyData(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(GRADE_RANK_KEY_DATA_PREFIX, pageId);
        return (GradeRankKeyOutbound)SalaryStandardCacheHelper.getCache().get(key, GradeRankKeyOutbound.class);
    }

    public static void putStdGridPageId(String pageId, Object data) {
        String key = SalaryStandardCacheHelper.generateKey(STD_GRID_PAGE_ID_KEY, pageId);
        SalaryStandardCacheHelper.getCache().put(key, data);
        String localKey = SalaryStandardCacheHelper.generateLocalKey(STD_GRID_PAGE_ID_KEY, pageId, RequestContext.get().getRequestId());
        localCache.put(localKey, data);
    }

    public static String getStdGridPageId(String pageId) {
        String localKey = SalaryStandardCacheHelper.generateLocalKey(STD_GRID_PAGE_ID_KEY, pageId, RequestContext.get().getRequestId());
        String gridPageId = (String)localCache.get(localKey);
        if (gridPageId == null) {
            String gridPageIdKey = SalaryStandardCacheHelper.generateKey(STD_GRID_PAGE_ID_KEY, pageId);
            gridPageId = (String)SalaryStandardCacheHelper.getCache().get(gridPageIdKey, String.class);
            if (gridPageId != null) {
                localCache.put(localKey, gridPageId);
            }
        }
        return gridPageId;
    }

    public static void putGradeRankContrastSetGridData(String pageId, Object obj) {
        String key = SalaryStandardCacheHelper.generateKey(GRADE_RANK_CONTRAST_SET_GRID_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().put(key, obj);
    }

    public static ContrastDataOutbound getContrastSetGridDataWithGradeRank(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(GRADE_RANK_CONTRAST_SET_GRID_PREFIX, pageId);
        return (ContrastDataOutbound)SalaryStandardCacheHelper.getCache().get(key, ContrastDataOutbound.class);
    }

    public static void clearCache(String pageId) {
        String key1 = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_ENTRY_DATA_PREFIX, pageId);
        String key2 = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_GRID_PREFIX, pageId);
        String key3 = SalaryStandardCacheHelper.generateKey(LITTLE_CONTRAST_SET_GRID_PREFIX, pageId);
        String key4 = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_LASTCALC_ENTRY_DATA_PREFIX, pageId);
        SalaryStandardCacheHelper.getCache().remove(key1);
        SalaryStandardCacheHelper.getCache().remove(key2);
        SalaryStandardCacheHelper.getCache().remove(key3);
        SalaryStandardCacheHelper.getCache().remove(key4);
        SalaryStandardCacheHelper.clearLocalCache(pageId);
    }

    private static void clearLocalCache(String pageId) {
        for (Map.Entry<String, Object> entry : localCache.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split(CACHE_KEY_SEPARATOR);
            if (split.length < 2 || !SWCStringUtils.equals((String)split[1], (String)pageId)) continue;
            localCache.remove(key);
        }
    }

    private static String generateKey(String prefix, String pageId) {
        return String.format("%s&%s", prefix, pageId);
    }

    public static void putSecondPageId(String pageId, String secondPageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_SECOND_PAGE_ID, pageId);
        SalaryStandardCacheHelper.getCache().put(key, (Object)secondPageId);
    }

    public static String getSecondPageId(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_SECOND_PAGE_ID, pageId);
        return (String)SalaryStandardCacheHelper.getCache().get(key, String.class);
    }

    public static void putFourthPageId(String pageId, String secondPageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_FOURTH_PAGE_ID, pageId);
        SalaryStandardCacheHelper.getCache().put(key, (Object)secondPageId);
    }

    public static String getFourthPageId(String pageId) {
        String key = SalaryStandardCacheHelper.generateKey(SALARY_STANDARD_FOURTH_PAGE_ID, pageId);
        return (String)SalaryStandardCacheHelper.getCache().get(key, String.class);
    }
}

