/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;

public class SalaryStandardComparator {

    static class StdDataComparatorWithGradeIdx
    implements Comparator<SalaryStdDataEntity> {
        private Map<Long, SalaryGradeEntity> gradeMap;

        public StdDataComparatorWithGradeIdx(Map<Long, SalaryGradeEntity> gradeMap) {
            this.gradeMap = gradeMap;
        }

        @Override
        public int compare(SalaryStdDataEntity o1, SalaryStdDataEntity o2) {
            SalaryGradeEntity o1Grade = this.gradeMap.get(o1.getGradeIdentity());
            SalaryGradeEntity o2Grade = this.gradeMap.get(o2.getGradeIdentity());
            if (o1Grade == null || o2Grade == null) {
                return 0;
            }
            return o1Grade.getGradeIndex() - o2Grade.getGradeIndex();
        }
    }

    static class StdDataComparatorWithRankIdx
    implements Comparator<SalaryStdDataEntity> {
        private Map<Long, SalaryRankEntity> rankMap;

        public StdDataComparatorWithRankIdx(Map<Long, SalaryRankEntity> rankMap) {
            this.rankMap = rankMap;
        }

        @Override
        public int compare(SalaryStdDataEntity o1, SalaryStdDataEntity o2) {
            SalaryRankEntity o1Rank = this.rankMap.get(o1.getRankIdentity());
            SalaryRankEntity o2Rank = this.rankMap.get(o2.getRankIdentity());
            int sum = o1Rank.getRankLabel().getIndex() - o2Rank.getRankLabel().getIndex();
            if (sum == 0) {
                sum = o1Rank.getRankIndex() - o2Rank.getRankIndex();
            }
            return sum;
        }
    }

    static class RankComparator
    implements Comparator<SalaryRankEntity> {
        RankComparator() {
        }

        @Override
        public int compare(SalaryRankEntity o1, SalaryRankEntity o2) {
            int sum = o1.getRankLabel().getIndex() - o2.getRankLabel().getIndex();
            if (sum == 0) {
                sum = o1.getRankIndex() - o2.getRankIndex();
            }
            return sum;
        }
    }

    static class ContrastDataWithPropComparator
    implements Comparator<ContrastDataEntity> {
        private List<Long> props;

        public ContrastDataWithPropComparator(List<Long> props) {
            this.props = props;
        }

        @Override
        public int compare(ContrastDataEntity o1, ContrastDataEntity o2) {
            int o1Index = this.props.indexOf(o1.getContrastPropConfId());
            int o2Index = this.props.indexOf(o2.getContrastPropConfId());
            int sum = o1Index - o2Index;
            if (o1Index == o2Index) {
                int o1SubIndex = o1.getSubIndex();
                int o2SubIndex = o2.getSubIndex();
                sum = o1SubIndex - o2SubIndex;
            }
            return sum;
        }
    }

    static class ContrastDataComparator
    implements Comparator<ContrastDataEntity> {
        ContrastDataComparator() {
        }

        @Override
        public int compare(ContrastDataEntity o1, ContrastDataEntity o2) {
            int o1RowIndex = o1.getRowIndex();
            int o2RowIndex = o2.getRowIndex();
            int o1SubIndex = o1.getSubIndex();
            int o2SubIndex = o2.getSubIndex();
            if (o1RowIndex != o2RowIndex) {
                return o1RowIndex - o2RowIndex;
            }
            return o1SubIndex - o2SubIndex;
        }
    }
}

