/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.common.entity.salarystandard.StdLabelBuildParam;
import kd.swc.hcdm.common.enums.LabelStyle;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;

public class SalaryStandardDrawLabelHelper {
    private static final String FLEX_ITEM = "flexItem";
    private static final String FLEX_USE_RANK = "flexUseRank";
    private static final String FLEX_USE_COUNT = "flexUseCount";
    private static final String FLEX_CONTRAST_PROP = "flexContrastProp";
    private static final LocaleString HEIGHT_LARGE = new LocaleString("20px");
    private static final LocaleString HEIGHT_SMALL = new LocaleString("20px");
    private static final String NONE_RADIUS = "0pxs";
    private static final String LBL_RADIUS = "9px";
    private static final String THEME_COLOR = "themeColor";
    private static final String LABEL_BALCK_COLOR = "#000000";
    private static final String LABEL_BACK_COLOR = "#ffffff";
    private static final int DEF_FONTSIZE = 12;
    private static final Margin margin = new Margin();
    private static final Padding padding = new Padding();

    public static void drawLabel(IFormView view, String flexKey, List<StdLabelBuildParam> labelParmList) {
        FlexPanelAp flex = new SWCFlexPanelAp.Builder(flexKey).build();
        for (StdLabelBuildParam labelParm : labelParmList) {
            Padding padding;
            Margin margin = labelParm.getMargin();
            if (margin == null) {
                margin = new Margin();
            }
            if ((padding = labelParm.getPadding()) == null) {
                padding = new Padding();
            }
            LabelAp label = ((SWCLabelAp.Builder)((SWCLabelAp.Builder)new SWCLabelAp.Builder(labelParm.getLabelKey()).setForeColor(labelParm.getForeColor()).setBackColor(labelParm.getBackColor()).setFontSize(12).setRadius(labelParm.getRadius()).setLabelStyle(labelParm.getLabelStyle().getValue()).setName(labelParm.getLabelShowName()).setHeight(labelParm.getHeight()).setMargin(margin.getTop(), margin.getRight(), margin.getBottom(), margin.getLeft())).setPadding(padding.getTop(), padding.getRight(), padding.getBottom(), padding.getLeft())).build();
            flex.getItems().add(label);
        }
        view.updateControlMetadata(flexKey, flex.createControl());
    }

    public static List<StdLabelBuildParam> buildItemLabelGenParm(List<SalaryStdItemEntity> salaryStdItemEntityList) {
        return salaryStdItemEntityList.stream().map(entity -> new StdLabelBuildParam(entity.getSalaryItemId().toString(), entity.getItemName(), FLEX_ITEM, LabelStyle.BLOCK, NONE_RADIUS, "#666666", LABEL_BACK_COLOR, null, HEIGHT_LARGE, margin, padding)).collect(Collectors.toList());
    }

    public static List<StdLabelBuildParam> buildUseRankItemLabelGenParm(List<SalaryStdItemEntity> salaryStdItemEntityList) {
        return salaryStdItemEntityList.stream().filter(entity -> entity.getItemIsUseSalaryRank() > 0).map(entity -> new StdLabelBuildParam(entity.getSalaryItemId().toString(), entity.getItemName(), FLEX_USE_RANK, LabelStyle.BLOCK, NONE_RADIUS, "#666666", LABEL_BACK_COLOR, null, HEIGHT_SMALL, margin, padding)).collect(Collectors.toList());
    }

    public static List<StdLabelBuildParam> buildUseCountItemLabelGenParm(List<SalaryStdItemEntity> salaryStdItemEntityList) {
        return salaryStdItemEntityList.stream().filter(entity -> entity.getItemIsUseSalaryCount() > 0).map(entity -> new StdLabelBuildParam(entity.getSalaryItemId().toString(), entity.getItemName(), FLEX_USE_COUNT, LabelStyle.BLOCK, NONE_RADIUS, "#666666", LABEL_BACK_COLOR, null, HEIGHT_SMALL, margin, padding)).collect(Collectors.toList());
    }

    public static List<StdLabelBuildParam> buildContrastpsLabelGenParm(List<ContrastPropEntity> contrastpsEntryList) {
        return contrastpsEntryList.stream().map(entity -> new StdLabelBuildParam(entity.getPropConfigId().toString(), entity.getPropConfigEntity().getName(), FLEX_CONTRAST_PROP, LabelStyle.BLOCK, LBL_RADIUS, "#666666", LABEL_BACK_COLOR, null, HEIGHT_SMALL, margin, padding)).collect(Collectors.toList());
    }

    static {
        margin.setRight("12px");
        margin.setTop("5px");
        margin.setBottom("5px");
        padding.setTop("1px");
        padding.setRight("8px");
        padding.setBottom("1px");
        padding.setLeft("8px");
    }
}

