/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.swc.hcdm.business.SalaryStandardCreatePkService;
import kd.swc.hcdm.business.salarystandard.validator.StdDesignerCompleteValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdDesignerMustInputValidator;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryStandardImportHelper {
    public static final String PROPERTY = "property";
    public static final String ALIAS = "alias";
    public static final String SHEET_NAME = "sheetName";
    public static final String JOB_LEVEL_SCM_NUMBER = "joblevelscm.number";
    public static final String JOB_LEVEL_SCM_NAME = "joblevelscm.name";
    public static final String JOB_GRADE_SCM_NUMBER = "jobgradescm.number";
    public static final String JOB_GRADE_SCM_NAME = "jobgradescm.name";

    public static ValidatorTree getMustInputValidatorTreeForDesign(ValidateContext<SalaryStandardEntryData> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode mustInputNode = new ValidatorTree.ValidatorNode(new StdDesignerMustInputValidator(validateContext, ErrorLevel.FatalError));
        ValidatorTree.ValidatorNode completeNode = new ValidatorTree.ValidatorNode(new StdDesignerCompleteValidator(validateContext, ErrorLevel.FatalError));
        tree.addNode(tree.getRoot(), mustInputNode);
        tree.addNode(mustInputNode, completeNode);
        return tree;
    }

    public static Map<Integer, String> getEntryFiledId(Map<String, KeyValue> captions) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        int i1 = 0;
        for (String key : captions.keySet()) {
            result.put(i1, key);
            ++i1;
        }
        return result;
    }

    public static List<Map<Integer, String>> getEntryHeadStructs(String[][] strArray) {
        ArrayList<Map<Integer, String>> resultList = new ArrayList<Map<Integer, String>>(strArray.length);
        for (int i = 0; i < strArray.length; ++i) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(strArray[i].length);
            for (int j = 0; j < strArray[i].length; ++j) {
                if (null == strArray[i][j]) continue;
                map.put(j, strArray[i][j]);
            }
            resultList.add(map);
        }
        return resultList;
    }

    public static Map<Integer, String> getGradeDataFromEntry(DynamicObjectCollection entryEntity, int height) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(entryEntity.size());
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        for (int i = 0; i < entryEntity.size(); ++i) {
            String gradeName = ((DynamicObject)entryEntity.get(i)).getString(gradeFieldKey);
            result.put(i + height, gradeName);
        }
        return result;
    }

    public static Map<Integer, String> getGradeDataFromExcel(List<Map<Integer, String>> rowDatas, int headHeight) {
        int colIndex = 0;
        HashMap<Integer, String> result = new HashMap<Integer, String>(rowDatas.size());
        for (int i = 0; i < rowDatas.size(); ++i) {
            result.put(i + headHeight, rowDatas.get(i).get(colIndex));
        }
        return result;
    }

    public static boolean isEqualCollection(List<Map<Integer, String>> beCompareList, List<Map<Integer, String>> compareList) {
        if (null == beCompareList || null == compareList || beCompareList.size() != compareList.size()) {
            return false;
        }
        for (int i = 0; i < beCompareList.size(); ++i) {
            if (SalaryStandardImportHelper.chekMapEqual(beCompareList.get(i), compareList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean chekMapEqual(Map<Integer, String> map, Map<Integer, String> beCompareMap) {
        if (map.size() != beCompareMap.size()) {
            return false;
        }
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String m2value;
            String m1value = entry.getValue() == null ? "" : entry.getValue();
            if (m1value.equals(m2value = beCompareMap.get(entry.getKey()) == null ? "" : beCompareMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> getEntryColumnsFromMeta(Map<String, Object> metas, String entryKey) {
        String id = (String)metas.get("id");
        if (SWCStringUtils.equals((String)entryKey, (String)id)) {
            return (List)metas.get("columns");
        }
        List items = (List)metas.get("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (Map item : items) {
                List<Map<String, Object>> res = SalaryStandardImportHelper.getEntryColumnsFromMeta(item, entryKey);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static String generateTemplateName(List<String> list, SalaryStandardTypeEnum type) {
        StringJoiner sj = null;
        sj = type == SalaryStandardTypeEnum.SALARYCOUNT ? new StringJoiner("\u3001", "\uff08", "\uff09") : new StringJoiner(":", "\uff08", "\uff09");
        for (String str : list) {
            sj.add(str);
        }
        return sj.toString();
    }

    public static String getTemplateFirstName(SalaryStandardEntryData stdData) {
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        SalaryStandardTypeEnum type = stdBaseEntity.getType();
        CalculationMethodEnum calcMethod = stdBaseEntity.getCalcMethod();
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)3);
        if (SalaryStandardTypeEnum.SALARYCOUNT == type) {
            nameList.add(SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME());
            if (stdBaseEntity.isUseSalaryCount()) {
                nameList.add(SalaryStandardConstants.FORM_STATIC_RANK_FIELD_NAME());
            }
            if (stdBaseEntity.isUseSalaryCount()) {
                String salaryCount = SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getI18nName().loadKDString();
                nameList.add(salaryCount);
            }
        } else if (SalaryStandardTypeEnum.BROADBAND == type) {
            nameList.add(SalaryStandardConstants.CALCULATION_METHOD());
            nameList.add(calcMethod.getI18nName().loadKDString());
        }
        String suffixName = SalaryStandardImportHelper.generateTemplateName(nameList, type);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868", (String)"SalaryStandardImportHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0])).append('-');
        sb.append(type.getI18nName().loadKDString());
        sb.append(suffixName);
        return sb.toString();
    }

    public static DynamicObjectCollection queryEntityDataByNameOrNumber(Collection<String> param, MulBasedataProp property, QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(property.getBaseEntityId());
        String displayProp = property.getDisplayProp();
        QFilter qFilter = new QFilter(displayProp, "in", param);
        qFilter.and(filter);
        return helper.queryOriginalCollection("id," + displayProp, new QFilter[]{qFilter});
    }

    public static Map<String, List<DynamicObject>> groupByName(DynamicObjectCollection coll) {
        return coll.stream().collect(Collectors.groupingBy(dy -> dy.getString("name")));
    }

    public static List<Long> getPkIdFromDynamicObject(DynamicObjectCollection objs) {
        return objs.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
    }

    public static List<ContrastDataEntity> fetchContrastDataEntityFromDyObj(String fieldKey, DynamicObjectCollection datas, int rowindex, Long contrastPropConfId) {
        List<Long> pkIds = SalaryStandardImportHelper.getPkIdFromDynamicObject(datas);
        ArrayList<ContrastDataEntity> resultList = new ArrayList<ContrastDataEntity>(datas.size());
        SalaryStandardCreatePkService createPkService = new SalaryStandardCreatePkService();
        long[] longs = createPkService.genEntPkByTime(pkIds.size());
        int subIndex = 0;
        for (Long contrastPropValue : pkIds) {
            ContrastDataEntity contrastDataEntity = new ContrastDataEntity(Long.valueOf(0L), Long.valueOf(0L), contrastPropConfId, contrastPropValue, rowindex, subIndex, ContrastPropLabelEnum.STANDARD);
            contrastDataEntity.setContrastIdentity(Long.valueOf(longs[subIndex]));
            resultList.add(contrastDataEntity);
            ++subIndex;
        }
        return resultList;
    }

    public static List<Map<String, Object>> geEntryColumns(IFormView entryView) {
        return SWCExportEntryHelper.readRuntimeEntryColumn((IFormView)entryView, (String)"entryentity");
    }

    public static List<EntryColumnContainer> getEntryColumnContainers(List<Map<String, Object>> columns, Set<String> ignoreSet) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.convertToEntryColumnInfo(columns);
        List containers = wrapper.getContainers();
        SWCExportEntryHelper.removeIgnoreColumn((List)containers, ignoreSet);
        return containers;
    }

    public static List<Map<Integer, String>> getSourceHeadData(List<EntryColumnContainer> containers, int headHeight, IDataModel model) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        Map<Integer, String> entryColId = SalaryStandardImportHelper.getEntryFiledId(captions);
        String[][] headArray = new String[headHeight][captions.size()];
        SWCExportEntryHelper.fillSheetHeadArray(containers, (String[][])headArray, (int)0, (int)0);
        List<Map<Integer, String>> headList = SalaryStandardImportHelper.getEntryHeadStructs(headArray);
        ArrayList dataHeadSource = Lists.newArrayListWithCapacity((int)(headHeight + 1));
        dataHeadSource.add(entryColId);
        dataHeadSource.addAll(headList);
        return dataHeadSource;
    }

    private static void fillFieldMustInputSign(List<EntryColumnContainer> containers, IDataModel model) {
        for (EntryColumnContainer container : containers) {
            IDataEntityProperty property;
            Object value;
            if (container.getType() == EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode() && (value = ReflectUtils.getFieldValue((String)"mustInput", (Object)(property = model.getProperty(container.getKey())))) != null && ((Boolean)value).booleanValue()) {
                LocaleString header = container.getHeader();
                header.setLocaleValue("*" + header.getLocaleValue());
            }
            if (container.getType() != EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode()) continue;
            SalaryStandardImportHelper.fillFieldMustInputSign(container.getChild(), model);
        }
    }

    public static int getRowDataSize(List<Map<Integer, String>> dataRow) {
        int size = 0;
        for (Map<Integer, String> rowMap : dataRow) {
            if (rowMap.size() <= 1) continue;
            ++size;
        }
        return size;
    }

    public static Map<String, Object> getPropertiesMap(String title, String[] propertyName, String[] propertyAlias) {
        HashMap<String, Object> propertie = new HashMap<String, Object>(2);
        List<String> property = Arrays.asList(propertyName);
        propertie.put(PROPERTY, property);
        propertie.put(SHEET_NAME, title);
        List<String> alias = Arrays.asList(propertyAlias);
        propertie.put(ALIAS, alias);
        return propertie;
    }

    public static Map<String, Object> getPropertiesMap(String entityName, String title, String queryFields) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = title;
        if (StringUtils.isBlank((CharSequence)title)) {
            localeValue = entityCaption.getLocaleValue();
        }
        HashMap<String, Object> propertie = new HashMap<String, Object>(3);
        String[] fields = queryFields.split(",");
        Map allFields = mainEntityType.getAllFields();
        ArrayList alias = Lists.newArrayListWithExpectedSize((int)fields.length);
        for (String field : fields) {
            if ("id".equals(field)) continue;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(field);
            String displayName = "";
            if (iDataEntityProperty != null) {
                displayName = iDataEntityProperty.getDisplayName().toString();
            }
            if ("number".equals(field) || "name".equals(field)) {
                if (SWCStringUtils.equals((String)entityName, (String)"haos_projectteamhr") || SWCStringUtils.equals((String)entityName, (String)"hbpm_positionhr") || SWCStringUtils.equals((String)entityName, (String)"hbpm_stposition")) {
                    alias.add(displayName);
                    continue;
                }
                alias.add(localeValue + displayName);
                continue;
            }
            if (SWCStringUtils.equals((String)entityName, (String)"hbjm_joblevelhr")) {
                if (JOB_LEVEL_SCM_NUMBER.equals(field)) {
                    displayName = ResManager.loadKDString((String)"\u804c\u7ea7\u65b9\u6848\u7f16\u7801", (String)"SalaryStandardImportHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
                } else if (JOB_LEVEL_SCM_NAME.equals(field)) {
                    displayName = ResManager.loadKDString((String)"\u804c\u7ea7\u65b9\u6848\u540d\u79f0", (String)"SalaryStandardImportHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
                }
            } else if (SWCStringUtils.equals((String)entityName, (String)"hbjm_jobgradehr")) {
                if (JOB_GRADE_SCM_NUMBER.equals(field)) {
                    displayName = ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u7f16\u7801", (String)"SalaryStandardImportHelper_3", (String)"swc-hcdm-business", (Object[])new Object[0]);
                } else if (JOB_GRADE_SCM_NAME.equals(field)) {
                    displayName = ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u540d\u79f0", (String)"SalaryStandardImportHelper_4", (String)"swc-hcdm-business", (Object[])new Object[0]);
                }
            }
            alias.add(displayName);
        }
        List<String> property = Arrays.asList(fields);
        List removedIdList = property.stream().filter(o1 -> !o1.equals("id")).collect(Collectors.toList());
        propertie.put(PROPERTY, removedIdList);
        propertie.put(SHEET_NAME, localeValue);
        propertie.put(ALIAS, alias);
        return propertie;
    }

    public static int getMaxRow(String key) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_standerdnamedes");
        if (dataEntityType.getProperties().containsKey((Object)key)) {
            DecimalProp prop = (DecimalProp)dataEntityType.getProperty(key);
            return prop.getMax().intValue();
        }
        return 200;
    }
}

