/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.SalaryStandardCreatePkService;
import kd.swc.hcdm.business.SalaryStandardDeleteEntHelper;
import kd.swc.hcdm.business.salarystandard.ContrastRelationSettingGridHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.StdTabValSetHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntity;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.filter.FilterParam;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataOutbound;
import kd.swc.hcdm.common.enums.FilterParamCompareType;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryStandardPageInteractionHelper {
    private static SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);

    public static void deleteItemEnt(AbstractFormDataModel model, List<Long> delItems) {
        DynamicObjectCollection salaryStdItems = model.getEntryEntity("salarystditem");
        HashSet delItemEntIndexs = Sets.newHashSetWithExpectedSize((int)16);
        HashSet delDataEntIds = Sets.newHashSetWithExpectedSize((int)16);
        for (int i = 0; i < salaryStdItems.size(); ++i) {
            DynamicObject salaryStdItem = (DynamicObject)salaryStdItems.get(i);
            if (!SalaryItemLabelEnum.STANDARD.name().equals(salaryStdItem.getString("itemlabel"))) continue;
            long salaryStdItemId = salaryStdItem.getLong("salaryitem.id");
            long itemId = salaryStdItem.getLong("itemidentity");
            if (salaryStdItemId != 0L && !delItems.contains(salaryStdItemId)) continue;
            delItemEntIndexs.add(i);
            delDataEntIds.add(itemId);
        }
        int[] dataIndexs = delItemEntIndexs.stream().mapToInt(Number::intValue).toArray();
        model.beginInit();
        if (dataIndexs.length > 0) {
            model.deleteEntryRows("salarystditem", dataIndexs);
        }
        if (SalaryStandardPageInteractionHelper.checkHasFixedItem(delItems)) {
            delDataEntIds.add(SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL);
        }
        delDataEntIds.add(SalaryStandardConstants.S_ITEM_TOTAL);
        SalaryStandardPageInteractionHelper.deleteDataEntByItemId(model, delDataEntIds);
        model.endInit();
    }

    private static boolean checkHasFixedItem(List<Long> delItems) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_standarditem");
        QFilter fixedFilter = new QFilter("fixeditem", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("id", "in", delItems);
        QFilter[] filters = new QFilter[]{idFilter, fixedFilter};
        return helper.isExists(filters);
    }

    public static void batchAddNewSalaryStdItems(AbstractFormDataModel model, List<Long> addItems) {
        String type = (String)model.getValue("type");
        if (SWCStringUtils.isEmpty((String)type)) {
            type = SalaryStandardTypeEnum.SALARYCOUNT.getCode();
        }
        DynamicObjectCollection salaryStdItems = model.getEntryEntity("salarystditem");
        Boolean isUseRank = (Boolean)model.getValue("isusesalaryrank");
        Boolean isUseCount = (Boolean)model.getValue("isusesalarycount");
        int index = salaryStdItems.size() + 1;
        TableValueSetter setter = StdTabValSetHelper.getSalaryStdItemSetter(type, index, isUseRank, isUseCount, addItems);
        model.beginInit();
        model.batchCreateNewEntryRow("salarystditem", setter);
        model.endInit();
    }

    public static void resetSalaryStdItemsIndex(DynamicObjectCollection salaryStdItems) {
        SalaryStandardPageInteractionHelper.resetEntIndex(salaryStdItems, "itemindex");
    }

    public static void updateSalaryRankToEnt(AbstractFormDataModel model, List<SalaryStandardEntryEntity> addNewEntityList, Map<Long, SalaryStandardEntryEntity> salaryRankEntityMap) {
        DynamicObjectCollection salaryRankEnts = model.getDataEntity(true).getDynamicObjectCollection("salaryrank");
        Iterator salaryRankEntIt = salaryRankEnts.iterator();
        HashSet deleteRankIds = Sets.newHashSetWithExpectedSize((int)16);
        Long firstRowId = null;
        while (salaryRankEntIt.hasNext()) {
            DynamicObject salaryRankEnt = (DynamicObject)salaryRankEntIt.next();
            long salaryRankId = salaryRankEnt.getLong("rankidentity");
            boolean isSysPreSet = salaryRankEnt.getBoolean("rankissyspreset");
            SalaryRankLabelEnum rankLabelEnum = SalaryRankLabelEnum.valueOf((String)salaryRankEnt.getString("ranklabel"));
            if (rankLabelEnum != SalaryRankLabelEnum.STANDARD) continue;
            if (isSysPreSet) {
                firstRowId = salaryRankEnt.getLong("rankidentity");
                salaryRankEntIt.remove();
                continue;
            }
            SalaryStandardEntryEntity newSalaryRankEntity = salaryRankEntityMap.get(salaryRankId);
            if (newSalaryRankEntity != null) {
                SalaryStandardPageInteractionHelper.setSalaryRankEnt(salaryRankEnt, newSalaryRankEntity);
                continue;
            }
            deleteRankIds.add(salaryRankId);
            salaryRankEntIt.remove();
        }
        if (!addNewEntityList.isEmpty()) {
            SalaryStandardPageInteractionHelper.addNewToSalaryRankEnt(model, addNewEntityList, firstRowId);
        }
        SalaryStandardPageInteractionHelper.setGradeRankSeqMap(model, "salaryrank", false);
        if (!deleteRankIds.isEmpty()) {
            SalaryStandardPageInteractionHelper.deleteDataEntByRank(model, deleteRankIds);
        }
        int rankNum = EntityConverter.dynamicObjToSalaryRankEntity(model.getEntryEntity("salaryrank"), 0L, null, true).size();
        int gradeNum = model.getEntryRowCount("salarygrade");
        SalaryStandardPageInteractionHelper.resetContrastRangeData((IDataModel)model, rankNum, gradeNum);
    }

    private static void deleteDataEntByItemId(AbstractFormDataModel model, Set<Long> delDataEntIds) {
        DynamicObjectCollection datas = model.getDataEntity(true).getDynamicObjectCollection("salarystddata_a");
        String gradeRankSeqMapStr = model.getDataEntity().getString("graderankseqmap");
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        SalaryStandardDeleteEntHelper.deleteStdData(datas, "salarystditemid", delDataEntIds, true, service.reverseGradeRankSeqMap(gradeRankSeqMap), null);
    }

    private static void deleteDataEntByRank(AbstractFormDataModel model, Set<Long> deleteRankIds) {
        DynamicObjectCollection datas = model.getDataEntity(true).getDynamicObjectCollection("salarystddata_a");
        model.beginInit();
        String gradeRankSeqMapStr = model.getDataEntity().getString("graderankseqmap");
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        SalaryStandardDeleteEntHelper.deleteStdData(datas, "salarydatarank", deleteRankIds, true, service.reverseGradeRankSeqMap(gradeRankSeqMap), null);
        model.endInit();
    }

    public static void resetContrastRangeData(IDataModel model, int rankNum, int gradeNum) {
        DynamicObjectCollection contrastRows = model.getEntryEntity("contrastsumdata");
        boolean needUpdateContrastEnt = false;
        for (DynamicObject contrastRow : contrastRows) {
            String graderankrange = contrastRow.getString("graderankrange");
            GradeRankRangeDBEntity rangeEntity = ContrastRowDataEntity.deserializeGradeRank((String)graderankrange);
            if (rangeEntity == null || !StringUtils.isNotBlank((CharSequence)rangeEntity.getRangeCodeString())) continue;
            needUpdateContrastEnt = true;
            List<GradeRankValue> gradeRankValues = GradeRankHelper.resetRangeCodeWithNewCarryBit(rangeEntity.getRuntimeRangeCodeArr(), rangeEntity.getRankNum(), rankNum, gradeNum);
            rangeEntity.setRangeCodeArr(gradeRankValues);
            rangeEntity.setRankNum(Integer.valueOf(rankNum));
            rangeEntity.setGradeNum(Integer.valueOf(gradeNum));
            contrastRow.set("graderankrange", (Object)ContrastRowDataEntity.serializeGradeRank((GradeRankRangeDBEntity)rangeEntity));
        }
        if (needUpdateContrastEnt) {
            model.updateEntryCache(contrastRows);
        }
    }

    private static void deleteDataEntByGrade(AbstractFormDataModel model, Set<Long> deleteGradeIds) {
        DynamicObjectCollection datas = model.getDataEntity(true).getDynamicObjectCollection("salarystddata_a");
        String gradeRankSeqMapStr = model.getDataEntity().getString("graderankseqmap");
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        SalaryStandardDeleteEntHelper.deleteStdData(datas, "salarydatagrade", deleteGradeIds, true, service.reverseGradeRankSeqMap(gradeRankSeqMap), null);
        int rankNum = EntityConverter.dynamicObjToSalaryRankEntity(model.getEntryEntity("salaryrank"), 0L, null, true).size();
        int gradeNum = model.getEntryRowCount("salarygrade");
        SalaryStandardPageInteractionHelper.resetContrastRangeData((IDataModel)model, rankNum, gradeNum);
    }

    private static void addNewToSalaryRankEnt(AbstractFormDataModel model, List<SalaryStandardEntryEntity> addNewEntityList, Long firstRowId) {
        String entryEntityName = "salaryrank";
        int count = firstRowId == null ? addNewEntityList.size() : addNewEntityList.size() - 1;
        SalaryStandardCreatePkService service = new SalaryStandardCreatePkService();
        long[] genIds = service.genEntPkByTime(count);
        ArrayList<Long> idList = new ArrayList<Long>(addNewEntityList.size());
        if (firstRowId != null) {
            idList.add(firstRowId);
        }
        long[] lArray = genIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long genId = lArray[i];
            idList.add(genId);
        }
        long[] ids = idList.stream().mapToLong(Long::longValue).toArray();
        TableValueSetter setter = StdTabValSetHelper.getSalaryRankTableSetter(ids, addNewEntityList);
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntityName, setter);
        model.endInit();
    }

    public static void setNewListAndUpdateMap(List<SalaryStandardEntryEntity> entityList, List<SalaryStandardEntryEntity> addNewEntityList, Map<Long, SalaryStandardEntryEntity> salaryRankEntityMap) {
        for (SalaryStandardEntryEntity entity : entityList) {
            Long id = entity.getId();
            if (id == null || id.equals(0L)) {
                addNewEntityList.add(entity);
                continue;
            }
            salaryRankEntityMap.put(id, entity);
        }
    }

    public static void updateSalaryGradeToEnt(AbstractFormDataModel model, List<SalaryStandardEntryEntity> addNewEntityList, Map<Long, SalaryStandardEntryEntity> entityMap) {
        DynamicObjectCollection salaryGradeEnts = model.getDataEntity(true).getDynamicObjectCollection("salarygrade");
        Iterator salaryGradeEntIt = salaryGradeEnts.iterator();
        HashSet deleteGradeIds = Sets.newHashSetWithExpectedSize((int)16);
        while (salaryGradeEntIt.hasNext()) {
            DynamicObject salaryGradeEnt = (DynamicObject)salaryGradeEntIt.next();
            long salaryGradeId = salaryGradeEnt.getLong("gradeidentity");
            SalaryStandardEntryEntity newSalaryGradeEntity = entityMap.get(salaryGradeId);
            if (newSalaryGradeEntity != null) {
                SalaryStandardPageInteractionHelper.setSalaryGradeEnt(salaryGradeEnt, newSalaryGradeEntity);
                continue;
            }
            salaryGradeEntIt.remove();
            deleteGradeIds.add(salaryGradeId);
        }
        model.beginInit();
        if (!addNewEntityList.isEmpty()) {
            SalaryStandardPageInteractionHelper.addNewToSalaryGradeEnt(addNewEntityList, model);
        }
        SalaryStandardPageInteractionHelper.setGradeRankSeqMap(model, "salarygrade", false);
        if (!deleteGradeIds.isEmpty()) {
            SalaryStandardPageInteractionHelper.deleteDataEntByGrade(model, deleteGradeIds);
        }
        model.endInit();
    }

    private static void addNewToSalaryGradeEnt(List<SalaryStandardEntryEntity> addNewEntityList, AbstractFormDataModel model) {
        String entryEntityName = "salarygrade";
        int size = addNewEntityList.size();
        SalaryStandardCreatePkService service = new SalaryStandardCreatePkService();
        long[] ids = service.genEntPkByTime(size);
        TableValueSetter setter = StdTabValSetHelper.getSalaryGradeTableSetter(ids, addNewEntityList);
        model.batchCreateNewEntryRow(entryEntityName, setter);
    }

    public static void setGradeRankSeqMap(AbstractFormDataModel model, String entityKey, boolean isSaveOp) {
        String gradeRankSeqMapStr = (String)model.getValue("graderankseqmap");
        Map<String, Map<Long, Integer>> gradeRankSeqMap = SalaryStandardPageInteractionHelper.getGradeRankSeqMap(gradeRankSeqMapStr, model.getEntryEntity(entityKey), "salarygrade".equals(entityKey), isSaveOp);
        model.setValue("graderankseqmap", (Object)JSON.toJSONString(gradeRankSeqMap));
    }

    public static Map<String, Map<Long, Integer>> getGradeRankSeqMap(String gradeRankSeqMapStr, DynamicObjectCollection gradeOrRankDyColl, boolean isGradeEnt, boolean isSaveOp) {
        String mapKey;
        HashMap<String, Map<Long, Integer>> gradeRankSeqMap = new HashMap<String, Map<Long, Integer>>(2);
        boolean isNeedToSave = StringUtils.isEmpty((CharSequence)gradeRankSeqMapStr);
        String idKey = isGradeEnt ? "gradeidentity" : "rankidentity";
        String string = mapKey = isGradeEnt ? "grade" : "rank";
        if (isNeedToSave) {
            HashMap gradeSeqMap = Maps.newHashMapWithExpectedSize((int)gradeOrRankDyColl.size());
            IntStream.range(0, gradeOrRankDyColl.size()).forEachOrdered(i -> {
                DynamicObject entObj = (DynamicObject)gradeOrRankDyColl.get(i);
                gradeSeqMap.put(entObj.getLong(idKey), i);
            });
            gradeRankSeqMap.put(mapKey, gradeSeqMap);
        } else {
            SalaryStandardPageInteractionHelper.updateGradeRankSeqMap(gradeOrRankDyColl, gradeRankSeqMap, gradeRankSeqMapStr, idKey, mapKey, isSaveOp);
        }
        return gradeRankSeqMap;
    }

    private static void updateGradeRankSeqMap(DynamicObjectCollection gradeOrRankDyColl, Map<String, Map<Long, Integer>> gradeRankSeqMap, String gradeRankSeqMapStr, String idKey, String mapKey, boolean isSaveOp) {
        JSONObject jsonObject = JSON.parseObject((String)gradeRankSeqMapStr);
        JSONObject gradeMap = jsonObject.getJSONObject(mapKey);
        if (gradeMap == null) {
            HashMap gradeSeqMap = Maps.newHashMapWithExpectedSize((int)gradeOrRankDyColl.size());
            IntStream.range(0, gradeOrRankDyColl.size()).forEachOrdered(i -> {
                DynamicObject entObj = (DynamicObject)gradeOrRankDyColl.get(i);
                gradeSeqMap.put(entObj.getLong(idKey), i);
            });
            gradeRankSeqMap.put(mapKey, gradeSeqMap);
        } else {
            HashMap gradeSeqMap;
            int maxIndex = -1;
            Collection indexs = gradeMap.values();
            if (indexs != null && !indexs.isEmpty()) {
                for (Object index : indexs) {
                    int i2;
                    if (!(index instanceof Integer) || (i2 = Integer.parseInt(index.toString())) <= maxIndex) continue;
                    maxIndex = i2;
                }
            }
            if (maxIndex == -1) {
                gradeSeqMap = Maps.newHashMapWithExpectedSize((int)gradeOrRankDyColl.size());
                IntStream.range(0, gradeOrRankDyColl.size()).forEachOrdered(i -> {
                    DynamicObject entObj = (DynamicObject)gradeOrRankDyColl.get(i);
                    gradeSeqMap.put(entObj.getLong(idKey), i);
                });
                gradeRankSeqMap.put(mapKey, gradeSeqMap);
            } else {
                gradeSeqMap = Maps.newHashMapWithExpectedSize((int)gradeOrRankDyColl.size());
                for (DynamicObject ent : gradeOrRankDyColl) {
                    String gradeIdentity = ent.getString(idKey);
                    Integer index = gradeMap.getInteger(gradeIdentity);
                    if (index != null) {
                        gradeSeqMap.put(ent.getLong(idKey), index);
                        continue;
                    }
                    gradeSeqMap.put(ent.getLong(idKey), ++maxIndex);
                }
                if (!isSaveOp) {
                    service.parseJsonToMap(gradeMap, gradeSeqMap);
                }
                gradeRankSeqMap.put(mapKey, gradeSeqMap);
            }
        }
        String otherMapKey = "grade".equals(mapKey) ? "rank" : "grade";
        JSONObject rankMap = jsonObject.getJSONObject(otherMapKey);
        if (rankMap != null) {
            HashMap rankSeqMap = Maps.newHashMapWithExpectedSize((int)gradeOrRankDyColl.size());
            service.parseJsonToMap(rankMap, rankSeqMap);
            gradeRankSeqMap.put(otherMapKey, rankSeqMap);
        }
    }

    private static void setSalaryGradeEnt(DynamicObject salaryGradeEnt, SalaryStandardEntryEntity newSalaryGradeEntity) {
        salaryGradeEnt.set("gradeindex", (Object)newSalaryGradeEntity.getIndex());
        salaryGradeEnt.set("gradename", (Object)newSalaryGradeEntity.getDisplayName());
        salaryGradeEnt.set("gradenumber", (Object)newSalaryGradeEntity.getDisplayName());
    }

    private static void setSalaryRankEnt(DynamicObject salaryRankEnt, SalaryStandardEntryEntity newSalaryRankEntity) {
        salaryRankEnt.set("rankindex", (Object)newSalaryRankEntity.getIndex());
        salaryRankEnt.set("rankname", (Object)newSalaryRankEntity.getDisplayName());
        salaryRankEnt.set("ranknumber", (Object)newSalaryRankEntity.getDisplayName());
        salaryRankEnt.set("ranklabel", (Object)SalaryRankLabelEnum.STANDARD.name());
        salaryRankEnt.set("rankisuserset", (Object)Boolean.TRUE);
        salaryRankEnt.set("rankissyspreset", (Object)Boolean.FALSE);
    }

    public static void preSetSalaryItemEnt(AbstractFormDataModel model) {
        SalaryStandardTypeEnum type = SalaryStandardTypeEnum.getFromCode((String)model.getDataEntity().getString("type"));
        List<SalaryStdItemEntity> items = SalaryStdItemHelper.getPresetItems(type);
        TableValueSetter setter = StdTabValSetHelper.getPreItemSetter(items);
        model.beginInit();
        model.batchCreateNewEntryRow("salarystditem", setter);
        model.endInit();
    }

    public static void preSetSalaryRankEnt(AbstractFormDataModel model) {
        DynamicObjectCollection ent = model.getEntityEntity("salaryrank");
        if (!CollectionUtils.isEmpty((Collection)ent)) {
            return;
        }
        SalaryStandardTypeEnum type = SalaryStandardTypeEnum.getFromCode((String)model.getDataEntity().getString("type"));
        List<SalaryRankEntity> presetRanks = GradeRankHelper.getPresetRanks(type);
        TableValueSetter setter = StdTabValSetHelper.getPreRankSetter(presetRanks);
        model.beginInit();
        model.batchCreateNewEntryRow("salaryrank", setter);
        model.endInit();
    }

    public static void deleteContrastpsEnt(IFormView view, List<Long> delIds) {
        IDataModel model = view.getModel();
        HashSet delContrastpsEntIndexs = Sets.newHashSetWithExpectedSize((int)16);
        HashSet<Long> delContrastpsIds = new HashSet<Long>(delIds);
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModelWithEntryName(model.getDataEntity(true), "contrastps", "contrastsumdata");
        List contrastPropEntities = entryData.getContrastPropEntities();
        List contrastRowEntities = entryData.getContrastRowEntities();
        int index = 0;
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            long contrastpsId = contrastPropEntity.getPropConfigId();
            if (delContrastpsIds.contains(contrastpsId)) {
                delContrastpsEntIndexs.add(index);
            }
            ++index;
        }
        Iterator iterator = contrastRowEntities.iterator();
        while (iterator.hasNext()) {
            ContrastRowDataEntity contrastRowEntity = (ContrastRowDataEntity)iterator.next();
            Map stdPropValueMap = contrastRowEntity.getStdPropValueMap();
            if (stdPropValueMap != null) {
                delIds.forEach(stdPropValueMap::remove);
            }
            if (!MapUtils.isEmpty((Map)stdPropValueMap)) continue;
            iterator.remove();
        }
        int[] dataIndexs = delContrastpsEntIndexs.stream().mapToInt(Number::intValue).toArray();
        model.beginInit();
        if (dataIndexs.length > 0) {
            model.deleteEntryRows("contrastps", dataIndexs);
        }
        if (!delContrastpsIds.isEmpty()) {
            ContrastRelationSettingGridHelper.updateToParentEntry(contrastRowEntities, view, true);
        }
        model.endInit();
    }

    @Deprecated
    private static void deleteContrastDataEnt(AbstractFormDataModel model, Set<Long> delContrastpsIds, Set<Integer> delContDataRowIndexs) {
    }

    public static void batchAddNewdeleteContrastpsEnt(AbstractFormDataModel model, List<Long> addIds) {
        String entryEntityName = "contrastps";
        DynamicObjectCollection salaryStdItems = model.getEntryEntity(entryEntityName);
        int index = salaryStdItems.size() + 1;
        TableValueSetter setter = StdTabValSetHelper.getContrastpsSetter(index, addIds);
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntityName, setter);
        model.endInit();
    }

    public static void resetContrastpsIndex(DynamicObjectCollection cols) {
        SalaryStandardPageInteractionHelper.resetEntIndex(cols, "pspropindex");
    }

    private static void resetEntIndex(DynamicObjectCollection cols, String field) {
        int i1 = 1;
        for (DynamicObject col : cols) {
            col.set(field, (Object)i1++);
        }
    }

    public static void deleteAndInsertSalaryStdDataEnt(IFormView mainPage, List<SalaryStdDataEntity> dataList, String gradeRankSeq) {
        AbstractFormDataModel model = (AbstractFormDataModel)mainPage.getModel();
        String entryName = "salarystddata_a";
        TableValueSetter setter = StdTabValSetHelper.getSalaryStdDataSetter(dataList, service.parseGradeRankSeqMap(gradeRankSeq));
        model.beginInit();
        model.deleteEntryData(entryName);
        model.batchCreateNewEntryRow(entryName, setter);
        model.updateEntryCache(model.getEntryEntity(entryName));
        model.endInit();
    }

    public static void updateSalaryStdDataEnt(IFormView mainPage, List<SalaryStdDataEntity> dataList) {
        AbstractFormDataModel model = (AbstractFormDataModel)mainPage.getModel();
        String entryName = "salarystddata_a";
        String gradeRankSeqMapStr = model.getDataEntity().getString("graderankseqmap");
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        List<SalaryStdDataEntity> allNewDataList = StdTabValSetHelper.mergeEntryRows(EntityConverter.dynamicObjToSalaryStdDataEntity(model.getEntityEntity(entryName), 0L, service.reverseGradeRankSeqMap(gradeRankSeqMap)), dataList);
        TableValueSetter setter = StdTabValSetHelper.getSalaryStdDataSetter(allNewDataList, gradeRankSeqMap);
        model.beginInit();
        model.deleteEntryData(entryName);
        model.batchCreateNewEntryRow(entryName, setter);
        model.endInit();
        mainPage.updateView("salarystddata_a");
    }

    @Deprecated
    public static void updateAllContrastpsDataEnt(AbstractFormDataModel model, ContrastDataOutbound contBound) {
    }

    @Deprecated
    public static void insertContrastpsDataEnt(AbstractFormDataModel model, List<ContrastDataEntity> contrastDataList) {
    }

    private static List<FilterParam<?>> buildContrastDataDelFilter(Long contrastPropConfId, int rowIndex) {
        ArrayList parms = new ArrayList(2);
        parms.add(new FilterParam("contrastpropconf.id", FilterParamCompareType.EQUALS, (Object)contrastPropConfId));
        parms.add(new FilterParam("rowindex", FilterParamCompareType.EQUALS, (Object)rowIndex));
        return parms;
    }

    public static void setSalaryRankItem(List<Long> useRankSalaryItemIds, DynamicObjectCollection salaryStdItems, List<Long> delDataItemIds) {
        for (DynamicObject salaryStdItem : salaryStdItems) {
            String itemlabel = salaryStdItem.getString("itemlabel");
            if (!SWCStringUtils.equals((String)SalaryItemLabelEnum.STANDARD.name(), (String)itemlabel)) continue;
            long salaryItemId = salaryStdItem.getLong("salaryitem.id");
            if (useRankSalaryItemIds.contains(salaryItemId)) {
                salaryStdItem.set("itemisusesalaryrank", (Object)Boolean.TRUE);
                continue;
            }
            salaryStdItem.set("itemisusesalaryrank", (Object)Boolean.FALSE);
            delDataItemIds.add(salaryStdItem.getLong("itemidentity"));
        }
    }

    public static void deleteStdUseRankData(DynamicObjectCollection salaryStdDatas, List<Long> needRetainedRankIds, List<Long> delDataItemIds, String gradeRankSeqMapStr) {
        Map<String, Map<Long, Integer>> gradeRankSeqMap = service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        Map<String, Map<Integer, Long>> seqGradeRankMap = service.reverseGradeRankSeqMap(gradeRankSeqMap);
        SalaryStandardDeleteEntHelper.deleteStdData(salaryStdDatas, "rankInItems", needRetainedRankIds, false, seqGradeRankMap, delDataItemIds);
    }

    public static void deleteRankEnt(DynamicObjectCollection salaryRanks, List<Long> retainRankIds) {
        FilterParam rankParm = new FilterParam("rankidentity", FilterParamCompareType.NOT_IN, retainRankIds);
        SalaryStandardDeleteEntHelper.deleteEntData(salaryRanks, rankParm);
    }

    public static void setFirstRankToDefault(DynamicObjectCollection salaryRanks, long firstRankId) {
        for (DynamicObject salaryRank : salaryRanks) {
            if (salaryRank.getLong("rankidentity") != firstRankId) continue;
            salaryRank.set("rankisuserset", (Object)Boolean.FALSE);
            salaryRank.set("rankissyspreset", (Object)Boolean.TRUE);
        }
    }

    private static Set<Long> getContrastDataIdByGradeId(DynamicObjectCollection contrastDataEnt, Set<Long> gradeIdSet) {
        return contrastDataEnt.stream().filter(object -> gradeIdSet.contains(object.getLong("contrastpropvalue"))).map(object -> object.getLong("contrastidentity")).collect(Collectors.toSet());
    }

    public static void deleteContrastDataByGradeId(DynamicObjectCollection contrastDataEnt, Set<Long> gradeIdSet) {
        Set<Long> delKeySet = SalaryStandardPageInteractionHelper.getContrastDataIdByGradeId(contrastDataEnt, gradeIdSet);
        ArrayList filters = new ArrayList(2);
        filters.add(new FilterParam("contrastidentity", FilterParamCompareType.IN, delKeySet));
        filters.add(new FilterParam("contrastparentidentity", FilterParamCompareType.IN, delKeySet));
        SalaryStandardDeleteEntHelper.deleteEntDataByFilterOr(contrastDataEnt, filters);
    }

    public static void deleteContrastRankData(DynamicObjectCollection contrastData, long firstRankId, boolean isSaveFirstRankId) {
        FilterParam rankParm = new FilterParam("contrastproplabel", FilterParamCompareType.EQUALS, (Object)ContrastPropLabelEnum.RANK.name());
        ArrayList params = new ArrayList(10);
        params.add(rankParm);
        if (isSaveFirstRankId) {
            FilterParam firstRankParm = new FilterParam("contrastpropvalue", FilterParamCompareType.NOT_EQUALS, (Object)firstRankId);
            params.add(firstRankParm);
        }
        SalaryStandardDeleteEntHelper.deleteEntDataByFilterAnd(contrastData, params);
    }
}

