/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.SalaryStdDataEntityKey;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryStandardViewHelper {
    public static final String HIGHLIGHTCOLOR = "rgba(85,130,243,0.1)";
    public static final int DEFAULT_PRECISION = 2;

    public static String getFieldLockStatus(int tableCanEdit, Boolean defaultLockStatus, int intervalPropNeedLock) {
        boolean needLock = tableCanEdit <= 0 || defaultLockStatus != false || intervalPropNeedLock > 0;
        return needLock ? "new,edit,view,submit,audit" : "";
    }

    public static boolean checkFieldHighLight(int tableCanEdit, Boolean defaultLockStatus, int intervalPropNeedLock) {
        return tableCanEdit == 1 && (defaultLockStatus != false || intervalPropNeedLock == 1);
    }

    public static List<IDataEntityProperty> findPropertyWithPrefix(List<IDataEntityProperty> properties, String prefix) {
        return properties.stream().filter(property -> property.getName().startsWith(prefix)).collect(Collectors.toList());
    }

    public static SalaryGradeEntity fetchGradeFromEntryRow(DynamicObject rowData, List<SalaryGradeEntity> gradeEntities) {
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        String gradeName = rowData.getString(gradeFieldKey);
        SalaryGradeEntity gradeEntity = GradeRankHelper.getGradeByName(gradeEntities, gradeName);
        return gradeEntity;
    }

    public static EntryAp createEntryAp(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        SalaryStdGridDisplayTypeEnum displayTypeEnum = DisplayParamHelper.checkGridTypeByCode(stdData.getDisplayParam().getDisplayGradeStyle());
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.GROUPITEMS) {
            return EntryParamContainerHelper.createEntryApForGroupItem(entityMetadata, stdData);
        }
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.TABULAR) {
            return EntryParamContainerHelper.createEntryApForTabular(entityMetadata, stdData);
        }
        return EntryParamContainerBaseHelper.createEntryAp((String)"entryentity");
    }

    public static void registerProperty(SalaryStandardEntryData stdData, EntryType entryType, IDataEntityProperty entryProperty, Object rowIndexObj) {
        SalaryStdGridDisplayTypeEnum displayTypeEnum = DisplayParamHelper.checkGridTypeByCode(stdData.getDisplayParam().getDisplayGradeStyle());
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.GROUPITEMS) {
            if (null != rowIndexObj) {
                SalaryStandardViewHelper.setEntryName(entryType, entryProperty, SalaryStandardConstants.PREVIEW_STYLE_SECOND());
            } else {
                SalaryStandardViewHelper.setEntryName(entryType, entryProperty, SalaryStandardConstants.SALARYSTD_DESIGN());
            }
            SalaryStandardViewHelper.registerPropertyForGroupItem(stdData, entryType);
        } else if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.TABULAR) {
            SalaryStandardViewHelper.setEntryName(entryType, entryProperty, SalaryStandardConstants.PREVIEW_STYLE_FIRST());
            SalaryStandardViewHelper.registerPropertyForTabular(stdData, entryType);
        }
    }

    private static void setEntryName(EntryType entryType, IDataEntityProperty entryProperty, String entryDisplayName) {
        entryType.setDisplayName(new LocaleString(entryDisplayName));
        LocaleString localeString = entryProperty.getDisplayName();
        localeString.setLocaleValue(entryDisplayName);
    }

    private static void registerPropertyForTabular(SalaryStandardEntryData stdData, EntryType entryType) {
        List<EntryParamContainer> params = EntryParamContainerHelper.createEntryBuildParamForTabular(null, stdData);
        EntryParamContainerBaseHelper.registProp(params, (EntityType)entryType);
    }

    public static void registerPropertyForGroupItem(SalaryStandardEntryData stdData, EntryType entryType) {
        List<EntryParamContainer> params = EntryParamContainerHelper.createEntryBuildParamForGroupItem(null, stdData);
        EntryParamContainerBaseHelper.registProp(params, (EntityType)entryType);
    }

    public static void setFormData(DynamicObjectCollection rows, SalaryStandardEntryData stdData, Object graderankrange) {
        List<GradeRankKey> gradeRankKeyList;
        GradeRankRangeDBEntity rangeDBEntity;
        SalaryStdGridDisplayTypeEnum displayTypeEnum = DisplayParamHelper.checkGridTypeByCode(stdData.getDisplayParam().getDisplayGradeStyle());
        Object contrastRowEntity = null;
        List rangeCodeArr = null;
        if (graderankrange != null && (rangeDBEntity = ContrastRowDataEntity.deserializeGradeRank((String)((String)graderankrange))) != null) {
            rangeCodeArr = rangeDBEntity.getRuntimeRangeCodeArr();
        }
        boolean isUseSalaryRank = stdData.getStdBaseEntity().getIsUseSalaryRank() > 0;
        List<SalaryRankEntity> stdRankEntities = GradeRankHelper.fetchStandardRank(stdData.getRankEntities());
        List<GradeRankKey> list = gradeRankKeyList = rangeCodeArr == null ? null : GradeRankHelper.getGradeRankKeyFromRangeCode(rangeCodeArr, stdRankEntities.size(), stdData.getGradeEntities(), stdRankEntities, isUseSalaryRank);
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.GROUPITEMS) {
            SalaryStandardViewHelper.setFormDataForGroupItem(stdData, rows, gradeRankKeyList, rangeCodeArr == null);
        } else if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.TABULAR) {
            SalaryStandardViewHelper.setFormDataForTabular(stdData.getStdBaseEntity(), rows, stdData.getGradeEntities(), stdData.getRankEntities(), gradeRankKeyList, stdData.getStdDataEntities(), stdData.getDisplayParam());
        }
    }

    public static void setFormDataForGroupItem(SalaryStandardEntryData stdData, DynamicObjectCollection rows, List<GradeRankKey> gradeRankKeyList, boolean allRange) {
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        List<Object> gradeEntities = stdData.getGradeEntities();
        DisplayParamNew displayParam = stdData.getDisplayParam();
        List data = stdData.getStdDataEntities();
        Map<Long, SalaryStdItemEntity> itemMap = SalaryStdItemHelper.groupBySalaryItemId(stdData.getItemEntities());
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(stdData.getRankEntities());
        Map<Object, Object> gradeEntitySetMap = new HashMap(16);
        if (gradeRankKeyList != null) {
            gradeEntitySetMap = ContrastDataHelper.getGradeRankEntityMap(gradeRankKeyList);
            gradeEntities = new ArrayList<Object>(gradeEntitySetMap.keySet());
        }
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        Map<Long, List<SalaryStdDataEntity>> gradeDataMap = SalaryStdDataHelper.groupByGrade(data);
        gradeEntities = GradeRankHelper.sortGradeList(gradeEntities, displayParam.getDisplaySalaryGradeSort());
        Map<Long, Map<String, BigDecimal>> dataMap = SalaryStdDataHelper.groupDataForGroupItemFieldKey(gradeDataMap, gradeEntities);
        DynamicObject currencyFromDb = SalaryStandardViewHelper.queryCurrencyFromDb(stdBaseEntity.getCurrencyId());
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        String currencyFieldKey = "currencyfield";
        for (SalaryGradeEntity salaryGradeEntity : gradeEntities) {
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            Map<String, BigDecimal> tempData = dataMap.get(salaryGradeEntity.getGradeIdentity());
            for (IDataEntityProperty tempProperty : entityProperties) {
                String tempPropertyName = tempProperty.getName();
                if (SWCStringUtils.equals((String)tempPropertyName, (String)gradeFieldKey)) {
                    tempRow.set(tempPropertyName, (Object)salaryGradeEntity.getGradeName());
                    continue;
                }
                if (SWCStringUtils.equals((String)tempPropertyName, (String)currencyFieldKey)) {
                    tempRow.set(tempPropertyName, (Object)currencyFromDb);
                    continue;
                }
                if (!SWCStringUtils.startsWithIgnoreCase((String)tempPropertyName, (String)"dgdf")) continue;
                DynamicFieldIdGenerationParamForGroup paramForGroup = DynamicFieldIdGenerationParamForGroup.parseFrom((String)tempPropertyName);
                Long itemId = paramForGroup.getItemId();
                Long rankId = paramForGroup.getRankId();
                String matchedKey = paramForGroup.generateDataMatchedKey();
                if (allRange) {
                    tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
                    continue;
                }
                Set salaryRankEntities = (Set)gradeEntitySetMap.get(salaryGradeEntity);
                SalaryStdItemEntity stdItemEntity = itemMap.get(itemId);
                SalaryRankEntity rankEntity = rankEntityMap.get(rankId);
                if (stdItemEntity != null && stdItemEntity.getItemLabel() == SalaryItemLabelEnum.STANDARD && rankEntity != null && rankEntity.getRankLabel() == SalaryRankLabelEnum.STANDARD) {
                    if (null == salaryRankEntities || !salaryRankEntities.contains(rankEntity)) continue;
                    tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
                    continue;
                }
                tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
            }
            rows.add((Object)tempRow);
        }
    }

    public static void setFormDataForTabular(SalaryStandardBaseEntity stdBaseEntity, DynamicObjectCollection rows, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<GradeRankKey> gradeRankKeyList, List<SalaryStdDataEntity> data, DisplayParamNew displayParam) {
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(rankEntities);
        if (gradeRankKeyList == null) {
            gradeRankKeyList = GradeRankHelper.getAllGradeRankKeyList(gradeEntities, rankEntities);
        }
        DynamicObject currencyFromDb = SalaryStandardViewHelper.queryCurrencyFromDb(stdBaseEntity.getCurrencyId());
        GradeRankHelper.sortGradeRankKeyList(gradeRankKeyList, displayParam.getDisplaySalaryGradeSort(), displayParam.getDisplaySalaryRankSort());
        Map<GradeRankKey, List<SalaryStdDataEntity>> gradeRankDataMap = SalaryStdDataHelper.groupByGradeRankKey(data, gradeEntityMap, rankEntityMap);
        Map<GradeRankKey, Map<String, BigDecimal>> dataMap = SalaryStdDataHelper.groupDataForTabularFieldKey(gradeRankDataMap);
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "grade").generateKey();
        String rankFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "rank").generateKey();
        for (GradeRankKey gradeRankKey : gradeRankKeyList) {
            DynamicObject tempRow = new DynamicObject(rows.getDynamicObjectType());
            Map<String, BigDecimal> tempData = dataMap.get(gradeRankKey);
            for (IDataEntityProperty tempProperty : entityProperties) {
                String tempPropertyName = tempProperty.getName();
                if (SWCStringUtils.equals((String)tempPropertyName, (String)gradeFieldKey)) {
                    tempRow.set(tempPropertyName, (Object)gradeRankKey.getGradeEntity().getGradeName());
                    continue;
                }
                if (SWCStringUtils.equals((String)tempPropertyName, (String)"currencyfield")) {
                    tempRow.set(tempPropertyName, (Object)currencyFromDb);
                    continue;
                }
                if (SWCStringUtils.equals((String)tempPropertyName, (String)rankFieldKey)) {
                    tempRow.set(tempPropertyName, (Object)gradeRankKey.getRankEntity().getRankName());
                    continue;
                }
                if (!SWCStringUtils.startsWithIgnoreCase((String)tempPropertyName, (String)"dgdf")) continue;
                String matchedKey = DynamicFieldIdGenerationParamForTabular.parseFrom((String)tempPropertyName).generateDataMatchedKey();
                if (tempData == null) continue;
                tempRow.set(tempPropertyName, (Object)tempData.get(matchedKey));
            }
            rows.add((Object)tempRow);
        }
    }

    public static DynamicObject queryCurrencyFromDb(Long currencyId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_currency");
        QFilter filter = new QFilter("id", "in", (Object)currencyId);
        DynamicObject[] dys = helper.query("id,number,amtprecision,priceprecision,sign,isshowsign", new QFilter[]{filter});
        DynamicObject currencyObj = dys.length > 0 ? dys[0] : null;
        return currencyObj;
    }

    public static List<SalaryStdDataEntity> fetchFormData(DynamicObjectCollection rows, SalaryStandardEntryData stdData) {
        SalaryStdGridDisplayTypeEnum displayTypeEnum = DisplayParamHelper.checkGridTypeByCode(stdData.getDisplayParam().getDisplayGradeStyle());
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.GROUPITEMS) {
            return SalaryStandardViewHelper.fetchFormDataForGroupItem(rows, stdData.getGradeEntities());
        }
        if (displayTypeEnum == SalaryStdGridDisplayTypeEnum.TABULAR) {
            return SalaryStandardViewHelper.fetchFormDataForTabular(rows, stdData.getGradeEntities(), stdData.getRankEntities());
        }
        return Collections.emptyList();
    }

    public static List<SalaryStdDataEntity> fetchFormDataForGroupItem(DynamicObjectCollection rows, List<SalaryGradeEntity> gradeEntities) {
        Map<String, Long> gradeNameToIdMap = GradeRankHelper.gradeGroupByName(gradeEntities);
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        List dynamicProperties = entityProperties.stream().filter(property -> SWCStringUtils.startsWithIgnoreCase((String)property.getName(), (String)"dgdf")).collect(Collectors.toList());
        HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity> currentDataMap = new HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity>();
        for (DynamicObject row : rows) {
            String gradeName = row.getString(gradeFieldKey);
            Long gradeIdentity = gradeNameToIdMap.get(gradeName);
            for (IDataEntityProperty tempProperty : dynamicProperties) {
                String propertyName = tempProperty.getName();
                BigDecimal dataValue = row.getBigDecimal(propertyName);
                DynamicFieldIdGenerationParamForGroup param = DynamicFieldIdGenerationParamForGroup.parseFrom((String)propertyName);
                SalaryStdDataEntityKey tempKey = new SalaryStdDataEntityKey(param.getItemId(), gradeIdentity, param.getRankId());
                SalaryStdDataEntity dataEntity = (SalaryStdDataEntity)currentDataMap.get(tempKey);
                if (dataEntity == null) {
                    dataEntity = new SalaryStdDataEntity(param.getItemId(), gradeIdentity, param.getRankId());
                    currentDataMap.put(tempKey, dataEntity);
                }
                dataEntity.setValueBySeq(dataValue, param.getSeq());
            }
        }
        return new ArrayList<SalaryStdDataEntity>(currentDataMap.values());
    }

    public static List<SalaryStdDataEntity> fetchFormDataForTabular(DynamicObjectCollection rows, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        Map<String, Long> gradeNameToIdMap = GradeRankHelper.gradeGroupByName(gradeEntities);
        Map<String, Long> rankNameToIdMap = GradeRankHelper.rankGroupByName(rankEntities);
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "grade").generateKey();
        String rankFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "rank").generateKey();
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        List dynamicProperties = entityProperties.stream().filter(property -> SWCStringUtils.startsWithIgnoreCase((String)property.getName(), (String)"dgdf")).collect(Collectors.toList());
        HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity> currentDataMap = new HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity>();
        for (DynamicObject row : rows) {
            String gradeName = row.getString(gradeFieldKey);
            Long gradeIdentity = gradeNameToIdMap.get(gradeName);
            String rankName = row.getString(rankFieldKey);
            Long rankIdentity = rankNameToIdMap.get(rankName);
            for (IDataEntityProperty tempProperty : dynamicProperties) {
                String propertyName = tempProperty.getName();
                BigDecimal dataValue = row.getBigDecimal(propertyName);
                DynamicFieldIdGenerationParamForTabular param = DynamicFieldIdGenerationParamForTabular.parseFrom((String)propertyName);
                SalaryStdDataEntityKey tempKey = new SalaryStdDataEntityKey(param.getIdentityId(), gradeIdentity, rankIdentity);
                if (currentDataMap.get(tempKey) != null) continue;
                SalaryStdDataEntity dataEntity = new SalaryStdDataEntity(param.getIdentityId(), gradeIdentity, rankIdentity);
                dataEntity.setValueBySeq(dataValue, param.getSeq());
                currentDataMap.put(tempKey, dataEntity);
            }
        }
        return new ArrayList<SalaryStdDataEntity>(currentDataMap.values());
    }

    public static void fixAmtPrecision(DynamicObject row, int amtPrecision) {
        DynamicObject currencyObj = row.getDynamicObject("currencyfield");
        if (currencyObj != null) {
            currencyObj.set("amtprecision", (Object)amtPrecision);
        }
    }
}

