/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardComparator;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.SalaryStdDataEntityKey;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryStdDataHelper {
    private static SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);

    public static Map<GradeRankKey, List<SalaryStdDataEntity>> groupByGradeRankKey(List<SalaryStdDataEntity> datas, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        HashMap<GradeRankKey, List<SalaryStdDataEntity>> resultMap = new HashMap<GradeRankKey, List<SalaryStdDataEntity>>(16);
        for (SalaryStdDataEntity data : datas) {
            if (data.getGradeIdentity() == 0L || data.getRankIdentity() == 0L) continue;
            SalaryGradeEntity gradeEntity = gradeEntityMap.get(data.getGradeIdentity());
            SalaryRankEntity rankEntity = rankEntityMap.get(data.getRankIdentity());
            if (gradeEntity == null || rankEntity == null) continue;
            GradeRankKey key = new GradeRankKey(gradeEntity, rankEntity);
            List stdDataEntities = resultMap.computeIfAbsent(key, obj -> new ArrayList(10));
            stdDataEntities.add(data);
        }
        return resultMap;
    }

    public static Map<GradeRankKey, Map<String, BigDecimal>> groupDataForTabularFieldKey(Map<GradeRankKey, List<SalaryStdDataEntity>> gradeRankDataMap) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)gradeRankDataMap.size());
        for (Map.Entry<GradeRankKey, List<SalaryStdDataEntity>> entry : gradeRankDataMap.entrySet()) {
            GradeRankKey gradeRankKey = entry.getKey();
            HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>();
            List<SalaryStdDataEntity> salaryStdDataEntities = gradeRankDataMap.get(gradeRankKey);
            if (salaryStdDataEntities != null) {
                String prefix = "dgdf";
                for (SalaryStdDataEntity stdDataEntity : salaryStdDataEntities) {
                    String salaryCountKey = new DynamicFieldIdGenerationParamForTabular(prefix, stdDataEntity.getItemIdentity(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode()).generateDataMatchedKey();
                    String minKey = new DynamicFieldIdGenerationParamForTabular(prefix, stdDataEntity.getItemIdentity(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()).generateDataMatchedKey();
                    String middleKey = new DynamicFieldIdGenerationParamForTabular(prefix, stdDataEntity.getItemIdentity(), SalaryStdGridFieldSeqEnum.MIDDLE_SEQ.getCode()).generateDataMatchedKey();
                    String maxKey = new DynamicFieldIdGenerationParamForTabular(prefix, stdDataEntity.getItemIdentity(), SalaryStdGridFieldSeqEnum.MAX_SEQ.getCode()).generateDataMatchedKey();
                    if (stdDataEntity.getSalaryCount() != null) {
                        tempMap.put(salaryCountKey, stdDataEntity.getSalaryCount());
                    }
                    if (stdDataEntity.getMin() != null) {
                        tempMap.put(minKey, stdDataEntity.getMin());
                    }
                    if (stdDataEntity.getMiddle() != null) {
                        tempMap.put(middleKey, stdDataEntity.getMiddle());
                    }
                    if (stdDataEntity.getMax() == null) continue;
                    tempMap.put(maxKey, stdDataEntity.getMax());
                }
            }
            dataMap.put(gradeRankKey, tempMap);
        }
        return dataMap;
    }

    public static Map<Long, Map<String, BigDecimal>> groupDataForGroupItemFieldKey(Map<Long, List<SalaryStdDataEntity>> gradeDataMap, List<SalaryGradeEntity> gradeEntities) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>();
            List<SalaryStdDataEntity> salaryStdDataEntities = gradeDataMap.get(gradeEntity.getGradeIdentity());
            if (salaryStdDataEntities != null) {
                String prefix = "dgdf";
                for (SalaryStdDataEntity stdDataEntity : salaryStdDataEntities) {
                    String salaryCountKey = new DynamicFieldIdGenerationParamForGroup(prefix, stdDataEntity.getItemIdentity(), stdDataEntity.getRankIdentity(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode()).generateDataMatchedKey();
                    String minKey = new DynamicFieldIdGenerationParamForGroup(prefix, stdDataEntity.getItemIdentity(), stdDataEntity.getRankIdentity(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()).generateDataMatchedKey();
                    String middleKey = new DynamicFieldIdGenerationParamForGroup(prefix, stdDataEntity.getItemIdentity(), stdDataEntity.getRankIdentity(), SalaryStdGridFieldSeqEnum.MIDDLE_SEQ.getCode()).generateDataMatchedKey();
                    String maxKey = new DynamicFieldIdGenerationParamForGroup(prefix, stdDataEntity.getItemIdentity(), stdDataEntity.getRankIdentity(), SalaryStdGridFieldSeqEnum.MAX_SEQ.getCode()).generateDataMatchedKey();
                    if (stdDataEntity.getSalaryCount() != null) {
                        tempMap.put(salaryCountKey, stdDataEntity.getSalaryCount());
                    }
                    if (stdDataEntity.getMin() != null) {
                        tempMap.put(minKey, stdDataEntity.getMin());
                    }
                    if (stdDataEntity.getMiddle() != null) {
                        tempMap.put(middleKey, stdDataEntity.getMiddle());
                    }
                    if (stdDataEntity.getMax() == null) continue;
                    tempMap.put(maxKey, stdDataEntity.getMax());
                }
            }
            dataMap.put(gradeEntity.getGradeIdentity(), tempMap);
        }
        return dataMap;
    }

    public static Map<Long, List<SalaryStdDataEntity>> groupByGrade(List<SalaryStdDataEntity> data) {
        return data.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getGradeIdentity, LinkedHashMap::new, Collectors.toList()));
    }

    public static Map<Long, Map<Long, List<SalaryStdDataEntity>>> groupByGradeItem(List<SalaryStdDataEntity> stdDataList) {
        if (CollectionUtils.isEmpty(stdDataList)) {
            return Maps.newHashMap();
        }
        Map<Long, List<SalaryStdDataEntity>> gradeMap = SalaryStdDataHelper.groupByGrade(stdDataList);
        LinkedHashMap<Long, Map<Long, List<SalaryStdDataEntity>>> result = new LinkedHashMap<Long, Map<Long, List<SalaryStdDataEntity>>>(gradeMap.size());
        for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : gradeMap.entrySet()) {
            Long key = entry.getKey();
            List<SalaryStdDataEntity> value = entry.getValue();
            Map<Long, List<SalaryStdDataEntity>> tempMap = SalaryStdDataHelper.groupByItem(value);
            result.put(key, tempMap);
        }
        return result;
    }

    public static Map<Long, Map<Long, List<SalaryStdDataEntity>>> groupByItemGrade(List<SalaryStdDataEntity> stdDataList) {
        if (CollectionUtils.isEmpty(stdDataList)) {
            return Maps.newHashMap();
        }
        Map<Long, List<SalaryStdDataEntity>> itemMap = SalaryStdDataHelper.groupByItem(stdDataList);
        LinkedHashMap<Long, Map<Long, List<SalaryStdDataEntity>>> result = new LinkedHashMap<Long, Map<Long, List<SalaryStdDataEntity>>>(itemMap.size());
        for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : itemMap.entrySet()) {
            Long key = entry.getKey();
            List<SalaryStdDataEntity> value = entry.getValue();
            Map<Long, List<SalaryStdDataEntity>> tempMap = SalaryStdDataHelper.groupByGrade(value);
            result.put(key, tempMap);
        }
        return result;
    }

    public static Map<Long, Map<Long, Map<Long, SalaryStdDataEntity>>> groupByGradeItemRank(List<SalaryStdDataEntity> stdDataList) {
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> gradeItemDataMap = SalaryStdDataHelper.groupByGradeItem(stdDataList);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Long, Map<Long, List<SalaryStdDataEntity>>> entry : gradeItemDataMap.entrySet()) {
            Long gradeId = entry.getKey();
            Map<Long, List<SalaryStdDataEntity>> curGradeItemDataMap = entry.getValue();
            Map resultItemMap = result.computeIfAbsent(gradeId, k1 -> Maps.newHashMap());
            for (Map.Entry<Long, List<SalaryStdDataEntity>> subEntry : curGradeItemDataMap.entrySet()) {
                Long itemId = subEntry.getKey();
                List<SalaryStdDataEntity> rankDatas = subEntry.getValue();
                Map resultRankMap = resultItemMap.computeIfAbsent(itemId, k1 -> Maps.newHashMap());
                for (SalaryStdDataEntity rankData : rankDatas) {
                    resultRankMap.put(rankData.getRankIdentity(), rankData);
                }
                resultItemMap.put(itemId, resultRankMap);
            }
            result.put(gradeId, resultItemMap);
        }
        return result;
    }

    public static List<SalaryStdDataEntity> getByItemIds(Collection<Long> itemIdentities, List<SalaryStdDataEntity> stdDataEntities) {
        return stdDataEntities.stream().filter(entity -> itemIdentities.contains(entity.getItemIdentity())).collect(Collectors.toList());
    }

    public static List<SalaryStdDataEntity> getByRankIds(Collection<Long> rankIdentities, List<SalaryStdDataEntity> stdDataEntities) {
        return stdDataEntities.stream().filter(entity -> rankIdentities.contains(entity.getRankIdentity())).collect(Collectors.toList());
    }

    public static Map<Long, Map<Long, List<SalaryStdDataEntity>>> groupByGradeAndRank(List<SalaryStdDataEntity> itemStdDataEntities) {
        Map<Long, List<SalaryStdDataEntity>> gradeMap = itemStdDataEntities.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getGradeIdentity));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)gradeMap.size());
        for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : gradeMap.entrySet()) {
            Map<Long, List<SalaryStdDataEntity>> tempRankMap = entry.getValue().stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getRankIdentity));
            resultMap.put(entry.getKey(), tempRankMap);
        }
        return resultMap;
    }

    public static void copyVarItemDataToOtherRank(List<SalaryStdDataEntity> stdDataEntities, List<Long> varItemIds, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        for (Long varItemId : varItemIds) {
            List<SalaryStdDataEntity> fixedSsData = SalaryStdDataHelper.getByItemIds(Collections.singleton(varItemId), stdDataEntities);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> fixedSsDataMap = SalaryStdDataHelper.groupByGradeAndRank(fixedSsData);
            SalaryRankEntity minStandardRank = GradeRankHelper.getMinStandardRank(rankEntities);
            if (null == minStandardRank) {
                return;
            }
            for (SalaryGradeEntity gradeEntity : gradeEntities) {
                Map<Long, List<SalaryStdDataEntity>> fixedSsDataOfCurrGrade = fixedSsDataMap.get(gradeEntity.getGradeIdentity());
                SalaryStdDataEntity targetRankData = fixedSsDataOfCurrGrade.get(minStandardRank.getRankIdentity()).get(0);
                for (SalaryRankEntity rankEntity : rankEntities) {
                    List<SalaryStdDataEntity> tempOtherRankDatas;
                    if (rankEntity.getRankIdentity().equals(minStandardRank.getRankIdentity()) || !CollectionUtils.isNotEmpty(tempOtherRankDatas = fixedSsDataOfCurrGrade.get(rankEntity.getRankIdentity()))) continue;
                    SalaryStdDataEntity temp = tempOtherRankDatas.get(0);
                    temp.setMin(targetRankData.getMin());
                }
            }
        }
    }

    public static List<SalaryStdDataEntity> copyNotUseRankItemDataToOtherRank(List<SalaryStdDataEntity> stdDataEntities, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<SalaryStdItemEntity> itemEntities) {
        Set<Long> itemIds = SalaryStdItemHelper.getNotUseRankSalaryItemIds(itemEntities);
        ArrayList<SalaryStdDataEntity> resultList = new ArrayList<SalaryStdDataEntity>();
        if (CollectionUtils.isEmpty(itemIds)) {
            return resultList;
        }
        List<SalaryStdDataEntity> notUseRankItemList = SalaryStdDataHelper.getByItemIds(itemIds, stdDataEntities);
        Map<Long, List<SalaryStdDataEntity>> notUseRankItemGroupData = SalaryStdDataHelper.groupByItem(notUseRankItemList);
        SalaryRankEntity minStandardRank = GradeRankHelper.getMinStandardRank(rankEntities);
        for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : notUseRankItemGroupData.entrySet()) {
            List<SalaryStdDataEntity> tempItemData = entry.getValue();
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> tempItemDataByGradeRank = SalaryStdDataHelper.groupByGradeAndRank(tempItemData);
            for (SalaryGradeEntity gradeEntity : gradeEntities) {
                Map<Long, List<SalaryStdDataEntity>> rankDatas = tempItemDataByGradeRank.get(gradeEntity.getGradeIdentity());
                if (MapUtils.isEmpty(rankDatas)) continue;
                List<SalaryStdDataEntity> targetRankData = rankDatas.get(minStandardRank.getRankIdentity());
                for (SalaryRankEntity rankEntity : rankEntities) {
                    resultList.addAll(SalaryStdDataHelper.copyDataWithNewRank(targetRankData, rankEntity));
                }
            }
        }
        return resultList;
    }

    public static Map<Long, List<SalaryStdDataEntity>> groupByItem(List<SalaryStdDataEntity> stdDataEntities) {
        return stdDataEntities.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getItemIdentity));
    }

    public static Map<Long, List<SalaryStdDataEntity>> groupByRank(List<SalaryStdDataEntity> stdDataEntities) {
        return stdDataEntities.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getRankIdentity));
    }

    private static List<SalaryStdDataEntity> copyDataWithNewRank(List<SalaryStdDataEntity> targetRankData, SalaryRankEntity rankEntity) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)targetRankData.size());
        for (SalaryStdDataEntity entity : targetRankData) {
            SalaryStdDataEntity newEntity = new SalaryStdDataEntity();
            try {
                BeanUtils.copyProperties((Object)newEntity, (Object)entity);
                newEntity.setRankIdentity(rankEntity.getRankIdentity());
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.add(newEntity);
        }
        return result;
    }

    public static List<SalaryStdDataEntity> createInitStdData(List<Long> itemIdentities, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        ArrayList<SalaryStdDataEntity> result = new ArrayList<SalaryStdDataEntity>();
        for (Long itemId : itemIdentities) {
            for (SalaryGradeEntity grade : gradeEntities) {
                for (SalaryRankEntity rank : rankEntities) {
                    SalaryStdDataEntity stdData = new SalaryStdDataEntity(itemId, grade.getGradeIdentity(), rank.getRankIdentity());
                    stdData.setSalaryCount(null);
                    stdData.setMin(null);
                    stdData.setMiddle(null);
                    stdData.setMax(null);
                    result.add(stdData);
                }
            }
        }
        return result;
    }

    public static List<SalaryStdDataEntity> completeStdData(List<Long> itemIds, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, List<SalaryStdDataEntity> stdDataEntities) {
        if (CollectionUtils.isEmpty(stdDataEntities)) {
            return SalaryStdDataHelper.createInitStdData(itemIds, gradeEntities, rankEntities);
        }
        ArrayList<SalaryStdDataEntity> result = new ArrayList<SalaryStdDataEntity>();
        for (Long itemId : itemIds) {
            Map<Long, List<SalaryStdDataEntity>> itemDataMap = SalaryStdDataHelper.groupByItem(stdDataEntities);
            List<SalaryStdDataEntity> curItemData = itemDataMap.get(itemId);
            if (CollectionUtils.isEmpty(curItemData)) {
                curItemData = SalaryStdDataHelper.createInitStdData(Collections.singletonList(itemId), gradeEntities, rankEntities);
                result.addAll(curItemData);
            }
            Map<Long, List<SalaryStdDataEntity>> gradeDataMap = SalaryStdDataHelper.groupByGrade(curItemData);
            for (SalaryGradeEntity gradeEntity : gradeEntities) {
                List<SalaryStdDataEntity> curGradeData = gradeDataMap.get(gradeEntity.getGradeIdentity());
                if (CollectionUtils.isEmpty(curGradeData)) {
                    curGradeData = SalaryStdDataHelper.createInitStdData(Collections.singletonList(itemId), Collections.singletonList(gradeEntity), rankEntities);
                    result.addAll(curGradeData);
                    continue;
                }
                Map<Long, List<SalaryStdDataEntity>> curRankDataMap = SalaryStdDataHelper.groupByRank(curGradeData);
                for (SalaryRankEntity rankEntity : rankEntities) {
                    if (curRankDataMap.containsKey(rankEntity.getRankIdentity())) continue;
                    result.addAll(SalaryStdDataHelper.createInitStdData(Collections.singletonList(itemId), Collections.singletonList(gradeEntity), Collections.singletonList(rankEntity)));
                }
            }
        }
        return result;
    }

    public static void sortByRankIndex(List<SalaryStdDataEntity> datalist, Map<Long, SalaryRankEntity> rankMap) {
        if (CollectionUtils.isEmpty(datalist)) {
            return;
        }
        datalist.sort(new SalaryStandardComparator.StdDataComparatorWithRankIdx(rankMap));
    }

    public static void sortByGradeIndex(List<SalaryStdDataEntity> datalist, Map<Long, SalaryGradeEntity> gradeMap) {
        if (CollectionUtils.isEmpty(datalist)) {
            return;
        }
        datalist.sort(new SalaryStandardComparator.StdDataComparatorWithGradeIdx(gradeMap));
    }

    public static Map<SalaryStdDataEntityKey, SalaryStdDataEntity> groupBySalaryStdDataEntityKey(List<SalaryStdDataEntity> stdDatas) {
        HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity> dataValueMap = new HashMap<SalaryStdDataEntityKey, SalaryStdDataEntity>(stdDatas.size());
        for (SalaryStdDataEntity data : stdDatas) {
            dataValueMap.put(new SalaryStdDataEntityKey(data.getItemIdentity(), data.getGradeIdentity(), data.getRankIdentity()), data);
        }
        return dataValueMap;
    }

    public static List<SalaryStdDataEntity> filterByItem(List<SalaryStdDataEntity> stdDataEntities, List<SalaryStdItemEntity> stdItemEntities) {
        List<Long> allSalaryItemIds = SalaryStdItemHelper.getAllItemIdentities(stdItemEntities);
        return stdDataEntities.stream().filter(entity -> allSalaryItemIds.contains(entity.getItemIdentity())).collect(Collectors.toList());
    }

    public static Map<Long, List<SalaryStdDataEntity>> queryStdDataEntities(Set<Long> stdVids) {
        if (CollectionUtils.isEmpty(stdVids)) {
            return Collections.emptyMap();
        }
        String stdDataEntSql = "SELECT A.FID,A.FSALARYSTDITEMID,A.FDATA,B.FGRADERANKSEQMAP FROM T_HCDM_STDSUMDATA A LEFT JOIN T_HCDM_SALARYSTD B ON A.FID = B.FID WHERE FID IN " + HCDMDbHelper.getFidHolder(stdVids.size());
        DataSet stdDataEntDataSet = HCDMDbHelper.queryDataSet(stdDataEntSql, stdVids.toArray());
        HashMap map = Maps.newHashMap();
        while (stdDataEntDataSet.hasNext()) {
            Row next = stdDataEntDataSet.next();
            Long stdVid = next.getLong("fid");
            String gradeRankSeqMapStr = next.getString("fgraderankseqmap");
            Long itemIdentity = next.getLong("fsalarystditemid");
            String stdData = next.getString("fdata");
            List<SalaryStdDataEntity> stdDataEntities = service.parseStdDataToEntity(stdVid, itemIdentity, stdData, gradeRankSeqMapStr);
            List list = map.computeIfAbsent(stdVid, value -> Lists.newArrayList());
            list.addAll(stdDataEntities);
        }
        return map;
    }

    public static void removeErrorData(List<SalaryStdDataEntity> stdDataEntities, List<SalaryStdItemEntity> salaryStdItemEntities, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities) {
        if (CollectionUtils.isEmpty(stdDataEntities)) {
            return;
        }
        Set itemIds = salaryStdItemEntities.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toSet());
        Set gradeIds = gradeEntities.stream().map(SalaryGradeEntity::getGradeIdentity).collect(Collectors.toSet());
        Set rankIds = rankEntities.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
        stdDataEntities.removeIf(next -> !itemIds.contains(next.getItemIdentity()) || !gradeIds.contains(next.getGradeIdentity()) || !rankIds.contains(next.getRankIdentity()));
    }

    public static BigDecimal getMiddleValueByStandardRankData(List<SalaryStdDataEntity> standardRankDataWithOrder, boolean withAmount) {
        int rankNum = standardRankDataWithOrder.size();
        SalaryStdDataEntity minEntity = null;
        SalaryStdDataEntity maxEntity = null;
        if (rankNum % 2 == 0) {
            minEntity = standardRankDataWithOrder.get(rankNum / 2 - 1);
            maxEntity = standardRankDataWithOrder.get(rankNum / 2);
        } else {
            SalaryStdDataEntity mid;
            minEntity = mid = standardRankDataWithOrder.get(rankNum / 2);
            maxEntity = mid;
        }
        if (withAmount) {
            if (minEntity.getMin() == null || maxEntity.getMin() == null) {
                return null;
            }
            int scale = Math.max(minEntity.getMin().scale(), maxEntity.getMin().scale());
            return minEntity.getMin().add(maxEntity.getMin()).divide(BigDecimal.valueOf(2L), scale, 4);
        }
        if (minEntity.getSalaryCount() == null || maxEntity.getSalaryCount() == null) {
            return null;
        }
        int scale = Math.max(minEntity.getSalaryCount().scale(), maxEntity.getSalaryCount().scale());
        return minEntity.getSalaryCount().add(maxEntity.getSalaryCount()).divide(BigDecimal.valueOf(2L), scale, 4);
    }

    public static List<SalaryStdDataEntity> fetchDataWithRankId(List<SalaryStdDataEntity> stdDataOfOneGrade, List<Long> rankIdentitys) {
        if (CollectionUtils.isEmpty(rankIdentitys)) {
            return Collections.emptyList();
        }
        return stdDataOfOneGrade.stream().filter(o1 -> rankIdentitys.contains(o1.getRankIdentity())).sorted(Comparator.comparingInt(o -> rankIdentitys.indexOf(o.getRankIdentity()))).collect(Collectors.toList());
    }
}

