/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetVarPredictItemEvent;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.common.constants.AdjSalSynConstants;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.ItemGroupTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryStdItemHelper {
    public static final String displayFixedSalaryRatio = "1000000000001";
    public static final String displayFixedSalaryTotal = "1000000000002";
    public static final String displayTotal = "1000000000003";

    public static Map<ItemGroupTypeEnum, List<SalaryStdItemEntity>> groupByItemType(List<SalaryStdItemEntity> itemEntities) {
        ArrayList<SalaryStdItemEntity> fixedItemList = new ArrayList<SalaryStdItemEntity>(itemEntities.size());
        ArrayList<SalaryStdItemEntity> noFixedItemList = new ArrayList<SalaryStdItemEntity>(itemEntities.size());
        ArrayList<SalaryStdItemEntity> specialItemList = new ArrayList<SalaryStdItemEntity>(itemEntities.size());
        for (SalaryStdItemEntity tempItem : itemEntities) {
            SalaryItemLabelEnum itemLabel = tempItem.getItemLabel();
            if (itemLabel == SalaryItemLabelEnum.STANDARD) {
                if (tempItem.getIsFixedItem() > 0) {
                    fixedItemList.add(tempItem);
                    continue;
                }
                noFixedItemList.add(tempItem);
                continue;
            }
            specialItemList.add(tempItem);
        }
        LinkedHashMap<ItemGroupTypeEnum, List<SalaryStdItemEntity>> dataMap = new LinkedHashMap<ItemGroupTypeEnum, List<SalaryStdItemEntity>>();
        dataMap.put(ItemGroupTypeEnum.FIXED, fixedItemList);
        dataMap.put(ItemGroupTypeEnum.UNFIXED, noFixedItemList);
        dataMap.put(ItemGroupTypeEnum.SPECIAL, specialItemList);
        return dataMap;
    }

    public static List<Long> getAllSalaryItemIds(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toList());
    }

    public static List<Long> getAllItemIdentities(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toList());
    }

    public static Map<Long, SalaryStdItemEntity> groupById(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().collect(Collectors.toMap(SalaryStdItemEntity::getItemIdentity, Function.identity(), (p1, p2) -> p2));
    }

    public static List<Long> getUseRankSalaryItemIds(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().filter(entity -> entity.getItemIsUseSalaryRank() > 0).map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toList());
    }

    public static Set<Long> getNotUseRankSalaryItemIds(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().filter(entity -> entity.getItemIsUseSalaryRank() == 0).map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toSet());
    }

    public static List<Long> getUseCountSalaryItemIds(List<SalaryStdItemEntity> salaryStdItemList) {
        return salaryStdItemList.stream().filter(entity -> entity.getItemIsUseSalaryCount() > 0).map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toList());
    }

    public static List<SalaryStdItemEntity> fetchStandardItem(List<SalaryStdItemEntity> stdItemEntities) {
        return stdItemEntities.stream().filter(entity -> SalaryItemLabelEnum.STANDARD.equals((Object)entity.getItemLabel())).collect(Collectors.toList());
    }

    public static List<Long> fetchStandardItemIdentity(List<SalaryStdItemEntity> stdItemEntities) {
        return SalaryStdItemHelper.fetchStandardItem(stdItemEntities).stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toList());
    }

    public static List<SalaryStdItemEntity> getItemBySpecialIdentity(List<SalaryStdItemEntity> stdItemEntities, boolean withStandard, List<Long> identity) {
        return stdItemEntities.stream().filter(entity -> identity.contains(entity.getItemIdentity()) || withStandard && entity.getItemLabel().equals((Object)SalaryItemLabelEnum.STANDARD)).collect(Collectors.toList());
    }

    public static List<SalaryStdItemEntity> getItemByFixedState(List<SalaryStdItemEntity> stdItemEntities, int fixed) {
        List<SalaryStdItemEntity> resultList = stdItemEntities.stream().filter(entity -> entity.getItemLabel() == SalaryItemLabelEnum.STANDARD && entity.getIsFixedItem() == fixed).collect(Collectors.toList());
        return resultList;
    }

    public static String getAllSalaryItemStr(List<SalaryStdItemEntity> salaryStdItemEntity) {
        Set itemNameSet = salaryStdItemEntity.stream().filter(entity -> SalaryItemLabelEnum.STANDARD == entity.getItemLabel()).map(SalaryStdItemEntity::getItemName).collect(Collectors.toSet());
        StringBuilder sb = new StringBuilder();
        Iterator iterator = itemNameSet.iterator();
        int i1 = 0;
        int size = itemNameSet.size();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (i1 != size - 1) {
                sb.append('\uff0c');
            }
            ++i1;
        }
        return sb.toString();
    }

    public static String getUserRankItemStr(List<SalaryStdItemEntity> salaryStdItemEntities) {
        salaryStdItemEntities = salaryStdItemEntities.stream().filter(entity -> entity.getItemIsUseSalaryRank() == 1).collect(Collectors.toList());
        return SalaryStdItemHelper.getAllSalaryItemStr(salaryStdItemEntities);
    }

    public static String getUserSalaryCountItemStr(List<SalaryStdItemEntity> salaryStdItemEntities) {
        salaryStdItemEntities = salaryStdItemEntities.stream().filter(entity -> entity.getItemIsUseSalaryCount() == 1).collect(Collectors.toList());
        return SalaryStdItemHelper.getAllSalaryItemStr(salaryStdItemEntities);
    }

    public static List<SalaryStdItemEntity> getCalcStdItemBySpecialIdentity(List<SalaryStdItemEntity> itemEntities, Long specialItemIdentity) {
        if (specialItemIdentity.equals(SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL)) {
            return SalaryStdItemHelper.getItemByFixedState(itemEntities, 1);
        }
        if (specialItemIdentity.equals(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL)) {
            return SalaryStdItemHelper.getItemByFixedState(itemEntities, 0);
        }
        return Collections.emptyList();
    }

    public static List<SalaryStdItemEntity> getPresetItems(SalaryStandardTypeEnum type) {
        DynamicObject[] dynamicObjects = SalaryStdItemHelper.getVarPredictItemWithExt(type, 2);
        ArrayList<SalaryStdItemEntity> result = new ArrayList<SalaryStdItemEntity>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            SalaryStdItemEntity entity = new SalaryStdItemEntity();
            String name = dynamicObject.getString("name");
            long id = dynamicObject.getLong("id");
            entity.setItemName(name);
            entity.setIsFixedItem(0);
            entity.setItemIdentity(Long.valueOf(id));
            entity.setItemIndex(i + 1);
            entity.setItemIsUseSalaryCount(type == SalaryStandardTypeEnum.SALARYCOUNT ? 1 : 0);
            entity.setItemIsUseSalaryRank(1);
            entity.setItemType(type);
            entity.setItemLabel(SalaryItemLabelEnum.SPECIAL);
            result.add(entity);
        }
        return result;
    }

    public static SalaryStdItemEntity generateVirtualItem(SalaryStandardTypeEnum type, Long specialIdentity) {
        SalaryStdItemEntity entity = new SalaryStdItemEntity();
        entity.setItemType(type);
        entity.setItemIdentity(specialIdentity);
        entity.setItemIsUseSalaryRank(1);
        entity.setItemLabel(SalaryItemLabelEnum.SPECIAL);
        if (type == SalaryStandardTypeEnum.SALARYCOUNT) {
            entity.setItemIsUseSalaryCount(1);
        }
        if (type == SalaryStandardTypeEnum.BROADBAND) {
            entity.setItemIsUseSalaryCount(0);
        }
        return entity;
    }

    public static boolean isChanged(List<SalaryStdItemEntity> source, List<SalaryStdItemEntity> target) {
        List<Long> targetIds;
        boolean idChanged;
        boolean sizeChanged;
        source = SalaryStdItemHelper.fetchStandardItem(source);
        target = SalaryStdItemHelper.fetchStandardItem(target);
        boolean bl = sizeChanged = source.size() != target.size();
        if (sizeChanged) {
            return true;
        }
        List<Long> sourceIds = SalaryStdItemHelper.getAllItemIdentities(source);
        boolean bl2 = idChanged = !sourceIds.containsAll(targetIds = SalaryStdItemHelper.getAllItemIdentities(target)) || !targetIds.containsAll(sourceIds);
        if (idChanged) {
            return true;
        }
        Map<Long, SalaryStdItemEntity> sourceMap = SalaryStdItemHelper.groupById(source);
        Map<Long, SalaryStdItemEntity> targetMap = SalaryStdItemHelper.groupById(target);
        boolean useRankChanged = false;
        for (Map.Entry<Long, SalaryStdItemEntity> entry : sourceMap.entrySet()) {
            SalaryStdItemEntity sourceItem = entry.getValue();
            SalaryStdItemEntity targetItem = targetMap.get(entry.getKey());
            if (sourceItem.getItemIsUseSalaryRank() == targetItem.getItemIsUseSalaryRank()) continue;
            useRankChanged = true;
            break;
        }
        if (useRankChanged) {
            return true;
        }
        boolean useSalaryCountChanged = false;
        for (Map.Entry<Long, SalaryStdItemEntity> entry : sourceMap.entrySet()) {
            SalaryStdItemEntity sourceItem = entry.getValue();
            SalaryStdItemEntity targetItem = targetMap.get(entry.getKey());
            if (sourceItem.getItemIsUseSalaryCount() == targetItem.getItemIsUseSalaryCount()) continue;
            useSalaryCountChanged = true;
            break;
        }
        return useSalaryCountChanged;
    }

    public static Map<Long, List<SalaryStdItemEntity>> queryItemEntities(Set<Long> stdVids) {
        if (CollectionUtils.isEmpty(stdVids)) {
            return Collections.emptyMap();
        }
        String stdItemEntSql = "select fentryid, fid,fitemidentity,fsalaryitemid,fitemlabel,fitemisusesalaryrank from t_hcdm_salarystditem where fid in " + HCDMDbHelper.getFidHolder(stdVids.size());
        DataSet stdItemEntDataSet = HCDMDbHelper.queryDataSet(stdItemEntSql, stdVids.toArray());
        HashMap map = Maps.newHashMap();
        while (stdItemEntDataSet.hasNext()) {
            Row next = stdItemEntDataSet.next();
            Long stdVid = next.getLong("fid");
            Long entryId = next.getLong("fentryid");
            Long itemIdentity = next.getLong("fitemidentity");
            Long salaryItemId = next.getLong("fsalaryitemid");
            String itemLabel = next.getString("fitemlabel");
            Integer itemIsUseSalaryRank = next.getInteger("fitemisusesalaryrank");
            SalaryStdItemEntity entity = new SalaryStdItemEntity();
            entity.setEntryid(entryId);
            entity.setItemIdentity(itemIdentity);
            entity.setSalaryItemId(salaryItemId);
            entity.setItemLabel(SalaryItemLabelEnum.valueOf((String)itemLabel));
            entity.setItemIsUseSalaryRank(itemIsUseSalaryRank.intValue());
            List list = map.computeIfAbsent(stdVid, value -> Lists.newArrayList());
            list.add(entity);
        }
        return map;
    }

    public static List<SalaryStdItemEntity> queryItemEntityList(Set<Long> stdIdList, Set<Long> itemIdList) {
        if (CollectionUtils.isEmpty(stdIdList) || CollectionUtils.isEmpty(itemIdList)) {
            return null;
        }
        String stdItemEntSql = "select fid, fsalaryitemid, fitemisusesalaryrank  from t_hcdm_salarystditem where fid in (" + StringUtils.join(stdIdList, (String)",") + ")  and fsalaryitemid in (" + StringUtils.join(itemIdList, (String)",") + ") ";
        DataSet stdItemEntDataSet = SWCDbUtil.queryDataSet((String)"queryItemEntities", (DBRoute)AdjSalSynConstants.DB_ROUTE, (String)stdItemEntSql, null);
        ArrayList<SalaryStdItemEntity> entityList = new ArrayList<SalaryStdItemEntity>(1);
        SalaryStdItemEntity entity = new SalaryStdItemEntity();
        while (stdItemEntDataSet.hasNext()) {
            Row next = stdItemEntDataSet.next();
            Integer itemIsUseSalaryRank = next.getInteger("fitemisusesalaryrank");
            Long salaryItemId = next.getLong("fsalaryitemid");
            Long id = next.getLong("fid");
            entity.setItemIsUseSalaryRank(itemIsUseSalaryRank.intValue());
            entity.setSalaryStandardId(id);
            entity.setSalaryItemId(salaryItemId);
            entityList.add(entity);
        }
        return entityList;
    }

    public static Map<Long, SalaryStdItemEntity> groupBySalaryItemId(List<SalaryStdItemEntity> itemEntities) {
        return itemEntities.stream().filter(entity -> entity.getSalaryItemId() > 0L).collect(Collectors.toMap(SalaryStdItemEntity::getSalaryItemId, Function.identity(), (o1, o2) -> o2));
    }

    public static List<SalaryStdItemEntity> fetchItemByVarPredictType(List<SalaryStdItemEntity> itemEntities, VarPredictItemType type) {
        return itemEntities.stream().filter(entity -> entity.getItemLabel() == SalaryItemLabelEnum.SPECIAL && entity.getVarPredictItemType() == type).collect(Collectors.toList());
    }

    public static List<Long> fetchItemIdByVarPredictType(List<SalaryStdItemEntity> itemEntities, VarPredictItemType type) {
        List<SalaryStdItemEntity> items = SalaryStdItemHelper.fetchItemByVarPredictType(itemEntities, type);
        return items.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toList());
    }

    public static DynamicObject[] queryAllVarPredictItem() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return new SWCDataServiceHelper("hcdm_varpredictitem").query("id,number,name,type", new QFilter[]{filter}, "index asc");
    }

    public static DynamicObject[] queryVarPredictItemByType(String type) {
        DynamicObject[] allVarPredictItem = SalaryStdItemHelper.queryAllVarPredictItem();
        return (DynamicObject[])Arrays.stream(allVarPredictItem).filter(object -> StringUtils.equals((CharSequence)object.getString("type"), (CharSequence)type)).toArray(DynamicObject[]::new);
    }

    public static VarPredictItemType getVarPredictItemTypeById(Long id) {
        ISWCAppCache appCache = SWCAppCache.get((String)"varPredictItemCacheKey");
        String varPredictItemTypeKey = MessageFormat.format("varPredictItem_{0}", id);
        String varPredictItemType = (String)appCache.get(varPredictItemTypeKey, String.class);
        if (SWCStringUtils.isEmpty((String)varPredictItemType)) {
            DynamicObject item = SalaryStdItemHelper.getVarPredictItemById(id);
            if (item != null) {
                String type = item.getString("type");
                appCache.put(varPredictItemTypeKey, (Object)type, 1800);
                return VarPredictItemType.fromCode((String)type);
            }
        } else {
            return VarPredictItemType.fromCode((String)varPredictItemType);
        }
        return null;
    }

    public static DynamicObject getVarPredictItemById(Long id) {
        DynamicObject[] allVarPredictItem = SalaryStdItemHelper.getVarPredictItemWithExt(SalaryStandardTypeEnum.SALARYCOUNT, 2);
        List collect = Arrays.stream(allVarPredictItem).filter(object -> object.getLong("id") == id.longValue()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            return (DynamicObject)collect.get(0);
        }
        return null;
    }

    public static DynamicObject[] getVarPredictItemWithExt(SalaryStandardTypeEnum type, int useScene) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetVarPredictItemList", null);
        type = type == null ? SalaryStandardTypeEnum.SALARYCOUNT : type;
        OnGetVarPredictItemEvent evt = new OnGetVarPredictItemEvent((Object)type);
        evt.setType(type);
        evt.setUseScene(useScene);
        proxy.callAfter(plugin -> {
            plugin.onGetVarPredictItemList(evt);
            return null;
        });
        return evt.getVarPredictItemList();
    }

    public static DynamicObject[] getDefaultVarPredictItem(SalaryStandardTypeEnum type, int useScene) {
        DynamicObject[] result = SalaryStdItemHelper.queryAllVarPredictItem();
        if (useScene == 2) {
            for (DynamicObject object : result) {
                if (object.getLong("id") != SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE.longValue()) continue;
                object.set("name", (Object)new LocaleString(object.getString("name") + "(%)"));
            }
        }
        return result;
    }
}

