/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntity;

public class StdTabValSetHelper {
    private static final Log Logger = LogFactory.getLog(StdTabValSetHelper.class);
    private static SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);

    public static TableValueSetter getPreItemSetter(List<SalaryStdItemEntity> entities) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("itemidentity", new Object[0]);
        setter.addField("itemindex", new Object[0]);
        setter.addField("salaryitem", new Object[0]);
        setter.addField("salarystdtype", new Object[0]);
        setter.addField("itemlabel", new Object[0]);
        setter.addField("itemisusesalaryrank", new Object[0]);
        setter.addField("itemisusesalarycount", new Object[0]);
        for (int i = 0; i < entities.size(); ++i) {
            SalaryStdItemEntity entity = entities.get(i);
            setter.addRow(new Object[]{entity.getItemIdentity(), entity.getItemIndex(), entity.getSalaryItemId(), entity.getItemType().getCode(), entity.getItemLabel().name(), entity.getItemIsUseSalaryRank() > 0, entity.getItemIsUseSalaryCount() > 0});
        }
        return setter;
    }

    public static TableValueSetter getSalaryStdItemSetter(String type, int index, Boolean isUseRank, Boolean isUseCount, List<Long> itemIds) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("itemidentity", new Object[0]);
        setter.addField("itemindex", new Object[0]);
        setter.addField("salaryitem", new Object[0]);
        setter.addField("salarystdtype", new Object[0]);
        setter.addField("itemlabel", new Object[0]);
        setter.addField("itemisusesalaryrank", new Object[0]);
        setter.addField("itemisusesalarycount", new Object[0]);
        for (Long item : itemIds) {
            setter.addRow(new Object[]{item, index, item, type, SalaryItemLabelEnum.STANDARD.name(), isUseRank, isUseCount});
            ++index;
        }
        return setter;
    }

    public static TableValueSetter getPreRankSetter(List<SalaryRankEntity> entities) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rankidentity", new Object[0]);
        setter.addField("rankindex", new Object[0]);
        setter.addField("rankname", new Object[0]);
        setter.addField("ranknumber", new Object[0]);
        setter.addField("ranklabel", new Object[0]);
        setter.addField("rankisuserset", new Object[0]);
        setter.addField("rankissyspreset", new Object[0]);
        for (SalaryRankEntity entity : entities) {
            setter.addRow(new Object[]{entity.getRankIdentity(), entity.getRankIndex(), entity.getRankName(), entity.getRankName(), entity.getRankLabel().name(), entity.getRankIsUserSet(), entity.getRankIsSysPreSet()});
        }
        return setter;
    }

    public static TableValueSetter getSalaryRankTableSetter(long[] ids, List<SalaryStandardEntryEntity> addNewEntityList) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rankidentity", new Object[0]);
        setter.addField("rankindex", new Object[0]);
        setter.addField("rankname", new Object[0]);
        setter.addField("ranknumber", new Object[0]);
        setter.addField("ranklabel", new Object[0]);
        setter.addField("rankisuserset", new Object[0]);
        setter.addField("rankissyspreset", new Object[0]);
        int i1 = 0;
        for (SalaryStandardEntryEntity addNewEntity : addNewEntityList) {
            setter.addRow(new Object[]{ids[i1++], addNewEntity.getIndex(), addNewEntity.getDisplayName(), addNewEntity.getDisplayName(), SalaryRankLabelEnum.STANDARD.name(), Boolean.TRUE, Boolean.FALSE});
        }
        return setter;
    }

    public static TableValueSetter getSalaryGradeTableSetter(long[] ids, List<SalaryStandardEntryEntity> addNewEntityList) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("gradeidentity", new Object[0]);
        setter.addField("gradeindex", new Object[0]);
        setter.addField("gradename", new Object[0]);
        setter.addField("gradenumber", new Object[0]);
        int i1 = 0;
        for (SalaryStandardEntryEntity addNewEntity : addNewEntityList) {
            Long id = ids[i1++];
            setter.addRow(new Object[]{id, addNewEntity.getIndex(), addNewEntity.getDisplayName(), addNewEntity.getDisplayName()});
        }
        return setter;
    }

    public static TableValueSetter getContrastpsSetter(int index, List<Long> ids) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("pscontrastpropconf", new Object[0]);
        setter.addField("pspropindex", new Object[0]);
        for (Long id : ids) {
            setter.addRow(new Object[]{id, index});
            ++index;
        }
        return setter;
    }

    public static TableValueSetter getSalaryStdDataSetter(List<SalaryStdDataEntity> dataList, Map<String, Map<Long, Integer>> gradeRankSeqMap) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("salarystditemid_a", new Object[0]);
        setter.addField("stddata", new Object[0]);
        LinkedHashMap<Long, String> itemLevelStdDataStr = service.getItemLevelStdDataStr(dataList, gradeRankSeqMap);
        for (Map.Entry itemLevelStdData : itemLevelStdDataStr.entrySet()) {
            setter.addRow(new Object[]{itemLevelStdData.getKey(), itemLevelStdData.getValue()});
        }
        return setter;
    }

    public static TableValueSetter getContrastpsDataTableSetter(List<ContrastRowDataEntity> contrastDataList) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("standardpropvalue", new Object[0]);
        setter.addField("graderankrange", new Object[0]);
        setter.addField("sumrowindex", new Object[0]);
        for (ContrastRowDataEntity data : contrastDataList) {
            data.saveChange();
            setter.addRow(new Object[]{data.getStdPropValueDBVal(), data.getGradeRankRangeDBVal(), data.getRowIndex()});
        }
        return setter;
    }

    public static TableValueSetter getGradeRankTableSetter(List<GradeRankValue> valueList, int carryBit, Map<Integer, String> gradeIndexNameMap, Map<Integer, String> rankIndexNameMap, boolean isUseRank) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("gradebegin", new Object[0]);
        setter.addField("rankbegin", new Object[0]);
        setter.addField("gradeend", new Object[0]);
        setter.addField("rankend", new Object[0]);
        setter.addField("graderank", new Object[0]);
        for (GradeRankValue value : valueList) {
            int beginValue = value.getBeginValue();
            int endValue = value.getEndValue();
            int gradeBeginIndex = beginValue / carryBit;
            int rankBeginIndex = beginValue % carryBit;
            int gradeEndIndex = endValue / carryBit;
            int rankEndIndex = endValue % carryBit;
            String gradeRankArr = GradeRankHelper.getRangeNameByRangeCode(value, carryBit, gradeIndexNameMap, rankIndexNameMap, isUseRank);
            boolean isGradeRankArr = gradeBeginIndex >= 0 && rankBeginIndex >= 0 && gradeEndIndex >= 0 && rankEndIndex >= 0;
            setter.addRow(new Object[]{gradeBeginIndex >= 0 ? Integer.valueOf(gradeBeginIndex) : null, isUseRank && rankBeginIndex >= 0 ? Integer.valueOf(rankBeginIndex) : null, gradeEndIndex >= 0 ? Integer.valueOf(gradeEndIndex) : null, isUseRank && rankEndIndex >= 0 ? Integer.valueOf(rankEndIndex) : null, isGradeRankArr ? gradeRankArr : null});
        }
        return setter;
    }

    public static TableValueSetter getDisplayParamTableValueSetter(DisplayParamNew displayParam, String displayModel) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("displayproperty", new Object[0]);
        setter.addField("displaypropertyvalue", new Object[0]);
        setter.addField("displaymodule", new Object[0]);
        setter.addRow(new Object[]{"displaySalaryRankSort", displayParam.getDisplaySalaryRankSort(), displayModel});
        setter.addRow(new Object[]{"displaySalaryGradeSort", displayParam.getDisplaySalaryGradeSort(), displayModel});
        setter.addRow(new Object[]{"displayGradeStyle", displayParam.getDisplayGradeStyle(), displayModel});
        setter.addRow(new Object[]{"displayOnlySalaryCount", displayParam.getDisplayOnlySalaryCount(), displayModel});
        LinkedHashMap itemLevelParam = displayParam.getItemLevelParam();
        LinkedHashMap rankLevelParam = displayParam.getRankLevelParam();
        for (Map.Entry itemLevel : itemLevelParam.entrySet()) {
            setter.addRow(new Object[]{"item_" + itemLevel.getKey(), itemLevel.getValue(), displayModel});
        }
        for (Map.Entry rankLevel : rankLevelParam.entrySet()) {
            setter.addRow(new Object[]{"rank_" + rankLevel.getKey(), rankLevel.getValue(), displayModel});
        }
        return setter;
    }

    public static TableValueSetter getNameDesignerGridTableValueSetter(List<SalaryStandardEntryEntity> salaryStandardEntryEntities) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("index", new Object[0]);
        setter.addField("displayname", new Object[0]);
        setter.addField("entityid", new Object[0]);
        for (SalaryStandardEntryEntity salaryStandardEntryEntity : salaryStandardEntryEntities) {
            setter.addRow(new Object[]{salaryStandardEntryEntity.getIndex(), salaryStandardEntryEntity.getDisplayName(), salaryStandardEntryEntity.getId()});
        }
        return setter;
    }

    public static List<SalaryStdDataEntity> mergeEntryRows(List<SalaryStdDataEntity> stdDataEntities, List<SalaryStdDataEntity> dataList) {
        Set idStrSet = dataList.stream().map(entity -> StringUtils.join((Object[])new Long[]{entity.getGradeIdentity(), entity.getItemIdentity(), entity.getRankIdentity()})).collect(Collectors.toSet());
        Iterator<SalaryStdDataEntity> iterator = stdDataEntities.iterator();
        while (iterator.hasNext()) {
            SalaryStdDataEntity entity2 = iterator.next();
            String idStr = StringUtils.join((Object[])new Long[]{entity2.getGradeIdentity(), entity2.getItemIdentity(), entity2.getRankIdentity()});
            if (!idStrSet.contains(idStr)) continue;
            iterator.remove();
        }
        stdDataEntities.addAll(dataList);
        return stdDataEntities;
    }
}

