/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard;

import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.swc.hcdm.business.salarystandard.validator.StdApplyRangeMustInputValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdContrastPropCompleteValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdContrastPropMustInputValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdContrastPropOverrideValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdContrastSetGradeRankValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdDesignerCompleteValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdDesignerMustInputValidator;
import kd.swc.hcdm.business.salarystandard.validator.StdDesignerWeakCompleteValidator;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;

public class StdValidatorHelper {
    public static ValidatorTree getValidatorTreeForCommonOp(ValidateContext<SalaryStandardEntryData> validateContext, SalaryStandardEntryData entryData) {
        SalaryStandardBaseEntity stdBaseEntity = entryData.getStdBaseEntity();
        SalaryStandardTypeEnum type = stdBaseEntity.getType();
        boolean isBoard = SalaryStandardTypeEnum.BROADBAND == type;
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode root = tree.getRoot();
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdApplyRangeMustInputValidator(validateContext, ErrorLevel.FatalError)));
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdDesignerMustInputValidator(validateContext, ErrorLevel.FatalError)));
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdContrastPropMustInputValidator(validateContext, ErrorLevel.FatalError)));
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdDesignerCompleteValidator(validateContext, ErrorLevel.FatalError)));
        if (!isBoard) {
            tree.addNode(root, new ValidatorTree.ValidatorNode(new StdDesignerWeakCompleteValidator(validateContext, ErrorLevel.FatalError)));
        }
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdContrastPropCompleteValidator(validateContext, ErrorLevel.FatalError)));
        tree.addNode(root, new ValidatorTree.ValidatorNode(new StdContrastSetGradeRankValidator(validateContext, ErrorLevel.FatalError)));
        if (!isBoard) {
            tree.addNode(root, new ValidatorTree.ValidatorNode(new StdContrastPropOverrideValidator(validateContext, ErrorLevel.FatalError)));
        }
        return tree;
    }

    public static ValidatorTree getMustInputValidatorTreeForDesign(ValidateContext<SalaryStandardEntryData> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode mustInputNode = new ValidatorTree.ValidatorNode(new StdDesignerMustInputValidator(validateContext, ErrorLevel.FatalError));
        tree.addNode(tree.getRoot(), mustInputNode);
        return tree;
    }

    public static ValidatorTree getToNextValidatorTreeForDesign(ValidateContext<SalaryStandardEntryData> validateContext, SalaryStandardEntryData entryData) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode mustInputNode = new ValidatorTree.ValidatorNode(new StdDesignerMustInputValidator(validateContext, ErrorLevel.FatalError));
        ValidatorTree.ValidatorNode completeNode = new ValidatorTree.ValidatorNode(new StdDesignerCompleteValidator(validateContext, ErrorLevel.Warning));
        ValidatorTree.ValidatorNode weakCompleteNode = new ValidatorTree.ValidatorNode(new StdDesignerWeakCompleteValidator(validateContext, ErrorLevel.Warning));
        tree.addNode(tree.getRoot(), mustInputNode);
        tree.addNode(tree.getRoot(), completeNode);
        tree.addNode(completeNode, weakCompleteNode);
        return tree;
    }

    public static ValidatorTree getMustValidatorTreeForContrast(ValidateContext<SalaryStandardEntryData> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode mustInputNode = new ValidatorTree.ValidatorNode(new StdContrastPropMustInputValidator(validateContext, ErrorLevel.FatalError));
        tree.addNode(tree.getRoot(), mustInputNode);
        return tree;
    }

    public static ValidatorTree getValidatorTreeForContrast(ValidateContext<SalaryStandardEntryData> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode propCompleNode = new ValidatorTree.ValidatorNode(new StdContrastPropCompleteValidator(validateContext, ErrorLevel.Warning));
        ValidatorTree.ValidatorNode setGradeRankNode = new ValidatorTree.ValidatorNode(new StdContrastSetGradeRankValidator(validateContext, ErrorLevel.Warning));
        ValidatorTree.ValidatorNode propOverrideNode = new ValidatorTree.ValidatorNode(new StdContrastPropOverrideValidator(validateContext, ErrorLevel.Warning));
        tree.addNode(tree.getRoot(), propCompleNode);
        tree.addNode(tree.getRoot(), setGradeRankNode);
        tree.addNode(setGradeRankNode, propOverrideNode);
        return tree;
    }

    public static ValidatorTree getValidatorTreeForCal(ValidateContext<SalaryStandardEntryData> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode mustInputNode = new ValidatorTree.ValidatorNode(new StdDesignerMustInputValidator(validateContext, ErrorLevel.FatalError));
        ValidatorTree.ValidatorNode completeNode = new ValidatorTree.ValidatorNode(new StdDesignerCompleteValidator(validateContext, ErrorLevel.FatalError));
        ValidatorTree.ValidatorNode weakCompleteNode = new ValidatorTree.ValidatorNode(new StdDesignerWeakCompleteValidator(validateContext, ErrorLevel.Error));
        tree.addNode(tree.getRoot(), mustInputNode);
        tree.addNode(mustInputNode, completeNode);
        tree.addNode(completeNode, weakCompleteNode);
        return tree;
    }
}

