/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.swc.hcdm.business.salarystandard.constraint.graph.EntityData;

public class EntityDataKey {
    private String entityNumber;
    private Long pkId;

    public EntityDataKey() {
    }

    public EntityDataKey(String entityNumber, Long pkId) {
        this.entityNumber = entityNumber;
        this.pkId = pkId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public Long getPkId() {
        return this.pkId;
    }

    public void setPkId(Long pkId) {
        this.pkId = pkId;
    }

    public static List<EntityDataKey> getEntityDataKeys(List<EntityData> allEntityData) {
        ArrayList entityDataKeys = Lists.newArrayListWithExpectedSize((int)10);
        for (EntityData entityData : allEntityData) {
            String entityNumber = entityData.getEntityNumber();
            List<Long> pkIds = entityData.getPkIds();
            for (Long pkId : pkIds) {
                EntityDataKey entityDataKey = new EntityDataKey();
                entityDataKey.setEntityNumber(entityNumber);
                entityDataKey.setPkId(pkId);
                entityDataKeys.add(entityDataKey);
            }
        }
        return entityDataKeys;
    }

    public String toString() {
        return "EntityDataKey{entityNumber='" + this.entityNumber + '\'' + ", pkId=" + this.pkId + '}';
    }
}

