/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetNumberConstraintEvent;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.converter.Converter;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.FieldTypeHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;
import org.apache.commons.lang3.StringUtils;

public class EntryFieldConstraintMapping {
    private static Map<String, Converter> stdItemRankMap = Maps.newHashMapWithExpectedSize((int)16);
    private static Map<String, Converter> stdItemSpRankMap = Maps.newHashMapWithExpectedSize((int)16);
    private static Map<String, Converter> spItemSpRankMap = Maps.newHashMapWithExpectedSize((int)16);
    private static Map<String, Converter> spItemStdRankMap = Maps.newHashMapWithExpectedSize((int)16);
    private static DecimalConverter defaultDecimalConverter = new DecimalConverter("[0,]", 12, 2);
    private static DecimalConverter summaryDecimalConverter = new DecimalConverter("[0,]", 15, 2);
    private static DecimalConverter percentageDecimalConverter = new DecimalConverter("[0,]", 5, 2);
    private static final String var_two_tpl = "%s-%d";
    private static final String var_three_tpl = "%s-%d-%d";
    private static final String var_four_tpl = "%s-%d-%d-%d";
    private HRPluginProxy<IStdTableExtPlugin> onGetNumberConstraintProxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetNumberConstraint", null);
    private FieldTypeHelper fieldTypeHelper = new FieldTypeHelper();
    private Map<Param, DecimalConverter> constraintCache = Maps.newHashMap();

    public FieldTypeHelper getFieldTypeHelper() {
        return this.fieldTypeHelper;
    }

    public void setFieldTypeHelper(FieldTypeHelper fieldTypeHelper) {
        this.fieldTypeHelper = fieldTypeHelper;
    }

    public DecimalConverter getConstraintWithCache(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        Converter converter;
        if (item == null) {
            return null;
        }
        Param param = new Param(stdBaseEntity, item, rank, seq);
        DecimalConverter converterFromCache = this.constraintCache.get(param);
        if (converterFromCache == null && (converter = this.getConverterWithExt(stdBaseEntity, item, rank, seq)) instanceof DecimalConverter) {
            this.constraintCache.put(param, (DecimalConverter)converter);
            converterFromCache = (DecimalConverter)converter;
        }
        return converterFromCache;
    }

    public Converter getConverterWithExt(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        DecimalConverter converter = null;
        OnGetNumberConstraintEvent evt = new OnGetNumberConstraintEvent((Object)stdBaseEntity);
        evt.setStdBaseEntity(stdBaseEntity);
        evt.setItemEntity(item);
        evt.setRankEntity(rank);
        evt.setSeq(seq);
        boolean withGroupItem = rank != null;
        this.onGetNumberConstraintProxy.callAfter(plugin -> {
            plugin.onGetNumberConstraint(evt);
            return null;
        });
        if (evt.getDataScope() != null || evt.getPrecision() > 0 || evt.getScale() > 0) {
            DecimalConverter deCimalConverter = new DecimalConverter(evt.getDataScope(), evt.getPrecision(), evt.getScale());
            String fieldType = null;
            fieldType = withGroupItem ? this.fieldTypeHelper.getFieldTypeForGroupItemWithExt(stdBaseEntity.getType(), item, rank, seq) : this.fieldTypeHelper.getFieldTypeForTabularWithExt(stdBaseEntity.getType(), item, seq);
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"amountfield")) {
                int intLen = deCimalConverter.getPrecision() - deCimalConverter.getScale();
                int amountPrecision = stdBaseEntity.getCurrencyEntity().getAmtPrecision();
                deCimalConverter.setPrecision(intLen + amountPrecision);
                deCimalConverter.setScale(stdBaseEntity.getCurrencyEntity().getAmtPrecision());
            }
            converter = deCimalConverter;
        }
        return converter;
    }

    public static Converter getDefaultConverter(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        Converter converter = null;
        if (rank != null) {
            SalaryRankLabelEnum rankLabel = rank.getRankLabel();
            converter = itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD) ? (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? stdItemRankMap.get(String.format(var_two_tpl, stdBaseEntity.getType().getCode(), seq)) : stdItemSpRankMap.get(String.format(var_three_tpl, stdBaseEntity.getType().getCode(), rank.getRankIdentity(), seq))) : (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? spItemStdRankMap.get(String.format(var_three_tpl, stdBaseEntity.getType().getCode(), item.getItemIdentity(), seq)) : spItemSpRankMap.get(String.format(var_four_tpl, stdBaseEntity.getType().getCode(), item.getItemIdentity(), rank.getRankIdentity(), seq)));
        }
        if (converter == null && SalaryItemLabelEnum.SPECIAL.equals((Object)itemLabel)) {
            VarPredictItemType varPredictItemType = SalaryStdItemHelper.getVarPredictItemTypeById(item.getItemIdentity());
            if (VarPredictItemType.predict == varPredictItemType) {
                converter = summaryDecimalConverter;
            }
            if (VarPredictItemType.variable == varPredictItemType) {
                converter = percentageDecimalConverter;
            }
        }
        if (converter == null) {
            converter = defaultDecimalConverter;
        }
        return converter;
    }

    static {
        stdItemRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT, SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode()), defaultDecimalConverter);
        stdItemRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), defaultDecimalConverter);
        stdItemRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), defaultDecimalConverter);
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT, SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), new DecimalConverter("[0,100]", 5, 2));
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), new DecimalConverter("[0,100]", 5, 2));
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), defaultDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), percentageDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_WIDTH, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), percentageDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_GEARDIFFERENCE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), defaultDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_OVERLAP, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), percentageDecimalConverter);
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_RANK_ISOMETRIC, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), percentageDecimalConverter);
        spItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
        spItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND, SalaryStandardConstants.S_ITEM_TOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), summaryDecimalConverter);
    }

    static class Param {
        private SalaryStandardBaseEntity stdBaseEntity;
        private SalaryStdItemEntity item;
        private SalaryRankEntity rank;
        private int seq;

        public Param(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
            this.stdBaseEntity = stdBaseEntity;
            this.item = item;
            this.rank = rank;
            this.seq = seq;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Param)) {
                return false;
            }
            Param param = (Param)obj;
            return this.seq == param.seq && Objects.equals(this.stdBaseEntity.getId(), param.stdBaseEntity.getId()) && Objects.equals(this.item.getItemIdentity(), param.item.getItemIdentity()) && Objects.equals(this.rank.getRankIdentity(), param.rank.getRankIdentity());
        }

        public int hashCode() {
            return Objects.hash(this.stdBaseEntity.getId(), this.item.getItemIdentity(), this.rank.getRankIdentity(), this.seq);
        }
    }
}

