/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.swc.hcdm.common.stdtab.AppliedRangeEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.swc.hcdm.business.salarystandard.constraint.ConstraintValidateResult;
import kd.swc.hcdm.business.salarystandard.constraint.DeleteResult;
import kd.swc.hcdm.business.salarystandard.constraint.EntityDataKey;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintResult;
import kd.swc.hcdm.business.salarystandard.constraint.graph.EntityData;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public class StandardTabConstrainManager {
    private static final Log logger = LogFactory.getLog(StandardTabConstrainManager.class);
    private static final String COUNTRY_ENTITY = "bd_country";
    private ConstraintGraphCalculator calculator = new ConstraintGraphCalculator();

    @Deprecated
    public ConstraintResult calcConstraintForApplyRange(Long countryId, List<AppliedRangeEntity> applyRangeData, String activeEntity) {
        logger.info("calcConstraintForApplyRange : activeEntity = {} ,applyRangeData = {}", (Object)activeEntity, (Object)JSON.toJSONString(applyRangeData));
        return null;
    }

    public ConstraintResult calcConstraintForContrastProp(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, ContrastRowDataEntity contrastRowData, Long activeContrastPropCfgId) {
        logger.info("calcConstraintForContrastProp : activeContrastPropCfgId = {},applyRangeData={}", (Object)activeContrastPropCfgId, (Object)JSON.toJSONString(applyRangeData));
        if (this.checkInBlankList(activeContrastPropCfgId)) {
            ConstraintResult constraintResult = new ConstraintResult();
            constraintResult.setConstraintFilter(ConstraintGraphCalculator.getTrueFilter());
            return new ConstraintResult();
        }
        Long activeNodeId = this.calculator.getNodeIdByContrastPropId(activeContrastPropCfgId);
        if (activeNodeId == null) {
            return new ConstraintResult();
        }
        logger.info("calcConstraintForContrastProp : activeEntity = {},applyRangeData={}", (Object)activeNodeId, (Object)JSON.toJSONString(applyRangeData));
        ConstraintResult constraintResult = new ConstraintResult();
        ArrayList entityDataList = Lists.newArrayListWithExpectedSize((int)applyRangeData.size());
        EntityData countryData = new EntityData();
        countryData.setNodeId(this.calculator.getCountryNode());
        countryData.setEntityNumber(COUNTRY_ENTITY);
        countryData.setPkIds(Lists.newArrayList((Object[])new Long[]{countryId}));
        entityDataList.add(countryData);
        if (contrastRowData == null) {
            contrastRowData = new ContrastRowDataEntity();
            contrastRowData.setStdContrastArrValue((List)Lists.newArrayList((Object[])new List[props.size()]));
        }
        List stdContrastDataIds = contrastRowData.getStdContrastArrValue();
        for (int i = 0; i < props.size(); ++i) {
            ContrastPropEntity propEntity = props.get(i);
            Long nodeId = this.calculator.getNodeIdByContrastPropId(propEntity.getPropConfigId());
            if (nodeId == null) continue;
            List valueSet = (List)stdContrastDataIds.get(i);
            EntityData data = new EntityData();
            data.setEntityNumber(propEntity.getPropConfigEntity().getObjectTypeIId());
            data.setPkIds(valueSet);
            data.setNodeId(nodeId);
            entityDataList.add(data);
        }
        constraintResult = this.calculator.calcConstraint(entityDataList, activeNodeId, true, null);
        logger.info("calcConstraintForContrastProp result: activeEntity = {} , result = {}", (Object)activeNodeId, (Object)constraintResult.toString());
        return constraintResult;
    }

    public DeleteResult calcDeleteByUpdateCountry(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastData, List<AppliedRangeEntity> currentDelData) {
        logger.info("calcConstraintForContrastProp : currentDelData = {},applyRangeData={}", (Object)JSON.toJSONString(currentDelData), (Object)JSON.toJSONString(applyRangeData));
        ArrayList contrastDataOfNeedDel = Lists.newArrayListWithExpectedSize((int)contrastData.size());
        for (ContrastRowDataEntity contrastDatum : contrastData) {
            ContrastRowDataEntity contrastDatumOfNeedDel = (ContrastRowDataEntity)ObjectUtils.clone((Object)contrastDatum);
            ContrastRowDataEntity contrastDatumAfterDel = (ContrastRowDataEntity)ObjectUtils.clone((Object)contrastDatum);
            contrastDataOfNeedDel.add(contrastDatumOfNeedDel);
            for (int i = 0; i < props.size(); ++i) {
                contrastDatumOfNeedDel.getStdContrastArrValue().set(i, Lists.newArrayList());
                ConstraintResult constraintResult = this.calcConstraintForContrastProp(countryId, applyRangeData, props, contrastDatumAfterDel, props.get(i).getPropConfigId());
                if (constraintResult.getConstraintFilter() == null) continue;
                List<Long> leftPkIds = this.loadDataByConstraintAndIds(props.get(i).getPropConfigEntity().getObjectTypeIId(), constraintResult.getConstraintFilter(), (List)contrastDatum.getStdContrastArrValue().get(i));
                contrastDatumAfterDel.getStdContrastArrValue().set(i, leftPkIds);
                ArrayList needDelPkIds = Lists.newArrayList((Iterable)CollectionUtils.removeAll((Collection)((Collection)contrastDatum.getStdContrastArrValue().get(i)), leftPkIds));
                contrastDatumOfNeedDel.getStdContrastArrValue().set(i, needDelPkIds);
            }
        }
        DeleteResult result = new DeleteResult();
        result.setApplyRangeData(applyRangeData);
        result.setContrastData(contrastDataOfNeedDel);
        result.setProps(props);
        result.setContrastPropDelPkIds(this.collectAllDelIds(props, contrastDataOfNeedDel));
        return result;
    }

    private Map<Long, Set<Long>> collectAllDelIds(List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastDataOfNeedDel) {
        LinkedHashMap entityMap = Maps.newLinkedHashMap();
        for (ContrastRowDataEntity rowDataEntity : contrastDataOfNeedDel) {
            List stdContrastDataIds = rowDataEntity.getStdContrastArrValue();
            for (int i = 0; i < stdContrastDataIds.size(); ++i) {
                List pkIds = (List)stdContrastDataIds.get(i);
                if (!CollectionUtils.isNotEmpty((Collection)pkIds)) continue;
                ContrastPropEntity propEntity = props.get(i);
                Set values = entityMap.computeIfAbsent(propEntity.getPropConfigId(), val -> Sets.newHashSet());
                values.addAll(pkIds);
            }
        }
        return entityMap;
    }

    public DeleteResult calcDeleteByRemovedContrastData(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastData, List<Long> removePkIds, Long removedPropCfgId, int rowIndex) {
        List<Object> leftPkIds;
        ContrastPropEntity prop;
        int i;
        logger.info("calcConstraintForContrastProp : removedPropCfgId = {},removePkIds = {},applyRangeData={}", new Object[]{removedPropCfgId, JSON.toJSONString(removePkIds), JSON.toJSONString(applyRangeData)});
        ContrastRowDataEntity rowDataEntityOfNeedCheck = null;
        for (ContrastRowDataEntity contrastDatum : contrastData) {
            if (contrastDatum.getRowIndex() != rowIndex) continue;
            rowDataEntityOfNeedCheck = contrastDatum;
            break;
        }
        if (rowDataEntityOfNeedCheck == null) {
            throw new KDBizException(String.format(Locale.ROOT, "rowIndex %d not found in rowset", rowIndex));
        }
        ContrastRowDataEntity rowDataEntityOfAfterDel = (ContrastRowDataEntity)ObjectUtils.clone(rowDataEntityOfNeedCheck);
        for (i = 0; i < props.size(); ++i) {
            prop = props.get(i);
            if (!prop.getPropConfigId().equals(removedPropCfgId)) continue;
            List originDataOfRemovedProp = (List)rowDataEntityOfAfterDel.getStdContrastArrValue().get(i);
            leftPkIds = Lists.newArrayList((Iterable)CollectionUtils.removeAll((Collection)originDataOfRemovedProp, removePkIds));
            rowDataEntityOfAfterDel.getStdContrastArrValue().set(i, leftPkIds);
            break;
        }
        for (i = 0; i < props.size(); ++i) {
            ConstraintResult constraintResult;
            prop = props.get(i);
            if (prop.getPropConfigId().equals(removedPropCfgId) || (constraintResult = this.calcConstraintForContrastProp(countryId, applyRangeData, props, rowDataEntityOfAfterDel, prop.getPropConfigId())).getConstraintFilter() == null) continue;
            leftPkIds = this.loadDataByConstraintAndIds(prop.getPropConfigEntity().getObjectTypeIId(), constraintResult.getConstraintFilter(), (List)rowDataEntityOfAfterDel.getStdContrastArrValue().get(i));
            rowDataEntityOfAfterDel.getStdContrastArrValue().set(i, leftPkIds);
        }
        DeleteResult result = new DeleteResult();
        for (int i2 = 0; i2 < props.size(); ++i2) {
            ContrastPropEntity prop2 = props.get(i2);
            List originPkIds = (List)rowDataEntityOfNeedCheck.getStdContrastArrValue().get(i2);
            if (prop2.getPropConfigId().equals(removedPropCfgId)) {
                rowDataEntityOfAfterDel.getStdContrastArrValue().set(i2, removePkIds);
                continue;
            }
            List leftPkIds2 = (List)rowDataEntityOfAfterDel.getStdContrastArrValue().get(i2);
            ArrayList needDelPkIds = Lists.newArrayList((Iterable)CollectionUtils.removeAll((Collection)originPkIds, (Collection)leftPkIds2));
            rowDataEntityOfAfterDel.getStdContrastArrValue().set(i2, needDelPkIds);
        }
        result.setProps(props);
        result.setContrastData(Collections.singletonList(rowDataEntityOfAfterDel));
        result.setContrastPropDelPkIds(this.collectAllDelIds(props, result.getContrastData()));
        return result;
    }

    public DeleteResult calcDeleteByRemovedContrastProp(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastData, List<Long> removedPropCfgIds) {
        List<Object> leftPkIds;
        ContrastPropEntity prop;
        int i;
        logger.info("calcConstraintForContrastProp : removedPropCfgIds = {},removePkIds = {},applyRangeData={}", (Object)JSON.toJSONString(removedPropCfgIds), (Object)JSON.toJSONString(applyRangeData));
        ArrayList contrastDataOfAfterDel = Lists.newArrayListWithCapacity((int)contrastData.size());
        for (ContrastRowDataEntity contrastDatum : contrastData) {
            ContrastRowDataEntity rowDataEntityOfAfterDel = (ContrastRowDataEntity)ObjectUtils.clone((Object)contrastDatum);
            contrastDataOfAfterDel.add(rowDataEntityOfAfterDel);
            boolean isExistDel = false;
            for (i = 0; i < props.size(); ++i) {
                List originDataOfRemovedProp;
                prop = props.get(i);
                if (!removedPropCfgIds.contains(prop.getPropConfigId()) || !CollectionUtils.isNotEmpty((Collection)(originDataOfRemovedProp = (List)rowDataEntityOfAfterDel.getStdContrastArrValue().get(i)))) continue;
                isExistDel = true;
                rowDataEntityOfAfterDel.getStdContrastArrValue().set(i, Lists.newArrayList());
            }
            if (!isExistDel) continue;
            for (i = 0; i < props.size(); ++i) {
                ConstraintResult constraintResult;
                prop = props.get(i);
                if (removedPropCfgIds.contains(prop.getPropConfigId()) || (constraintResult = this.calcConstraintForContrastProp(countryId, applyRangeData, props, rowDataEntityOfAfterDel, prop.getPropConfigId())).getConstraintFilter() == null) continue;
                leftPkIds = this.loadDataByConstraintAndIds(prop.getPropConfigEntity().getObjectTypeIId(), constraintResult.getConstraintFilter(), (List)rowDataEntityOfAfterDel.getStdContrastArrValue().get(i));
                rowDataEntityOfAfterDel.getStdContrastArrValue().set(i, leftPkIds);
            }
        }
        DeleteResult result = new DeleteResult();
        for (int rowIndex = 0; rowIndex < contrastData.size(); ++rowIndex) {
            ContrastRowDataEntity originRowData = contrastData.get(rowIndex);
            ContrastRowDataEntity rowDataOfAfterDel = (ContrastRowDataEntity)contrastDataOfAfterDel.get(rowIndex);
            for (i = 0; i < props.size(); ++i) {
                prop = props.get(i);
                if (removedPropCfgIds.contains(prop.getPropConfigId())) continue;
                List originPkIds = (List)originRowData.getStdContrastArrValue().get(i);
                leftPkIds = (List)rowDataOfAfterDel.getStdContrastArrValue().get(i);
                if (originPkIds == null) continue;
                if (leftPkIds == null) {
                    leftPkIds = Collections.emptyList();
                }
                ArrayList needDelPkIds = Lists.newArrayList((Iterable)CollectionUtils.removeAll((Collection)originPkIds, leftPkIds));
                rowDataOfAfterDel.getStdContrastArrValue().set(i, needDelPkIds);
            }
        }
        result.setProps(props);
        result.setContrastData(contrastDataOfAfterDel);
        result.setContrastPropDelPkIds(this.collectAllDelIds(props, result.getContrastData()));
        return result;
    }

    public DeleteResult calcDeleteByUpdateCountry(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastData) {
        logger.info("calcDeleteByRemovedCountry before : oldCountry = {}", (Object)countryId);
        DeleteResult result = this.calcDeleteByUpdateCountry(countryId, applyRangeData, props, contrastData, Collections.emptyList());
        logger.info("calcDeleteByRemovedCountry after (by calcDeleteByRemovedApplyRange) : DeleteResult = {}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public List<List<ConstraintValidateResult>> validateForContrastData(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastData) {
        ArrayList validateResultList = Lists.newArrayListWithExpectedSize((int)contrastData.size());
        if (contrastData.size() > 1) {
            ContrastRowDataEntity mergeResult = this.mergeToOneRow(contrastData);
            this.preValidateOnBatchData(countryId, applyRangeData, props, mergeResult);
        }
        for (int rowIndex = 0; rowIndex < contrastData.size(); ++rowIndex) {
            ContrastRowDataEntity contrastRowDataBeforeDel = contrastData.get(rowIndex);
            ContrastRowDataEntity contrastRowDataAfterDel = (ContrastRowDataEntity)ObjectUtils.clone((Object)contrastRowDataBeforeDel);
            logger.info("validateForContrastData contrastRowData-->{}", (Object)JSON.toJSONString((Object)contrastRowDataBeforeDel.getStdContrastArrValue()));
            ArrayList tempRowResult = Lists.newArrayListWithExpectedSize((int)props.size());
            validateResultList.add(tempRowResult);
            for (int i = 0; i < props.size(); ++i) {
                ContrastPropEntity prop = props.get(i);
                ConstraintResult constraintResult = this.calcConstraintForContrastProp(countryId, applyRangeData, props, contrastRowDataAfterDel, prop.getPropConfigId());
                if (constraintResult.getConstraintFilter() == null) continue;
                List originPkIds = (List)contrastRowDataBeforeDel.getStdContrastArrValue().get(i);
                List<Long> leftPkIds = this.loadDataByConstraintAndIds(prop.getPropConfigEntity().getObjectTypeIId(), constraintResult.getConstraintFilter(), originPkIds);
                contrastRowDataAfterDel.getStdContrastArrValue().set(i, leftPkIds);
                ArrayList needDelPkIds = Lists.newArrayList((Iterable)CollectionUtils.removeAll((Collection)originPkIds, leftPkIds));
                if (!CollectionUtils.isNotEmpty((Collection)needDelPkIds)) continue;
                ConstraintValidateResult constraintValidateResult = new ConstraintValidateResult();
                constraintValidateResult.setValidateEntity(prop.getPropConfigEntity().getObjectTypeIId());
                constraintValidateResult.setPropConfigId(prop.getPropConfigId());
                constraintValidateResult.setNotMatchPkIds(needDelPkIds);
                List<String> nodeName = this.calculator.getNodeNameById(constraintResult.getRelationNodeIds());
                int countryNodeIdx = constraintResult.getRelationNodeIds().indexOf(this.calculator.getCountryNode());
                if (countryNodeIdx >= 0) {
                    nodeName.set(countryNodeIdx, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"AdjConfirmTplEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                }
                constraintValidateResult.setRelationNodeName(nodeName);
                tempRowResult.add(constraintValidateResult);
            }
            logger.info("validateForContrastData tempRowResult-->{}", (Object)JSON.toJSONString((Object)tempRowResult));
        }
        return validateResultList;
    }

    private void preValidateOnBatchData(Long countryId, List<AppliedRangeEntity> applyRangeData, List<ContrastPropEntity> props, ContrastRowDataEntity contrastData) {
        logger.info("preValidateOnBatchData begin");
        for (int i = 0; i < props.size(); ++i) {
            ContrastPropEntity prop = props.get(i);
            this.calcConstraintForContrastProp(countryId, applyRangeData, props, contrastData, prop.getPropConfigId());
        }
        logger.info("preValidateOnBatchData end");
    }

    private ContrastRowDataEntity mergeToOneRow(List<ContrastRowDataEntity> contrastDataEntity) {
        int propSize = contrastDataEntity.get(0).getStdContrastArrValue().size();
        ArrayList propValues = Lists.newArrayListWithCapacity((int)propSize);
        for (int i = 0; i < propSize; ++i) {
            propValues.add(Sets.newHashSet());
        }
        for (ContrastRowDataEntity entity : contrastDataEntity) {
            for (int index = 0; index < entity.getStdContrastArrValue().size(); ++index) {
                ((Set)propValues.get(index)).addAll((Collection)entity.getStdContrastArrValue().get(index));
            }
        }
        List propValueList = propValues.stream().map(Lists::newArrayList).collect(Collectors.toList());
        return new ContrastRowDataEntity(0, propValueList, null, null, 0);
    }

    @Deprecated
    private List<EntityData> mergeEntityData(List<AppliedRangeEntity> rangeDataListOfAfterDel, List<ContrastPropEntity> props, List<ContrastRowDataEntity> contrastDataOfNeedDel) {
        return null;
    }

    public List<Long> loadDataByConstraintAndIds(String rangeType, QFilter constraintFilter, List<Long> pkIds) {
        QFilter pkFilter = new QFilter("id", "in", pkIds);
        Map existData = BusinessDataServiceHelper.loadFromCache((String)rangeType, (String)"id", (QFilter[])new QFilter[]{pkFilter, constraintFilter});
        return existData.keySet().stream().map(o1 -> (Long)o1).collect(Collectors.toList());
    }

    public Map<String, String> getEntityData(EntityDataKey key, IFormView formView) {
        SWCPageCache pageCache = new SWCPageCache(formView);
        String entityNumber = key.getEntityNumber();
        Long pkId = key.getPkId();
        String cacheKey = key.toString();
        Map entityNameMap = (Map)pageCache.get(cacheKey, Map.class);
        if (entityNameMap == null) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityNumber);
            QFilter qFilter = new QFilter("id", "=", (Object)pkId);
            String selectProperties = "name";
            DynamicObject dy = serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
            entityNameMap = Maps.newHashMapWithExpectedSize((int)2);
            if (dy != null) {
                entityNameMap.put("name", dy.getString("name"));
            }
        }
        return entityNameMap;
    }

    @Deprecated
    public List<EntityDataKey> getEntityDataKey(DeleteResult deleteResult) {
        return null;
    }

    private boolean checkInBlankList(Long propCfg) {
        return propCfg.equals(1300L);
    }
}

