/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGroupExpParser;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintResult;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintType;
import kd.swc.hcdm.business.salarystandard.constraint.graph.EdgeDir;
import kd.swc.hcdm.business.salarystandard.constraint.graph.EntityData;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphCacheManager;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNodeType;
import kd.swc.hcdm.business.salarystandard.constraint.graph.LightColor;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConstraintGraphCalculator {
    private static final Log logger = LogFactory.getLog(ConstraintGraphCalculator.class);
    private static final String ENTITY_GRAPHNODE = "hcdm_constraintnode";
    private static final String ENTITY_GRAPHEDGE = "hcdm_constraintedge";
    private Map<Long, GraphNode> nodeMap;
    private List<GraphEdge> edgeList;
    private Map<Long, GraphEdge> edgeMap;
    private GraphCacheManager cacheManager = new GraphCacheManager();
    private static final List<Pair<Long, EdgeDir>> canEmptyOfRefKey = Lists.newArrayList();

    public static final QFilter getNOTFilter() {
        return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
    }

    public static final QFilter getTrueFilter() {
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    public boolean canEmpty(GraphEdge edge, EdgeDir dir) {
        for (Pair<Long, EdgeDir> edgeDirPair : canEmptyOfRefKey) {
            if (!((Long)edgeDirPair.getKey()).equals(edge.getId())) continue;
            return edgeDirPair.getValue() == dir;
        }
        return false;
    }

    public ConstraintGraphCalculator() {
        this.initNode();
        this.initEdge();
    }

    private void initEdge() {
        SWCDataServiceHelper edgeServiceHelper = new SWCDataServiceHelper(ENTITY_GRAPHEDGE);
        DynamicObject[] edgeObjs = edgeServiceHelper.query("id,name,sourcenode,targetnode,constrainttypes2t,constrainttypet2s,refprop,constraintservice,positivedepedge,positivedepedgedir,reversedepedge,reversedepedgedir", new QFilter[0]);
        this.edgeList = Lists.newArrayListWithExpectedSize((int)edgeObjs.length);
        this.edgeMap = Maps.newLinkedHashMapWithExpectedSize((int)edgeObjs.length);
        for (DynamicObject edgeObj : edgeObjs) {
            GraphEdge graphEdge = new GraphEdge();
            long sourceNodeId = edgeObj.getLong("sourcenode.id");
            long targetNodeId = edgeObj.getLong("targetnode.id");
            graphEdge.setId(edgeObj.getLong("id"));
            graphEdge.setSourceNode(this.nodeMap.get(sourceNodeId));
            graphEdge.setTargetNode(this.nodeMap.get(targetNodeId));
            graphEdge.setConstraintOfSourceToTarget(ConstraintType.getByCode(edgeObj.getString("constrainttypes2t")));
            graphEdge.setConstraintOfTargetToSource(ConstraintType.getByCode(edgeObj.getString("constrainttypet2s")));
            graphEdge.setRefProp(edgeObj.getString("refprop"));
            graphEdge.setConstraintService(edgeObj.getString("constraintservice"));
            graphEdge.setName(edgeObj.getString("name"));
            this.edgeList.add(graphEdge);
            this.edgeMap.put(graphEdge.getId(), graphEdge);
        }
        for (DynamicObject edgeObj : edgeObjs) {
            long id = edgeObj.getLong("id");
            long positiveDepEdgeId = edgeObj.getLong("positivedepedge.id");
            long reverseDepEdgeId = edgeObj.getLong("reversedepedge.id");
            String positiveDepEdgeDir = edgeObj.getString("positivedepedgedir");
            String reverseDepEdgeDir = edgeObj.getString("reversedepedgedir");
            GraphEdge currentEdge = this.edgeMap.get(id);
            GraphEdge positiveDepEdge = positiveDepEdgeId > 0L ? this.edgeMap.get(positiveDepEdgeId) : null;
            GraphEdge reverseDepEdge = reverseDepEdgeId > 0L ? this.edgeMap.get(reverseDepEdgeId) : null;
            currentEdge.setPositiveDepEdge(positiveDepEdge);
            currentEdge.setReverseDepEdge(reverseDepEdge);
            currentEdge.setPositiveDepEdgeDir(EdgeDir.getByCode(positiveDepEdgeDir));
            currentEdge.setReverseDepEdgeDir(EdgeDir.getByCode(reverseDepEdgeDir));
        }
    }

    private void initNode() {
        SWCDataServiceHelper nodeServiceHelper = new SWCDataServiceHelper(ENTITY_GRAPHNODE);
        DynamicObject[] nodeObjs = nodeServiceHelper.query("id,name,nodetype,entitynumber,contrastpropcfg,constraintgroupexp", new QFilter[0]);
        this.nodeMap = Maps.newHashMapWithExpectedSize((int)nodeObjs.length);
        for (DynamicObject nodeObj : nodeObjs) {
            GraphNode graphNode = new GraphNode();
            long nodeId = nodeObj.getLong("id");
            graphNode.setName(nodeObj.getString("name"));
            graphNode.setEntityNumber(nodeObj.getString("entitynumber"));
            graphNode.setNodeType(GraphNodeType.getByCode(nodeObj.getString("nodetype")));
            graphNode.setConstraintGroupExp(nodeObj.getString("constraintgroupexp"));
            graphNode.setLightColor(LightColor.black);
            graphNode.setId(nodeId);
            graphNode.setContrastPropId(nodeObj.getLong("contrastpropcfg.id"));
            this.nodeMap.put(nodeId, graphNode);
        }
    }

    public ConstraintResult calcConstraint(List<EntityData> entityDataList, Long nodeId, boolean withOrder, List<Long> entityBlankList) {
        entityDataList = this.distinctByOrder(entityDataList, withOrder);
        this.initNodeDataSet(entityDataList);
        ConstraintResult constraintResult = new ConstraintResult();
        if (entityBlankList != null && entityBlankList.contains(nodeId)) {
            return constraintResult;
        }
        GraphNode activeNode = this.nodeMap.get(nodeId);
        if (activeNode == null) {
            return constraintResult;
        }
        this.lightUpNode(entityDataList);
        this.lightUpEdge(entityDataList, withOrder);
        this.checkEdgeDependency();
        List<GraphEdge> adjacentEdgeList = this.getAdjacentEdge(activeNode);
        HashMap qFilterMap = Maps.newHashMapWithExpectedSize((int)adjacentEdgeList.size());
        String constraintGroupExp = activeNode.getConstraintGroupExp();
        String notFilter = ConstraintGraphCalculator.getNOTFilter().toString();
        for (GraphEdge currEdge : adjacentEdgeList) {
            EdgeDir lightDir;
            GraphNode currEdgeTargetNode;
            if (!currEdge.isLightUp() || (currEdgeTargetNode = (lightDir = currEdge.getLightDir()) == EdgeDir.positive ? currEdge.getTargetNode() : currEdge.getSourceNode()) != activeNode) continue;
            GraphNode currEdgeSourceNode = lightDir == EdgeDir.positive ? currEdge.getSourceNode() : currEdge.getTargetNode();
            QFilter constraintOfActive = this.createConstraintOfActive(activeNode, currEdge);
            if (constraintOfActive == null || StringUtils.equals((CharSequence)notFilter, (CharSequence)constraintOfActive.toString())) {
                logger.warn("createConstraintOfActive result is null or [1 != 1] ,activeNodeName = {} , sourceNode = {} ,targetNode = {}", new Object[]{activeNode.getName(), JSON.toJSON((Object)currEdge.getSourceNode()), JSON.toJSON((Object)currEdge.getTargetNode())});
            }
            if (constraintOfActive == null) continue;
            qFilterMap.put(currEdgeSourceNode, constraintOfActive);
            constraintResult.getRelationNodeIds().add(currEdgeSourceNode.getId());
        }
        QFilter finalConstraintFilter = this.calcConstraintGroupExp(constraintGroupExp, qFilterMap);
        constraintResult.setConstraintFilter(finalConstraintFilter);
        logger.info("calcConstraint activeEntity ={} ,finalConstraintFilter = {}", (Object)nodeId, (Object)(finalConstraintFilter == null ? "null" : finalConstraintFilter.toString()));
        this.reset();
        return constraintResult;
    }

    public Long getNodeIdByContrastPropId(Long propId) {
        for (Map.Entry<Long, GraphNode> entry : this.nodeMap.entrySet()) {
            Long contrastPropId = entry.getValue().getContrastPropId();
            if (contrastPropId == null || !contrastPropId.equals(propId)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Long getCountryNode() {
        for (Map.Entry<Long, GraphNode> entry : this.nodeMap.entrySet()) {
            String entityNumber = entry.getValue().getEntityNumber();
            Long contrastPropId = entry.getValue().getContrastPropId();
            if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)"bd_country") || contrastPropId != 0L) continue;
            return entry.getKey();
        }
        return null;
    }

    private List<EntityData> distinctByOrder(List<EntityData> entityDataList, boolean withOrder) {
        Map collect = entityDataList.stream().collect(Collectors.groupingBy(EntityData::getNodeId, LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap distinctMap = Maps.newLinkedHashMapWithExpectedSize((int)collect.size());
        for (Map.Entry entry : collect.entrySet()) {
            Long nodeId = (Long)entry.getKey();
            List duplicatedDatas = (List)entry.getValue();
            if (!withOrder) continue;
            distinctMap.put(nodeId, duplicatedDatas.get(0));
        }
        return Lists.newArrayList(distinctMap.values());
    }

    private void reset() {
        for (GraphEdge graphEdge : this.edgeList) {
            graphEdge.setLightColor(null);
            graphEdge.setLightDir(null);
            GraphNode sourceNode = graphEdge.getSourceNode();
            GraphNode targetNode = graphEdge.getTargetNode();
            sourceNode.setLightColor(null);
            sourceNode.setDataSet(null);
            targetNode.setLightColor(null);
            targetNode.setDataSet(null);
        }
    }

    private QFilter calcConstraintGroupExp(String constraintGroupExp, Map<GraphNode, QFilter> qFilterMap) {
        if (StringUtils.isEmpty((CharSequence)constraintGroupExp)) {
            if (qFilterMap.size() > 1) {
                throw new KDBizException("constraintGroupExp is empty");
            }
            if (qFilterMap.size() == 1) {
                return (QFilter)qFilterMap.values().toArray()[0];
            }
        }
        if (qFilterMap.isEmpty()) {
            return null;
        }
        HashMap keyMap = Maps.newHashMapWithExpectedSize((int)qFilterMap.size());
        for (Map.Entry<GraphNode, QFilter> entry : qFilterMap.entrySet()) {
            keyMap.putIfAbsent(entry.getKey().getName(), entry.getValue());
        }
        return new ConstraintGroupExpParser(constraintGroupExp, keyMap).execute();
    }

    private void checkEdgeDependency() {
        for (GraphEdge edge : this.edgeList) {
            if (!edge.isLightUp()) continue;
            boolean needLightDown = true;
            EdgeDir lightDir = edge.getLightDir();
            if (EdgeDir.positive == lightDir) {
                GraphEdge positiveDepEdge = edge.getPositiveDepEdge();
                if (positiveDepEdge == null) {
                    needLightDown = false;
                } else if (positiveDepEdge.isLightUp() && positiveDepEdge.getLightDir() == edge.getPositiveDepEdgeDir()) {
                    needLightDown = false;
                }
            } else {
                GraphEdge reverseDepEdge = edge.getReverseDepEdge();
                if (reverseDepEdge == null) {
                    needLightDown = false;
                } else if (reverseDepEdge.isLightUp() && reverseDepEdge.getLightDir() == edge.getReverseDepEdgeDir()) {
                    needLightDown = false;
                }
            }
            if (!needLightDown) continue;
            edge.setLightColor(LightColor.black);
            edge.setLightDir(null);
        }
    }

    private void lightUpEdge(List<EntityData> entityDataList, boolean withOrder) {
        for (EntityData entityData : entityDataList) {
            String currentEntityNumber = entityData.getEntityNumber();
            GraphNode currentNode = this.nodeMap.get(entityData.getNodeId());
            if (currentNode == null || LightColor.white != currentNode.getLightColor()) continue;
            List<GraphEdge> adjacentEdgeList = this.getAdjacentEdge(currentNode);
            for (GraphEdge adjacentEdge : adjacentEdgeList) {
                if (LightColor.white == adjacentEdge.getLightColor()) continue;
                GraphNode adjacentNode = adjacentEdge.getSourceNode() == currentNode ? adjacentEdge.getTargetNode() : adjacentEdge.getSourceNode();
                EdgeDir dir = adjacentEdge.getSourceNode() == currentNode ? EdgeDir.positive : EdgeDir.reverse;
                boolean needLightUp = false;
                if (LightColor.white == adjacentNode.getLightColor()) {
                    if (withOrder && this.checkSuccessor(entityDataList, currentEntityNumber, adjacentNode.getEntityNumber())) {
                        needLightUp = true;
                    }
                    if (!withOrder) {
                        needLightUp = true;
                    }
                }
                if (!needLightUp) continue;
                adjacentEdge.setLightColor(LightColor.white);
                adjacentEdge.setLightDir(dir);
                logger.info("lightUpEdge : adjacentEdge = {},lightDir = {}", (Object)adjacentEdge.getName(), (Object)adjacentEdge.getLightDir().name());
            }
        }
    }

    private boolean checkSuccessor(List<EntityData> entityDataList, String currentEntityNumber, String adjacentEntityNumber) {
        int currIndex = -1;
        int adjIndex = -1;
        for (int i = 0; i < entityDataList.size(); ++i) {
            EntityData entityData = entityDataList.get(i);
            if (entityData.getEntityNumber().equals(currentEntityNumber)) {
                currIndex = i;
            }
            if (!entityData.getEntityNumber().equals(adjacentEntityNumber)) continue;
            adjIndex = i;
        }
        if (currIndex < 0 || adjIndex < 0) {
            throw new KDBizException(String.format("checkSuccessor has wrong ,currentEntityNumber = %s adjacentEntityNumber = %s", currentEntityNumber, adjacentEntityNumber));
        }
        return adjIndex > currIndex;
    }

    private void lightUpNode(List<EntityData> entityDataList) {
        for (EntityData entityData : entityDataList) {
            GraphNode graphNode = this.nodeMap.get(entityData.getNodeId());
            if (graphNode == null) continue;
            graphNode.setLightColor(LightColor.white);
        }
    }

    private QFilter createConstraintOfActive(GraphNode activeNode, GraphEdge graphEdge) {
        ConstraintType constraintType = activeNode == graphEdge.getSourceNode() ? graphEdge.getConstraintOfSourceToTarget() : graphEdge.getConstraintOfTargetToSource();
        GraphNode targetNode = activeNode == graphEdge.getSourceNode() ? graphEdge.getTargetNode() : graphEdge.getSourceNode();
        boolean canEmpty = this.canEmpty(graphEdge, graphEdge.getLightDir());
        if (constraintType == ConstraintType.COMPLEX) {
            this.tryCreateConstraintServiceInstance(graphEdge);
            return this.createConstraintComplex(activeNode, graphEdge);
        }
        if (constraintType == ConstraintType.FK_REF) {
            return this.createConstraintByFkRef(activeNode, targetNode, graphEdge.getRefProp(), canEmpty);
        }
        if (constraintType == ConstraintType.REFBY_FK) {
            return this.createConstraintByFkRefBy(activeNode, targetNode, graphEdge.getRefProp());
        }
        return null;
    }

    private QFilter createConstraintByFkRefBy(GraphNode activeNode, GraphNode targetNode, String refProp) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(targetNode.getEntityNumber());
        String selectProp = "id," + refProp;
        DynamicObject[] targetDataRows = serviceHelper.query(selectProp, new QFilter[]{new QFilter("id", "in", targetNode.getDataSet())});
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetNode.getEntityNumber());
        String filterPropName = refProp;
        DynamicProperty property = targetEntityType.getProperty(refProp);
        if (property instanceof BasedataProp) {
            filterPropName = refProp + ".id";
        }
        HashSet valueSet = Sets.newHashSetWithExpectedSize((int)targetDataRows.length);
        for (DynamicObject targetDataRow : targetDataRows) {
            Object propVapue = targetDataRow.get(filterPropName);
            if (propVapue == null) continue;
            valueSet.add(propVapue);
        }
        if (valueSet.isEmpty()) {
            return ConstraintGraphCalculator.getNOTFilter();
        }
        return new QFilter("id", "in", (Object)valueSet);
    }

    private QFilter createConstraintByFkRef(GraphNode activeNode, GraphNode targetNode, String refProp, boolean canEmpty) {
        MainEntityType activeEntityType = EntityMetadataCache.getDataEntityType((String)activeNode.getEntityNumber());
        DynamicProperty property = activeEntityType.getProperty(refProp);
        String filterPropName = refProp;
        if (property instanceof BasedataProp) {
            filterPropName = refProp + ".id";
        }
        if (CollectionUtils.isEmpty(targetNode.getDataSet())) {
            return ConstraintGraphCalculator.getNOTFilter().or(new QFilter(filterPropName, "=", (Object)0));
        }
        QFilter qFilter = new QFilter(filterPropName, "in", targetNode.getDataSet());
        if (canEmpty) {
            qFilter = qFilter.or(new QFilter(filterPropName, "=", (Object)0));
        }
        return qFilter;
    }

    private QFilter createConstraintComplex(GraphNode activeNode, GraphEdge graphEdge) {
        ComplexConstraintHandler service = graphEdge.getConstraintServiceInstance();
        QFilter resultFilter = null;
        resultFilter = activeNode == graphEdge.getSourceNode() ? service.getInverseConstraintFilter(graphEdge) : service.getConstraintFilter(graphEdge);
        return resultFilter;
    }

    private void tryCreateConstraintServiceInstance(GraphEdge graphEdge) {
        String constraintService = graphEdge.getConstraintService();
        if (StringUtils.isEmpty((CharSequence)constraintService)) {
            throw new KDBizException(String.format("constraintService not config,sourcenode is %s,targetnode is %s", graphEdge.getSourceNode().getName(), graphEdge.getTargetNode().getName()));
        }
        if (graphEdge.getConstraintServiceInstance() != null) {
            return;
        }
        Object instance = TypesContainer.createInstance((String)constraintService);
        if (instance instanceof ComplexConstraintHandler) {
            graphEdge.setConstraintServiceInstance((ComplexConstraintHandler)instance);
            if (instance instanceof AbstractGraphHandler) {
                ((AbstractGraphHandler)instance).setGraphCacheManager(this.cacheManager);
            }
        } else {
            throw new KDBizException(String.format("constraintService %s  is not instance of %s", constraintService, ComplexConstraintHandler.class.getName()));
        }
    }

    private void initNodeDataSet(List<EntityData> entityDataList) {
        for (EntityData entityData : entityDataList) {
            GraphNode node = this.nodeMap.get(entityData.getNodeId());
            if (node == null) continue;
            node.setDataSet(entityData.getPkIds());
        }
    }

    private List<GraphEdge> getAdjacentEdge(GraphNode activeNode) {
        return this.edgeList.stream().filter(o1 -> o1.getSourceNode() == activeNode || o1.getTargetNode() == activeNode).collect(Collectors.toList());
    }

    public List<String> getNodeNameById(List<Long> relationNodeIds) {
        return relationNodeIds.stream().map(o -> this.nodeMap.get(o).getName()).collect(Collectors.toList());
    }

    static {
        canEmptyOfRefKey.add((Pair<Long, EdgeDir>)Pair.create((Object)1563860174559555584L, (Object)((Object)EdgeDir.positive)));
        canEmptyOfRefKey.add((Pair<Long, EdgeDir>)Pair.create((Object)1563860814979444736L, (Object)((Object)EdgeDir.positive)));
        canEmptyOfRefKey.add((Pair<Long, EdgeDir>)Pair.create((Object)1563859241352081408L, (Object)((Object)EdgeDir.positive)));
    }
}

