/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.CharUtils;

public class ConstraintGroupExpParser {
    private static final Log logger = LogFactory.getLog(ConstraintGroupExpParser.class);
    private static final String tpl = "${%s}";
    private String exp;
    private Map<String, QFilter> keyMap;

    public ConstraintGroupExpParser(String exp, Map<String, QFilter> keyMap) {
        this.exp = exp;
        this.keyMap = keyMap;
    }

    public QFilter execute() {
        logger.info("before execute: exp = {} ,keyMap = {}", (Object)this.exp, (Object)this.keyMap.toString());
        String tempExp = this.exp;
        Node node = null;
        int startIndex = tempExp.indexOf(40);
        if (startIndex == -1) {
            return null;
        }
        int lastIndex = this.findRightBre(tempExp, startIndex);
        String substring = tempExp.substring(startIndex + 1, lastIndex);
        Node root = this.parse(substring, node);
        logger.info("exp tree is : \r\n{}", (Object)Node.print(root));
        QFilter filter = this.calcNode(root, this.keyMap);
        logger.info("end execute: exp = {}", (Object)filter);
        return filter;
    }

    private QFilter calcNode(Node root, Map<String, QFilter> keyMap) {
        String name = root.name;
        List<Node> childList = root.childList;
        if (!childList.isEmpty()) {
            return this.calcNodeWithOp(childList, name, keyMap);
        }
        return null;
    }

    private QFilter calcNodeWithOp(List<Node> childList, String op, Map<String, QFilter> keyMap) {
        QFilter qFilter = null;
        for (Node curNode : childList) {
            QFilter curNodeFilter = null;
            String type = curNode.type;
            QFilter filter = keyMap.get(curNode.name);
            if (filter != null && type.equals("2")) {
                curNodeFilter = filter.copy();
            }
            if ("1".equals(type) && !curNode.childList.isEmpty()) {
                curNodeFilter = this.calcNodeWithOp(curNode.childList, curNode.name, keyMap);
            }
            if (qFilter == null) {
                qFilter = curNodeFilter;
                continue;
            }
            switch (op) {
                case "and": {
                    qFilter = qFilter.and(curNodeFilter);
                    break;
                }
                case "or": {
                    qFilter = qFilter.or(curNodeFilter);
                    break;
                }
            }
        }
        return qFilter;
    }

    public Node parse(String exp, Node node) {
        int firstSep = exp.indexOf(44);
        String op = exp.substring(0, firstSep);
        Node opNode = Node.createOpNode(op, node);
        int start = firstSep;
        int end = exp.length();
        while (start < end) {
            String nextChar = this.findNextCharFrom(exp, start);
            if ("$".equals(nextChar)) {
                int vbegin = this.nextCharAtFrom(exp, start, '{');
                int vend = this.nextCharAtFrom(exp, start, '}');
                String vname = exp.substring(vbegin + 1, vend);
                Node.createLeafNode(vname, opNode);
                start = vend;
                continue;
            }
            if ("(".equals(nextChar)) {
                int startIndex = this.nextCharAtFrom(exp, start, '(');
                int lastIndex = this.findRightBre(exp, startIndex);
                String substring = exp.substring(startIndex + 1, lastIndex);
                this.parse(substring, opNode);
                start = lastIndex;
                continue;
            }
            ++start;
        }
        return opNode;
    }

    private int findRightBre(String exp, int start) {
        if (exp.charAt(start) != '(') {
            return -1;
        }
        int leftCount = 1;
        for (int begin = start; begin < exp.length(); ++begin) {
            if (leftCount == 0) {
                return begin;
            }
            String nextChar = this.findNextCharFrom(exp, begin);
            if ("(".equals(nextChar)) {
                ++leftCount;
                continue;
            }
            if (!")".equals(nextChar)) continue;
            --leftCount;
        }
        return -1;
    }

    private String findNextCharFrom(String exp, int start) {
        if (start == 0) {
            return null;
        }
        int startIndex = start + 1;
        for (int endIndex = start + 1; endIndex < exp.length(); ++endIndex) {
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)' ') == 0) {
                ++startIndex;
                continue;
            }
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)'a') == 0) {
                return exp.substring(startIndex, startIndex + 3);
            }
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)'o') == 0) {
                return exp.substring(startIndex, startIndex + 2);
            }
            return exp.substring(startIndex, startIndex + 1);
        }
        return null;
    }

    private String findPreCharFrom(String exp, int start) {
        if (start == 0) {
            return null;
        }
        int startIndex = start - 1;
        int endIndex = start - 1;
        while (startIndex >= 0) {
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)' ') == 0) {
                --startIndex;
                --endIndex;
                continue;
            }
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)'d') == 0) {
                startIndex = endIndex - 2;
                break;
            }
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)'r') == 0) {
                startIndex = endIndex - 1;
                break;
            }
            if (CharUtils.compare((char)exp.charAt(endIndex), (char)'(') != 0) continue;
            return "(";
        }
        return exp.substring(startIndex, endIndex + 1);
    }

    private int nextCharAtFrom(String exp, int start, char cha) {
        int index = exp.substring(start).indexOf(cha);
        if (index >= 0) {
            return start + index;
        }
        return index;
    }

    public static class Node {
        String type;
        String name;
        List<Node> childList = Lists.newArrayList();

        public Node(String name) {
            this.name = name;
        }

        public void appendChild(Node child) {
            this.childList.add(child);
        }

        public static Node createOpNode(String name, Node parent) {
            Node node = Node.createNode(name, parent);
            node.type = "1";
            return node;
        }

        public static Node createLeafNode(String name, Node parent) {
            Node node = Node.createNode(name, parent);
            node.type = "2";
            return node;
        }

        public static Node createNode(String name, Node parent) {
            Node node = new Node(name);
            if (parent != null) {
                parent.appendChild(node);
            }
            return node;
        }

        public static String print(Node root) {
            StringBuilder sb = new StringBuilder();
            Node.printHelper(root, "\t", sb);
            return sb.toString();
        }

        private static void printHelper(Node root, String start, StringBuilder sb) {
            if (root == null) {
                return;
            }
            String mid = start.substring(0, start.lastIndexOf(9));
            sb.append(mid).append("\u2514---").append(root.name).append("\r\n");
            if (root.childList == null) {
                return;
            }
            for (Node node : root.childList) {
                Node.printHelper(node, start + "\t", sb);
            }
        }
    }
}

