/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class GraphCacheManager {
    private Map<Long, DynamicObject> seqScmObjMap = Maps.newHashMap();
    private Map<Long, DynamicObject> classScmObjMap = Maps.newHashMap();
    private Map<Long, DynamicObject> familyScmObjMap = Maps.newHashMap();
    private Map<Long, DynamicObject> adminOrgCompanyObjMap = Maps.newHashMap();
    private Map<Long, DynamicObject> adminOrgDepObjMap = Maps.newHashMap();

    public void cacheSeqScmObj(DynamicObject[] seqScmObjs) {
        this.cacheObj(seqScmObjs, this.seqScmObjMap);
    }

    public void cacheClassScmObj(DynamicObject[] classScmObjs) {
        this.cacheObj(classScmObjs, this.classScmObjMap);
    }

    public void cacheFamilyScmObj(DynamicObject[] familyScmObjs) {
        this.cacheObj(familyScmObjs, this.familyScmObjMap);
    }

    public void cacheAdminOrgCompanyObj(DynamicObject[] adminOrgCompanyObjs) {
        this.cacheObj(adminOrgCompanyObjs, this.adminOrgCompanyObjMap);
    }

    public void cacheAdminOrgDepObj(DynamicObject[] adminOrgDepObjs) {
        this.cacheObj(adminOrgDepObjs, this.adminOrgDepObjMap);
    }

    private void cacheObj(DynamicObject[] objs, Map<Long, DynamicObject> cache) {
        for (DynamicObject obj : objs) {
            cache.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    public Map<Long, DynamicObject> getSeqScmObjMap() {
        return this.seqScmObjMap;
    }

    public Map<Long, DynamicObject> getClassScmObjMap() {
        return this.classScmObjMap;
    }

    public Map<Long, DynamicObject> getFamilyScmObjMap() {
        return this.familyScmObjMap;
    }

    public Map<Long, DynamicObject> getAdminOrgCompanyObjMap() {
        return this.adminOrgCompanyObjMap;
    }

    public Map<Long, DynamicObject> getAdminOrgDepObjMap() {
        return this.adminOrgDepObjMap;
    }
}

