/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNodeType;
import kd.swc.hcdm.business.salarystandard.constraint.graph.LightColor;
import org.apache.commons.collections.CollectionUtils;

public class GraphNode {
    private Long id;
    private String name;
    private GraphNodeType nodeType;
    private String entityNumber;
    private String constraintGroupExp;
    private List<Long> dataSet;
    private LightColor lightColor;
    private Long contrastPropId;
    @JSONField(serialize=false)
    private Map<Long, DynamicObject> nodeEntityDataObjCache = new HashMap<Long, DynamicObject>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getContrastPropId() {
        return this.contrastPropId;
    }

    public void setContrastPropId(Long contrastPropId) {
        this.contrastPropId = contrastPropId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GraphNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(GraphNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public List<Long> getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(List<Long> dataSet) {
        this.dataSet = dataSet;
    }

    public String getConstraintGroupExp() {
        return this.constraintGroupExp;
    }

    public void setConstraintGroupExp(String constraintGroupExp) {
        this.constraintGroupExp = constraintGroupExp;
    }

    public LightColor getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(LightColor lightColor) {
        this.lightColor = lightColor;
    }

    public boolean isLightUp() {
        return this.lightColor != null && this.lightColor == LightColor.white;
    }

    public String toString() {
        return "GraphNode{name='" + this.name + '\'' + ", entityNumber='" + this.entityNumber + '\'' + ", lightColor=" + (Object)((Object)this.lightColor) + '}';
    }

    public void cacheEntityDataObj(DynamicObject[] nodeEntityObjs) {
        for (DynamicObject obj : nodeEntityObjs) {
            this.nodeEntityDataObjCache.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    public DynamicObject[] getEntityDataObjsFromCache(Collection<Long> nodeEntityPkIds) {
        if (CollectionUtils.isEmpty(nodeEntityPkIds)) {
            return null;
        }
        if (this.nodeEntityDataObjCache.keySet().containsAll(nodeEntityPkIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)nodeEntityPkIds.size());
            for (Long aLong : nodeEntityPkIds) {
                DynamicObject obj = this.nodeEntityDataObjCache.get(aLong);
                if (obj == null) continue;
                resultList.add(obj);
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    public Map<Long, DynamicObject> getNodeEntityDataObjCache() {
        return this.nodeEntityDataObjCache;
    }
}

