/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class DepTypeToAdminOrgHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_DEPTYPE = "haos_departmenttype";
    private static final String ENTITY_ADMINORG = "haos_adminorghr";
    private static final String ENTITY_ADMINORGDEP = "haos_adminorgdepartment";
    private SWCDataServiceHelper adminDepServiceHelper = new SWCDataServiceHelper("haos_adminorgdepartment");
    private Map<Long, Map<Long, DynamicObject>> adminOrgIdToOrgDepObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> departmentTypeIdToOrgDepObjMap = Maps.newHashMap();

    private void cacheOrgDepObj(DynamicObject[] orgDepObj) {
        this.getGraphCacheManager().cacheAdminOrgDepObj(orgDepObj);
        for (DynamicObject obj : orgDepObj) {
            Map map1 = this.departmentTypeIdToOrgDepObjMap.computeIfAbsent(obj.getLong("departmenttype.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.adminOrgIdToOrgDepObjMap.computeIfAbsent(obj.getLong("adminorg.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getOrgDepObjByAdminOrgIdFromCache(Collection<Long> adminOrgIds) {
        if (adminOrgIds == null) {
            return null;
        }
        if (this.adminOrgIdToOrgDepObjMap.keySet().containsAll(adminOrgIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)adminOrgIds.size());
            for (Long aLong : adminOrgIds) {
                Map<Long, DynamicObject> map = this.adminOrgIdToOrgDepObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getOrgDepObjByDepartmentTypeIdFromCache(Collection<Long> departmentTypeIds) {
        if (departmentTypeIds == null) {
            return null;
        }
        if (this.departmentTypeIdToOrgDepObjMap.keySet().containsAll(departmentTypeIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)departmentTypeIds.size());
            for (Long aLong : departmentTypeIds) {
                Map<Long, DynamicObject> map = this.departmentTypeIdToOrgDepObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_ADMINORG.equals(sourceNode.getEntityNumber())) {
            List<Long> adminOrgIdSet = sourceNode.getDataSet();
            DynamicObject[] adminOrgDepObjs = this.getOrgDepObjByAdminOrgIdFromCache(adminOrgIdSet);
            if (adminOrgDepObjs == null) {
                adminOrgDepObjs = this.adminDepServiceHelper.query("id,adminorg,departmenttype", new QFilter[]{new QFilter("adminorg", "in", adminOrgIdSet), BaseDataHisHelper.getHisCurrFilter()});
                this.cacheOrgDepObj(adminOrgDepObjs);
            }
            Set departmentTypeIds = Arrays.stream(adminOrgDepObjs).map(o1 -> o1.getLong("departmenttype.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", departmentTypeIds);
            if (departmentTypeIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode targetNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_DEPTYPE.equals(targetNode.getEntityNumber())) {
            List<Long> depTypeIds = targetNode.getDataSet();
            DynamicObject[] adminOrgDepObjs = this.getOrgDepObjByDepartmentTypeIdFromCache(depTypeIds);
            if (adminOrgDepObjs == null) {
                adminOrgDepObjs = this.adminDepServiceHelper.query("id,adminorg,departmenttype", new QFilter[]{new QFilter("departmenttype", "in", depTypeIds), BaseDataHisHelper.getHisCurrFilter()});
                this.cacheOrgDepObj(adminOrgDepObjs);
            }
            Set adminorgIds = Arrays.stream(adminOrgDepObjs).map(o1 -> o1.getLong("adminorg.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", adminorgIds);
            if (adminorgIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

