/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class IndustryCategoryToAdminOrgHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_INDUSTRYTYPE = "hbss_industrytype";
    private static final String ENTITY_ADMINORG = "haos_adminorghr";
    private static final String ENTITY_ADMINORGCOMPANY = "haos_adminorgcompany";
    private SWCDataServiceHelper adminOrgCompanyServiceHelper = new SWCDataServiceHelper("haos_adminorgcompany");
    private Map<Long, Map<Long, DynamicObject>> adminOrgIdToOrgCompanyObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> industryTypeIdToOrgCompanyObjMap = Maps.newHashMap();

    private void cacheOrgCompanyObj(DynamicObject[] orgCompanyObj) {
        this.getGraphCacheManager().cacheAdminOrgCompanyObj(orgCompanyObj);
        for (DynamicObject obj : orgCompanyObj) {
            Map map1 = this.industryTypeIdToOrgCompanyObjMap.computeIfAbsent(obj.getLong("industrytype.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.adminOrgIdToOrgCompanyObjMap.computeIfAbsent(obj.getLong("adminorg.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getOrgCompanyObjByAdminOrgIdFromCache(Collection<Long> adminOrgIds) {
        if (adminOrgIds == null) {
            return null;
        }
        if (this.adminOrgIdToOrgCompanyObjMap.keySet().containsAll(adminOrgIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)adminOrgIds.size());
            for (Long aLong : adminOrgIds) {
                Map<Long, DynamicObject> map = this.adminOrgIdToOrgCompanyObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getOrgCompanyObjByIndustryTypeIdFromCache(Collection<Long> industryTypeIds) {
        if (industryTypeIds == null) {
            return null;
        }
        if (this.industryTypeIdToOrgCompanyObjMap.keySet().containsAll(industryTypeIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)industryTypeIds.size());
            for (Long aLong : industryTypeIds) {
                Map<Long, DynamicObject> map = this.industryTypeIdToOrgCompanyObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_ADMINORG.equals(sourceNode.getEntityNumber())) {
            List<Long> adminOrgIdSet = sourceNode.getDataSet();
            DynamicObject[] adminOrgCompanyObjs = this.getOrgCompanyObjByAdminOrgIdFromCache(adminOrgIdSet);
            if (adminOrgCompanyObjs == null) {
                adminOrgCompanyObjs = this.adminOrgCompanyServiceHelper.query("id,adminorg,industrytype", new QFilter[]{new QFilter("adminorg", "in", adminOrgIdSet), BaseDataHisHelper.getHisCurrFilter()});
                this.cacheOrgCompanyObj(adminOrgCompanyObjs);
            }
            Set industryTypeIds = Arrays.stream(adminOrgCompanyObjs).map(object -> object.getLong("industrytype.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", industryTypeIds);
            if (industryTypeIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode targetNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_INDUSTRYTYPE.equals(targetNode.getEntityNumber())) {
            List<Long> industryTypeIds = targetNode.getDataSet();
            DynamicObject[] adminOrgCompanyObjs = this.getOrgCompanyObjByIndustryTypeIdFromCache(industryTypeIds);
            if (adminOrgCompanyObjs == null) {
                adminOrgCompanyObjs = this.adminOrgCompanyServiceHelper.query("id,adminorg,industrytype", new QFilter[]{new QFilter("industrytype", "in", industryTypeIds), BaseDataHisHelper.getHisCurrFilter()});
                this.cacheOrgCompanyObj(adminOrgCompanyObjs);
            }
            Set adminorgIds = Arrays.stream(adminOrgCompanyObjs).map(object -> object.getLong("adminorg.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", adminorgIds);
            if (adminorgIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

