/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ContrastConstraintHelper;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobClassToJobGradeHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBCLASS = "hbjm_jobclasshr";
    private static final String ENTITY_JOBGRADE = "hbjm_jobgradehr";
    private static final String ENTITY_JOBCLASSSCM = "hbjm_jobclassscm";
    private SWCDataServiceHelper jobClassScmServiceHelper = new SWCDataServiceHelper("hbjm_jobclassscm");
    private SWCDataServiceHelper jobGradeServiceHelper = new SWCDataServiceHelper("hbjm_jobgradehr");
    private Map<Long, Map<Long, DynamicObject>> jobClassIdToClassScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> gradeScmIdToClassScmObjMap = Maps.newHashMap();

    private void cacheClassScmObj(DynamicObject[] classScmObj) {
        this.getGraphCacheManager().cacheClassScmObj(classScmObj);
        for (DynamicObject obj : classScmObj) {
            Map map1 = this.gradeScmIdToClassScmObjMap.computeIfAbsent(obj.getLong("highjobgrade.jobgradescm.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobClassIdToClassScmObjMap.computeIfAbsent(obj.getLong("jobclass.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getClassScmObjByJobClassIdFromCache(Collection<Long> jobClassIds) {
        if (jobClassIds == null) {
            return null;
        }
        if (this.jobClassIdToClassScmObjMap.keySet().containsAll(jobClassIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobClassIds.size());
            for (Long aLong : jobClassIds) {
                Map<Long, DynamicObject> map = this.jobClassIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getClassScmObjByGradeScmIdFromCache(Collection<Long> gradeScmIds) {
        if (gradeScmIds == null) {
            return null;
        }
        if (this.gradeScmIdToClassScmObjMap.keySet().containsAll(gradeScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)gradeScmIds.size());
            for (Long aLong : gradeScmIds) {
                Map<Long, DynamicObject> map = this.gradeScmIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBCLASS.equals(sourceNode.getEntityNumber())) {
            List<Long> jobClassIds = sourceNode.getDataSet();
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByJobClassIdFromCache(jobClassIds);
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("jobclass", "in", jobClassIds)});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)jobClassScmObjs.length);
            for (DynamicObject jobClassScm : jobClassScmObjs) {
                if (jobClassScm.getDynamicObject("lowjobgrade") == null) continue;
                int lowSeq = jobClassScm.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = jobClassScm.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = jobClassScm.getInt("highjobgrade.jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(jobGradeScm, Pair.create((Object)lowSeq, (Object)highSeq));
                    continue;
                }
                seqPair.setKey((Object)(lowSeq < (Integer)seqPair.getKey() ? Integer.valueOf(lowSeq) : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(highSeq > (Integer)seqPair.getValue() ? Integer.valueOf(highSeq) : (Integer)seqPair.getValue()));
            }
            resultQFilter = ContrastConstraintHelper.createQFilterByScmSeqForGradeLevel(gradeScmMinMaxSeq, true);
            if (gradeScmMinMaxSeq.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobGradeNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBGRADE.equals(jobGradeNode.getEntityNumber())) {
            List<Long> jobGradeIdSet = jobGradeNode.getDataSet();
            DynamicObject[] jobGradeObjs = jobGradeNode.getEntityDataObjsFromCache(jobGradeIdSet);
            if (jobGradeObjs == null) {
                jobGradeObjs = this.jobGradeServiceHelper.query("id,jobgradeseq,jobgradescm", new QFilter[]{new QFilter("id", "in", jobGradeIdSet)});
                jobGradeNode.cacheEntityDataObj(jobGradeObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject jobGradeObj : jobGradeObjs) {
                long scmId = jobGradeObj.getLong("jobgradescm.id");
                Integer jobGradeSeq = jobGradeObj.getInt("jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(scmId);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(scmId, Pair.create((Object)jobGradeSeq, (Object)jobGradeSeq));
                    continue;
                }
                seqPair.setKey((Object)(jobGradeSeq < (Integer)seqPair.getKey() ? jobGradeSeq : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(jobGradeSeq > (Integer)seqPair.getValue() ? jobGradeSeq : (Integer)seqPair.getValue()));
            }
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByGradeScmIdFromCache(gradeScmMinMaxSeq.keySet());
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("highjobgrade.jobgradescm", "in", gradeScmMinMaxSeq.keySet())});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            HashSet jobClassIds = Sets.newHashSetWithExpectedSize((int)jobClassScmObjs.length);
            for (DynamicObject jobClassScm : jobClassScmObjs) {
                int lowSeq = jobClassScm.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = jobClassScm.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = jobClassScm.getInt("highjobgrade.jobgradeseq");
                Pair gradeRange = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (gradeRange == null || lowSeq > (Integer)gradeRange.getKey() || highSeq < (Integer)gradeRange.getValue()) continue;
                Long jobClassId = jobClassScm.getLong("jobclass.id");
                jobClassIds.add(jobClassId);
            }
            resultQFilter = new QFilter("id", "in", (Object)jobClassIds);
            if (jobClassIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

