/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ContrastConstraintHelper;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobClassToJobLevelHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBCLASS = "hbjm_jobclasshr";
    private static final String ENTITY_JOBLEVEL = "hbjm_joblevelhr";
    private static final String ENTITY_JOBCLASSSCM = "hbjm_jobclassscm";
    private SWCDataServiceHelper jobClassScmServiceHelper = new SWCDataServiceHelper("hbjm_jobclassscm");
    private SWCDataServiceHelper jobLevelServiceHelper = new SWCDataServiceHelper("hbjm_joblevelhr");
    private Map<Long, Map<Long, DynamicObject>> jobClassIdToClassScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> levelScmIdToClassScmObjMap = Maps.newHashMap();

    private void cacheClassScmObj(DynamicObject[] classScmObj) {
        this.getGraphCacheManager().cacheClassScmObj(classScmObj);
        for (DynamicObject obj : classScmObj) {
            Map map1 = this.levelScmIdToClassScmObjMap.computeIfAbsent(obj.getLong("highjoblevel.joblevelscm.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobClassIdToClassScmObjMap.computeIfAbsent(obj.getLong("jobclass.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getClassScmObjByLevelScmIdFromCache(Collection<Long> levelScmIds) {
        if (levelScmIds == null) {
            return null;
        }
        if (this.levelScmIdToClassScmObjMap.keySet().containsAll(levelScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)levelScmIds.size());
            for (Long aLong : levelScmIds) {
                Map<Long, DynamicObject> map = this.levelScmIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getClassScmObjByJobClassIdFromCache(Collection<Long> JobClassIds) {
        if (JobClassIds == null) {
            return null;
        }
        if (this.jobClassIdToClassScmObjMap.keySet().containsAll(JobClassIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)JobClassIds.size());
            for (Long aLong : JobClassIds) {
                Map<Long, DynamicObject> map = this.jobClassIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode jobClassNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBCLASS.equals(jobClassNode.getEntityNumber())) {
            List<Long> jobClassIds = jobClassNode.getDataSet();
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByJobClassIdFromCache(jobClassIds);
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("jobclass", "in", jobClassIds)});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            HashMap levelScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)jobClassScmObjs.length);
            for (DynamicObject jobClassScm : jobClassScmObjs) {
                if (jobClassScm.getDynamicObject("lowjoblevel") == null) continue;
                int lowSeq = jobClassScm.getInt("lowjoblevel.joblevelseq");
                Long jobLevelScm = jobClassScm.getLong("lowjoblevel.joblevelscm.id");
                int highSeq = jobClassScm.getInt("highjoblevel.joblevelseq");
                Pair seqPair = (Pair)levelScmMinMaxSeq.get(jobLevelScm);
                if (seqPair == null) {
                    levelScmMinMaxSeq.put(jobLevelScm, Pair.create((Object)lowSeq, (Object)highSeq));
                    continue;
                }
                seqPair.setKey((Object)(lowSeq < (Integer)seqPair.getKey() ? Integer.valueOf(lowSeq) : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(highSeq > (Integer)seqPair.getValue() ? Integer.valueOf(highSeq) : (Integer)seqPair.getValue()));
            }
            resultQFilter = ContrastConstraintHelper.createQFilterByScmSeqForGradeLevel(levelScmMinMaxSeq, false);
            if (levelScmMinMaxSeq.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobLevelNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBLEVEL.equals(jobLevelNode.getEntityNumber())) {
            List<Long> jobLevelIdSet = jobLevelNode.getDataSet();
            DynamicObject[] jobLevelObjs = jobLevelNode.getEntityDataObjsFromCache(jobLevelIdSet);
            if (jobLevelObjs == null) {
                jobLevelObjs = this.jobLevelServiceHelper.query("id,joblevelseq,joblevelscm", new QFilter[]{new QFilter("id", "in", jobLevelIdSet)});
                jobLevelNode.cacheEntityDataObj(jobLevelObjs);
            }
            HashMap levelScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject jobLevelObj : jobLevelObjs) {
                long scmId = jobLevelObj.getLong("joblevelscm.id");
                Integer jobLevelSeq = jobLevelObj.getInt("joblevelseq");
                Pair seqPair = (Pair)levelScmMinMaxSeq.get(scmId);
                if (seqPair == null) {
                    levelScmMinMaxSeq.put(scmId, Pair.create((Object)jobLevelSeq, (Object)jobLevelSeq));
                    continue;
                }
                seqPair.setKey((Object)(jobLevelSeq < (Integer)seqPair.getKey() ? jobLevelSeq : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(jobLevelSeq > (Integer)seqPair.getValue() ? jobLevelSeq : (Integer)seqPair.getValue()));
            }
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByLevelScmIdFromCache(levelScmMinMaxSeq.keySet());
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("highjoblevel.joblevelscm", "in", levelScmMinMaxSeq.keySet())});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            HashSet jobClassIds = Sets.newHashSetWithExpectedSize((int)jobClassScmObjs.length);
            for (DynamicObject jobClassScm : jobClassScmObjs) {
                int lowSeq = jobClassScm.getInt("lowjoblevel.joblevelseq");
                Long jobLevelScm = jobClassScm.getLong("lowjoblevel.joblevelscm.id");
                int highSeq = jobClassScm.getInt("highjoblevel.joblevelseq");
                Pair levelRange = (Pair)levelScmMinMaxSeq.get(jobLevelScm);
                if (levelRange == null || lowSeq > (Integer)levelRange.getKey() || highSeq < (Integer)levelRange.getValue()) continue;
                Long jobClassId = jobClassScm.getLong("jobclass.id");
                jobClassIds.add(jobClassId);
            }
            resultQFilter = new QFilter("id", "in", (Object)jobClassIds);
            if (jobClassIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

