/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobFamilyToJobGradeHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBFAMILY = "hbjm_jobfamilyhr";
    private static final String ENTITY_JOBGRADE = "hbjm_jobgradehr";
    private static final String ENTITY_JOBFAMILYSCM = "hbjm_jobfamilyscm";
    private SWCDataServiceHelper jobFamilyScmServiceHelper = new SWCDataServiceHelper("hbjm_jobfamilyscm");
    private SWCDataServiceHelper jobGradeServiceHelper = new SWCDataServiceHelper("hbjm_jobgradehr");
    private Map<Long, Map<Long, DynamicObject>> jobFamilyIdToFamilyScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> gradeScmIdToFamilyScmObjMap = Maps.newHashMap();

    private void cacheFamilyScmObj(DynamicObject[] familyScmObj) {
        this.getGraphCacheManager().cacheFamilyScmObj(familyScmObj);
        for (DynamicObject obj : familyScmObj) {
            Map map1 = this.gradeScmIdToFamilyScmObjMap.computeIfAbsent(obj.getLong("jobgradescm.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobFamilyIdToFamilyScmObjMap.computeIfAbsent(obj.getLong("jobfamily.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getFamilyScmObjByJobFamilyIdFromCache(Collection<Long> jobFamilyIds) {
        if (jobFamilyIds == null) {
            return null;
        }
        if (this.jobFamilyIdToFamilyScmObjMap.keySet().containsAll(jobFamilyIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobFamilyIds.size());
            for (Long aLong : jobFamilyIds) {
                Map<Long, DynamicObject> map = this.jobFamilyIdToFamilyScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getFamilyScmObjByGradeScmIdFromCache(Collection<Long> gradeScmIds) {
        if (gradeScmIds == null) {
            return null;
        }
        if (this.gradeScmIdToFamilyScmObjMap.keySet().containsAll(gradeScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)gradeScmIds.size());
            for (Long aLong : gradeScmIds) {
                Map<Long, DynamicObject> map = this.gradeScmIdToFamilyScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBFAMILY.equals(sourceNode.getEntityNumber())) {
            List<Long> jobFamilyIds = sourceNode.getDataSet();
            DynamicObject[] jobFamilyScmObjs = this.getFamilyScmObjByJobFamilyIdFromCache(jobFamilyIds);
            if (jobFamilyScmObjs == null) {
                jobFamilyScmObjs = this.jobFamilyScmServiceHelper.query("id,jobscm,jobfamily,jobgradescm,joblevelscm", new QFilter[]{new QFilter("jobfamily", "in", jobFamilyIds)});
                this.cacheFamilyScmObj(jobFamilyScmObjs);
            }
            Set gradeScmIds = Arrays.stream(jobFamilyScmObjs).map(object -> object.getLong("jobgradescm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("jobgradescm", "in", gradeScmIds);
            if (gradeScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobGradeNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBGRADE.equals(jobGradeNode.getEntityNumber())) {
            Set<Long> jobGradeScmIds;
            DynamicObject[] jobFamilyScmObjs;
            List<Long> jobGradeIdSet = jobGradeNode.getDataSet();
            DynamicObject[] jobGradeObjs = jobGradeNode.getEntityDataObjsFromCache(jobGradeIdSet);
            if (jobGradeObjs == null) {
                jobGradeObjs = this.jobGradeServiceHelper.query("id,jobgradeseq,jobgradescm", new QFilter[]{new QFilter("id", "in", jobGradeIdSet)});
                jobGradeNode.cacheEntityDataObj(jobGradeObjs);
            }
            if ((jobFamilyScmObjs = this.getFamilyScmObjByGradeScmIdFromCache(jobGradeScmIds = Arrays.stream(jobGradeObjs).map(object -> object.getLong("jobgradescm.id")).collect(Collectors.toSet()))) == null) {
                jobFamilyScmObjs = this.jobFamilyScmServiceHelper.query("id,jobscm,jobfamily,jobgradescm,joblevelscm", new QFilter[]{new QFilter("jobgradescm.id", "in", jobGradeScmIds)});
                this.cacheFamilyScmObj(jobFamilyScmObjs);
            }
            Set jobFamilyIds = Arrays.stream(jobFamilyScmObjs).map(object -> object.getLong("jobfamily.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", jobFamilyIds);
            if (jobFamilyIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

