/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobFamilyToJobLevelHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBFAMILY = "hbjm_jobfamilyhr";
    private static final String ENTITY_JOBLEVEL = "hbjm_joblevelhr";
    private static final String ENTITY_JOBFAMILYSCM = "hbjm_jobfamilyscm";
    private SWCDataServiceHelper jobFamilyScmServiceHelper = new SWCDataServiceHelper("hbjm_jobfamilyscm");
    private SWCDataServiceHelper jobLevelServiceHelper = new SWCDataServiceHelper("hbjm_joblevelhr");
    private Map<Long, Map<Long, DynamicObject>> jobFamilyIdToFamilyScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> levelScmIdToFamilyScmObjMap = Maps.newHashMap();

    private void cacheFamilyScmObj(DynamicObject[] familyScmObj) {
        this.getGraphCacheManager().cacheFamilyScmObj(familyScmObj);
        for (DynamicObject obj : familyScmObj) {
            Map map1 = this.levelScmIdToFamilyScmObjMap.computeIfAbsent(obj.getLong("joblevelscm.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobFamilyIdToFamilyScmObjMap.computeIfAbsent(obj.getLong("jobfamily.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getFamilyScmObjByLevelScmIdFromCache(Collection<Long> levelScmIds) {
        if (levelScmIds == null) {
            return null;
        }
        if (this.levelScmIdToFamilyScmObjMap.keySet().containsAll(levelScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)levelScmIds.size());
            for (Long aLong : levelScmIds) {
                Map<Long, DynamicObject> map = this.levelScmIdToFamilyScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getFamilyScmObjByJobFamilyIdFromCache(Collection<Long> JobFamilyIds) {
        if (JobFamilyIds == null) {
            return null;
        }
        if (this.jobFamilyIdToFamilyScmObjMap.keySet().containsAll(JobFamilyIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)JobFamilyIds.size());
            for (Long aLong : JobFamilyIds) {
                Map<Long, DynamicObject> map = this.jobFamilyIdToFamilyScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBFAMILY.equals(sourceNode.getEntityNumber())) {
            List<Long> jobFamilyIds = sourceNode.getDataSet();
            DynamicObject[] jobFamilyScmObjs = this.getFamilyScmObjByJobFamilyIdFromCache(jobFamilyIds);
            if (jobFamilyScmObjs == null) {
                jobFamilyScmObjs = this.jobFamilyScmServiceHelper.query("id,jobscm,jobfamily,jobgradescm,joblevelscm", new QFilter[]{new QFilter("jobfamily", "in", jobFamilyIds)});
                this.cacheFamilyScmObj(jobFamilyScmObjs);
            }
            Set levelScmIds = Arrays.stream(jobFamilyScmObjs).map(object -> object.getLong("joblevelscm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("joblevelscm", "in", levelScmIds);
            if (levelScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobLevelNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBLEVEL.equals(jobLevelNode.getEntityNumber())) {
            Set<Long> jobLevelScmIds;
            DynamicObject[] jobFamilyScmObjs;
            List<Long> jobLevelIdSet = jobLevelNode.getDataSet();
            DynamicObject[] jobLevelObjs = jobLevelNode.getEntityDataObjsFromCache(jobLevelIdSet);
            if (jobLevelObjs == null) {
                jobLevelObjs = this.jobLevelServiceHelper.query("id,joblevelseq,joblevelscm", new QFilter[]{new QFilter("id", "in", jobLevelIdSet)});
                jobLevelNode.cacheEntityDataObj(jobLevelObjs);
            }
            if ((jobFamilyScmObjs = this.getFamilyScmObjByLevelScmIdFromCache(jobLevelScmIds = Arrays.stream(jobLevelObjs).map(object -> object.getLong("joblevelscm.id")).collect(Collectors.toSet()))) == null) {
                jobFamilyScmObjs = this.jobFamilyScmServiceHelper.query("id,jobscm,jobfamily,jobgradescm,joblevelscm", new QFilter[]{new QFilter("joblevelscm.id", "in", jobLevelScmIds)});
                this.cacheFamilyScmObj(jobFamilyScmObjs);
            }
            Set jobFamilyIds = Arrays.stream(jobFamilyScmObjs).map(object -> object.getLong("jobfamily.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", jobFamilyIds);
            if (jobFamilyIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

