/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobScmToJobClassHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBSCM = "hbjm_jobscmhr";
    private static final String ENTITY_JOBCLASS = "hbjm_jobclasshr";
    private static final String ENTITY_JOBCLASSSCM = "hbjm_jobclassscm";
    private final SWCDataServiceHelper jobClassScmServiceHelper = new SWCDataServiceHelper("hbjm_jobclassscm");
    private Map<Long, Map<Long, DynamicObject>> jobClassIdToClassScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> jobScmIdToClassScmObjMap = Maps.newHashMap();

    private void cacheClassScmObj(DynamicObject[] classScmObj) {
        this.getGraphCacheManager().cacheClassScmObj(classScmObj);
        for (DynamicObject obj : classScmObj) {
            Map map1 = this.jobClassIdToClassScmObjMap.computeIfAbsent(obj.getLong("jobclass.id"), aLong -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobScmIdToClassScmObjMap.computeIfAbsent(obj.getLong("jobscm.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getClassScmObjByJobClassIdFromCache(Collection<Long> jobClassIds) {
        if (jobClassIds == null) {
            return null;
        }
        if (this.jobClassIdToClassScmObjMap.keySet().containsAll(jobClassIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobClassIds.size());
            for (Long aLong : jobClassIds) {
                Map<Long, DynamicObject> map = this.jobClassIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getClassScmObjByJobScmIdFromCache(Collection<Long> jobScmIds) {
        if (jobScmIds == null) {
            return null;
        }
        if (this.jobScmIdToClassScmObjMap.keySet().containsAll(jobScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobScmIds.size());
            for (Long aLong : jobScmIds) {
                Map<Long, DynamicObject> map = this.jobScmIdToClassScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBSCM.equals(sourceNode.getEntityNumber())) {
            List<Long> jobScmIds = sourceNode.getDataSet();
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByJobScmIdFromCache(jobScmIds);
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("jobscm", "in", jobScmIds)});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            Set jobClassIds = Arrays.stream(jobClassScmObjs).map(object -> object.getLong("jobclass.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", jobClassIds);
            if (jobClassIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode targetNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBCLASS.equals(targetNode.getEntityNumber())) {
            List<Long> jobClassIdSet = targetNode.getDataSet();
            DynamicObject[] jobClassScmObjs = this.getClassScmObjByJobClassIdFromCache(jobClassIdSet);
            if (jobClassScmObjs == null) {
                jobClassScmObjs = this.jobClassScmServiceHelper.query("id,jobscm,jobclass,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade", new QFilter[]{new QFilter("jobclass", "in", jobClassIdSet)});
                this.cacheClassScmObj(jobClassScmObjs);
            }
            Set scmIds = Arrays.stream(jobClassScmObjs).map(object -> object.getLong("jobscm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", scmIds);
            if (scmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

