/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class JobScmToJobGradeHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBSCM = "hbjm_jobscmhr";
    private static final String ENTITY_JOBGRADE = "hbjm_jobgradehr";
    private static final String ENTITY_JOBGRADESCM = "hbjm_jobgradescmhr";
    private SWCDataServiceHelper jobScmServiceHelper = new SWCDataServiceHelper("hbjm_jobscmhr");
    private SWCDataServiceHelper jobGradeServiceHelper = new SWCDataServiceHelper("hbjm_jobgradehr");

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode jobScmNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBSCM.equals(jobScmNode.getEntityNumber())) {
            List<Long> jobScmIds = jobScmNode.getDataSet();
            DynamicObject[] jobScmObjs = jobScmNode.getEntityDataObjsFromCache(jobScmIds);
            if (jobScmObjs == null) {
                jobScmObjs = this.jobScmServiceHelper.query("id,joblevelscm,jobgradescm", new QFilter[]{new QFilter("id", "in", jobScmIds)});
                jobScmNode.cacheEntityDataObj(jobScmObjs);
            }
            Set gradeScmIds = Arrays.stream(jobScmObjs).map(object -> object.getLong("jobgradescm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("jobgradescm", "in", gradeScmIds);
            if (gradeScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobGradeNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBGRADE.equals(jobGradeNode.getEntityNumber())) {
            List<Long> jobGradeIdSet = jobGradeNode.getDataSet();
            DynamicObject[] jobGradeObjs = jobGradeNode.getEntityDataObjsFromCache(jobGradeIdSet);
            if (jobGradeObjs == null) {
                jobGradeObjs = this.jobGradeServiceHelper.query("id,jobgradeseq,jobgradescm", new QFilter[]{new QFilter("id", "in", jobGradeIdSet)});
                jobGradeNode.cacheEntityDataObj(jobGradeObjs);
            }
            Set jobGradeScmIds = Arrays.stream(jobGradeObjs).map(object -> object.getLong("jobgradescm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("jobgradescm", "in", jobGradeScmIds);
            if (jobGradeScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

